// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';







export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'segmentation_internals.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "segmentation_internals.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'segmentation_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getServiceStatus(): void;
  executeModel(segmentId: number): void;
  overwriteResult(segmentId: number, result: number): void;
  setSelected(segmentationKey: string, optimizationTarget: number): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getServiceStatus(): void {
    this.proxy.sendMessage(
        0,
        PageHandler_GetServiceStatus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  executeModel(
      segmentId: number): void {
    this.proxy.sendMessage(
        1,
        PageHandler_ExecuteModel_ParamsSpec.$,
        null,
        [
          segmentId
        ],
        false);
  }

  overwriteResult(
      segmentId: number,
      result: number): void {
    this.proxy.sendMessage(
        2,
        PageHandler_OverwriteResult_ParamsSpec.$,
        null,
        [
          segmentId,
          result
        ],
        false);
  }

  setSelected(
      segmentationKey: string,
      optimizationTarget: number): void {
    this.proxy.sendMessage(
        3,
        PageHandler_SetSelected_ParamsSpec.$,
        null,
        [
          segmentationKey,
          optimizationTarget
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetServiceStatus_ParamsSpec.$,
        null,
        impl.getServiceStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_ExecuteModel_ParamsSpec.$,
        null,
        impl.executeModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_OverwriteResult_ParamsSpec.$,
        null,
        impl.overwriteResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_SetSelected_ParamsSpec.$,
        null,
        impl.setSelected.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "segmentation_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getServiceStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  executeModel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  overwriteResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSelected: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getServiceStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetServiceStatus_ParamsSpec.$,
        null,
        this.getServiceStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    this.executeModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_ExecuteModel_ParamsSpec.$,
        null,
        this.executeModel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.overwriteResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_OverwriteResult_ParamsSpec.$,
        null,
        this.overwriteResult.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setSelected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_SetSelected_ParamsSpec.$,
        null,
        this.setSelected.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'segmentation_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onServiceStatusChanged(isInitialized: boolean, statusFlag: number): void;
  onClientInfoAvailable(clientInfo: ClientInfo[]): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onServiceStatusChanged(
      isInitialized: boolean,
      statusFlag: number): void {
    this.proxy.sendMessage(
        0,
        Page_OnServiceStatusChanged_ParamsSpec.$,
        null,
        [
          isInitialized,
          statusFlag
        ],
        false);
  }

  onClientInfoAvailable(
      clientInfo: ClientInfo[]): void {
    this.proxy.sendMessage(
        1,
        Page_OnClientInfoAvailable_ParamsSpec.$,
        null,
        [
          clientInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnServiceStatusChanged_ParamsSpec.$,
        null,
        impl.onServiceStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnClientInfoAvailable_ParamsSpec.$,
        null,
        impl.onClientInfoAvailable.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "segmentation_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onServiceStatusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onClientInfoAvailable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onServiceStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnServiceStatusChanged_ParamsSpec.$,
        null,
        this.onServiceStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onClientInfoAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnClientInfoAvailable_ParamsSpec.$,
        null,
        this.onClientInfoAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const ServiceStatusSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SegmentInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ClientInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetServiceStatus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ExecuteModel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OverwriteResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetSelected_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnServiceStatusChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnClientInfoAvailable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface ServiceStatusMojoType {
  isInitialized: boolean;
  intializationStatus: number;
}


export type ServiceStatus = ServiceStatusMojoType;
mojo.internal.Struct<ServiceStatusMojoType>(
    ServiceStatusSpec.$,
    'ServiceStatus',
    [
      mojo.internal.StructField<ServiceStatusMojoType, boolean>(
        'isInitialized', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ServiceStatusMojoType, number>(
        'intializationStatus', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SegmentInfoMojoType {
  segmentName: string;
  segmentId: number;
  canExecuteSegment: boolean;
  segmentData: string;
  predictionResult: string;
  predictionTimestamp: mojoBase_mojom_Time;
}


export type SegmentInfo = SegmentInfoMojoType;
mojo.internal.Struct<SegmentInfoMojoType>(
    SegmentInfoSpec.$,
    'SegmentInfo',
    [
      mojo.internal.StructField<SegmentInfoMojoType, string>(
        'segmentName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SegmentInfoMojoType, number>(
        'segmentId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SegmentInfoMojoType, string>(
        'segmentData', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SegmentInfoMojoType, boolean>(
        'canExecuteSegment', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SegmentInfoMojoType, string>(
        'predictionResult', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SegmentInfoMojoType, mojoBase_mojom_Time>(
        'predictionTimestamp', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface ClientInfoMojoType {
  segmentationKey: string;
  selectedSegment: string;
  segmentInfo: SegmentInfo[];
}


export type ClientInfo = ClientInfoMojoType;
mojo.internal.Struct<ClientInfoMojoType>(
    ClientInfoSpec.$,
    'ClientInfo',
    [
      mojo.internal.StructField<ClientInfoMojoType, string>(
        'segmentationKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientInfoMojoType, string>(
        'selectedSegment', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ClientInfoMojoType, SegmentInfo[]>(
        'segmentInfo', 16,
        0,
        mojo.internal.Array(SegmentInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetServiceStatus_ParamsMojoType {
}


export type PageHandler_GetServiceStatus_Params = PageHandler_GetServiceStatus_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetServiceStatus_ParamsMojoType>(
    PageHandler_GetServiceStatus_ParamsSpec.$,
    'PageHandler_GetServiceStatus_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ExecuteModel_ParamsMojoType {
  segmentId: number;
}


export type PageHandler_ExecuteModel_Params = PageHandler_ExecuteModel_ParamsMojoType;
mojo.internal.Struct<PageHandler_ExecuteModel_ParamsMojoType>(
    PageHandler_ExecuteModel_ParamsSpec.$,
    'PageHandler_ExecuteModel_Params',
    [
      mojo.internal.StructField<PageHandler_ExecuteModel_ParamsMojoType, number>(
        'segmentId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OverwriteResult_ParamsMojoType {
  segmentId: number;
  result: number;
}


export type PageHandler_OverwriteResult_Params = PageHandler_OverwriteResult_ParamsMojoType;
mojo.internal.Struct<PageHandler_OverwriteResult_ParamsMojoType>(
    PageHandler_OverwriteResult_ParamsSpec.$,
    'PageHandler_OverwriteResult_Params',
    [
      mojo.internal.StructField<PageHandler_OverwriteResult_ParamsMojoType, number>(
        'segmentId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OverwriteResult_ParamsMojoType, number>(
        'result', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetSelected_ParamsMojoType {
  segmentationKey: string;
  optimizationTarget: number;
}


export type PageHandler_SetSelected_Params = PageHandler_SetSelected_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetSelected_ParamsMojoType>(
    PageHandler_SetSelected_ParamsSpec.$,
    'PageHandler_SetSelected_Params',
    [
      mojo.internal.StructField<PageHandler_SetSelected_ParamsMojoType, string>(
        'segmentationKey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetSelected_ParamsMojoType, number>(
        'optimizationTarget', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_OnServiceStatusChanged_ParamsMojoType {
  isInitialized: boolean;
  statusFlag: number;
}


export type Page_OnServiceStatusChanged_Params = Page_OnServiceStatusChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnServiceStatusChanged_ParamsMojoType>(
    Page_OnServiceStatusChanged_ParamsSpec.$,
    'Page_OnServiceStatusChanged_Params',
    [
      mojo.internal.StructField<Page_OnServiceStatusChanged_ParamsMojoType, boolean>(
        'isInitialized', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnServiceStatusChanged_ParamsMojoType, number>(
        'statusFlag', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnClientInfoAvailable_ParamsMojoType {
  clientInfo: ClientInfo[];
}


export type Page_OnClientInfoAvailable_Params = Page_OnClientInfoAvailable_ParamsMojoType;
mojo.internal.Struct<Page_OnClientInfoAvailable_ParamsMojoType>(
    Page_OnClientInfoAvailable_ParamsSpec.$,
    'Page_OnClientInfoAvailable_Params',
    [
      mojo.internal.StructField<Page_OnClientInfoAvailable_ParamsMojoType, ClientInfo[]>(
        'clientInfo', 0,
        0,
        mojo.internal.Array(ClientInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



