// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{MetricsReporterImpl}from"//resources/js/metrics_reporter/metrics_reporter.js";export var ReloadButtonInputType;(function(ReloadButtonInputType){ReloadButtonInputType[ReloadButtonInputType["MOUSE_RELEASE"]=0]="MOUSE_RELEASE";ReloadButtonInputType[ReloadButtonInputType["KEY_PRESS"]=1]="KEY_PRESS";ReloadButtonInputType[ReloadButtonInputType["MAX_VALUE"]=2]="MAX_VALUE"})(ReloadButtonInputType||(ReloadButtonInputType={}));export var ReloadButtonVisibleMode;(function(ReloadButtonVisibleMode){ReloadButtonVisibleMode[ReloadButtonVisibleMode["RELOAD"]=0]="RELOAD";ReloadButtonVisibleMode[ReloadButtonVisibleMode["STOP"]=1]="STOP"})(ReloadButtonVisibleMode||(ReloadButtonVisibleMode={}));const INPUT_COUNT_HISTOGRAM_="InitialWebUI.ReloadButton.InputCount";const MOUSE_HOVER_TO_NEXT_PAINT_HISTOGRAM_="InitialWebUI.ReloadButton.MouseHoverToNextPaint";const MOUSE_PRESS_TO_NEXT_PAINT_HISTOGRAM_="InitialWebUI.ReloadButton.MousePressToNextPaint";const INPUT_TO_NEXT_PAINT_MOUSE_RELEASE_HISTOGRAM_="InitialWebUI.ReloadButton.InputToNextPaint.MouseRelease";const INPUT_MOUSE_RELEASE_START_MARK_="ReloadButton.Input.MouseRelease.Start";export class MetricsRecorder{static getVisibleMode(isLoading){return isLoading?ReloadButtonVisibleMode.STOP:ReloadButtonVisibleMode.RELOAD}browserProxy_;metricsReporter_;interactionObserver_=null;lastInputType_=null;constructor(browserProxy){this.browserProxy_=browserProxy;this.metricsReporter_=MetricsReporterImpl.getInstance()}startObserving(){if(!this.interactionObserver_){this.interactionObserver_=this.observeInteractionsToNextPaint_(["mouseenter","mousedown","click","keydown"])}}stopObserving(){if(this.interactionObserver_){this.interactionObserver_.disconnect();this.interactionObserver_=null}}onButtonPressedStart(event){let inputType=null;if(event instanceof PointerEvent){this.metricsReporter_.mark(INPUT_MOUSE_RELEASE_START_MARK_);inputType=ReloadButtonInputType.MOUSE_RELEASE}else if(event instanceof KeyboardEvent){inputType=ReloadButtonInputType.KEY_PRESS}else{return}this.lastInputType_=inputType;this.browserProxy_.recordInHistogram(INPUT_COUNT_HISTOGRAM_,inputType,ReloadButtonInputType.MAX_VALUE)}onChangeVisibleMode(currentMode,targetMode){if(currentMode===targetMode){return}}getNextPaintTime_(entry){return Math.max(entry.startTime+entry.duration,entry.processingStart)}toMicroseconds_(timeInMs){return BigInt(Math.round(timeInMs*1e3))}onPerformanceEventEntry_(entry){const duration=this.getNextPaintTime_(entry)-entry.startTime;const durationInMicroseconds=this.toMicroseconds_(duration);switch(entry.name){case"mouseenter":this.metricsReporter_.umaReportTime(MOUSE_HOVER_TO_NEXT_PAINT_HISTOGRAM_,durationInMicroseconds);break;case"mousedown":this.metricsReporter_.umaReportTime(MOUSE_PRESS_TO_NEXT_PAINT_HISTOGRAM_,durationInMicroseconds);break;case"click":if(this.lastInputType_===ReloadButtonInputType.MOUSE_RELEASE){this.metricsReporter_.umaReportTime(INPUT_TO_NEXT_PAINT_MOUSE_RELEASE_HISTOGRAM_,durationInMicroseconds);this.lastInputType_=null}break;case"keydown":break;default:}}onObserveInteractionEntryList_(list,eventNames){for(const entry of list.getEntries()){if(eventNames.includes(entry.name)){this.onPerformanceEventEntry_(entry)}}}observeInteractionsToNextPaint_(eventNames){const observer=new PerformanceObserver((list=>this.onObserveInteractionEntryList_(list,eventNames)));observer.observe({type:"event",buffered:true,durationThreshold:0});return observer}}