// chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  PrivacySandboxNoticeSpec as privacySandbox_notice_mojom_PrivacySandboxNoticeSpec,
  PrivacySandboxNotice as privacySandbox_notice_mojom_PrivacySandboxNotice,
  PrivacySandboxNoticeEventSpec as privacySandbox_notice_mojom_PrivacySandboxNoticeEventSpec,
  PrivacySandboxNoticeEvent as privacySandbox_notice_mojom_PrivacySandboxNoticeEvent
} from './notice.mojom-webui.js';







export type BaseDialogPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BaseDialogPageHandlerFactoryPendingReceiver>;

export class BaseDialogPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BaseDialogPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<BaseDialogPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|BaseDialogPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'privacy_sandbox.dialog.mojom.BaseDialogPageHandlerFactory',
        scope);
  }
}

export interface BaseDialogPageHandlerFactoryInterface {
  createPageHandler(page: BaseDialogPageRemote, receiver: BaseDialogPageHandlerPendingReceiver): void;
}

export class BaseDialogPageHandlerFactoryRemote implements BaseDialogPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BaseDialogPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BaseDialogPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BaseDialogPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BaseDialogPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: BaseDialogPageRemote,
      receiver: BaseDialogPageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        BaseDialogPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BaseDialogPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BaseDialogPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageHandlerFactoryRemote, BaseDialogPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageHandlerFactoryRemote, BaseDialogPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BaseDialogPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BaseDialogPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BaseDialogPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BaseDialogPageHandlerFactory {
  static get $interfaceName(): string {
    return "privacy_sandbox.dialog.mojom.BaseDialogPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BaseDialogPageHandlerFactoryRemote {
    let remote = new BaseDialogPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BaseDialogPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BaseDialogPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageHandlerFactoryRemote, BaseDialogPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageHandlerFactoryRemote, BaseDialogPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BaseDialogPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BaseDialogPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type BaseDialogPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BaseDialogPageHandlerPendingReceiver>;

export class BaseDialogPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BaseDialogPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<BaseDialogPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|BaseDialogPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'privacy_sandbox.dialog.mojom.BaseDialogPageHandler',
        scope);
  }
}

export interface BaseDialogPageHandlerInterface {
  resizeDialog(height: number): void;
  showDialog(): void;
  eventOccurred(notice: privacySandbox_notice_mojom_PrivacySandboxNotice, event: privacySandbox_notice_mojom_PrivacySandboxNoticeEvent): void;
}

export class BaseDialogPageHandlerRemote implements BaseDialogPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BaseDialogPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BaseDialogPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BaseDialogPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BaseDialogPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  resizeDialog(
      height: number): void {
    this.proxy.sendMessage(
        0,
        BaseDialogPageHandler_ResizeDialog_ParamsSpec.$,
        null,
        [
          height
        ],
        false);
  }

  showDialog(): void {
    this.proxy.sendMessage(
        1,
        BaseDialogPageHandler_ShowDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  eventOccurred(
      notice: privacySandbox_notice_mojom_PrivacySandboxNotice,
      event: privacySandbox_notice_mojom_PrivacySandboxNoticeEvent): void {
    this.proxy.sendMessage(
        2,
        BaseDialogPageHandler_EventOccurred_ParamsSpec.$,
        null,
        [
          notice,
          event
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BaseDialogPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BaseDialogPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageHandlerRemote, BaseDialogPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageHandlerRemote, BaseDialogPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BaseDialogPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BaseDialogPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BaseDialogPageHandler_ResizeDialog_ParamsSpec.$,
        null,
        impl.resizeDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BaseDialogPageHandler_ShowDialog_ParamsSpec.$,
        null,
        impl.showDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        BaseDialogPageHandler_EventOccurred_ParamsSpec.$,
        null,
        impl.eventOccurred.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BaseDialogPageHandler {
  static get $interfaceName(): string {
    return "privacy_sandbox.dialog.mojom.BaseDialogPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BaseDialogPageHandlerRemote {
    let remote = new BaseDialogPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BaseDialogPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BaseDialogPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageHandlerRemote, BaseDialogPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageHandlerRemote, BaseDialogPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  resizeDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  eventOccurred: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BaseDialogPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.resizeDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BaseDialogPageHandler_ResizeDialog_ParamsSpec.$,
        null,
        this.resizeDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BaseDialogPageHandler_ShowDialog_ParamsSpec.$,
        null,
        this.showDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.eventOccurred =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        BaseDialogPageHandler_EventOccurred_ParamsSpec.$,
        null,
        this.eventOccurred.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type BaseDialogPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BaseDialogPagePendingReceiver>;

export class BaseDialogPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<BaseDialogPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<BaseDialogPagePendingReceiver>;
  constructor(handle: MojoHandle|BaseDialogPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'privacy_sandbox.dialog.mojom.BaseDialogPage',
        scope);
  }
}

export interface BaseDialogPageInterface {
  navigateToNextStep(nextStep: privacySandbox_notice_mojom_PrivacySandboxNotice): void;
}

export class BaseDialogPageRemote implements BaseDialogPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BaseDialogPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BaseDialogPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BaseDialogPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BaseDialogPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  navigateToNextStep(
      nextStep: privacySandbox_notice_mojom_PrivacySandboxNotice): void {
    this.proxy.sendMessage(
        0,
        BaseDialogPage_NavigateToNextStep_ParamsSpec.$,
        null,
        [
          nextStep
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BaseDialogPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BaseDialogPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageRemote, BaseDialogPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageRemote, BaseDialogPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BaseDialogPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BaseDialogPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BaseDialogPage_NavigateToNextStep_ParamsSpec.$,
        null,
        impl.navigateToNextStep.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BaseDialogPage {
  static get $interfaceName(): string {
    return "privacy_sandbox.dialog.mojom.BaseDialogPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BaseDialogPageRemote {
    let remote = new BaseDialogPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the BaseDialogPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BaseDialogPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BaseDialogPageRemote, BaseDialogPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BaseDialogPageRemote, BaseDialogPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  navigateToNextStep: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BaseDialogPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.navigateToNextStep =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BaseDialogPage_NavigateToNextStep_ParamsSpec.$,
        null,
        this.navigateToNextStep.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const BaseDialogPageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseDialogPageHandler_ResizeDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseDialogPageHandler_ShowDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseDialogPageHandler_EventOccurred_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BaseDialogPage_NavigateToNextStep_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface BaseDialogPageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: BaseDialogPageRemote;
  receiver: BaseDialogPageHandlerPendingReceiver;
}


export type BaseDialogPageHandlerFactory_CreatePageHandler_Params = BaseDialogPageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<BaseDialogPageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    BaseDialogPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'BaseDialogPageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<BaseDialogPageHandlerFactory_CreatePageHandler_ParamsMojoType, BaseDialogPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(BaseDialogPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseDialogPageHandlerFactory_CreatePageHandler_ParamsMojoType, BaseDialogPageHandlerPendingReceiver>(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(BaseDialogPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface BaseDialogPageHandler_ResizeDialog_ParamsMojoType {
  height: number;
}


export type BaseDialogPageHandler_ResizeDialog_Params = BaseDialogPageHandler_ResizeDialog_ParamsMojoType;
mojo.internal.Struct<BaseDialogPageHandler_ResizeDialog_ParamsMojoType>(
    BaseDialogPageHandler_ResizeDialog_ParamsSpec.$,
    'BaseDialogPageHandler_ResizeDialog_Params',
    [
      mojo.internal.StructField<BaseDialogPageHandler_ResizeDialog_ParamsMojoType, number>(
        'height', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BaseDialogPageHandler_ShowDialog_ParamsMojoType {
}


export type BaseDialogPageHandler_ShowDialog_Params = BaseDialogPageHandler_ShowDialog_ParamsMojoType;
mojo.internal.Struct<BaseDialogPageHandler_ShowDialog_ParamsMojoType>(
    BaseDialogPageHandler_ShowDialog_ParamsSpec.$,
    'BaseDialogPageHandler_ShowDialog_Params',
    [
    ],
    [[0, 8],]);





export interface BaseDialogPageHandler_EventOccurred_ParamsMojoType {
  notice: privacySandbox_notice_mojom_PrivacySandboxNotice;
  event: privacySandbox_notice_mojom_PrivacySandboxNoticeEvent;
}


export type BaseDialogPageHandler_EventOccurred_Params = BaseDialogPageHandler_EventOccurred_ParamsMojoType;
mojo.internal.Struct<BaseDialogPageHandler_EventOccurred_ParamsMojoType>(
    BaseDialogPageHandler_EventOccurred_ParamsSpec.$,
    'BaseDialogPageHandler_EventOccurred_Params',
    [
      mojo.internal.StructField<BaseDialogPageHandler_EventOccurred_ParamsMojoType, privacySandbox_notice_mojom_PrivacySandboxNotice>(
        'notice', 0,
        0,
        privacySandbox_notice_mojom_PrivacySandboxNoticeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BaseDialogPageHandler_EventOccurred_ParamsMojoType, privacySandbox_notice_mojom_PrivacySandboxNoticeEvent>(
        'event', 4,
        0,
        privacySandbox_notice_mojom_PrivacySandboxNoticeEventSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface BaseDialogPage_NavigateToNextStep_ParamsMojoType {
  nextStep: privacySandbox_notice_mojom_PrivacySandboxNotice;
}


export type BaseDialogPage_NavigateToNextStep_Params = BaseDialogPage_NavigateToNextStep_ParamsMojoType;
mojo.internal.Struct<BaseDialogPage_NavigateToNextStep_ParamsMojoType>(
    BaseDialogPage_NavigateToNextStep_ParamsSpec.$,
    'BaseDialogPage_NavigateToNextStep_Params',
    [
      mojo.internal.StructField<BaseDialogPage_NavigateToNextStep_ParamsMojoType, privacySandbox_notice_mojom_PrivacySandboxNotice>(
        'nextStep', 0,
        0,
        privacySandbox_notice_mojom_PrivacySandboxNoticeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



