export interface RouteObserver {
    onRouteChanged(pageName: string | null, searchQuery: string | null): void;
}
export declare class Router {
    private static instance;
    private observers;
    private currentPage;
    private currentSearchQuery;
    private constructor();
    static resetInstanceForTesting(): void;
    static getInstance(): Router;
    navigateTo(pageName: string): void;
    setSearchQuery(query: string): void;
    processInitialRoute(defaultPage: string): void;
    addObserver(observer: RouteObserver): void;
    removeObserver(observer: RouteObserver): void;
    private getRouteFromUrl;
    private setRoute;
}
