import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '//resources/cr_elements/cr_icon/cr_icon.js';
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import './site_favicon.js';
import type { CrCollapseElement } from '//resources/cr_elements/cr_collapse/cr_collapse.js';
import type { CrExpandButtonElement } from '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { Member } from './related_website_sets.mojom-webui.js';
import { SiteType } from './related_website_sets.mojom-webui.js';
export interface RelatedWebsiteSetsListItemElement {
    $: {
        expandedContent: CrCollapseElement;
        expandButton: CrExpandButtonElement;
    };
}
export declare class RelatedWebsiteSetsListItemElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        expanded: {
            type: BooleanConstructor;
        };
        primarySite: {
            type: StringConstructor;
        };
        memberSites: {
            type: ArrayConstructor;
        };
        managedByEnterprise: {
            type: BooleanConstructor;
        };
        query: {
            type: StringConstructor;
        };
    };
    accessor expanded: boolean;
    accessor primarySite: string;
    accessor memberSites: Member[];
    accessor managedByEnterprise: boolean;
    accessor query: string;
    updated(changedProperties: PropertyValues<this>): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    protected onExpandedChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected getSiteType_(type: SiteType): string;
    protected isEnterpriseIconHidden_(): boolean;
    protected boldQuery_(url: string): string | (string | import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>)[];
    protected getIconImageUrl_(site: string): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'related-website-sets-list-item': RelatedWebsiteSetsListItemElement;
    }
}
