import type { AnnotationBrush, Color, Point, TextAnnotation, TextAttributes, TextBoxRect, TextStyles } from './constants.js';
import { AnnotationBrushType, TextAlignment, TextTypeface } from './constants.js';
import type { Viewport, ViewportRect } from './viewport.js';
export interface ViewportParams {
    clockwiseRotations: number;
    pageDimensions: ViewportRect;
    zoom: number;
}
export interface TextBoxInit {
    annotation: TextAnnotation;
    pageDimensions: ViewportRect;
}
export declare const DEFAULT_TEXTBOX_WIDTH: number;
export declare const MIN_TEXTBOX_SIZE_PX = 24;
export declare function colorsEqual(color1: Color, color2: Color): boolean;
export declare function stylesEqual(style1: TextStyles, style2: TextStyles): boolean;
/**
 * Converts `rect` from `oldRotations` clockwise rotations to `newRotations`
 * clockwise rotations. `newPageWidth` should be the page width in
 * `newRotations` coordinates, and `newPageHeight` should be the page height in
 * `newRotations` coordinates.
 */
export declare function convertRotatedCoordinates(rect: TextBoxRect, oldRotations: number, newRotations: number, newPageWidth: number, newPageHeight: number): TextBoxRect;
export declare class Ink2Manager extends EventTarget {
    private brush_;
    private annotations_;
    private attributes_;
    private brushResolver_;
    private existingAnnotationAttributes_;
    private pageNumber_;
    private pluginController_;
    private textResolver_;
    private viewport_;
    private viewportParams_;
    private nextAnnotationId_;
    setViewport(viewport: Viewport): void;
    resetAnnotationIdForTest(): void;
    initializeTextAnnotation(location?: Point): boolean;
    getViewportParams(): ViewportParams;
    viewportChanged(): void;
    isInitializationStarted(): boolean;
    isTextInitializationComplete(): boolean;
    isInitializationComplete(): boolean;
    getCurrentBrush(): AnnotationBrush;
    getCurrentTextAttributes(): TextAttributes;
    initializeBrush(): Promise<void>;
    initializeTextAnnotations(): Promise<void>;
    setBrushColor(color: Color): void;
    setBrushSize(size: number): void;
    setBrushType(type: AnnotationBrushType): Promise<void>;
    setTextTypeface(typeface: TextTypeface): void;
    setTextSize(size: number): void;
    setTextColor(color: Color): void;
    setTextAlignment(alignment: TextAlignment): void;
    setTextStyles(styles: TextStyles): void;
    private pageToScreenCoordinates_;
    private screenToPageCoordinates_;
    /**
     * Updates the stored annotation and notifies the plugin of the new or
     * modified annotation.
     */
    commitTextAnnotation(annotation: TextAnnotation, edited: boolean): void;
    textBoxFocused(textBoxRect: TextBoxRect): void;
    /**
     * Sets the current brush properties to the values in `brush`.
     */
    private setAnnotationBrush_;
    /**
     * Sets the annotation brush in the plugin with the current brush parameters.
     */
    private setAnnotationBrushInPlugin_;
    private fireBrushChanged_;
    private fireAttributesChanged_;
    static getInstance(): Ink2Manager;
    static setInstance(obj: Ink2Manager): void;
}
