import 'chrome://resources/cr_elements/cr_icon/cr_iconset.js';
import {getTrustedHTML} from 'chrome://resources/js/static_types.js';

const div = document.createElement('div');
div.innerHTML = getTrustedHTML`<cr-iconset size="20" name="pdf">
  <svg>
    <defs>
      <g id="add" viewBox="0 -960 960 960"><path d="M444-444H240v-72h204v-204h72v204h204v72H516v204h-72v-204Z"></path></g>
      <g id="attach-file" viewBox="0 -960 960 960"><path d="M696-312q0 89.86-63.07 152.93Q569.86-96 480-96q-91 0-153.5-65.5T264-319v-389q0-65 45.5-110.5T420-864q66 0 111 48t45 115v365q0 40.15-27.93 68.07Q520.15-240 480-240q-41 0-68.5-29.09T384-340v-380h72v384q0 10.4 6.8 17.2 6.8 6.8 17.2 6.8 10.4 0 17.2-6.8 6.8-6.8 6.8-17.2v-372q0-35-24.5-59.5T419.8-792q-35.19 0-59.5 25.5Q336-741 336-706v394q0 60 42 101.5T480-168q60 1 102-43t42-106v-403h72v408Z"></path></g>
      <g id="check" viewBox="0 -960 960 960"><path d="M389-267 195-460l51-52 143 143 325-324 51 51-376 375Z"></path></g>
      <g id="doc-outline" viewBox="0 -960 960 960"><path d="M323.79-288q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Zm0-156q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Zm0-156q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM432-288h240v-72H432v72Zm0-156h240v-72H432v72Zm0-156h240v-72H432v72ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v528Zm0-528v528-528Z"></path></g>
      <g id="fit-to-height" viewBox="0 -960 960 960"><path d="M263.72-96Q234-96 213-117.15T192-168v-624q0-29.7 21.16-50.85Q234.32-864 264.04-864h432.24Q726-864 747-842.85T768-792v624q0 29.7-21.16 50.85Q725.68-96 695.96-96H263.72ZM696-168v-624H264v624h432Zm0-624H264h432ZM360-600h240L480-720 360-600Zm120 360 120-120H360l120 120Z"></path></g>
      <g id="fit-to-width" viewBox="0 -960 960 960"><path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm624-504H168v432h624v-432Zm-624 0v432-432Zm192 336v-240L240-480l120 120Zm360-120L600-600v240l120-120Z"></path></g>
      <g id="fullscreen-exit" viewBox="0 -960 960 960"><path d="M264-144v-120H144v-72h192v192h-72Zm360 0v-192h192v72H696v120h-72ZM144-624v-72h120v-120h72v192H144Zm480 0v-192h72v120h120v72H624Z"></path></g>
      <g id="menu" viewBox="0 -960 960 960"><path d="M144-264v-72h672v72H144Zm0-180v-72h672v72H144Zm0-180v-72h672v72H144Z"></path></g>
      <g id="more" viewBox="0 -960 960 960" width="20px"><path d="M479.79-192Q450-192 429-213.21t-21-51Q408-294 429.21-315t51-21Q510-336 531-314.79t21 51Q552-234 530.79-213t-51 21Zm0-216Q450-408 429-429.21t-21-51Q408-510 429.21-531t51-21Q510-552 531-530.79t21 51Q552-450 530.79-429t-51 21Zm0-216Q450-624 429-645.21t-21-51Q408-726 429.21-747t51-21Q510-768 531-746.79t21 51Q552-666 530.79-645t-51 21Z"></path></g>
      <g id="print" viewBox="0 -960 960 960"><path d="M648-624v-120H312v120h-72v-192h480v192h-72Zm-480 72h625-625Zm539.79 96q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM648-216v-144H312v144h336Zm72 72H240v-144H96v-240q0-40 28-68t68-28h576q40 0 68 28t28 68v240H720v144Zm73-216v-153.67Q793-530 781-541t-28-11H206q-16.15 0-27.07 11.04Q168-529.92 168-513.6V-360h72v-72h480v72h73Z"></path></g>
      <g id="redo" viewBox="0 -960 960 960"><path d="M384-192q-80 0-136-56t-56-136q0-80 56-136t136-56h246l-93-93 51-51 180 180-180 180-51-51 93-93H384q-50 0-85 35t-35 85q0 50 35 85t85 35h288v72H384Z"></path></g>
      <g id="remove" viewBox="0 -960 960 960"><path d="M232-444v-72h496v72H232Z"></path></g>
      <g id="rotate-left" viewBox="0 -960 960 960"><path d="M528-84q-52 0-98.5-14.5T343-140l52-52q29 17 63 26.5t70 9.5q109 0 186.5-77.5T792-420q0-109-77.5-187.5T522-684l57 57-51 51-144-144 144-144 51 51-57 57q144-3 243 96.5T864-420q0 70-26.5 131t-72 106.5Q720-137 659-110.5T528-84Zm-240-96L48-420l240-240 240 240-240 240Zm0-102 138-138-138-138-138 138 138 138Zm0-138Z"></path></g>
      <g id="thumbnails" viewBox="0 -960 960 960"><path d="M216-144q-29.7 0-50.85-21.5Q144-187 144-216v-528q0-29 21.15-50.5T216-816h528q29.7 0 50.85 21.5Q816-773 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h528v-528H216v528Zm48-72h432L552-480 444-336l-72-96-108 144Zm-48 72v-528 528Z"></path></g>
      <g id="undo" viewBox="0 -960 960 960"><path d="M288-192v-72h288q50 0 85-35t35-85q0-50-35-85t-85-35H330l93 93-51 51-180-180 180-180 51 51-93 93h246q80 0 136 56t56 136q0 80-56 136t-136 56H288Z"></path></g>

      <g id="add-to-drive" viewBox="0 -960 960 960"><path d="M232-120q-17 0-31.5-8.5t-22.29-22.09L80.79-320.41Q73-334 73-351t8-31l248-427q8-14 22.5-22.5t31.06-8.5h194.88q16.56 0 31.06 8.5t22.42 22.37L811-500q-21-5-42-4.5t-42 4.5L571-768H389L146-351l92 159h337q11 21.17 25.5 39.59Q615-134 634-120H232Zm68-171-27-48 172.95-302H514l110 192q-14.32 13-26.53 28.5T576-388l-96-168-111 194h196q-6 17-9.5 34.7-3.5 17.71-3.5 36.3H300Zm432 147v-108H624v-72h108v-108h72v108h108v72H804v108h-72Z"></path></g>
      <g id="arrow-upward-alt" viewBox="0 -960 960 960"><path d="M440-240v-368L296-464l-56-56 240-240 240 240-56 56-144-144v368h-80Z"></path></g>
      <g id="cancel-unfill" viewBox="0 -960 960 960"><path d="m339-288 141-141 141 141 51-51-141-141 141-141-51-51-141 141-141-141-51 51 141 141-141 141 51 51ZM480-96q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30-149.5t82.5-122Q261-804 331-834t149-30q80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 79-30 149t-82.5 122.5Q699-156 629.5-126T480-96Zm0-72q130 0 221-91t91-221q0-130-91-221t-221-91q-130 0-221 91t-91 221q0 130 91 221t221 91Zm0-312Z"></path></g>
      <g id="pdf-icon" viewBox="0 -960 960 960"><path d="M612-384h48v-64h48v-48h-48v-32h48v-48h-96v192Zm-360 0h48v-64h36q20.4 0 34.2-13.8Q384-475.6 384-496v-32q0-20.4-13.8-34.2Q356.4-576 336-576h-84v192Zm48-112v-32h36v32h-36Zm132 112h84q20.4 0 34.2-13.8Q564-411.6 564-432v-96q0-20.4-13.8-34.2Q536.4-576 516-576h-84v192Zm48-48v-96h36v96h-36ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Z"></path></g>

    </defs>
  </svg>
</cr-iconset>


  <cr-iconset size="24" name="pdf-ink">
    <svg>
      <defs>
      <g id="annotate" viewBox="0 -960 960 960"><path d="M547-144q-46 0-77-32t-31-80q0-69 62.5-127.5T649-454q-7-48-26-73t-49-25q-35 0-74.5 33.5T418-420q-44 68-85 100t-83 32q-45 0-72.5-31.5T150-402q0-42 20-90.5T231-599q29-41 43.5-70.5T289-719q0-11-4.5-17.5T272-743q-11 0-29 13.5T195-686l-51-50q44-44 73-62t56-18q37 0 62 27t25 68q0 33-19 75.5T287-555q-32 44-49 81.5T221-406q0 20 9 33t23 13q12 0 23.5-6.5T304-390q11-11 23.5-27.5T354-455q57-85 112-127t109-42q60 0 100 46t46 122h95v72h-92q0 95-53.5 167.5T547-144Zm3-71q37 0 69.5-53T652-381q-53 9-97.5 47.5T510-258q0 18 11.5 30.5T550-215Z"></path></g>
      <g id="highlighter-size-1" viewBox="0 -960 960 960"><path d="m268-212-56-56q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t28.5 12l56 56q12 12 12 28.5T748-635L324-212q-11 11-28 11t-28-11Z"></path></g>
      <g id="highlighter-size-2" viewBox="0 -960 960 960"><path d="m282-198-84-84q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t28.5 12l84 85q11 11 11 28t-11 28L339-198q-12 12-28.5 12T282-198Z"></path></g>
      <g id="highlighter-size-3" viewBox="0 -960 960 960"><path d="M310-170 169-311q-11-11-11-28t11-28l423-424q12-12 29-12t28 12l141 142q11 11 11 28t-11 28L367-170q-12 12-28.5 12T310-170Z"></path></g>
      <g id="highlighter-size-4" viewBox="0 -960 960 960"><path d="M353-127 127-353q-12-12-12-28.5t12-28.5l423-423q12-12 28.5-12t27.5 12l227 226q12 12 12 28.5T833-550L410-127q-12 12-28.5 12T353-127Z"></path></g>
      <g id="highlighter-size-5" viewBox="0 -960 960 960"><path d="M410-70 70-410q-11-11-11-28t11-28l424-424q11-11 27.5-11t28.5 12l340 339q11 11 11 28t-11 28L466-70q-11 11-28 11t-28-11Z"></path></g>
      <g id="ink-eraser" viewBox="0 -960 960 960"><path d="M672-264h192v72H600l72-72Zm-437 72L117-310q-21-21-21.5-50.5T117-412l431-431q22-22 51-22t51.27 22.27L843-650q21 21 21.5 50.5T843-548L487-192H235Zm222-72 335-335-193-193-431 431 97 97h192Zm23-216Z"></path></g>
      <g id="ink-eraser-fill" viewBox="0 -960 960 960"><path d="M672-264h192v72H600l72-72Zm-437 72L117-310q-21-21-21.5-50.5T117-412l431-431q22-22 51-22t51 22l193 193q21 21 21.5 50.5T843-548L487-192H235Z"></path></g>
      <g id="ink-highlighter" viewBox="0 -960 960 960"><path d="m548-410-90-91-193 193 91 91 192-193Zm-38-143 90 91 192-192-90-91-192 192Zm-77-24 192 192-218 218q-22 20-50.5 21.5T308-164l-20 20H96l116-116q-21-20-20-49.5t23-49.5l218-218Zm0 0 218-218q21-21 51-21t51 21l90 90q20 22 20 51t-20 51L625-385 433-577Z"></path></g>
      <g id="ink-highlighter-fill" viewBox="0 -960 960 960"><path d="m407-551 192 192-192 192q-22 20-50.5 21.5T308-164l-20 20H96l116-116q-21-20-20-49.5t23-49.5l192-192Zm52-52 192-192q21-21 51-21t51 21l90 90q20 22 20 51t-20 51L651-411 459-603Z"></path></g>
      <g id="ink-pen" viewBox="0 -960 960 960"><path d="m484-526 42 42 208-208-42-42-208 208ZM216-216h42l218-218-42-42-218 218v42Zm336-192L408-552l136-136-51-51-201 201-51-51 202-201q21-21 50.5-21t50.5 21l51 51 63-63q14-14 34-14t34 14l76 76q14 14 13.5 33.5T802-658L552-408ZM288-144H144v-144l264-264 144 144-264 264Z"></path></g>
      <g id="ink-pen-fill" viewBox="0 -960 960 960"><path d="M602-458 458-602l86-86-51-51-201 201-51-51 202-201q21-21 50.5-21t50.5 21l51 51 63-63q14-14 34-14t34 14l76 76q14 14 13.5 33.5T802-658L602-458ZM288-144H144v-144l263-263 144 144-263 263Z"></path></g>
      <g id="pen-size-1" viewBox="0 -960 960 960"><path d="M199-199q-9-9-9-21t9-21l520-520q9-9 21-9t21 9q9 9 9 21t-9 21L241-199q-9 9-21 9t-21-9Z"></path></g>
      <g id="pen-size-2" viewBox="0 -960 960 960"><path d="M212-212q-11-11-11-28t11-28l480-480q11-12 27.5-12t28.5 12q11 11 11 28t-11 28L268-212q-11 11-28 11t-28-11Z"></path></g>
      <g id="pen-size-3" viewBox="0 -960 960 960"><path d="M218-218q-17-17-17-42t17-42l440-440q17-18 42-17.5t42 17.5q17 17 17.5 42T742-658L302-218q-17 17-42 17.5T218-218Z"></path></g>
      <g id="pen-size-4" viewBox="0 -960 960 960"><path d="M229-229q-29-29-29-71t29-71l360-360q29-29 71-29t71 29q29 29 29 71t-29 71L371-229q-29 29-71 29t-71-29Z"></path></g>
      <g id="pen-size-5" viewBox="0 -960 960 960"><path d="M235-235q-35-35-35-85t35-85l320-320q35-35 85-35t85 35q35 35 35 85t-35 85L405-235q-35 35-85 35t-85-35Z"></path></g>
      <g id="text-align-center" viewBox="0 -960 960 960"><path d="M120-120v-80h720v80H120Zm160-160v-80h400v80H280ZM120-440v-80h720v80H120Zm160-160v-80h400v80H280ZM120-760v-80h720v80H120Z"></path></g>
      <g id="text-align-left" viewBox="0 -960 960 960"><path d="M120-120v-80h720v80H120Zm0-160v-80h480v80H120Zm0-160v-80h720v80H120Zm0-160v-80h480v80H120Zm0-160v-80h720v80H120Z"></path></g>
      <g id="text-align-right" viewBox="0 -960 960 960"><path d="M120-760v-80h720v80H120Zm240 160v-80h480v80H360ZM120-440v-80h720v80H120Zm240 160v-80h480v80H360ZM120-120v-80h720v80H120Z"></path></g>
      <g id="text-annotate" viewBox="0 -960 960 960"><path d="M280-160v-520H80v-120h520v120H400v520H280Zm360 0v-320H520v-120h360v120H760v320H640Z"></path></g>
      <g id="text-format-bold" viewBox="0 -960 960 960"><path d="M272-200v-560h221q65 0 120 40t55 111q0 51-23 78.5T602-491q25 11 55.5 41t30.5 90q0 89-65 124.5T501-200H272Zm121-112h104q48 0 58.5-24.5T566-372q0-11-10.5-35.5T494-432H393v120Zm0-228h93q33 0 48-17t15-38q0-24-17-39t-44-15h-95v109Z"></path></g>
      <g id="text-format-italic" viewBox="0 -960 960 960"><path d="M200-200v-100h160l120-360H320v-100h400v100H580L460-300h140v100H200Z"></path></g>
    </defs>
    </svg>
  </cr-iconset>

`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
  document.head.appendChild(iconset);
}
