/**
 * @fileoverview
 * `pref-toggle-button` is a toggle that controls a supplied preference.
 */
import '//resources/cr_elements/cr_actionable_row_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_toggle/cr_toggle.js';
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare class PrefToggleButtonElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** The main label. */
        label: {
            type: StringConstructor;
            value: string;
        };
        /** Additional (optional) sub-label. */
        subLabel: {
            type: StringConstructor;
            value: string;
        };
        /** Whether the control is checked. */
        checked: {
            type: BooleanConstructor;
            value: boolean;
            notify: boolean;
            reflectToAttribute: boolean;
        };
        /**
         * Whether the control is disabled, for example due to an extension
         * managing the preference.
         */
        disabled: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * If true, do not automatically set the preference value on user click.
         * Confirm the change first then call either sendPrefChange or
         * resetToPrefValue accordingly.
         */
        changeRequiresValidation: {
            type: BooleanConstructor;
            value: boolean;
        };
        noExtensionIndicator: BooleanConstructor;
        pref: ObjectConstructor;
    };
    static get observers(): string[];
    label: string;
    subLabel: string;
    checked: boolean;
    disabled: boolean;
    changeRequiresValidation: boolean;
    noExtensionIndicator: boolean;
    pref: chrome.settingsPrivate.PrefObject;
    ready(): void;
    /**
     * Handles non cr-toggle button clicks (cr-toggle handles its own click events
     * which don't bubble).
     */
    private onClick_;
    private onToggleClick_;
    private prefValueChanged_;
    private prefEnforcementChanged_;
    /** Update the pref to the current |checked| value. */
    private updatePrefValue_;
    private getAriaLabel_;
    private isPrefEnforced_;
    private hasPrefPolicyIndicator_;
    private controlDisabled_;
}
declare global {
    interface HTMLElementTagNameMap {
        'pref-toggle-button': PrefToggleButtonElement;
    }
}
