import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export type PageHandlerFactoryPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
export declare class PageHandlerFactoryPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerFactoryInterface {
    createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}
export declare class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerFactoryPendingReceiverEndpoint);
    createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerFactoryReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerFactoryInterface);
}
export declare class PageHandlerFactory {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerFactoryRemote;
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerFactoryCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    extendAuthValidity(): void;
    deleteAllPasswordManagerData(): Promise<{
        success: boolean;
    }>;
    copyPlaintextBackupPassword(id: number): Promise<{
        success: boolean;
    }>;
    removeBackupPassword(id: number): void;
    getActorLoginPermissions(): Promise<{
        sites: ActorLoginPermission[];
    }>;
    revokeActorLoginPermission(site: ActorLoginPermission): void;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    extendAuthValidity(): void;
    deleteAllPasswordManagerData(): Promise<{
        success: boolean;
    }>;
    copyPlaintextBackupPassword(id: number): Promise<{
        success: boolean;
    }>;
    removeBackupPassword(id: number): void;
    getActorLoginPermissions(): Promise<{
        sites: ActorLoginPermission[];
    }>;
    revokeActorLoginPermission(site: ActorLoginPermission): void;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    extendAuthValidity: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    deleteAllPasswordManagerData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    copyPlaintextBackupPassword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    removeBackupPassword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getActorLoginPermissions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    revokeActorLoginPermission: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(_impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const FormattedUrlSpec: {
    $: mojo.internal.MojomType;
};
export declare const ActorLoginPermissionSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandlerFactory_CreatePageHandler_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ExtendAuthValidity_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_DeleteAllPasswordManagerData_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_DeleteAllPasswordManagerData_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CopyPlaintextBackupPassword_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_CopyPlaintextBackupPassword_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RemoveBackupPassword_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetActorLoginPermissions_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetActorLoginPermissions_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_RevokeActorLoginPermission_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface FormattedUrlMojoType {
    humanReadableUrl: string;
    link: string;
}
export type FormattedUrl = FormattedUrlMojoType;
export interface ActorLoginPermissionMojoType {
    url: FormattedUrl;
    username: string;
}
export type ActorLoginPermission = ActorLoginPermissionMojoType;
export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
    page: PageRemote;
    handler: PageHandlerPendingReceiver;
}
export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
export interface PageHandler_ExtendAuthValidity_ParamsMojoType {
}
export type PageHandler_ExtendAuthValidity_Params = PageHandler_ExtendAuthValidity_ParamsMojoType;
export interface PageHandler_DeleteAllPasswordManagerData_ParamsMojoType {
}
export type PageHandler_DeleteAllPasswordManagerData_Params = PageHandler_DeleteAllPasswordManagerData_ParamsMojoType;
export interface PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType {
    success: boolean;
}
export type PageHandler_DeleteAllPasswordManagerData_ResponseParams = PageHandler_DeleteAllPasswordManagerData_ResponseParamsMojoType;
export interface PageHandler_CopyPlaintextBackupPassword_ParamsMojoType {
    id: number;
}
export type PageHandler_CopyPlaintextBackupPassword_Params = PageHandler_CopyPlaintextBackupPassword_ParamsMojoType;
export interface PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType {
    success: boolean;
}
export type PageHandler_CopyPlaintextBackupPassword_ResponseParams = PageHandler_CopyPlaintextBackupPassword_ResponseParamsMojoType;
export interface PageHandler_RemoveBackupPassword_ParamsMojoType {
    id: number;
}
export type PageHandler_RemoveBackupPassword_Params = PageHandler_RemoveBackupPassword_ParamsMojoType;
export interface PageHandler_GetActorLoginPermissions_ParamsMojoType {
}
export type PageHandler_GetActorLoginPermissions_Params = PageHandler_GetActorLoginPermissions_ParamsMojoType;
export interface PageHandler_GetActorLoginPermissions_ResponseParamsMojoType {
    sites: ActorLoginPermission[];
}
export type PageHandler_GetActorLoginPermissions_ResponseParams = PageHandler_GetActorLoginPermissions_ResponseParamsMojoType;
export interface PageHandler_RevokeActorLoginPermission_ParamsMojoType {
    site: ActorLoginPermission;
}
export type PageHandler_RevokeActorLoginPermission_Params = PageHandler_RevokeActorLoginPermission_ParamsMojoType;
