import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shared-style">cr-checkbox{display:flex;padding:10px 8px}#avatar{border-radius:50%;height:20px;margin-inline-end:16px;width:20px}.cr-row{padding:0}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title" class="dialog-title">
    $i18n{deletePasswordDialogAccount}
  </div>
  <div slot="body">
    <div inner-h-t-m-l="[[getDialogBodyMessage_()]]"></div>
    <cr-checkbox checked="{{removeFromAccountChecked_}}"
        id="removeFromAccountCheckbox">
      <div class="cr-row first">
        <img id="avatar" src="[[avatarImage]]"></img>
        <div>
          $i18n{deletePasswordDialogAccount}
        </div>
        <div class="cr-secondary-text">
          &nbsp([[accountEmail]])
        </div>
      </div>
    </cr-checkbox>
    <cr-checkbox checked="{{removeFromDeviceChecked_}}"
        id="removeFromDeviceCheckbox">
      <div>
        $i18n{deletePasswordDialogDevice}
      </div>
    </cr-checkbox>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" id="cancelButton"
        on-click="onCancelButtonClick_" autofocus>
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" id="removeButton"
        disabled="[[shouldDisableRemoveButton_(removeFromAccountChecked_,
            removeFromDeviceChecked_)]]"
        on-click="onRemoveButtonClick_">
      $i18n{deletePassword}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
