import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-input-style cr-shared-style
                credential-details-card cr-icons">:host{isolation:auto}#shareButtonContainer{margin-inline-start:auto;display:flex}#movePasswordLink>a[href]{color:var(--cr-link-color)}cr-tooltip-icon{margin-block:auto;margin-inline-end:16px}#uploadSinglePassword{width:16px;height:16px;vertical-align:text-bottom;margin-inline-end:8px}.move-password-container{display:flex;margin-top:4px;margin-bottom:10px;padding:0 var(--cr-form-field-bottom-spacing);align-items:center}</style>
<div class="card" aria-label="[[getAriaLabelForPasswordCard_(password)]]"
    role="region">
  <div class="credential-container">
    <div class="row-container">
      <div class="column-container">
        <credential-field value="[[password.username]]" id="usernameValue"
            label="$i18n{usernameLabel}" copy-button-label="$i18n{copyUsername}"
            value-copied-toast-label="$i18n{usernameCopiedToClipboard}"
            placeholder="$i18n{emptyUsername}"
            interaction-id="[[interactionsEnum_.USERNAME_COPY_BUTTON_CLICKED]]">
        </credential-field>
      </div>
      <div class="column-container">
        <div id="domainLabel" class="cr-form-field-label">
          [[getDomainLabel_(password)]]
        </div>
        <template id="links" is="dom-repeat"
            items="[[password.affiliatedDomains]]">
          <div class="elide-left">
            <a href="[[item.url]]" class="site-link" target="_blank">
              [[item.name]]
            </a>
          </div>
        </template>
      </div>
    </div>
    <div class="row-container">
      <div class="column-container">
        <cr-input id="passwordValue" label="[[getPasswordLabel_(password)]]"
            value="[[getPasswordValue_(password)]]"
            class="input-field password-input"
            role="textbox"
            type="[[getPasswordType_(password, isPasswordVisible)]]"
            readonly aria-disabled="true">
          <cr-icon-button id="showPasswordButton"
              class$="[[getShowHideButtonIconClass(isPasswordVisible)]]"
              title="[[getShowHideButtonLabel(isPasswordVisible)]]"
              on-click="onShowPasswordClick_" slot="inline-suffix"
              hidden="[[isFederated_(password)]]">
          </cr-icon-button>
          <cr-icon-button id="copyPasswordButton" class="icon-copy-content"
              title="$i18n{copyPassword}" on-click="onCopyPasswordClick_"
              slot="inline-suffix" hidden="[[isFederated_(password)]]">
          </cr-icon-button>
        </cr-input>
      </div>
      <div class="column-container">
        <div hidden="[[isFederated_(password)]]">
          <credential-note note="[[password.note]]" id="noteValue">
          </credential-note>
        </div>
      </div>
    </div>
  </div>
  <template is="dom-if"
      if="[[showMovePasswordEntry_(password.storedIn, isUsingAccountStore)]]"
      restamp>
    <div class="move-password-container">
      <cr-icon id="uploadSinglePassword" icon="passwords-icon:upload"
          aria-hidden="true">
      </cr-icon>
      <div id="movePasswordLink" class="cr-secondary-text"
          on-click="movePasswordClicked_"
          inner-h-t-m-l="[[computeMovePasswordText_()]]">
      </div>
    </div>
  </template>
  <div class="button-container">
    <cr-button id="editButton" hidden="[[isFederated_(password)]]"
        class="edit-button" on-click="onEditClicked_"
        aria-label="[[getAriaLabelForEditButton_(password)]]">
      $i18n{editPassword}
    </cr-button>
    <cr-button id="deleteButton"
        on-click="onDeleteClick_"
        aria-label="[[getAriaLabelForDeleteButton_(password)]]">
      $i18n{deletePassword}
    </cr-button>
    <div id="shareButtonContainer" hidden="[[!showShareButton_]]">
      <cr-tooltip-icon icon-class="cr20:domain"
        hidden="[[!passwordSharingDisabled_]]"
        tooltip-text="$i18n{sharePasswordManagedByAdmin}"
        icon-aria-label="$i18n{sharePasswordManagedByAdmin}">
      </cr-tooltip-icon>
      <cr-button id="shareButton" on-click="onShareButtonClick_"
          disabled="[[passwordSharingDisabled_]]">
        $i18n{share}
      </cr-button>
    </div>
    <template is="dom-if" if="[[showShareFlow_]]" restamp>
      <share-password-flow password-name="[[groupName]]" icon-url="[[iconUrl]]"
          password="[[password]]" on-share-flow-done="onShareFlowDone_">
      </share-password-flow>
    </template>
  </div>
</div>
<template is="dom-if" if="[[showEditPasswordDialog_]]" restamp>
  <edit-password-dialog on-close="onEditPasswordDialogClosed_"
      id="editPasswordDialog" credential="{{password}}">
  </edit-password-dialog>
</template>
<template is="dom-if" if="[[showDeletePasswordDialog_]]" restamp>
  <multi-store-delete-password-dialog on-close="onDeletePasswordDialogClosed_"
      id="deletePasswordDialog" duplicated-password="[[password]]">
  </multi-store-delete-password-dialog>
</template>
<template is="dom-if" if="[[showMovePasswordDialog_]]" restamp>
  <move-single-password-dialog on-close="onMovePasswordDialogClose_"
      id="movePasswordsDialog" password="[[password]]">
  </move-single-password-dialog>
</template>
<!--_html_template_end_-->`;
}