"use strict";
/**
 * @license
 * Copyright 2013 The Chromium Authors
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 * SPDX-License-Identifier: BSD-3-Clause
 */const MV_DOMAIN_ORIGIN="{{ORIGIN}}";function convertToHexColor(color){if(isFinite(color)&&Math.floor(color)===color&&color>=0&&color<=16777215){const hexColor=color.toString(16);return"#000000".substr(0,7-hexColor.length)+hexColor}return null}function isValidRBGAComponent(component){return isFinite(component)&&component>=0&&component<=255}function convertArrayToRGBAColor(rgbaColor){if(rgbaColor instanceof Array&&rgbaColor.length===4&&isValidRBGAComponent(rgbaColor[0])&&isValidRBGAComponent(rgbaColor[1])&&isValidRBGAComponent(rgbaColor[2])&&isValidRBGAComponent(rgbaColor[3])){return"rgba("+rgbaColor[0]+","+rgbaColor[1]+","+rgbaColor[2]+","+rgbaColor[3]/255+")"}return null}function parseQueryParams(location){const params=Object.create(null);const query=location.search.substring(1);const vars=query.split("&");for(let i=0;i<vars.length;i++){const pair=vars[i].split("=");const k=decodeURIComponent(pair[0]);if(k in params){return Object.create(null)}else{params[k]=decodeURIComponent(pair[1])}}return params}function createMostVisitedLink(params,href,title,text,direction){const styles=getMostVisitedStyles(params,!!text);const link=document.createElement("a");link.style.color=styles.color;link.style.fontSize=styles.fontSize+"px";if(styles.fontFamily){link.style.fontFamily=styles.fontFamily}if(styles.textAlign){link.style.textAlign=styles.textAlign}if(styles.textFadePos){const dir=/^rtl$/i.test(direction)?"to left":"to right";const mask="linear-gradient("+dir+", rgba(0,0,0,1), rgba(0,0,0,1) "+styles.textFadePos+"px, rgba(0,0,0,0))";link.style.textOverflow="clip";link.style.webkitMask=mask}if(styles.numTitleLines&&styles.numTitleLines>1){link.classList.add("multiline")}link.href=href;link.title=title;link.target="_top";link.tabIndex=0;if(text){const spanWrap=document.createElement("span");spanWrap.textContent=text;link.appendChild(spanWrap)}link.addEventListener("focus",(function(){window.parent.postMessage("linkFocused",MV_DOMAIN_ORIGIN)}));link.addEventListener("blur",(function(){window.parent.postMessage("linkBlurred",MV_DOMAIN_ORIGIN)}));link.addEventListener("keydown",(function(event){if(event.keyCode===46||event.keyCode===8){event.preventDefault();window.parent.postMessage("tileBlacklisted,"+params.pos,MV_DOMAIN_ORIGIN)}else if(event.keyCode===13||event.keyCode===32){event.preventDefault();event.target.click()}}));return link}function getTextColor(params,isTitle){if("c"in params&&params.c.match(/^[0-9A-Fa-f]{8}$/)){const t=params.c.match(/(..)(..)(..)(..)/).slice(1).map((function(s){return parseInt(s,16)}));return"rgba("+t[0]+","+t[1]+","+t[2]+","+t[3]/255+")"}const apiHandle=chrome.embeddedSearch.newTabPage;const ntpTheme=apiHandle.ntpTheme;let c="#777";if(isTitle&&ntpTheme&&!ntpTheme.usingDefaultTheme){c=convertArrayToRGBAColor(ntpTheme.textColorRgba)||c}else if("c"in params){c=convertToHexColor(parseInt(params.c,16))||c}return c}function getMostVisitedStyles(params,isTitle){const styles={color:getTextColor(params,isTitle),fontFamily:"",fontSize:11};if("f"in params&&/^[-0-9a-zA-Z ,]+$/.test(params.f)){styles.fontFamily=params.f}if("fs"in params){const fs=parseInt(params.fs,10);if(isFinite(fs)){styles.fontSize=fs}}if("ta"in params&&/^[-0-9a-zA-Z ,]+$/.test(params.ta)){styles.textAlign=params.ta}if("tf"in params){const tf=parseInt(params.tf,10);if(isFinite(tf)){styles.textFadePos=tf}}if("ntl"in params){const ntl=parseInt(params.ntl,10);if(isFinite(ntl)){styles.numTitleLines=ntl}}return styles}function isSchemeAllowed(url){return url.startsWith("http://")||url.startsWith("https://")||url.startsWith("ftp://")||url.startsWith("chrome-extension://")}function fillMostVisited(location,fill){const params=parseQueryParams(location);const rid=parseInt(params.rid,10);if(!isFinite(rid)){return}const data=chrome.embeddedSearch.newTabPage.getMostVisitedItemData(rid);if(!data){return}if(data.url&&!isSchemeAllowed(data.url)){return}const dummy=parseInt(params.dummy,10);if(isFinite(dummy)){data.dummy=true}if(data.direction){document.body.dir=data.direction}fill(params,data)}window.addEventListener("DOMContentLoaded",(function(){fillMostVisited(window.location,(function(params,data){document.body.appendChild(createMostVisitedLink(params,data.url,data.title,data.title,data.direction))}))}));