import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><div id="files">
  ${this.files.map((item, index) => html `
    <a class="file" href="${item.itemUrl.url}" data-index="${index}"
        @click="${this.onFileClick_}" title="${item.title}">
      <div id="hover-layer"></div>
      <icon-container class="icon-container">
        <img is="cr-auto-img"
          class="file-icon"
          draggable="false"
          .autoSrc="${item.iconUrl.url}">
      </icon-container>
      <div class="file-info">
        <div class="file-title">${item.title}</div>
        <div class="file-description">${item.justificationText}</div>
      </div>
    </a>
  `)}
</div>
<!--_html_template_end_-->`;
}
