import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_--><cr-dialog id="dialog" show-on-attach>
  <div id="title" slot="title">${this.title}</div>
  <div slot="body">
    <div id="buttons">
      <cr-button id="facebookButton" title="$i18n{facebook}"
          @click="${this.onFacebookClick_}">
      </cr-button>
      <cr-button id="twitterButton" title="$i18n{twitter}"
          @click="${this.onTwitterClick_}">
      </cr-button>
      <cr-button id="emailButton" title="$i18n{email}"
          @click="${this.onEmailClick_}">
      </cr-button>
    </div>
    <cr-input readonly label="$i18n{doodleLink}" id="url"
        .value="${this.url.url}">
      <cr-icon-button id="copyButton" slot="suffix" title="$i18n{copyLink}"
          @click="${this.onCopyClick_}">
      </cr-icon-button>
    </cr-input>
  </div>
  <div slot="button-container">
    <cr-button id="doneButton" class="action-button"
        @click="${this.onCloseClick_}">
      $i18n{doneButton}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
