// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ChipTypeSpec = { $: mojo.internal.Enum() };
export var ChipType;
(function (ChipType) {
    ChipType[ChipType["MIN_VALUE"] = 0] = "MIN_VALUE";
    ChipType[ChipType["MAX_VALUE"] = 3] = "MAX_VALUE";
    ChipType[ChipType["kImage"] = 0] = "kImage";
    ChipType[ChipType["kDeepSearch"] = 1] = "kDeepSearch";
    ChipType[ChipType["kRecentTab"] = 2] = "kRecentTab";
    ChipType[ChipType["kDeepDive"] = 3] = "kDeepDive";
})(ChipType || (ChipType = {}));
export class ActionChipsHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'action_chips.mojom.ActionChipsHandler', scope);
    }
}
export class ActionChipsHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ActionChipsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    startActionChipsRetrieval() {
        this.proxy.sendMessage(0, ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the ActionChipsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ActionChipsHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ActionChipsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$, null, impl.startActionChipsRetrieval.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ActionChipsHandler {
    static get $interfaceName() {
        return "action_chips.mojom.ActionChipsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ActionChipsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ActionChipsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ActionChipsHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    startActionChipsRetrieval;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ActionChipsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.startActionChipsRetrieval =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$, null, this.startActionChipsRetrieval.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'action_chips.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onActionChipsChanged(actionChips) {
        this.proxy.sendMessage(0, Page_OnActionChipsChanged_ParamsSpec.$, null, [
            actionChips
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnActionChipsChanged_ParamsSpec.$, null, impl.onActionChipsChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "action_chips.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onActionChipsChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onActionChipsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnActionChipsChanged_ParamsSpec.$, null, this.onActionChipsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ActionChipsHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'action_chips.mojom.ActionChipsHandlerFactory', scope);
    }
}
export class ActionChipsHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ActionChipsHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createActionChipsHandler(handler, page) {
        this.proxy.sendMessage(0, ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$, null, [
            handler,
            page
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ActionChipsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ActionChipsHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ActionChipsHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$, null, impl.createActionChipsHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ActionChipsHandlerFactory {
    static get $interfaceName() {
        return "action_chips.mojom.ActionChipsHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ActionChipsHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ActionChipsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ActionChipsHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createActionChipsHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ActionChipsHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createActionChipsHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$, null, this.createActionChipsHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TabInfoSpec = { $: {} };
export const ActionChipSpec = { $: {} };
export const ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec = { $: {} };
export const Page_OnActionChipsChanged_ParamsSpec = { $: {} };
export const ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec = { $: {} };
mojo.internal.Struct(TabInfoSpec.$, 'TabInfo', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveTime', 24, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(ActionChipSpec.$, 'ActionChip', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('suggestion', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, ChipTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tab', 24, 0, TabInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$, 'ActionChipsHandler_StartActionChipsRetrieval_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnActionChipsChanged_ParamsSpec.$, 'Page_OnActionChipsChanged_Params', [
    mojo.internal.StructField('actionChips', 0, 0, mojo.internal.Array(ActionChipSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$, 'ActionChipsHandlerFactory_CreateActionChipsHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(ActionChipsHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('page', 4, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
