import {html} from '//resources/lit/v3_0/lit.rollup.js';
import type {LensUploadDialogElement} from './lens_upload_dialog.js';

export function getHtml(this: LensUploadDialogElement) {
  return html`<!--_html_template_start_--><div id="dialog" ?hidden="${this.isHidden_}" tabindex="-1"
    lang="$i18n{language}" role="dialog" aria-modal="true"
    @focusout="${this.onFocusOut_}">
  <ntp-lens-form id="lensForm" @loading="${this.handleFormLoading_}"
      @error="${this.handleFormError_}">
  </ntp-lens-form>
  <div id="container">
    <cr-icon-button id="closeButton" class="icon-clear"
        title="$i18n{lensSearchUploadDialogCloseButtonLabel}"
        @click="${this.onCloseButtonClick_}"
        @keydown="${this.onCloseButtonKeydown_}">
    </cr-icon-button>
    <div id="title">$i18n{lensSearchUploadDialogTitle}</div>
    <div id="dragDropArea" @dragenter="${this.onDragEnter_}"
        @dragover="${this.onDragOver_}" @dragleave="${this.onDragLeave_}"
        @drop="${this.onDrop_}">
      <!-- Error state -->
      ${this.isError_ ? html`
        <div id="dragDropError">
          <div id="dragDropErrorMessage">${this.getErrorString_()}</div>
        </div>
      ` : ''}
      <!-- Normal state -->
      ${this.isNormalOrError_ ? html`
        <div class="drag-drop-title-container">
          <div id="dragDropIllustration"></div>
          <div class="drag-drop-title">
            <span id="dragText">$i18n{lensSearchUploadDialogDragTitle}</span>
            <span tabindex="0" role="button" id="uploadText"
                @click="${this.onUploadFileClick_}"
                @keydown="${this.onUploadFileKeyDown_}"
                @touchend="${this.onUploadFileTouchEnd_}">
              $i18n{lensSearchUploadDialogUploadFileTitle}
            </span>
          </div>
        </div>
        <div id="urlUploadContainer">
          <div id="sectionDivider">
            <div class="divider-line"></div>
            <div id="orLabel">$i18n{lensSearchUploadDialogOrText}</div>
            <div class="divider-line"></div>
          </div>
          <div id="inputContainer">
            <input id="inputBox" autocomplete="false" autocorrect="false"
                placeholder="$i18n{lensSearchUploadDialogTextPlaceholder}"
                text="text" .value="${this.uploadUrl_}"
                @input="${this.onInputBoxInput_}"
                @keydown="${this.onUrlKeyDown_}">
            <div id="inputSubmit" tabindex="0" role="button"
                @click="${this.onSubmitUrl_}"
                @keydown="${this.onInputSubmitKeyDown_}">
              $i18n{lensSearchUploadDialogSearchButtonLabel}
            </div>
          </div>
        </div>
      ` : ''}
      <!-- Dragging state -->
      ${this.isDragging_ ? html`
        <div class="drag-drop-title-container">
          <div class="drag-drop-title">
            $i18n{lensSearchUploadDialogDragDropTitle}
          </div>
        </div>
      ` : ''}
      <!-- Loading state -->
      ${this.isLoading_ ? html`
        <div id="loadingContainer">
          <div class="spinner"></div>
          <div class="drag-drop-title">
            $i18n{lensSearchUploadDialogLoadingText}
          </div>
        </div>
      ` : ''}
      <!-- Offline state -->
      ${this.isOffline_ ? html`
        <div id="offlineContainer">
          <div id="offlineImage"></div>
          <div id="offlineTitle" class="drag-drop-title">
            $i18n{lensSearchUploadDialogOfflineText}
          </div>
          <div id="offlineSubtitle">
            $i18n{lensSearchUploadDialogOfflineSubtitleText}
          </div>
          <cr-button id="offlineRetryButton" class="action-button"
              @click="${this.onOfflineRetryButtonClick_}"
              @keydown="${this.onOfflineRetryButtonKeydown_}">
            $i18n{lensSearchUploadDialogOfflineButtonLabel}
          </cr-button>
        </div>
      ` : ''}
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}