// chrome/browser/ui/webui/new_tab_page/action_chips/action_chips.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ChipTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ChipType {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kImage = 0,
  kDeepSearch = 1,
  kRecentTab = 2,
  kDeepDive = 3,
}



export type ActionChipsHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ActionChipsHandlerPendingReceiver>;

export class ActionChipsHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ActionChipsHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ActionChipsHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ActionChipsHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'action_chips.mojom.ActionChipsHandler',
        scope);
  }
}

export interface ActionChipsHandlerInterface {
  startActionChipsRetrieval(): void;
}

export class ActionChipsHandlerRemote implements ActionChipsHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ActionChipsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ActionChipsHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ActionChipsHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ActionChipsHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  startActionChipsRetrieval(): void {
    this.proxy.sendMessage(
        0,
        ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ActionChipsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ActionChipsHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ActionChipsHandlerRemote, ActionChipsHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ActionChipsHandlerRemote, ActionChipsHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ActionChipsHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ActionChipsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$,
        null,
        impl.startActionChipsRetrieval.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ActionChipsHandler {
  static get $interfaceName(): string {
    return "action_chips.mojom.ActionChipsHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ActionChipsHandlerRemote {
    let remote = new ActionChipsHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ActionChipsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ActionChipsHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ActionChipsHandlerRemote, ActionChipsHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ActionChipsHandlerRemote, ActionChipsHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  startActionChipsRetrieval: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ActionChipsHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.startActionChipsRetrieval =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$,
        null,
        this.startActionChipsRetrieval.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'action_chips.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onActionChipsChanged(actionChips: ActionChip[]): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onActionChipsChanged(
      actionChips: ActionChip[]): void {
    this.proxy.sendMessage(
        0,
        Page_OnActionChipsChanged_ParamsSpec.$,
        null,
        [
          actionChips
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnActionChipsChanged_ParamsSpec.$,
        null,
        impl.onActionChipsChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "action_chips.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onActionChipsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onActionChipsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnActionChipsChanged_ParamsSpec.$,
        null,
        this.onActionChipsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ActionChipsHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ActionChipsHandlerFactoryPendingReceiver>;

export class ActionChipsHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ActionChipsHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<ActionChipsHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|ActionChipsHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'action_chips.mojom.ActionChipsHandlerFactory',
        scope);
  }
}

export interface ActionChipsHandlerFactoryInterface {
  createActionChipsHandler(handler: ActionChipsHandlerPendingReceiver, page: PageRemote): void;
}

export class ActionChipsHandlerFactoryRemote implements ActionChipsHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ActionChipsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ActionChipsHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ActionChipsHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ActionChipsHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createActionChipsHandler(
      handler: ActionChipsHandlerPendingReceiver,
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$,
        null,
        [
          handler,
          page
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ActionChipsHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ActionChipsHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ActionChipsHandlerFactoryRemote, ActionChipsHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ActionChipsHandlerFactoryRemote, ActionChipsHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ActionChipsHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ActionChipsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$,
        null,
        impl.createActionChipsHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ActionChipsHandlerFactory {
  static get $interfaceName(): string {
    return "action_chips.mojom.ActionChipsHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ActionChipsHandlerFactoryRemote {
    let remote = new ActionChipsHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ActionChipsHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ActionChipsHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ActionChipsHandlerFactoryRemote, ActionChipsHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ActionChipsHandlerFactoryRemote, ActionChipsHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createActionChipsHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ActionChipsHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createActionChipsHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$,
        null,
        this.createActionChipsHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TabInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActionChipSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnActionChipsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TabInfoMojoType {
  tabId: number;
  title: string;
  url: url_mojom_Url;
  lastActiveTime: mojoBase_mojom_Time;
}


export type TabInfo = TabInfoMojoType;
mojo.internal.Struct<TabInfoMojoType>(
    TabInfoSpec.$,
    'TabInfo',
    [
      mojo.internal.StructField<TabInfoMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabInfoMojoType, mojoBase_mojom_Time>(
        'lastActiveTime', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface ActionChipMojoType {
  title: string;
  suggestion: string;
  type: ChipType;
  tab: (TabInfo | null);
}


export type ActionChip = ActionChipMojoType;
mojo.internal.Struct<ActionChipMojoType>(
    ActionChipSpec.$,
    'ActionChip',
    [
      mojo.internal.StructField<ActionChipMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionChipMojoType, string>(
        'suggestion', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionChipMojoType, ChipType>(
        'type', 16,
        0,
        ChipTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionChipMojoType, TabInfo>(
        'tab', 24,
        0,
        TabInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface ActionChipsHandler_StartActionChipsRetrieval_ParamsMojoType {
}


export type ActionChipsHandler_StartActionChipsRetrieval_Params = ActionChipsHandler_StartActionChipsRetrieval_ParamsMojoType;
mojo.internal.Struct<ActionChipsHandler_StartActionChipsRetrieval_ParamsMojoType>(
    ActionChipsHandler_StartActionChipsRetrieval_ParamsSpec.$,
    'ActionChipsHandler_StartActionChipsRetrieval_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnActionChipsChanged_ParamsMojoType {
  actionChips: ActionChip[];
}


export type Page_OnActionChipsChanged_Params = Page_OnActionChipsChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnActionChipsChanged_ParamsMojoType>(
    Page_OnActionChipsChanged_ParamsSpec.$,
    'Page_OnActionChipsChanged_Params',
    [
      mojo.internal.StructField<Page_OnActionChipsChanged_ParamsMojoType, ActionChip[]>(
        'actionChips', 0,
        0,
        mojo.internal.Array(ActionChipSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsMojoType {
  handler: ActionChipsHandlerPendingReceiver;
  page: PageRemote;
}


export type ActionChipsHandlerFactory_CreateActionChipsHandler_Params = ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsMojoType;
mojo.internal.Struct<ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsMojoType>(
    ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsSpec.$,
    'ActionChipsHandlerFactory_CreateActionChipsHandler_Params',
    [
      mojo.internal.StructField<ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsMojoType, ActionChipsHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(ActionChipsHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ActionChipsHandlerFactory_CreateActionChipsHandler_ParamsMojoType, PageRemote>(
        'page', 4,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



