// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{$}from"chrome://resources/js/util.js";import{addNode,addNodeWithText,setNodeDisplay,setNodePosition}from"./util.js";import{View}from"./view.js";const TAB_LIST_ID="tab-list";let instance=null;export class TabSwitcherView extends View{constructor(){super();this.tabIdToView_={};this.tabIdToLink_={};this.tabIdsLinkVisibility_=new Map;this.activeTabId_=null;this.onTabSwitched_=null;this.tabListWidth_=$(TAB_LIST_ID).offsetWidth}setOnTabSwitched(onTabSwitched){this.onTabSwitched_=onTabSwitched}setGeometry(left,top,width,height){super.setGeometry(this,left,top,width,height);const tabListNode=$(TAB_LIST_ID);let tabListWidth=this.tabListWidth_;if(tabListWidth>width){tabListWidth=width}tabListNode.style.position="absolute";setNodePosition(tabListNode,left,top,tabListWidth,height);for(const tabId in this.tabIdToView_){const view=this.tabIdToView_[tabId];view.setGeometry(left+tabListWidth,top,width-tabListWidth,height)}}show(isVisible){super.show(isVisible);const activeView=this.getActiveTabView();if(activeView){activeView.show(isVisible)}}addTab(tabId,view,name,hash){if(!tabId){throw Error("Must specify a non-false tabId")}this.tabIdToView_[tabId]=view;this.tabIdsLinkVisibility_.set(tabId,true);const node=addNodeWithText($(TAB_LIST_ID),"a",name);node.href=hash;this.tabIdToLink_[tabId]=node;addNode($(TAB_LIST_ID),"br");view.show(false);this.tabListWidth_=$(TAB_LIST_ID).offsetWidth}getAllTabViews(){return this.tabIdToView_}getTabView(tabId){return this.tabIdToView_[tabId]}getActiveTabView(){return this.tabIdToView_[this.activeTabId_]}getActiveTabId(){return this.activeTabId_}switchToTab(tabId){const newView=this.getTabView(tabId);if(!newView){throw Error("Invalid tabId")}const oldTabId=this.activeTabId_;this.activeTabId_=tabId;if(oldTabId){this.tabIdToLink_[oldTabId].classList.remove("selected");this.getTabView(oldTabId).show(false)}this.tabIdToLink_[tabId].classList.add("selected");newView.show(this.isVisible());if(this.onTabSwitched_){this.onTabSwitched_(oldTabId,tabId)}}static getInstance(){return instance||(instance=new TabSwitcherView)}}