import './object_layer.js';
import './simplified_text_layer.js';
import './text_layer.js';
import './region_selection.js';
import './post_selection_renderer.js';
import './overlay_border_glow.js';
import './overlay_shimmer_canvas.js';
import '/strings.m.js';
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_toast/cr_toast.js';
import type { CrIconButtonElement } from '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { getFallbackTheme } from './color_utils.js';
import type { CenterRotatedBox } from './geometry.mojom-webui.js';
import type { ObjectLayerElement } from './object_layer.js';
import type { OverlayShimmerCanvasElement } from './overlay_shimmer_canvas.js';
import type { PostSelectionRendererElement } from './post_selection_renderer.js';
import type { RegionSelectionElement } from './region_selection.js';
import { CursorType } from './selection_utils.js';
import type { GestureEvent } from './selection_utils.js';
import type { SimplifiedTextLayerElement } from './simplified_text_layer.js';
export declare const CURSOR_SIZE_PIXEL = 32;
export declare const CURSOR_IMG_URL = "--cursor-img-url";
export interface CursorData {
    cursor: CursorType;
}
export interface SelectedTextContextMenuData {
    text: string;
    contentLanguage: string;
    left: number;
    right: number;
    top: number;
    bottom: number;
    selectionStartIndex: number;
    selectionEndIndex: number;
}
export interface SelectedRegionContextMenuData {
    box: CenterRotatedBox;
    selectionStartIndex: number;
    selectionEndIndex: number;
    text?: string;
}
export interface SelectionOverlayElement {
    $: {
        backgroundImageCanvas: HTMLCanvasElement;
        closeButton: CrIconButtonElement;
        cursor: HTMLElement;
        initialFlashScrim: HTMLElement;
        objectSelectionLayer: ObjectLayerElement;
        overlayShimmerCanvas: OverlayShimmerCanvasElement;
        postSelectionRenderer: PostSelectionRendererElement;
        regionSelectionLayer: RegionSelectionElement;
        selectedRegionContextMenu: HTMLElement;
        selectedTextContextMenu: HTMLElement;
        selectionOverlay: HTMLElement;
        selectTextContextMenuItem: HTMLElement;
        textLayer: SimplifiedTextLayerElement;
    };
}
declare const SelectionOverlayElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SelectionOverlayElement extends SelectionOverlayElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        isScreenshotRendered: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        isResized: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
            observer: string;
        };
        isInitialSize: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        showTranslateContextMenuItem: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        showSelectedTextContextMenu: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        showSelectedRegionContextMenu: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        showDetectedTextContextMenuOptions: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
        };
        selectedTextContextMenuX: NumberConstructor;
        selectedTextContextMenuY: NumberConstructor;
        selectedRegionContextMenuX: NumberConstructor;
        selectedRegionContextMenuY: NumberConstructor;
        selectedRegionContextMenuHorizontalStyle: StringConstructor;
        selectedRegionContextMenuVerticalStyle: StringConstructor;
        canvasHeight: NumberConstructor;
        canvasWidth: NumberConstructor;
        isPointerInside: {
            type: BooleanConstructor;
            value: boolean;
        };
        currentGesture: {
            type: ObjectConstructor;
            value: () => GestureEvent;
        };
        disableShimmer: {
            type: BooleanConstructor;
            readOnly: boolean;
            value: boolean;
        };
        enableBorderGlow: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        enableCopyAsImage: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: () => boolean;
        };
        enableSaveAsImage: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: () => boolean;
        };
        isClosing: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        suppressCopyAndSaveAsImage: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: () => boolean;
        };
        shimmerOnSegmentation: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        shimmerFadeOutComplete: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        darkenExtraScrim: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        theme: {
            type: ObjectConstructor;
            value: typeof getFallbackTheme;
        };
        translateModeEnabled: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        selectionOverlayRect: ObjectConstructor;
        isSearchboxFocused: BooleanConstructor;
        areLanguagePickersOpen: BooleanConstructor;
        sidePanelOpened: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        hideBackgroundImageCanvas: {
            type: BooleanConstructor;
            reflectToAttribute: boolean;
            value: boolean;
        };
        enableRegionContextMenu: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
    };
    private isScreenshotRendered;
    private isResized;
    private isInitialSize;
    private showTranslateContextMenuItem;
    private showSelectedTextContextMenu;
    private showSelectedRegionContextMenu;
    private showDetectedTextContextMenuOptions;
    private selectedTextContextMenuX;
    private selectedTextContextMenuY;
    private selectedRegionContextMenuX;
    private selectedRegionContextMenuY;
    private canvasHeight;
    private canvasWidth;
    private selectedRegionContextMenuHorizontalStyle;
    private selectedRegionContextMenuVerticalStyle;
    private selectionOverlayRect;
    private isSearchboxFocused;
    private areLanguagePickersOpen;
    private selectedRegionContextMenuBox;
    private highlightedText;
    private contentLanguage;
    private textSelectionStartIndex;
    private textSelectionEndIndex;
    private detectedTextStartIndex;
    private detectedTextEndIndex;
    private isPointerInside;
    private isPointerInsideButton;
    private currentGesture;
    private disableShimmer;
    private enableBorderGlow;
    private enableCopyAsImage;
    private enableSaveAsImage;
    private suppressCopyAndSaveAsImage;
    private isClosing;
    private darkenExtraScrim;
    private shimmerOnSegmentation;
    private shimmerFadeOutComplete;
    private sidePanelOpened;
    private hideBackgroundImageCanvas;
    private enableRegionContextMenu;
    private overlayBorderGlow;
    private eventTracker_;
    private listenerIds;
    private draggingRespondent;
    private resizeObserver;
    private matchMedia?;
    private cursorOffsetX;
    private cursorOffsetY;
    private hasInitialFlashAnimationEnded;
    private browserProxy;
    private updateCursorPositionRequestId?;
    private onPointerMoveRequestId?;
    private handleResizeRequestId?;
    private closeButtonUsedRecorded;
    private theme;
    private translateModeEnabled;
    connectedCallback(): void;
    disconnectedCallback(): void;
    ready(): void;
    private addDragListeners;
    private removeDragListeners;
    private updateDevicePixelRatioListener;
    private onDevicePixelRatioChanged;
    private updateCursorPosition;
    private updateShimmerForCursor;
    protected onIsResizedChanged(newValue: boolean): void;
    private getHiddenCursorClass;
    private setCursorToText;
    private setCursorToCrosshair;
    private setCursorToPointer;
    private resetCursor;
    private handlePointerEnter;
    private handlePointerLeave;
    private onImageRendered;
    private onPointerDown;
    private onPointerUp;
    private onPointerMove;
    private cancelPendingDragAnimationFrame;
    private onPointerCancel;
    private handleGestureStart;
    private handleGestureDrag;
    private handleGestureEnd;
    private handleGestureCancel;
    private handlePostSelectionUpdated;
    private updateCanvasSize;
    private handleResize;
    private updateSelectionOverlayRect;
    private resizeSelectionCanvases;
    private updateGestureCoordinates;
    private shouldIgnoreEvent;
    private isDragging;
    private positionSelectedRegionContextMenu;
    private getContextMenuStyle;
    private handleCopy;
    private handleCopyDetectedText;
    private copyText;
    private handleSelectText;
    private handleTranslateDetectedText;
    private handleTranslate;
    private handleCopyAsImage;
    private handleSaveAsImage;
    private handlePointerEnterButton;
    private handlePointerLeaveButton;
    private setShowSelectedTextContextMenu;
    private setShowSelectedRegionContextMenu;
    private onInitialFlashAnimationEnd;
    private screenshotDataReceived;
    private onOverlayReshown;
    private getOverlayBorderGlow;
    private onCopyCommand;
    private updateSelectedRegionContextMenu;
    private onNotifyResultsPanelOpened;
    private onCloseButtonClick;
    private onFinishReshowOverlay;
    /**
     * Returns the bounding rect of the selection overlay. This is preferred over
     * using getBoundingClientRect() because it is a cached DOM property which
     * doesn't need to be recalculated every time.
     */
    getBoundingRect(): DOMRect;
    fetchNewScreenshotForTesting(): void;
    getShowSelectedRegionContextMenuForTesting(): boolean;
    getShowSelectedTextContextMenuForTesting(): boolean;
    getShowDetectedTextContextMenuOptionsForTesting(): boolean;
    getSuppressCopyAndSaveAsImageForTesting(): boolean;
    handleSelectTextForTesting(): void;
    handleTranslateDetectedTextForTesting(): void;
    handleCopyForTesting(): void;
    handleCopyDetectedTextForTesting(): void;
    handleTranslateForTesting(): void;
    handleCopyAsImageForTesting(): void;
    handleSaveAsImageForTesting(): void;
    setSearchboxFocusForTesting(isFocused: boolean): void;
    setLanguagePickersOpenForTesting(open: boolean): void;
    getHideBackgroundImageCanvasForTesting(): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'lens-selection-overlay': SelectionOverlayElement;
    }
}
export {};
