// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { LensPageCallbackRouter, LensPageHandlerFactory, LensPageHandlerRemote } from './lens.mojom-webui.js';
let instance = null;
export class BrowserProxyImpl {
    callbackRouter = new LensPageCallbackRouter();
    handler = new LensPageHandlerRemote();
    constructor() {
        const factory = LensPageHandlerFactory.getRemote();
        factory.createPageHandler(this.handler.$.bindNewPipeAndPassReceiver(), this.callbackRouter.$.bindNewPipeAndPassRemote());
    }
    static getInstance() {
        return instance || (instance = new BrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
