// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_icon/cr_icon.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import"//resources/cr_elements/icons.html.js";import{assert,assertInstanceof}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{afterNextRender,PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{LanguageBrowserProxyImpl}from"./language_browser_proxy.js";import{UserAction}from"./lens.mojom-webui.js";import{INVOCATION_SOURCE}from"./lens_overlay_app.js";import{recordLensOverlayInteraction}from"./metrics_utils.js";import{focusShimmerOnRegion,ShimmerControlRequester,unfocusShimmer}from"./selection_utils.js";import{getTemplate}from"./translate_button.html.js";const SUPPORTED_TRANSLATION_LANGUAGES=new Set(["af","sq","am","ar","hy","az","eu","be","bn","bs","bg","ca","ceb","zh-CN","zh-TW","co","hr","cs","da","nl","en","eo","et","fi","fr","fy","gl","ka","de","el","gu","ht","ha","haw","hi","hmn","hu","is","ig","id","ga","it","iw","ja","jv","kn","kk","km","rw","ko","ku","ky","lo","la","lv","lt","lb","mk","mg","ms","ml","mt","mi","mr","mn","my","ne","no","ny","or","ps","fa","pl","pt","pa","ro","ru","sm","gd","sr","st","sn","sd","si","sk","sl","so","es","su","sw","sv","tl","tg","ta","tt","te","th","tr","tk","uk","ur","ug","uz","vi","cy","xh","yi","yo","zu"]);export class TranslateButtonElement extends PolymerElement{static get is(){return"translate-button"}static get template(){return getTemplate()}static get properties(){return{clientSourceLanguageList:{type:Array},clientTargetLanguageList:{type:Array},contentLanguage:{type:String,reflectToAttribute:true,value:""},isLensOverlayContextualSearchboxEnabled:{type:Boolean,reflectToAttribute:true},isSourceLanguageSearchboxOpen:{type:Boolean,reflectToAttribute:true,value:false},isTargetLanguageSearchboxOpen:{type:Boolean,reflectToAttribute:true,value:false},isTranslateModeEnabled:{type:Boolean,reflectToAttribute:true,value:false},languagePickerButtonsVisible:{type:Boolean,computed:`computeLanguagePickerButtonsVisible(\n              isTranslateModeEnabled, sourceLanguageMenuVisible,\n              targetLanguageMenuVisible)`},recentSourceLanguages:{type:Array,value:()=>[]},recentTargetLanguages:{type:Array,value:()=>[]},shouldFetchSupportedLanguages:{type:Boolean,value:()=>loadTimeData.getBoolean("shouldFetchSupportedLanguages"),readOnly:true,reflectToAttribute:true},shouldShowRecentSourceLanguages:{type:Boolean,computed:"shouldShowRecentLanguages(recentSourceLanguages)",reflectToAttribute:true},shouldShowRecentTargetLanguages:{type:Boolean,computed:"shouldShowRecentLanguages(recentTargetLanguages)",reflectToAttribute:true},searchboxHasText:{type:Boolean,reflectToAttribute:true,value:false},searchedLanguageList:{type:Array,value:()=>[]},serverSourceLanguageList:{type:Array,value:()=>[]},serverTargetLanguageList:{type:Array,value:()=>[]},shouldShowStarsIcon:{type:Boolean,computed:"computeShouldShowStarsIcon(sourceLanguage)",reflectToAttribute:true},sourceLanguage:{type:Object,value:null},sourceLanguageList:{type:Array,computed:`getSourceLanguageList(clientSourceLanguageList,\n                                   serverSourceLanguageList)`},sourceLanguageMenuVisible:{type:Boolean,reflectToAttribute:true,value:false},targetLanguage:{type:Object,value:null},targetLanguageList:{type:Array,computed:`getTargetLanguageList(clientTargetLanguageList,\n                                   serverTargetLanguageList)`},targetLanguageMenuVisible:{type:Boolean,reflectToAttribute:true,value:false}}}eventTracker=new EventTracker;supportedSourceLanguages=new Set(loadTimeData.getString("translateSourceLanguages").split(","));supportedTargetLanguages=new Set(loadTimeData.getString("translateTargetLanguages").split(","));browserProxy=BrowserProxyImpl.getInstance();languageBrowserProxy=LanguageBrowserProxyImpl.getInstance();listenerIds;connectedCallback(){super.connectedCallback();this.handleFetchLanguageList();this.eventTracker.add(document,"received-content-language",(e=>{if(e.detail.contentLanguage==="zh"){this.contentLanguage="zh-CN"}else if(e.detail.contentLanguage==="zh-Hant"){this.contentLanguage="zh-TW"}else{this.contentLanguage=e.detail.contentLanguage}}));this.eventTracker.add(this.$.sourceLanguagePickerMenu,"focusout",(event=>{const targetWithFocus=event.relatedTarget;if(!targetWithFocus||!(targetWithFocus instanceof Node)||!this.$.sourceLanguagePickerMenu.contains(targetWithFocus)){this.hideLanguagePickerMenus(false)}}));this.eventTracker.add(this.$.targetLanguagePickerMenu,"focusout",(event=>{const targetWithFocus=event.relatedTarget;if(!targetWithFocus||!(targetWithFocus instanceof Node)||!this.$.targetLanguagePickerMenu.contains(targetWithFocus)){this.hideLanguagePickerMenus(false)}}));this.listenerIds=[this.browserProxy.callbackRouter.setTranslateMode.addListener(this.setTranslateMode.bind(this))]}disconnectedCallback(){super.disconnectedCallback();this.listenerIds.forEach((id=>assert(this.browserProxy.callbackRouter.removeListener(id))));this.listenerIds=[];this.eventTracker.removeAll()}getTranslateEnableButton(){return this.$.translateEnableButton}handleLanguagePickerKeyDown(event){if(this.isTargetLanguageSearchboxOpen||this.isSourceLanguageSearchboxOpen){return}assert(this.sourceLanguageMenuVisible||this.targetLanguageMenuVisible);if(event.key.length!==1){return}if(this.shouldFetchSupportedLanguages){const isTarget=this.targetLanguageMenuVisible?true:false;if(isTarget){this.openTargetLanguageSearchbox()}else{this.openSourceLanguageSearchbox()}return}const languageList=this.sourceLanguageMenuVisible?this.getSourceLanguageList():this.getTargetLanguageList();let scrollLanguageIndex=-1;const startingChar=event.key.toLowerCase();for(let i=0;i<languageList.length;i++){const language=languageList[i];const languageStartingChar=language.name.charAt(0).toLowerCase();if(startingChar===languageStartingChar){scrollLanguageIndex=i;break}}if(scrollLanguageIndex>=0){const pickerMenu=this.sourceLanguageMenuVisible?this.$.sourceLanguagePickerMenu:this.$.targetLanguagePickerMenu;const menuItems=pickerMenu.querySelectorAll("cr-button:not(#sourceAutoDetectButton)");const languageElement=menuItems[scrollLanguageIndex];languageElement.scrollIntoView();languageElement.focus()}}handleFetchLanguageList(){if(this.shouldFetchSupportedLanguages){this.supportedSourceLanguages.forEach((code=>this.supportedTargetLanguages.add(code)));this.languageBrowserProxy.getStoredServerLanguages(this.browserProxy).then(this.onServerLanguageListRetrieved.bind(this))}this.languageBrowserProxy.getClientLanguageList().then(this.onClientLanguageListRetrieved.bind(this))}onServerLanguageListRetrieved(languages){this.serverSourceLanguageList=languages.sourceLanguages.filter((language=>this.supportedSourceLanguages.has(language.languageCode)));this.serverTargetLanguageList=languages.targetLanguages.filter((language=>this.supportedTargetLanguages.has(language.languageCode)));this.maybeSetInitialLanguagesInPicker(true)}onClientLanguageListRetrieved(languageList){const supportedSourceTranslateLanguages=this.shouldFetchSupportedLanguages?this.supportedSourceLanguages:SUPPORTED_TRANSLATION_LANGUAGES;const supportedTargetTranslateLanguages=this.shouldFetchSupportedLanguages?this.supportedTargetLanguages:SUPPORTED_TRANSLATION_LANGUAGES;this.clientSourceLanguageList=languageList.filter((language=>supportedSourceTranslateLanguages.has(language.languageCode)));this.clientTargetLanguageList=languageList.filter((language=>supportedTargetTranslateLanguages.has(language.languageCode)));this.maybeSetInitialLanguagesInPicker()}maybeSetInitialLanguagesInPicker(overrideExisting=false){if(this.targetLanguage&&!overrideExisting){return}if(this.shouldFetchSupportedLanguages){this.maybeSetRecentLanguages();const sourceLanguageCode=this.languageBrowserProxy.getLastUsedSourceLanguage();const targetLanguageCode=this.languageBrowserProxy.getLastUsedTargetLanguage();const initialSourceLanguage=this.getSourceLanguageList().find((language=>language.languageCode===sourceLanguageCode));const initialTargetLanguage=this.getTargetLanguageList().find((language=>language.languageCode===targetLanguageCode));this.sourceLanguage=initialSourceLanguage?initialSourceLanguage:null;this.targetLanguage=initialTargetLanguage?initialTargetLanguage:null;if(this.targetLanguage){return}}this.languageBrowserProxy.getTranslateTargetLanguage().then(this.onTargetLanguageRetrieved.bind(this))}maybeSetRecentLanguages(){const recentSourceLanguageCodes=this.languageBrowserProxy.getRecentSourceLanguages();if(recentSourceLanguageCodes.length>0){this.recentSourceLanguages=this.getSourceLanguageList().filter((language=>recentSourceLanguageCodes.includes(language.languageCode)))}const recentTargetLanguageCodes=this.languageBrowserProxy.getRecentTargetLanguages();if(recentTargetLanguageCodes.length>0){this.recentTargetLanguages=this.getTargetLanguageList().filter((language=>recentTargetLanguageCodes.includes(language.languageCode)))}}onTargetLanguageRetrieved(targetLanguageCode){const defaultLanguage=this.getTargetLanguageList().find((language=>language.languageCode===targetLanguageCode));if(defaultLanguage){this.targetLanguage=defaultLanguage;return}this.targetLanguage=this.getTargetLanguageList()[0]}onAutoDetectMenuItemClick(){this.sourceLanguage=null;this.languageBrowserProxy.storeLastUsedSourceLanguage(null);this.hideLanguagePickerMenus();this.maybeIssueTranslateRequest();recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kTranslateSourceLanguageChanged)}onSourceLanguageButtonClick(){this.notifyLanguagePickerOpened();this.sourceLanguageMenuVisible=!this.sourceLanguageMenuVisible;this.targetLanguageMenuVisible=false;afterNextRender(this,(()=>{this.$.sourceLanguagePickerBackButton.focus()}))}onTargetLanguageButtonClick(){this.notifyLanguagePickerOpened();this.targetLanguageMenuVisible=!this.targetLanguageMenuVisible;this.sourceLanguageMenuVisible=false;afterNextRender(this,(()=>{this.$.targetLanguagePickerBackButton.focus()}))}onSourceLanguageMenuItemClick(event){assertInstanceof(event.target,HTMLElement);const newSourceLanguage=this.$.sourceLanguagePickerContainer.itemForElement(event.target);this.setNewSourceLanguage(newSourceLanguage)}onRecentSourceLanguageClick(event){assertInstanceof(event.target,HTMLElement);const newSourceLanguage=this.$.recentSourceLanguagesContainer.itemForElement(event.target);this.setNewSourceLanguage(newSourceLanguage)}onSourceSearchLanguageItemClick(event){assertInstanceof(event.target,HTMLElement);const searchedLanguage=this.$.searchSourceLanguagesContainer.itemForElement(event.target);this.setNewSourceLanguage(searchedLanguage.language)}setNewSourceLanguage(sourceLanguage){this.sourceLanguage=sourceLanguage;if(this.shouldFetchSupportedLanguages){this.languageBrowserProxy.storeLastUsedSourceLanguage(sourceLanguage?sourceLanguage.languageCode:null);this.addRecentSourceLanguage(sourceLanguage)}this.clearSearchboxState();this.hideLanguagePickerMenus();this.maybeIssueTranslateRequest();recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kTranslateSourceLanguageChanged)}onTargetLanguageMenuItemClick(event){assertInstanceof(event.target,HTMLElement);const newTargetLanguage=this.$.targetLanguagePickerContainer.itemForElement(event.target);this.setNewTargetLanguage(newTargetLanguage)}onTargetSearchLanguageItemClick(event){assertInstanceof(event.target,HTMLElement);const searchedLanguage=this.$.searchTargetLanguagesContainer.itemForElement(event.target);this.setNewTargetLanguage(searchedLanguage.language)}onRecentTargetLanguageClick(event){assertInstanceof(event.target,HTMLElement);const newTargetLanguage=this.$.recentTargetLanguagesContainer.itemForElement(event.target);this.setNewTargetLanguage(newTargetLanguage)}setNewTargetLanguage(targetLanguage){this.targetLanguage=targetLanguage;if(this.shouldFetchSupportedLanguages){this.languageBrowserProxy.storeLastUsedTargetLanguage(targetLanguage?targetLanguage.languageCode:null);this.addRecentTargetLanguage(targetLanguage)}this.clearSearchboxState();this.hideLanguagePickerMenus();this.maybeIssueTranslateRequest();recordLensOverlayInteraction(INVOCATION_SOURCE,UserAction.kTranslateTargetLanguageChanged);this.updateTranslateModeState(true)}onTranslateButtonClick(){this.isTranslateModeEnabled=!this.isTranslateModeEnabled;if(this.isTranslateModeEnabled){this.browserProxy.handler.maybeCloseTranslateFeaturePromo(true);this.maybeIssueTranslateRequest()}else{this.browserProxy.handler.issueEndTranslateModeRequest()}recordLensOverlayInteraction(INVOCATION_SOURCE,this.isTranslateModeEnabled?UserAction.kTranslateButtonEnableAction:UserAction.kTranslateButtonDisableAction);if(this.isTranslateModeEnabled){focusShimmerOnRegion(this,0,0,0,0,ShimmerControlRequester.TRANSLATE);this.$.sourceLanguageButton.focus()}else{unfocusShimmer(this,ShimmerControlRequester.TRANSLATE);this.$.translateEnableButton.focus()}this.updateTranslateModeState(true)}maybeIssueTranslateRequest(){if(this.isTranslateModeEnabled&&this.targetLanguage){this.browserProxy.handler.issueTranslateFullPageRequest(this.sourceLanguage?this.sourceLanguage.languageCode:"auto",this.targetLanguage.languageCode)}}setTranslateMode(sourceLanguage,targetLanguage){if(sourceLanguage.length===0&&targetLanguage.length===0){this.disableTranslateMode();return}const newSourceLanguage=sourceLanguage==="auto"?null:this.getSourceLanguageList().find((language=>language.languageCode===sourceLanguage));const newTargetLanguage=this.getTargetLanguageList().find((language=>language.languageCode===targetLanguage));if(newSourceLanguage===undefined||!newTargetLanguage||this.sourceLanguage===newSourceLanguage&&this.targetLanguage===newTargetLanguage&&this.isTranslateModeEnabled){return}this.sourceLanguage=newSourceLanguage;this.targetLanguage=newTargetLanguage;if(!this.isTranslateModeEnabled){focusShimmerOnRegion(this,0,0,0,0,ShimmerControlRequester.TRANSLATE)}this.isTranslateModeEnabled=true;this.maybeIssueTranslateRequest();this.updateTranslateModeState(true)}disableTranslateMode(){if(!this.isTranslateModeEnabled){return}this.isTranslateModeEnabled=false;unfocusShimmer(this,ShimmerControlRequester.TRANSLATE);this.updateTranslateModeState(false)}handleBackButtonClick(){if(this.isTargetLanguageSearchboxOpen||this.isSourceLanguageSearchboxOpen){this.clearSearchboxState();return}this.hideLanguagePickerMenus()}hideLanguagePickerMenus(shouldFocus=true){this.$.sourceLanguagePickerMenu.scroll(0,0);this.$.targetLanguagePickerMenu.scroll(0,0);if(shouldFocus){if(this.sourceLanguageMenuVisible){this.$.sourceLanguageButton.focus()}else{this.$.targetLanguageButton.focus()}}this.notifyLanguagePickerClosed();this.targetLanguageMenuVisible=false;this.sourceLanguageMenuVisible=false}getSourceLanguageDisplayName(){if(this.sourceLanguage){return this.sourceLanguage.name}if(this.contentLanguage!==""&&this.getSourceLanguageList()){const detectedLanguage=this.getSourceLanguageList().find((language=>language.languageCode===this.contentLanguage));if(detectedLanguage!==undefined){return detectedLanguage.name}}return loadTimeData.getString("detectLanguage")}getTargetLanguageDisplayName(){if(this.targetLanguage){return this.targetLanguage.name}return""}getContentLanguageDisplayName(){if(this.contentLanguage!==""&&this.getSourceLanguageList()){const detectedLanguage=this.getSourceLanguageList().find((language=>language.languageCode===this.contentLanguage));if(detectedLanguage!==undefined){return detectedLanguage.name}}return""}notifyLanguagePickerOpened(){document.dispatchEvent(new CustomEvent("language-picker-opened",{bubbles:true,composed:true}))}notifyLanguagePickerClosed(){document.dispatchEvent(new CustomEvent("language-picker-closed",{bubbles:true,composed:true}))}openSourceLanguageSearchbox(){this.isSourceLanguageSearchboxOpen=true;this.$.sourceLanguageSearchbox.focus();this.onSourceSearchboxInputChange()}openTargetLanguageSearchbox(){this.isTargetLanguageSearchboxOpen=true;this.$.targetLanguageSearchbox.focus();this.onTargetSearchboxInputChange()}onSourceSearchboxInputChange(){const searchString=this.$.sourceLanguageSearchbox.value.trim();this.updateSearchedListOnInputChanged(this.getSourceLanguageList(),searchString)}onTargetSearchboxInputChange(){const searchString=this.$.targetLanguageSearchbox.value.trim();this.updateSearchedListOnInputChanged(this.getTargetLanguageList(),searchString)}updateSearchedListOnInputChanged(languageList,searchString){this.searchboxHasText=searchString.length>0;if(this.searchboxHasText){const lowerCaseSearchString=searchString.toLowerCase();this.searchedLanguageList=languageList.filter((language=>{const lowerCaseLanguageName=language.name.toLowerCase();return lowerCaseLanguageName.includes(lowerCaseSearchString)})).sort(((previous,next)=>{const lowerCaseA=previous.name.toLowerCase();const lowerCaseB=next.name.toLowerCase();const startsWithA=lowerCaseA.startsWith(lowerCaseSearchString);const startsWithB=lowerCaseB.startsWith(lowerCaseSearchString);if(startsWithA&&!startsWithB){return-1}else if(!startsWithA&&startsWithB){return 1}else{return 0}})).map((language=>{const lowerCaseLanguageName=language.name.toLowerCase();const startIndex=lowerCaseLanguageName.indexOf(lowerCaseSearchString);if(startIndex!==-1){const beforeSearch=language.name.substring(0,startIndex);const highlightText=language.name.substring(startIndex,startIndex+lowerCaseSearchString.length);const afterSearch=language.name.substring(startIndex+lowerCaseSearchString.length);return{beforeHighlightText:beforeSearch,searchHighlightText:highlightText,afterHighlightText:afterSearch,language:language}}return{beforeHighlightText:language.name,searchHighlightText:"",afterHighlightText:"",language:language}}))}}clearSearchboxState(){this.searchedLanguageList=[];this.$.targetLanguageSearchbox.value="";this.$.sourceLanguageSearchbox.value="";this.searchboxHasText=false;this.isSourceLanguageSearchboxOpen=false;this.isTargetLanguageSearchboxOpen=false}computeShouldShowStarsIcon(){return this.sourceLanguage===null}getTabIndexForTranslateEntry(){return this.isTranslateModeEnabled?-1:0}getTabIndexForTranslateExit(){if((this.sourceLanguageMenuVisible||this.targetLanguageMenuVisible)&&this.isLensOverlayContextualSearchboxEnabled){return 0}return this.getTabIndexForLanguagePickerButtons()}getTabIndexForLanguagePickerButtons(){return this.computeLanguagePickerButtonsVisible()?0:-1}computeLanguagePickerButtonsVisible(){return this.isTranslateModeEnabled&&!this.sourceLanguageMenuVisible&&!this.targetLanguageMenuVisible}getSourceLanguageButtonAriaLabel(){let sourceLanguageAriaLabel=this.getSourceLanguageDisplayName();if(this.sourceLanguage===null&&sourceLanguageAriaLabel!==loadTimeData.getString("detectLanguage")){sourceLanguageAriaLabel=`${this.getSourceLanguageDisplayName()}, ${loadTimeData.getString("detectLanguage")}`}return loadTimeData.getStringF("sourceLanguageAriaLabel",sourceLanguageAriaLabel)}getTargetLanguageButtonAriaLabel(){return loadTimeData.getStringF("targetLanguageAriaLabel",this.getTargetLanguageDisplayName())}getAutoCheckedClass(sourceLanguage){return sourceLanguage===null?"selected":""}getSearchedLanguageCheckedClass(searchedLanguage,selectedLanguage){return this.getLanguageCheckedClass(searchedLanguage.language,selectedLanguage)}getLanguageCheckedClass(language,selectedLanguage){if(!selectedLanguage){return""}return selectedLanguage.languageCode===language.languageCode?"selected":""}shouldShowRecentLanguages(recentLanguages){return recentLanguages.length>0}updateTranslateModeState(shouldUnselectWords){this.dispatchEvent(new CustomEvent("translate-mode-state-changed",{bubbles:true,composed:true,detail:{translateModeEnabled:this.isTranslateModeEnabled,targetLanguage:this.targetLanguage.languageCode,shouldUnselectWords:shouldUnselectWords}}))}addRecentSourceLanguage(language){if(!language){return}this.prepareRecentLanguageListForAddition(this.recentSourceLanguages,language);this.recentSourceLanguages=[language,...this.recentSourceLanguages];this.languageBrowserProxy.storeRecentSourceLanguages(this.recentSourceLanguages.map((language=>language.languageCode)))}addRecentTargetLanguage(language){assert(language);this.prepareRecentLanguageListForAddition(this.recentTargetLanguages,language);this.recentTargetLanguages=[language,...this.recentTargetLanguages];this.languageBrowserProxy.storeRecentTargetLanguages(this.recentTargetLanguages.map((language=>language.languageCode)))}prepareRecentLanguageListForAddition(languageList,language){const index=languageList.findIndex((recentLanguage=>recentLanguage.languageCode===language.languageCode));if(index>-1){languageList.splice(index,1)}while(languageList.length>=loadTimeData.getInteger("recentLanguagesAmount")){languageList.pop()}}getSourceLanguageList(){return this.serverSourceLanguageList.length===0?this.clientSourceLanguageList:this.serverSourceLanguageList}getTargetLanguageList(){return this.serverTargetLanguageList.length===0?this.clientTargetLanguageList:this.serverTargetLanguageList}}customElements.define(TranslateButtonElement.is,TranslateButtonElement);