// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./side_panel_ghost_loader.js";import"./side_panel_error_page.js";import"./feedback_toast.js";import"/strings.m.js";import"/lens/shared/searchbox_ghost_loader.js";import"/lens/shared/searchbox_shared_style.css.js";import"//resources/cr_components/searchbox/searchbox.js";import"//resources/cr_elements/cr_icons.css.js";import"//resources/cr_elements/cr_toast/cr_toast.js";import"//resources/cr_components/composebox/composebox.js";import{ColorChangeUpdater}from"//resources/cr_components/color_change_listener/colors_css_updater.js";import{HelpBubbleMixin}from"//resources/cr_components/help_bubble/help_bubble_mixin.js";import{GlowAnimationState}from"//resources/cr_components/search/constants.js";import{I18nMixin}from"//resources/cr_elements/i18n_mixin.js";import{assert}from"//resources/js/assert.js";import{EventTracker}from"//resources/js/event_tracker.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{SidePanelResultStatus}from"../lens_side_panel.mojom-webui.js";import{PageContentType}from"../page_content_type.mojom-webui.js";import{handleEscapeSearchbox}from"../searchbox_utils.js";import{PostMessageReceiver}from"./post_message_communication.js";import{getTemplate}from"./side_panel_app.html.js";import{SidePanelBrowserProxyImpl}from"./side_panel_browser_proxy.js";const VIEWPORT_HEIGHT_KEY="bih";const VIEWPORT_WIDTH_KEY="biw";const RESHOW_FEEDBACK_TOAST_DELAY_MS=4100;const LensSidePanelAppElementBase=HelpBubbleMixin(I18nMixin(PolymerElement));export class LensSidePanelAppElement extends LensSidePanelAppElementBase{static get is(){return"lens-side-panel-app"}static get template(){return getTemplate()}static get properties(){return{autocompleteRequestStarted:{type:Boolean,value:false},enableAimSearchbox:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableAimSearchbox")},enableFloatingGForHeader:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableFloatingGForHeader")},enableClientSideAimHeader:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableClientSideAimHeader")},enableWebviewResults:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebviewResults")},enableLensAimSuggestions:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableLensAimSuggestions")},enableLensAimSuggestionsGradientBackground:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableLensAimSuggestionsGradientBackground")},enableCsbMotionTweaks:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableCsbMotionTweaks")},enableVisualSelectionUpdates:{reflectToAttribute:true,type:Boolean,value:()=>loadTimeData.getBoolean("enableVisualSelectionUpdates")},isBackArrowVisible:{type:Boolean,value:false,reflectToAttribute:true},isErrorPageVisible:{type:Boolean,value:false,reflectToAttribute:true},wasBackArrowAvailable:{type:Boolean,value:false},isLoadingResults:{type:Boolean,value:true,reflectToAttribute:true},isContextualSearchbox:{type:Boolean,value:false,reflectToAttribute:true},loadingImageUrl:{type:String,value:loadTimeData.getString("resultsLoadingUrl"),readOnly:true},darkMode:{type:Boolean,value:()=>loadTimeData.getBoolean("darkMode"),reflectToAttribute:true},isSearchboxFocused:{type:Boolean,value:false,reflectToAttribute:true},suppressGhostLoader:{type:Boolean,value:true},enableGhostLoader:{type:Boolean,value:()=>loadTimeData.getBoolean("enableGhostLoader")},showGhostLoader:{type:Boolean,computed:`computeShowGhostLoader(\n                enableGhostLoader,\n                isSearchboxFocused,\n                autocompleteRequestStarted,\n                showErrorState,\n                suppressGhostLoader,\n                isContextualSearchbox)`,reflectToAttribute:true},showErrorState:{type:Boolean,value:false,notify:true},showLensButton:{type:Boolean,value:()=>loadTimeData.getBoolean("showLensButton"),reflectToAttribute:true},showSubmitButton:{type:Boolean,value:()=>loadTimeData.getBoolean("composeboxShowSubmit"),reflectToAttribute:true},pageContentType:{type:Number,value:PageContentType.kUnknown},placeholderText:{type:String,computed:`computePlaceholderText(isContextualSearchbox, pageContentType)`},uploadProgressPercentage:{type:Number,value:0},showUploadProgress:{type:Number,computed:`computeShowUploadProgress(uploadProgressPercentage)`,reflectToAttribute:true},toastMessage:{type:String,value:""},searchboxSuggestionCount:{type:Number,value:0},isOnAimResults:{type:Boolean,value:false,reflectToAttribute:true},composeboxHeight_:{type:Number,value:0},composeboxDropdownHeight_:{type:Number,value:0},isOverlayShowing:{type:Boolean,value:true,reflectToAttribute:true},isComposeboxFocused:{type:Boolean,value:false,reflectToAttribute:true}}}progressBarAnimation=null;progressBarHideAnimation=null;postMessageReceiver;feedbackToastDismissed=false;feedbackToastShown=false;feedbackToastReshowTimeoutId=-1;feedbackToastShowAfterDelayTimeoutId=-1;browserProxy=SidePanelBrowserProxyImpl.getInstance();listenerIds;pageHandler;eventTracker_=new EventTracker;composeboxResizeObserver_=null;composeboxDropdownResizeObserver_=null;searchboxBoundingClientRectObserver=new ResizeObserver(this.onSearchboxBoundsChanged.bind(this));constructor(){super();this.browserProxy.handler.getIsContextualSearchbox().then((({isContextualSearchbox:isContextualSearchbox})=>{this.isContextualSearchbox=isContextualSearchbox}));this.pageHandler=SidePanelBrowserProxyImpl.getInstance().handler;ColorChangeUpdater.forDocument().start()}ready(){super.ready();this.registerHelpBubble("kLensSidePanelSearchBoxElementId",this.$.searchbox)}connectedCallback(){super.connectedCallback();this.listenerIds=[this.browserProxy.callbackRouter.loadResultsInFrame.addListener(this.loadResultsInFrame.bind(this)),this.browserProxy.callbackRouter.setIsLoadingResults.addListener(this.setIsLoadingResults.bind(this)),this.browserProxy.callbackRouter.setPageContentUploadProgress.addListener(this.setPageContentUploadProgress.bind(this)),this.browserProxy.callbackRouter.setBackArrowVisible.addListener(this.setBackArrowVisible.bind(this)),this.browserProxy.callbackRouter.setShowErrorPage.addListener(this.setShowErrorPage.bind(this)),this.browserProxy.callbackRouter.suppressGhostLoader.addListener(this.suppressGhostLoader_.bind(this)),this.browserProxy.callbackRouter.pageContentTypeChanged.addListener(this.pageContentTypeChanged.bind(this)),this.browserProxy.callbackRouter.showToast.addListener(this.showMessageToast.bind(this)),this.browserProxy.callbackRouter.aimResultsChanged.addListener(this.onAimResultsChanged.bind(this)),this.browserProxy.callbackRouter.focusResultsFrame.addListener(this.focusResultsFrame.bind(this)),this.browserProxy.callbackRouter.setIsOverlayShowing.addListener(this.setIsOverlayShowing.bind(this)),this.browserProxy.callbackRouter.focusSearchbox.addListener(this.focusSearchbox.bind(this))];this.eventTracker_.add(this.$.searchbox,"mousedown",(()=>{this.suppressGhostLoader=false}));this.eventTracker_.add(this.$.searchbox,"keydown",(e=>{if(e.key==="Enter"){this.onSearchboxEnter()}}));this.eventTracker_.add(document,"query-autocomplete",this.handleQueryAutocomplete.bind(this));this.eventTracker_.add(this.$.feedbackToast,"feedback-toast-dismissed",(()=>this.feedbackToastDismissed=true));this.eventTracker_.add(this.$.composebox,"composebox-focus-in",(()=>{this.$.feedbackToast.hide();this.$.composebox.playGlowAnimation();this.isComposeboxFocused=true}));this.eventTracker_.add(this.$.composebox,"composebox-focus-out",(()=>{this.isComposeboxFocused=false;this.$.composebox.animationState=GlowAnimationState.NONE}));this.postMessageReceiver=new PostMessageReceiver(SidePanelBrowserProxyImpl.getInstance(),this.getResults());if(this.enableAimSearchbox){const composebox=this.$.composebox;this.composeboxResizeObserver_=new ResizeObserver((()=>{this.composeboxHeight_=composebox.offsetHeight}));this.composeboxDropdownResizeObserver_=new ResizeObserver((()=>{this.composeboxDropdownHeight_=composebox.getMatchesElement().offsetHeight}));this.composeboxResizeObserver_.observe(composebox);this.composeboxDropdownResizeObserver_.observe(composebox.getMatchesElement())}}disconnectedCallback(){super.disconnectedCallback();this.listenerIds.forEach((id=>assert(this.browserProxy.callbackRouter.removeListener(id))));this.listenerIds=[];this.eventTracker_.removeAll();this.postMessageReceiver.detach();this.postMessageReceiver=undefined;if(this.composeboxResizeObserver_){this.composeboxResizeObserver_.disconnect();this.composeboxResizeObserver_=null}if(this.composeboxDropdownResizeObserver_){this.composeboxDropdownResizeObserver_.disconnect();this.composeboxDropdownResizeObserver_=null}}onBackArrowClick(){this.pageHandler.popAndLoadQueryFromHistory()}onSearchboxEnter(){if(this.$.searchbox.isInputEmpty()&&this.$.searchbox.hasThumbnail()){this.browserProxy.handler.onImageQueryWithEmptyText()}}setIsLoadingResults(isLoading){if(this.isLoadingResults===isLoading){return}this.isLoadingResults=isLoading;if(this.isLoadingResults){this.blurSearchbox();clearTimeout(this.feedbackToastShowAfterDelayTimeoutId);clearTimeout(this.feedbackToastReshowTimeoutId);this.$.feedbackToast.hide();this.$.messageToast.hide()}else{this.progressBarHideAnimation=this.$.uploadProgressBarContainer.animate({height:["0px"],transform:["scaleY(1)","scaleY(0)"]},{duration:200,easing:"cubic-bezier(0.3, 0, 0.8, 0.15)",fill:"forwards"});this.progressBarHideAnimation.onfinish=()=>{this.uploadProgressPercentage=0};this.hideAndReshowFeedbackToast()}}setPageContentUploadProgress(progress){if(!this.isLoadingResults){return}if(this.uploadProgressPercentage===0){this.progressBarAnimation?.cancel();this.progressBarHideAnimation?.cancel()}this.uploadProgressPercentage=progress*100;this.progressBarAnimation=this.$.uploadProgressBar.animate({width:[this.uploadProgressPercentage+"%"]},{duration:this.uploadProgressPercentage===100?400:1e3,easing:"cubic-bezier(0.2, 0.0, 0, 1.0)",fill:"forwards"})}loadResultsInFrame(resultsUrl){const url=new URL(resultsUrl.url);const resultsBoundingRect=this.getResults().getBoundingClientRect();if(resultsBoundingRect.width>0){url.searchParams.set(VIEWPORT_WIDTH_KEY,resultsBoundingRect.width.toString())}if(resultsBoundingRect.height>0){url.searchParams.set(VIEWPORT_HEIGHT_KEY,resultsBoundingRect.height.toString())}this.getResults().src=url.href;this.blurSearchbox()}blurSearchbox(){this.shadowRoot.querySelector("cr-searchbox")?.shadowRoot.querySelector("input")?.blur();this.$.composebox.blur()}handleEscapeSearchbox(e){handleEscapeSearchbox(this,this.$.searchbox,e)}setBackArrowVisible(visible){this.isBackArrowVisible=visible;this.wasBackArrowAvailable=visible}handleQueryAutocomplete(e){this.autocompleteRequestStarted=!e.detail.inputValue;if(this.autocompleteRequestStarted&&!window.navigator.onLine){this.showErrorState=true;return}this.showErrorState=false}setShowErrorPage(shouldShowErrorPage,status){this.$.errorPage.setIsProtectedError(status===SidePanelResultStatus.kErrorPageShownProtected);this.isErrorPageVisible=shouldShowErrorPage&&loadTimeData.getBoolean("enableErrorPage")}onSearchboxFocusIn_(){this.isBackArrowVisible=false;this.suppressGhostLoader=false;this.isSearchboxFocused=true;this.notifyHelpBubbleAnchorCustomEvent("kLensSidePanelSearchBoxElementId","kLensSidePanelSearchBoxFocusedEventId");this.searchboxBoundingClientRectObserver.observe(this.$.searchbox.getSuggestionsElement())}onSearchboxFocusOut_(event){if(event.relatedTarget instanceof Node&&this.$.searchboxContainer.contains(event.relatedTarget)){return}this.isBackArrowVisible=this.wasBackArrowAvailable;this.isSearchboxFocused=false;this.autocompleteRequestStarted=false;this.showErrorState=false;this.searchboxBoundingClientRectObserver.disconnect()}onSearchboxBoundsChanged(){this.searchboxSuggestionCount=this.$.searchbox.getSuggestionsElement().selectableMatchElements.length}computeShowGhostLoader(){if(!this.isContextualSearchbox||!this.enableGhostLoader||this.suppressGhostLoader){return false}return this.isSearchboxFocused&&(this.autocompleteRequestStarted||this.showErrorState)}computePlaceholderText(){if(!this.isContextualSearchbox){return""}return this.pageContentType===PageContentType.kPdf?this.i18n("searchBoxHintContextualPdf"):this.i18n("searchBoxHintContextualDefault")}computeShowUploadProgress(){return this.uploadProgressPercentage>0}getSearchboxAriaDescription(){return this.$.searchboxGhostLoader.getText()}suppressGhostLoader_(){this.suppressGhostLoader=true}pageContentTypeChanged(newPageContentType){this.pageContentType=newPageContentType;this.browserProxy.handler.getIsContextualSearchbox().then((({isContextualSearchbox:isContextualSearchbox})=>{this.isContextualSearchbox=isContextualSearchbox}))}async showFeedbackToast(){if(!loadTimeData.getBoolean("newFeedbackEnabled")){return}await this.$.messageToast.hide();if(loadTimeData.getBoolean("updatedFeedbackEnabled")){this.feedbackToastShowAfterDelayTimeoutId=setTimeout((()=>{if(this.isComposeboxFocused){return}this.feedbackToastShown=true;this.$.feedbackToast.show()}),loadTimeData.getInteger("updatedFeedbackToastTimeoutMs"));return}this.feedbackToastShown=true;this.$.feedbackToast.show()}async showMessageToast(message){this.$.feedbackToast.hide();await this.showToast(this.$.messageToast,message);if(!this.feedbackToastDismissed&&this.feedbackToastShown){clearTimeout(this.feedbackToastReshowTimeoutId);this.feedbackToastReshowTimeoutId=setTimeout((()=>{this.showFeedbackToast()}),RESHOW_FEEDBACK_TOAST_DELAY_MS)}}onAimResultsChanged(onAim){if(onAim&&loadTimeData.getBoolean("updatedFeedbackEnabled")){this.hideAndReshowFeedbackToast()}this.isOnAimResults=onAim}setIsOverlayShowing(isShowing){this.isOverlayShowing=isShowing}focusResultsFrame(){if(loadTimeData.getBoolean("updatedFeedbackEnabled")){this.hideAndReshowFeedbackToast()}this.getResults().focus()}focusSearchbox(){if(this.enableAimSearchbox){this.$.composebox.focusInput();return}this.$.searchbox.focus()}async showToast(toast,message){if(toast.open){await toast.hide();setTimeout((()=>{this.toastMessage=message??this.toastMessage;toast.show()}),100);return}this.toastMessage=message??this.toastMessage;toast.show()}onHideMessageToastClick(){this.$.messageToast.hide();if(!this.feedbackToastDismissed&&this.feedbackToastShown){clearTimeout(this.feedbackToastReshowTimeoutId);this.showFeedbackToast()}}getResults(){if(this.enableWebviewResults){return this.$.resultsWebview}return this.$.results}hideAndReshowFeedbackToast(){clearTimeout(this.feedbackToastShowAfterDelayTimeoutId);this.$.feedbackToast.hide();this.feedbackToastDismissed=false;this.showFeedbackToast()}makeGhostLoaderVisibleForTesting(){this.isContextualSearchbox=true;this.suppressGhostLoader=false;this.isSearchboxFocused=true;this.autocompleteRequestStarted=true}}window.CSS.registerProperty({name:"--search-background-color",syntax:"<color>",inherits:true,initialValue:"white"});window.CSS.registerProperty({name:"--cr-composebox-background-color",syntax:"<color>",inherits:true,initialValue:"white"});customElements.define(LensSidePanelAppElement.is,LensSidePanelAppElement);