// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{BrowserProxyImpl}from"./browser_proxy.js";import{UserAction}from"./lens.mojom-webui.js";export var ContextMenuOption;(function(ContextMenuOption){ContextMenuOption[ContextMenuOption["COPY_TEXT"]=0]="COPY_TEXT";ContextMenuOption[ContextMenuOption["TRANSLATE_TEXT"]=1]="TRANSLATE_TEXT";ContextMenuOption[ContextMenuOption["SELECT_TEXT_IN_REGION"]=2]="SELECT_TEXT_IN_REGION";ContextMenuOption[ContextMenuOption["TRANSLATE_TEXT_IN_REGION"]=3]="TRANSLATE_TEXT_IN_REGION";ContextMenuOption[ContextMenuOption["COPY_AS_IMAGE"]=4]="COPY_AS_IMAGE";ContextMenuOption[ContextMenuOption["SAVE_AS_IMAGE"]=5]="SAVE_AS_IMAGE";ContextMenuOption[ContextMenuOption["COPY_TEXT_IN_REGION"]=6]="COPY_TEXT_IN_REGION";ContextMenuOption[ContextMenuOption["COUNT"]=7]="COUNT"})(ContextMenuOption||(ContextMenuOption={}));export var LensOverlaySelectionCloseButtonEvent;(function(LensOverlaySelectionCloseButtonEvent){LensOverlaySelectionCloseButtonEvent[LensOverlaySelectionCloseButtonEvent["SHOWN"]=0]="SHOWN";LensOverlaySelectionCloseButtonEvent[LensOverlaySelectionCloseButtonEvent["USED"]=1]="USED";LensOverlaySelectionCloseButtonEvent[LensOverlaySelectionCloseButtonEvent["COUNT"]=2]="COUNT"})(LensOverlaySelectionCloseButtonEvent||(LensOverlaySelectionCloseButtonEvent={}));export function recordContextMenuOptionShown(invocationSource,contextMenuOption){chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.ContextMenuOption.Shown`,contextMenuOption,ContextMenuOption.COUNT);chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.ByInvocationSource.${invocationSource}.ContextMenuOption.Shown`,contextMenuOption,ContextMenuOption.COUNT)}export function recordLensOverlayInteraction(invocationSource,interaction){chrome.metricsPrivate.recordEnumerationValue("Lens.Overlay.Overlay.UserAction",interaction,UserAction.MAX_VALUE+1);chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.Overlay.ByInvocationSource.${invocationSource}.UserAction`,interaction,UserAction.MAX_VALUE+1);BrowserProxyImpl.getInstance().handler.recordUkmAndTaskCompletionForLensOverlayInteraction(interaction)}export function recordLensOverlaySemanticEvent(semanticEvent){BrowserProxyImpl.getInstance().handler.recordLensOverlaySemanticEvent(semanticEvent)}export function recordTimeToWebUIReady(durationMs){chrome.metricsPrivate.recordValue({metricName:"Lens.Overlay.TimeToWebUIReady",type:chrome.metricsPrivate.MetricTypeType.HISTOGRAM_LOG,min:1,max:5e4,buckets:100},Math.floor(durationMs))}export function recordAverageFps(averageFps){chrome.metricsPrivate.recordValue({metricName:"Lens.Overlay.Performance.AverageFPS",type:chrome.metricsPrivate.MetricTypeType.HISTOGRAM_LOG,min:1,max:200,buckets:50},Math.floor(averageFps))}export function recordLensOverlaySelectionCloseButtonShown(invocationSource){chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.ByInvocationSource.${invocationSource}.SelectionState.CloseButtonEvent`,LensOverlaySelectionCloseButtonEvent.SHOWN,LensOverlaySelectionCloseButtonEvent.COUNT);chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.SelectionState.CloseButtonEvent`,LensOverlaySelectionCloseButtonEvent.SHOWN,LensOverlaySelectionCloseButtonEvent.COUNT)}export function recordLensOverlaySelectionCloseButtonUsed(invocationSource){chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.ByInvocationSource.${invocationSource}.SelectionState.CloseButtonEvent`,LensOverlaySelectionCloseButtonEvent.USED,LensOverlaySelectionCloseButtonEvent.COUNT);chrome.metricsPrivate.recordEnumerationValue(`Lens.Overlay.SelectionState.CloseButtonEvent`,LensOverlaySelectionCloseButtonEvent.USED,LensOverlaySelectionCloseButtonEvent.COUNT)}