// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{WritingDirection}from"./text.mojom-webui.js";const BOUNDING_BOX_HIT_MARGIN_PERCENT=.02;export function bestHit(words,target){if(words.length===0){return null}return bestHorizontallyExtendedHit(words,target)||bestVerticalHit(words,target)}function bestHorizontallyExtendedHit(words,target){const hits=[];for(const word of words){const hit=horizontallyExtendedHit(word,target);if(hit){hits.push(hit)}}return getBestHit(hits,target)}function bestVerticalHit(words,target){const closestProjectedDistances=getShortedProjectedDistanceHits(words,target);return getBestHit(closestProjectedDistances,target)}function horizontallyExtendedHit(word,target){const position=rotateCoordinate(word,target);const boundingBox=boundingBoxWithMargin(word);if(boxContainsTarget(boundingBox,position)){return word}if(isInExtension(position,boundingBox,word.writingDirection)){return word}return null}function getBestHit(hits,target){let closestHit=null;let closestDistance=Number.MAX_SAFE_INTEGER;for(const hit of hits){const wordBoundingBox=hit.geometry?.boundingBox.box;if(!wordBoundingBox){continue}const distX=target.x-wordBoundingBox.x;const distY=target.y-wordBoundingBox.y;const totalDistance=distX*distX+distY*distY;if(totalDistance<closestDistance){closestHit=hit;closestDistance=totalDistance}}return closestHit}function rotateCoordinate(word,target){const wordBoundingBox=word.geometry?.boundingBox;if(!wordBoundingBox){return{x:0,y:0}}const translatedX=target.x-wordBoundingBox.box.x;const translatedY=target.y-wordBoundingBox.box.y;const rotatedX=translatedX*Math.cos(wordBoundingBox.rotation)+translatedY*Math.sin(wordBoundingBox.rotation);const rotatedY=-translatedX*Math.sin(wordBoundingBox.rotation)+translatedY*Math.cos(wordBoundingBox.rotation);const finalX=rotatedX+wordBoundingBox.box.x;const finalY=rotatedY+wordBoundingBox.box.y;return{x:finalX,y:finalY}}function boundingBoxWithMargin(word){const wordBoundingBox=word.geometry?.boundingBox.box;if(!wordBoundingBox){return{x:0,y:0,width:0,height:0}}return{x:wordBoundingBox.x,y:wordBoundingBox.y,width:wordBoundingBox.width+BOUNDING_BOX_HIT_MARGIN_PERCENT,height:wordBoundingBox.height+BOUNDING_BOX_HIT_MARGIN_PERCENT}}function boxContainsTarget(box,target){const boxMinX=box.x-box.width/2;const boxMaxX=box.x+box.width/2;const boxMinY=box.y-box.height/2;const boxMaxY=box.y+box.height/2;return target.x>=boxMinX&&target.x<=boxMaxX&&target.y>=boxMinY&&target.y<=boxMaxY}function isInExtension(position,boundingBox,writingDirection){const boxLeft=boundingBox.x-boundingBox.width/2;const boxRight=boundingBox.x+boundingBox.width/2;const boxTop=boundingBox.y-boundingBox.height/2;const boxBottom=boundingBox.y+boundingBox.height/2;if(writingDirection===WritingDirection.kTopToBottom){const isAboveBox=position.x>boxLeft&&position.x<boxRight&&position.y<=boundingBox.y;const isBelowBox=position.x>boxLeft&&position.x<boxRight&&position.y>=boundingBox.y;return isAboveBox||isBelowBox}const isLeftOfBox=position.y>boxTop&&position.y<boxBottom&&position.x<=boundingBox.x;const isRightOfBox=position.y>boxTop&&position.y<boxBottom&&position.x>=boundingBox.x;return isLeftOfBox||isRightOfBox}function getShortedProjectedDistanceHits(words,target){let closestHits=[];let closestProjectedDistance=Number.MAX_SAFE_INTEGER;for(const word of words){const projectedDistance=getProjectedDistance(word,target);if(!projectedDistance){continue}if(Math.abs(closestProjectedDistance-projectedDistance)<=BOUNDING_BOX_HIT_MARGIN_PERCENT){closestHits.push(word)}else if(projectedDistance<=closestProjectedDistance){closestHits=[word];closestProjectedDistance=projectedDistance}}return closestHits}function getProjectedDistance(word,target){const rotatedTarget=rotateCoordinate(word,target);const boundingBox=word.geometry?.boundingBox.box;if(!boundingBox){return null}const deltaX=Math.max(Math.abs(boundingBox.x-rotatedTarget.x)-boundingBox.width/2,0);const deltaY=Math.max(Math.abs(boundingBox.y-rotatedTarget.y)-boundingBox.height/2,0);return word.writingDirection===WritingDirection.kTopToBottom?deltaX:deltaY}