import type { BrowserProxyImpl } from './browser_proxy.js';
import { WebClientState } from './glic_api_impl/glic_api_host.js';
import type { ApiHostEmbedder } from './glic_api_impl/glic_api_host.js';
import type { ObservableValueReadOnly } from './observable.js';
export type PageType = 'login' | 'regular' | 'guestError' | 'guestCaaError' | 'loadError';
export interface WebviewDelegate {
    webviewError(reason: string): void;
    webviewUnresponsive(): void;
    webviewPageCommit(pageType: PageType): void;
    webviewDeniedByAdmin(): void;
}
export declare class WebviewPersistentState {
    private loadUrl;
    private loadUrlUsed;
    useLoadUrl(): string;
    onCommitAfterConnect(newUrl: string): void;
    onClientReady(): void;
}
export declare class WebviewController {
    private readonly container;
    private browserProxy;
    private delegate;
    private hostEmbedder;
    private persistentState;
    webview: chrome.webviewTag.WebView;
    private host?;
    private hostSubscriber?;
    private onDestroy;
    private eventTracker;
    private webClientState;
    private oneMinuteTimer;
    private glicRequestHeaderInjector;
    constructor(container: HTMLElement, browserProxy: BrowserProxyImpl, delegate: WebviewDelegate, hostEmbedder: ApiHostEmbedder, persistentState: WebviewPersistentState);
    getWebClientState(): ObservableValueReadOnly<WebClientState>;
    destroy(): void;
    private destroyHost;
    waitingOnPanelWillOpen(): boolean;
    onLoadTimeOut(): void;
    private onLoadCommit;
    private onLoadStop;
    private onNewWindow;
    private onPermissionRequest;
    private onUnresponsive;
    private onExit;
    private loadCommit;
    private contentLoaded;
    private onNewWindowEvent;
    private urlMatchesAdminBlockedUrl;
    private onBeforeRequest;
}
/**
 * Returns a URLPattern given an origin pattern string that has the syntax:
 * <protocol>://<hostname>[:<port>]
 * where <protocol>, <hostname> and <port> are inserted into URLPattern.
 */
export declare function matcherForOrigin(originPattern: string): URLPattern | null;
export declare function urlMatchesAllowedOrigin(url: string): boolean;
