import type { WebClientInitialState } from '../glic.mojom-webui.js';
import type { ActorTaskPauseReason, ActorTaskState, ActorTaskStopReason, AdditionalContext, AdditionalContextPart, AnnotatedPageData, AutofillSuggestion, CaptureRegionErrorReason, CaptureRegionResult, ChromeVersion, ConversationInfo, Credential, DraggableArea, ErrorReasonTypes, ErrorWithReason, FocusedTabDataHasFocus, FocusedTabDataHasNoFocus, FormFillingRequest, GetPinCandidatesOptions, HostCapability, Journal, MetricUserInputReactionType, NavigationConfirmationRequest, NavigationConfirmationResponse, OnResponseStoppedDetails, OpenPanelInfo, OpenSettingsOptions, PageMetadata, PanelOpeningData, PanelState, PdfDocumentData, PinCandidate, ResumeActorTaskResult, Screenshot, ScrollToParams, SelectAutofillSuggestionsDialogRequest, SelectAutofillSuggestionsDialogResponse, SelectCredentialDialogRequest, SelectCredentialDialogResponse, TabContextOptions, TabContextResult, TabData, TaskOptions, UserConfirmationDialogRequest, UserConfirmationDialogResponse, UserProfileInfo, ViewChangedNotification, ViewChangeRequest, WebClientMode, ZeroStateSuggestions, ZeroStateSuggestionsOptions, ZeroStateSuggestionsV2 } from '../glic_api/glic_api.js';
/**
 * Defines a request and optionally a corresponding response messages.
 */
export interface RequestDef {
    request?: any;
    response?: any;
    /**
     * Whether the request can be processed in the background.
     *
     * If true, the request is allowed to be sent and serviced in the
     * background.
     * If false (the default if omitted):
     * For Host requests, `BACKGROUND_RESPONSES` defines how these are handled.
     * For Client requests, it affects usage of `GatedSender`.
     */
    backgroundAllowed?: boolean;
}
type ValidateRequestMap<T extends Record<string, RequestDef>> = T;
export declare type HostRequestTypes = ValidateRequestMap<{
    glicBrowserWebClientCreated: {
        response: {
            initialState: WebClientInitialStatePrivate;
        };
        backgroundAllowed: true;
    };
    glicBrowserWebClientInitialized: {
        request: {
            success: boolean;
            exception?: TransferableException;
        };
        backgroundAllowed: true;
    };
    glicBrowserCreateTab: {
        request: {
            url: string;
            options: {
                openInBackground?: boolean;
                windowId?: string;
            };
        };
        response: {
            tabData?: TabDataPrivate;
        };
        backgroundAllowed: false;
    };
    glicBrowserOpenGlicSettingsPage: {
        request: {
            options?: OpenSettingsOptions;
        };
        backgroundAllowed: true;
    };
    glicBrowserOpenPasswordManagerSettingsPage: {
        backgroundAllowed: true;
    };
    glicBrowserClosePanel: {
        backgroundAllowed: true;
    };
    glicBrowserClosePanelAndShutdown: {
        backgroundAllowed: true;
    };
    glicBrowserShowProfilePicker: {};
    glicBrowserGetModelQualityClientId: {
        response: {
            modelQualityClientId: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserSwitchConversation: {
        request: {
            info?: ConversationInfo;
        };
        response: {};
        backgroundAllowed: true;
    };
    glicBrowserRegisterConversation: {
        request: {
            info: ConversationInfo;
        };
        response: {};
        backgroundAllowed: true;
    };
    glicBrowserGetContextFromFocusedTab: {
        request: {
            options: TabContextOptions;
        };
        response: {
            tabContextResult: TabContextResultPrivate;
        };
        backgroundAllowed: false;
    };
    glicBrowserGetContextFromTab: {
        backgroundAllowed: false;
        request: {
            tabId: string;
            options: TabContextOptions;
        };
        response: {
            tabContextResult: TabContextResultPrivate;
        };
    };
    glicBrowserGetContextForActorFromTab: {
        request: {
            tabId: string;
            options: TabContextOptions;
        };
        response: {
            tabContextResult: TabContextResultPrivate;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetMaximumNumberOfPinnedTabs: {
        request: {
            requestedMax: number;
        };
        response: {
            effectiveMax: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserCreateTask: {
        request: {
            taskOptions?: TaskOptions;
        };
        response: {
            taskId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserPerformActions: {
        request: {
            actions: ArrayBuffer;
        };
        response: {
            actionsResult: ArrayBuffer;
        };
        backgroundAllowed: true;
    };
    glicBrowserStopActorTask: {
        request: {
            taskId: number;
            stopReason: ActorTaskStopReason;
        };
        backgroundAllowed: true;
    };
    glicBrowserPauseActorTask: {
        request: {
            taskId: number;
            pauseReason: ActorTaskPauseReason;
            tabId: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserResumeActorTask: {
        request: {
            taskId: number;
            tabContextOptions: TabContextOptions;
        };
        response: {
            resumeActorTaskResult: ResumeActorTaskResultPrivate;
        };
        backgroundAllowed: true;
    };
    glicBrowserInterruptActorTask: {
        request: {
            taskId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserUninterruptActorTask: {
        request: {
            taskId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserCreateActorTab: {
        request: {
            taskId: number;
            options: {
                initiatorTabId?: string;
                initiatorWindowId?: string;
                openInBackground?: boolean;
            };
        };
        response: {
            tabData?: TabDataPrivate;
        };
        backgroundAllowed: true;
    };
    glicBrowserActivateTab: {
        request: {
            tabId: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserCaptureScreenshot: {
        response: {
            screenshot: Screenshot;
        };
        backgroundAllowed: false;
    };
    glicBrowserResizeWindow: {
        request: {
            size: {
                width: number;
                height: number;
            };
            options?: {
                durationMs?: number;
            };
        };
        backgroundAllowed: true;
    };
    glicBrowserEnableDragResize: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetWindowDraggableAreas: {
        request: {
            areas: DraggableArea[];
        };
        backgroundAllowed: true;
    };
    glicBrowserSetMinimumWidgetSize: {
        request: {
            size: {
                width: number;
                height: number;
            };
        };
        backgroundAllowed: true;
    };
    glicBrowserSetMicrophonePermissionState: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetLocationPermissionState: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetTabContextPermissionState: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetClosedCaptioningSetting: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetContextAccessIndicator: {
        request: {
            show: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserSetActuationOnWebSetting: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserGetUserProfileInfo: {
        response: {
            profileInfo?: UserProfileInfoPrivate;
        };
        backgroundAllowed: true;
    };
    glicBrowserRefreshSignInCookies: {
        response: {
            success: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserAttachPanel: {
        backgroundAllowed: true;
    };
    glicBrowserDetachPanel: {
        backgroundAllowed: true;
    };
    glicBrowserSetAudioDucking: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserLogBeginAsyncEvent: {
        request: {
            asyncEventId: number;
            taskId: number;
            event: string;
            details: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserLogEndAsyncEvent: {
        request: {
            asyncEventId: number;
            details: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserLogInstantEvent: {
        request: {
            taskId: number;
            event: string;
            details: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserJournalClear: {
        backgroundAllowed: true;
    };
    glicBrowserJournalSnapshot: {
        request: {
            clear: boolean;
        };
        response: {
            journal: Journal;
        };
        backgroundAllowed: true;
    };
    glicBrowserJournalStart: {
        request: {
            maxBytes: number;
            captureScreenshots: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserJournalStop: {
        backgroundAllowed: true;
    };
    glicBrowserJournalRecordFeedback: {
        request: {
            positive: boolean;
            reason: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnUserInputSubmitted: {
        request: {
            mode: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnReaction: {
        backgroundAllowed: true;
        request: {
            reactionType: MetricUserInputReactionType;
        };
    };
    glicBrowserOnContextUploadStarted: {
        backgroundAllowed: true;
    };
    glicBrowserOnContextUploadCompleted: {
        backgroundAllowed: true;
    };
    glicBrowserOnResponseStarted: {
        backgroundAllowed: true;
    };
    glicBrowserOnResponseStopped: {
        request: {
            details?: OnResponseStoppedDetails;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnSessionTerminated: {
        backgroundAllowed: true;
    };
    glicBrowserOnTurnCompleted: {
        request: {
            model: number;
            duration: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnModelChanged: {
        request: {
            model: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnRecordUseCounter: {
        request: {
            counter: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnResponseRated: {
        request: {
            positive: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnClosedCaptionsShown: {
        backgroundAllowed: true;
    };
    glicBrowserScrollTo: {
        request: {
            params: ScrollToParams;
        };
        backgroundAllowed: false;
    };
    glicBrowserDropScrollToHighlight: {
        backgroundAllowed: true;
    };
    glicBrowserSetSyntheticExperimentState: {
        request: {
            trialName: string;
            groupName: string;
        };
        backgroundAllowed: true;
    };
    glicBrowserOpenOsPermissionSettingsMenu: {
        request: {
            permission: string;
        };
    };
    glicBrowserGetOsMicrophonePermissionStatus: {
        response: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserPinTabs: {
        backgroundAllowed: false;
        request: {
            tabIds: string[];
        };
        response: {
            pinnedAll: boolean;
        };
    };
    glicBrowserUnpinTabs: {
        backgroundAllowed: true;
        request: {
            tabIds: string[];
        };
        response: {
            unpinnedAll: boolean;
        };
    };
    glicBrowserUnpinAllTabs: {
        backgroundAllowed: false;
    };
    glicBrowserSubscribeToPinCandidates: {
        backgroundAllowed: false;
        request: {
            options: GetPinCandidatesOptions;
            observationId: number;
        };
    };
    glicBrowserUnsubscribeFromPinCandidates: {
        request: {
            observationId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserSubscribeToCaptureRegion: {
        request: {
            observationId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserUnsubscribeFromCaptureRegion: {
        request: {
            observationId: number;
        };
        backgroundAllowed: true;
    };
    glicBrowserGetZeroStateSuggestionsForFocusedTab: {
        request: {
            isFirstRun?: boolean;
        };
        response: {
            suggestions?: ZeroStateSuggestions;
        };
        backgroundAllowed: false;
    };
    glicBrowserMaybeRefreshUserStatus: {
        backgroundAllowed: true;
    };
    glicBrowserGetZeroStateSuggestionsAndSubscribe: {
        request: {
            hasActiveSubscription: boolean;
            options: ZeroStateSuggestionsOptions;
        };
        response: {
            suggestions?: ZeroStateSuggestionsV2;
        };
    };
    glicBrowserOnViewChanged: {
        request: {
            notification: ViewChangedNotification;
        };
        backgroundAllowed: true;
    };
    glicBrowserSubscribeToPageMetadata: {
        request: {
            tabId: string;
            names: string[];
        };
        response: {
            success: boolean;
        };
        backgroundAllowed: true;
    };
    glicBrowserOnModeChange: {
        request: {
            newMode: WebClientMode;
        };
        backgroundAllowed: true;
    };
}>;
export declare type WebClientRequestTypes = ValidateRequestMap<{
    glicWebClientNotifyPanelWillOpen: {
        request: {
            panelOpeningData: PanelOpeningData;
        };
        response: {
            openPanelInfo?: OpenPanelInfo;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyPanelWasClosed: {
        backgroundAllowed: true;
    };
    glicWebClientPanelStateChanged: {
        request: {
            panelState: PanelState;
        };
        backgroundAllowed: true;
    };
    glicWebClientRequestViewChange: {
        request: {
            request: ViewChangeRequest;
        };
        backgroundAllowed: true;
    };
    glicWebClientCanAttachStateChanged: {
        request: {
            canAttach: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyMicrophonePermissionStateChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyLocationPermissionStateChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyTabContextPermissionStateChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyDefaultTabContextPermissionStateChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyOsLocationPermissionStateChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyClosedCaptioningSettingChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyActuationOnWebSettingChanged: {
        request: {
            enabled: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyFocusedTabChanged: {
        request: {
            focusedTabDataPrivate: FocusedTabDataPrivate;
        };
    };
    glicWebClientNotifyPanelActiveChanged: {
        request: {
            panelActive: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientCheckResponsive: {
        backgroundAllowed: true;
    };
    glicWebClientNotifyManualResizeChanged: {
        request: {
            resizing: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientBrowserIsOpenChanged: {
        request: {
            browserIsOpen: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyOsHotkeyStateChanged: {
        request: {
            hotkey: string;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyPinnedTabsChanged: {
        request: {
            tabData: TabDataPrivate[];
        };
    };
    glicWebClientNotifyPinnedTabDataChanged: {
        request: {
            tabData: TabDataPrivate;
        };
    };
    glicWebClientPinCandidatesChanged: {
        request: {
            candidates: PinCandidatePrivate[];
            observationId: number;
        };
    };
    glicWebClientZeroStateSuggestionsChanged: {
        request: {
            suggestions: ZeroStateSuggestionsV2;
            options: ZeroStateSuggestionsOptions;
        };
    };
    glicWebClientNotifyActorTaskStateChanged: {
        request: {
            taskId: number;
            state: ActorTaskState;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyTabDataChanged: {
        request: {
            tabData: TabDataPrivate;
        };
        backgroundAllowed: true;
    };
    glicWebClientPageMetadataChanged: {
        request: {
            tabId: string;
            pageMetadata: PageMetadata | null;
        };
    };
    glicWebClientRequestToShowDialog: {
        request: {
            request: SelectCredentialDialogRequestPrivate;
        };
        response: {
            response: SelectCredentialDialogResponsePrivate;
        };
        backgroundAllowed: true;
    };
    glicWebClientRequestToShowConfirmationDialog: {
        request: {
            request: UserConfirmationDialogRequestPrivate;
        };
        response: {
            response: UserConfirmationDialogResponsePrivate;
        };
        backgroundAllowed: true;
    };
    glicWebClientRequestToConfirmNavigation: {
        request: {
            request: NavigationConfirmationRequestPrivate;
        };
        response: {
            response: NavigationConfirmationResponsePrivate;
        };
        backgroundAllowed: true;
    };
    glicWebClientNotifyAdditionalContext: {
        request: {
            context: AdditionalContextPrivate;
        };
    };
    glicWebClientCaptureRegionUpdate: {
        request: {
            result?: CaptureRegionResult;
            reason?: CaptureRegionErrorReason;
            observationId: number;
        };
    };
    glicWebClientNotifyActOnWebCapabilityChanged: {
        request: {
            canActOnWeb: boolean;
        };
        backgroundAllowed: true;
    };
    glicWebClientRequestToShowAutofillSuggestionsDialog: {
        request: {
            request: SelectAutofillSuggestionsDialogRequestPrivate;
        };
        response: {
            response: SelectAutofillSuggestionsDialogResponsePrivate;
        };
        backgroundAllowed: true;
    };
}>;
type RemoveStringPrefix<S extends string, Prefix extends string> = S extends `${Prefix}${infer Rest}` ? Rest : 'prefixNotFound!';
export type HostRequestEnumNamesType = {
    [K in keyof HostRequestTypes as RemoveStringPrefix<K, 'glicBrowser'>]: number;
};
export declare const HOST_REQUEST_TYPES: HostRequestEnumNamesType & {
    MAX_VALUE: number;
};
export declare function requestTypeToHistogramSuffix(type: string): string | undefined;
export type AllRequestTypes = HostRequestTypes & WebClientRequestTypes;
export type AllRequestTypesWithoutReturn = {
    [K in keyof AllRequestTypes as RequestResponseType<K> extends void ? K : never]: AllRequestTypes[K];
};
export type AllRequestTypesWithReturn = {
    [K in keyof AllRequestTypes as RequestResponseType<K> extends void ? never : K]: AllRequestTypes[K];
};
export type RequestRequestType<T extends keyof AllRequestTypes> = 'request' extends keyof AllRequestTypes[T] ? AllRequestTypes[T]['request'] : undefined;
export type RequestResponseType<T extends keyof AllRequestTypes> = 'response' extends keyof AllRequestTypes[T] ? AllRequestTypes[T]['response'] : void;
type ReplaceProperties<A, B> = {
    [K in keyof A | keyof B]: K extends keyof B ? B[K] : K extends keyof A ? A[K] : never;
};
export type WebClientInitialStatePrivate = ReplaceProperties<WebClientInitialState, {
    panelState: PanelState;
    chromeVersion: ChromeVersion;
    focusedTabData: FocusedTabDataPrivate;
    loggingEnabled: boolean;
    enableZeroStateSuggestions: boolean;
    hostCapabilities: HostCapability[];
}>;
export declare interface TabDataPrivate extends Omit<TabData, 'favicon'> {
    favicon?: RgbaImage;
}
export declare interface PinCandidatePrivate extends Omit<PinCandidate, 'tabData'> {
    tabData: TabDataPrivate;
}
export declare interface RgbaImage {
    dataRGBA: ArrayBuffer;
    width: number;
    height: number;
    alphaType: ImageAlphaType;
    colorType: ImageColorType;
}
export declare enum ImageAlphaType {
    UNPREMUL = 0,
    PREMUL = 1
}
export declare enum ImageColorType {
    BGRA = 0
}
export declare interface FocusedTabDataPrivate {
    hasFocus?: Omit<FocusedTabDataHasFocus, 'tabData'> & {
        tabData: TabDataPrivate;
    };
    hasNoFocus?: Omit<FocusedTabDataHasNoFocus, 'tabFocusCandidateData'> & {
        tabFocusCandidateData?: TabDataPrivate;
    };
}
export declare interface TabContextResultPrivate extends Omit<TabContextResult, 'tabData' | 'pdfDocumentData' | 'annotatedPageData'> {
    tabData: TabDataPrivate;
    pdfDocumentData?: PdfDocumentDataPrivate;
    annotatedPageData?: AnnotatedPageDataPrivate;
}
export declare interface ResumeActorTaskResultPrivate extends Omit<ResumeActorTaskResult, 'tabData' | 'pdfDocumentData' | 'annotatedPageData'> {
    tabData: TabDataPrivate;
    pdfDocumentData?: PdfDocumentDataPrivate;
    annotatedPageData?: AnnotatedPageDataPrivate;
}
export declare interface UserProfileInfoPrivate extends Omit<UserProfileInfo, 'avatarIcon'> {
    avatarIcon?: RgbaImage;
}
export declare interface PdfDocumentDataPrivate extends Omit<PdfDocumentData, 'pdfData'> {
    pdfData?: ArrayBuffer;
}
export declare interface AnnotatedPageDataPrivate extends Omit<AnnotatedPageData, 'annotatedPageContent'> {
    annotatedPageContent?: ArrayBuffer;
    metadata?: PageMetadata;
}
export declare interface AdditionalContextPartPrivate extends Omit<AdditionalContextPart, 'annotatedPageData' | 'pdf' | 'data' | 'tabContext'> {
    annotatedPageData?: AnnotatedPageDataPrivate;
    pdf?: PdfDocumentDataPrivate;
    data?: {
        mimeType: string;
        data: ArrayBuffer;
    };
    tabContext?: TabContextResultPrivate;
}
export declare interface AdditionalContextPrivate extends Omit<AdditionalContext, 'parts'> {
    parts: AdditionalContextPartPrivate[];
}
export declare interface CredentialPrivate extends Omit<Credential, 'getIcon'> {
}
export declare interface SelectCredentialDialogRequestPrivate extends Omit<SelectCredentialDialogRequest, 'onDialogClosed' | 'icons' | 'credentials'> {
    icons: Map<string, RgbaImage>;
    credentials: CredentialPrivate[];
}
/** Reasons why the credential selection dialog request failed. */
export declare enum SelectCredentialDialogErrorReason {
    DIALOG_PROMISE_NO_SUBSCRIBER = 0
}
export declare interface SelectCredentialDialogResponsePrivate extends SelectCredentialDialogResponse {
    errorReason?: SelectCredentialDialogErrorReason;
}
export declare interface AutofillSuggestionPrivate extends Omit<AutofillSuggestion, 'getIcon'> {
    icon?: RgbaImage;
}
export declare interface FormFillingRequestPrivate extends Omit<FormFillingRequest, 'suggestions'> {
    suggestions: AutofillSuggestionPrivate[];
}
export declare interface SelectAutofillSuggestionsDialogRequestPrivate extends Omit<SelectAutofillSuggestionsDialogRequest, 'onDialogClosed' | 'formFillingRequests'> {
    taskId: number;
    formFillingRequests: FormFillingRequestPrivate[];
}
/** Reasons why the autofill suggestion selection dialog request failed. */
export declare enum SelectAutofillSuggestionsDialogErrorReason {
    DIALOG_PROMISE_NO_SUBSCRIBER = 0,
    MISMATCHED_TASK_ID = 1,
    NO_ACTOR_TASK_DELEGATE = 2
}
export declare interface SelectAutofillSuggestionsDialogResponsePrivate extends SelectAutofillSuggestionsDialogResponse {
    taskId: number;
    errorReason?: SelectAutofillSuggestionsDialogErrorReason;
}
export declare interface UserConfirmationDialogRequestPrivate extends Omit<UserConfirmationDialogRequest, 'onDialogClosed'> {
}
export declare enum ConfirmationRequestErrorReason {
    REQUEST_PROMISE_NO_SUBSCRIBER = 0,
    PREEMPTED_BY_NEW_REQUEST = 1
}
export declare interface UserConfirmationDialogResponsePrivate extends UserConfirmationDialogResponse {
    errorReason?: ConfirmationRequestErrorReason;
}
export declare interface NavigationConfirmationRequestPrivate extends Omit<NavigationConfirmationRequest, 'onConfirmationDecision'> {
}
export declare interface NavigationConfirmationResponsePrivate extends NavigationConfirmationResponse {
    errorReason?: ConfirmationRequestErrorReason;
}
export declare class ErrorWithReasonImpl<T extends keyof ErrorReasonTypes> extends Error implements ErrorWithReason<T> {
    reasonType: T;
    reason: ErrorReasonTypes[T];
    constructor(reasonType: T, reason: ErrorReasonTypes[T], message?: string);
}
/** Any ErrorWithReason<T>.reason type. */
export type AnyErrorReasonType = ErrorReasonTypes[keyof ErrorReasonTypes];
/** Any ErrorWithReason type. */
export type AnyErrorWithReasonType = ErrorWithReason<keyof ErrorReasonTypes>;
/** Sent in ResponseMessage to reconstruct the ErrorWithReason. */
export interface ErrorWithReasonDetails {
    reason: AnyErrorReasonType;
    reasonType: keyof ErrorReasonTypes;
}
export interface TransferableException {
    exception: Error;
    exceptionReason?: ErrorWithReasonDetails;
}
export declare function exceptionFromTransferable(e: TransferableException): Error | AnyErrorWithReasonType;
export declare function newTransferableException(e: Error): TransferableException;
export {};
