// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export var ResponseStopCause;
(function (ResponseStopCause) {
    /** User cancelled response. */
    ResponseStopCause[ResponseStopCause["USER"] = 0] = "USER";
    /** System cancelled response for another reason. */
    ResponseStopCause[ResponseStopCause["OTHER"] = 1] = "OTHER";
})(ResponseStopCause || (ResponseStopCause = {}));
/** The default value of TabContextOptions.pdfSizeLimit. */
export const DEFAULT_PDF_SIZE_LIMIT = 64 * 1024 * 1024;
/** The default value of TabContextOptions.innerTextBytesLimit. */
export const DEFAULT_INNER_TEXT_BYTES_LIMIT = 20000;
/** Reason why the web client could not initialize. */
export var WebClientInitializeErrorReason;
(function (WebClientInitializeErrorReason) {
    /**
     * Unknown reason. The user can manually retry loading, which reloads the
     * entire webview.
     */
    WebClientInitializeErrorReason[WebClientInitializeErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    /** This list will be expanded later. */
})(WebClientInitializeErrorReason || (WebClientInitializeErrorReason = {}));
/** Reason for failure while acting in the focused tab. */
export var ActInFocusedTabErrorReason;
(function (ActInFocusedTabErrorReason) {
    ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    /** Context could not be gathered after acting. */
    ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["GET_CONTEXT_FAILED"] = 1] = "GET_CONTEXT_FAILED";
    /** The action proto is invalid. */
    ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["INVALID_ACTION_PROTO"] = 2] = "INVALID_ACTION_PROTO";
    /** Action target is not found. */
    ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["TARGET_NOT_FOUND"] = 3] = "TARGET_NOT_FOUND";
    /** Failed to start a new task. */
    ActInFocusedTabErrorReason[ActInFocusedTabErrorReason["FAILED_TO_START_TASK"] = 4] = "FAILED_TO_START_TASK";
})(ActInFocusedTabErrorReason || (ActInFocusedTabErrorReason = {}));
/**
 * Top-level views of the glic web client.
 */
export var ClientView;
(function (ClientView) {
    ClientView["ACTUATION"] = "actuation";
    ClientView["CONVERSATION"] = "conversation";
})(ClientView || (ClientView = {}));
///////////////////////////////////////////////////////////////////////////////
/// BEGIN_GENERATED - DO NOT MODIFY BELOW
// This block is generated by
// chrome/browser/resources/glic/glic_api_impl/generate.py
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// The type of user input reaction.
export var MetricUserInputReactionType;
(function (MetricUserInputReactionType) {
    // An unknown reaction type.
    MetricUserInputReactionType[MetricUserInputReactionType["UNKNOWN"] = 0] = "UNKNOWN";
    // A canned reaction which can be presented without communication with the
    // server.
    MetricUserInputReactionType[MetricUserInputReactionType["CANNED"] = 1] = "CANNED";
    // A reaction which requires some generic modeling to produce.
    MetricUserInputReactionType[MetricUserInputReactionType["MODEL"] = 2] = "MODEL";
})(MetricUserInputReactionType || (MetricUserInputReactionType = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason for failure while acting.
export var PerformActionsErrorReason;
(function (PerformActionsErrorReason) {
    PerformActionsErrorReason[PerformActionsErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    // The serialized actions proto failed to parse.
    PerformActionsErrorReason[PerformActionsErrorReason["INVALID_ACTION_PROTO"] = 1] = "INVALID_ACTION_PROTO";
})(PerformActionsErrorReason || (PerformActionsErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason for failure when creating an actor task.
export var CreateTaskErrorReason;
(function (CreateTaskErrorReason) {
    CreateTaskErrorReason[CreateTaskErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    // The host does not support the actor task system.
    CreateTaskErrorReason[CreateTaskErrorReason["TASK_SYSTEM_UNAVAILABLE"] = 1] = "TASK_SYSTEM_UNAVAILABLE";
})(CreateTaskErrorReason || (CreateTaskErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// The state of an actor task.
export var ActorTaskState;
(function (ActorTaskState) {
    ActorTaskState[ActorTaskState["UNKNOWN"] = 0] = "UNKNOWN";
    // The actor task is idle and waiting for the next action instruction.
    ActorTaskState[ActorTaskState["IDLE"] = 1] = "IDLE";
    // The actor task is performing an action.
    ActorTaskState[ActorTaskState["ACTING"] = 2] = "ACTING";
    // The actor task is paused and waiting to be resumed or stopped.
    ActorTaskState[ActorTaskState["PAUSED"] = 3] = "PAUSED";
    // The actor task is stopped and going away.
    ActorTaskState[ActorTaskState["STOPPED"] = 4] = "STOPPED";
})(ActorTaskState || (ActorTaskState = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// The reason/source of why an actor task was paused.
export var ActorTaskPauseReason;
(function (ActorTaskPauseReason) {
    // Actor task was paused by the model.
    ActorTaskPauseReason[ActorTaskPauseReason["PAUSED_BY_MODEL"] = 0] = "PAUSED_BY_MODEL";
    // Actor task was puased by the user.
    ActorTaskPauseReason[ActorTaskPauseReason["PAUSED_BY_USER"] = 1] = "PAUSED_BY_USER";
})(ActorTaskPauseReason || (ActorTaskPauseReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// The reason/source of why an actor task was stopped.
export var ActorTaskStopReason;
(function (ActorTaskStopReason) {
    // Actor task is complete.
    ActorTaskStopReason[ActorTaskStopReason["TASK_COMPLETE"] = 0] = "TASK_COMPLETE";
    // Actor task was stopped by the user.
    ActorTaskStopReason[ActorTaskStopReason["STOPPED_BY_USER"] = 1] = "STOPPED_BY_USER";
    // Actor task was stopped because the model reported a failure.
    ActorTaskStopReason[ActorTaskStopReason["MODEL_ERROR"] = 2] = "MODEL_ERROR";
    // Actor task was stopped by choosing a new conversation.
    ActorTaskStopReason[ActorTaskStopReason["USER_STARTED_NEW_CHAT"] = 3] = "USER_STARTED_NEW_CHAT";
    // Actor task was stopped by choosing a previous conversation.
    ActorTaskStopReason[ActorTaskStopReason["USER_LOADED_PREVIOUS_CHAT"] = 4] = "USER_LOADED_PREVIOUS_CHAT";
})(ActorTaskStopReason || (ActorTaskStopReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason why capturing desktop screenshot failed. NOTE: This may be extended in
// the future so avoid using complete switches on the currently used enum
// values.
export var CaptureScreenshotErrorReason;
(function (CaptureScreenshotErrorReason) {
    // Screen capture or frame encoding failure.
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    // Screen capture requested but already in progress of serving another
    // request.
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["SCREEN_CAPTURE_REQUEST_THROTTLED"] = 1] = "SCREEN_CAPTURE_REQUEST_THROTTLED";
    // User declined screen capture dialog before taking a screenshot.
    CaptureScreenshotErrorReason[CaptureScreenshotErrorReason["USER_CANCELLED_SCREEN_PICKER_DIALOG"] = 2] = "USER_CANCELLED_SCREEN_PICKER_DIALOG";
})(CaptureScreenshotErrorReason || (CaptureScreenshotErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason why scrollTo() failed.
export var ScrollToErrorReason;
(function (ScrollToErrorReason) {
    // Invalid params were provided to scrollTo(), or the browser doesn't support
    // scrollTo() yet.
    ScrollToErrorReason[ScrollToErrorReason["NOT_SUPPORTED"] = 0] = "NOT_SUPPORTED";
    // scrollTo() was called again before this call finished processing.
    ScrollToErrorReason[ScrollToErrorReason["NEWER_SCROLL_TO_CALL"] = 1] = "NEWER_SCROLL_TO_CALL";
    // There is no tab currently in focus.
    ScrollToErrorReason[ScrollToErrorReason["NO_FOCUSED_TAB"] = 2] = "NO_FOCUSED_TAB";
    // The input selector did not match any content in the document or a given
    // range.
    ScrollToErrorReason[ScrollToErrorReason["NO_MATCH_FOUND"] = 3] = "NO_MATCH_FOUND";
    // The currently focused tab changed or navigated while processing the
    // scrollTo() call.
    ScrollToErrorReason[ScrollToErrorReason["FOCUSED_TAB_CHANGED_OR_NAVIGATED"] = 4] = "FOCUSED_TAB_CHANGED_OR_NAVIGATED";
    // The document_id or url provided doesn't match the active document in the
    // primary main frame of the currently focused tab. The document may have been
    // navigated away, may not currently be in focus, or may not be in a primary
    // main frame (we don't currently support iframes).
    ScrollToErrorReason[ScrollToErrorReason["NO_MATCHING_DOCUMENT"] = 5] = "NO_MATCHING_DOCUMENT";
    // The search range starting from DOMNodeId did not result in a valid range.
    ScrollToErrorReason[ScrollToErrorReason["SEARCH_RANGE_INVALID"] = 6] = "SEARCH_RANGE_INVALID";
    // Page context access is disabled.
    ScrollToErrorReason[ScrollToErrorReason["TAB_CONTEXT_PERMISSION_DISABLED"] = 7] = "TAB_CONTEXT_PERMISSION_DISABLED";
    // The web client requested to drop the highlight via
    // `dropScrollToHighlight()`.
    ScrollToErrorReason[ScrollToErrorReason["DROPPED_BY_WEB_CLIENT"] = 8] = "DROPPED_BY_WEB_CLIENT";
})(ScrollToErrorReason || (ScrollToErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason for failure when switching a conversation.
export var SwitchConversationErrorReason;
(function (SwitchConversationErrorReason) {
    SwitchConversationErrorReason[SwitchConversationErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
})(SwitchConversationErrorReason || (SwitchConversationErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason for failure when registering a conversation.
export var RegisterConversationErrorReason;
(function (RegisterConversationErrorReason) {
    RegisterConversationErrorReason[RegisterConversationErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    // The instance already has a conversation ID.
    RegisterConversationErrorReason[RegisterConversationErrorReason["INSTANCE_ALREADY_HAS_CONVERSATION_ID"] = 1] = "INSTANCE_ALREADY_HAS_CONVERSATION_ID";
})(RegisterConversationErrorReason || (RegisterConversationErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// The panel can be in one of these three states.
export var PanelStateKind;
(function (PanelStateKind) {
    // The panel is hidden.
    PanelStateKind[PanelStateKind["HIDDEN"] = 0] = "HIDDEN";
    // The panel is a floating window, detached from any browser window.
    PanelStateKind[PanelStateKind["DETACHED"] = 1] = "DETACHED";
    // The panel is a side panel, attached to a browser window.
    PanelStateKind[PanelStateKind["ATTACHED"] = 2] = "ATTACHED";
})(PanelStateKind || (PanelStateKind = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Entry points that can trigger the opening of the panel.
export var InvocationSource;
(function (InvocationSource) {
    // Button in the OS.
    InvocationSource[InvocationSource["OS_BUTTON"] = 0] = "OS_BUTTON";
    // Menu from button in the OS.
    InvocationSource[InvocationSource["OS_BUTTON_MENU"] = 1] = "OS_BUTTON_MENU";
    // OS-level hotkey.
    InvocationSource[InvocationSource["OS_HOTKEY"] = 2] = "OS_HOTKEY";
    // Button in top-chrome.
    InvocationSource[InvocationSource["TOP_CHROME_BUTTON"] = 3] = "TOP_CHROME_BUTTON";
    // First run experience.
    InvocationSource[InvocationSource["FRE"] = 4] = "FRE";
    // From the profile picker.
    InvocationSource[InvocationSource["PROFILE_PICKER"] = 5] = "PROFILE_PICKER";
    // From tab strip nudge.
    InvocationSource[InvocationSource["NUDGE"] = 6] = "NUDGE";
    // From 3-dot menu.
    InvocationSource[InvocationSource["THREE_DOTS_MENU"] = 7] = "THREE_DOTS_MENU";
    // An unsupported/unknown source.
    InvocationSource[InvocationSource["UNSUPPORTED"] = 8] = "UNSUPPORTED";
    // From the What's New page.
    InvocationSource[InvocationSource["WHATS_NEW"] = 9] = "WHATS_NEW";
    // User clicked the sign-in button and signed in.
    InvocationSource[InvocationSource["AFTER_SIGN_IN"] = 10] = "AFTER_SIGN_IN";
    // User shared a tab (e.g. via its context menu).
    InvocationSource[InvocationSource["SHARED_TAB"] = 11] = "SHARED_TAB";
    // From the actor task icon.
    InvocationSource[InvocationSource["ACTOR_TASK_ICON"] = 12] = "ACTOR_TASK_ICON";
    // User shared an image via the context menu.
    InvocationSource[InvocationSource["SHARED_IMAGE"] = 13] = "SHARED_IMAGE";
    // From the handoff button.
    InvocationSource[InvocationSource["HANDOFF_BUTTON"] = 14] = "HANDOFF_BUTTON";
})(InvocationSource || (InvocationSource = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Web client's operation modes.
export var WebClientMode;
(function (WebClientMode) {
    // Text operation mode.
    WebClientMode[WebClientMode["TEXT"] = 0] = "TEXT";
    // Audio operation mode.
    WebClientMode[WebClientMode["AUDIO"] = 1] = "AUDIO";
})(WebClientMode || (WebClientMode = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Web client's operation model.
export var WebClientModel;
(function (WebClientModel) {
    // Default model.
    WebClientModel[WebClientModel["DEFAULT"] = 0] = "DEFAULT";
    // Actor operation mode.
    WebClientModel[WebClientModel["ACTOR"] = 1] = "ACTOR";
})(WebClientModel || (WebClientModel = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Web client's user counter.
export var WebUseCounter;
(function (WebUseCounter) {
    // Default counter. Never used.
    WebUseCounter[WebUseCounter["DEFAULT"] = 0] = "DEFAULT";
    WebUseCounter[WebUseCounter["SUBMIT_PROMPT_WITH_AUTO_MODE"] = 1] = "SUBMIT_PROMPT_WITH_AUTO_MODE";
})(WebUseCounter || (WebUseCounter = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Reason for `captureRegion` error.
export var CaptureRegionErrorReason;
(function (CaptureRegionErrorReason) {
    CaptureRegionErrorReason[CaptureRegionErrorReason["UNKNOWN"] = 0] = "UNKNOWN";
    // There is no focused tab that can be used for region capture.
    CaptureRegionErrorReason[CaptureRegionErrorReason["NO_FOCUSABLE_TAB"] = 1] = "NO_FOCUSABLE_TAB";
})(CaptureRegionErrorReason || (CaptureRegionErrorReason = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Fields of interest from the Glic settings page.
export var SettingsPageField;
(function (SettingsPageField) {
    // The OS hotkey configuration field.
    SettingsPageField[SettingsPageField["OS_HOTKEY"] = 1] = "OS_HOTKEY";
    // The OS entrypoint enabling field.
    SettingsPageField[SettingsPageField["OS_ENTRYPOINT_TOGGLE"] = 2] = "OS_ENTRYPOINT_TOGGLE";
})(SettingsPageField || (SettingsPageField = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Describes the capability of the glic host.
export var HostCapability;
(function (HostCapability) {
    // Glic host supports scrollTo() with PDF documents.
    HostCapability[HostCapability["SCROLL_TO_PDF"] = 0] = "SCROLL_TO_PDF";
    // Glic host will reset panel size and location on open.
    HostCapability[HostCapability["RESET_SIZE_AND_LOCATION_ON_OPEN"] = 1] = "RESET_SIZE_AND_LOCATION_ON_OPEN";
    // The glic host's getModelQualityClientId() is enabled and can be called
    // safely.
    HostCapability[HostCapability["GET_MODEL_QUALITY_CLIENT_ID"] = 2] = "GET_MODEL_QUALITY_CLIENT_ID";
    // Glic is in multi-instance mode.
    HostCapability[HostCapability["MULTI_INSTANCE"] = 3] = "MULTI_INSTANCE";
})(HostCapability || (HostCapability = {}));
///////////////////////////////////////////////
// WARNING - GENERATED FROM MOJOM, DO NOT EDIT.
// Describes how long the user grants the actor with the permission to actuate.
// Used when the actor is to actuate with sensitive data, such as entering
// payment information or login credentials.
export var UserGrantedPermissionDuration;
(function (UserGrantedPermissionDuration) {
    // The user only grants a one-time permission. The user will be asked again.
    // This is the default behavior.
    UserGrantedPermissionDuration[UserGrantedPermissionDuration["ONE_TIME"] = 0] = "ONE_TIME";
    // The user grants a permission to always allow the actor to actuate with
    // sensitive data. The persistence of this permission is defined differently
    // for different features.
    UserGrantedPermissionDuration[UserGrantedPermissionDuration["ALWAYS_ALLOW"] = 1] = "ALWAYS_ALLOW";
})(UserGrantedPermissionDuration || (UserGrantedPermissionDuration = {}));
/// END_GENERATED - DO NOT MODIFY ABOVE
///////////////////////////////////////////////////////////////////////////////
