import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BitmapN32 as skia_mojom_BitmapN32 } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import { Origin as url_mojom_Origin } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
export declare const UserGrantedPermissionDurationSpec: {
    $: mojo.internal.MojomType;
};
export declare enum UserGrantedPermissionDuration {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kOneTime = 0,
    kAlwaysAllow = 1
}
export declare const SelectCredentialDialogErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SelectCredentialDialogErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 0,
    kDialogPromiseNoSubscriber = 0
}
export declare const SelectAutofillSuggestionsDialogErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SelectAutofillSuggestionsDialogErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kDialogPromiseNoSubscriber = 0,
    kMismatchedTaskId = 1,
    kNoActorTaskDelegate = 2
}
export declare const ConfirmationRequestErrorReasonSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ConfirmationRequestErrorReason {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kRequestPromiseNoSubscriber = 0,
    kPreemptedByNewRequest = 1
}
export declare const TaskOptionsSpec: {
    $: mojo.internal.MojomType;
};
export declare const CredentialSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectCredentialDialogRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectCredentialDialogResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const AutofillSuggestionSpec: {
    $: mojo.internal.MojomType;
};
export declare const FormFillingRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectAutofillSuggestionsDialogRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const FormFillingResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectAutofillSuggestionsDialogResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogPayloadSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const NavigationConfirmationRequestSpec: {
    $: mojo.internal.MojomType;
};
export declare const NavigationConfirmationResponseSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectAutofillSuggestionsDialogResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const UserConfirmationDialogResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const ConfirmationRequestResultSpec: {
    $: mojo.internal.MojomType;
};
export interface TaskOptionsMojoType {
    title: (string | null);
}
export type TaskOptions = TaskOptionsMojoType;
export interface CredentialMojoType {
    id: number;
    username: string;
    sourceSiteOrApp: string;
    requestOrigin: url_mojom_Origin;
}
export type Credential = CredentialMojoType;
export interface SelectCredentialDialogRequestMojoType {
    taskId: number;
    showDialog: boolean;
    credentials: Credential[];
    icons: {
        [key: string]: skia_mojom_BitmapN32;
    };
}
export type SelectCredentialDialogRequest = SelectCredentialDialogRequestMojoType;
export interface SelectCredentialDialogResponseMojoType {
    taskId: number;
    errorReason: (SelectCredentialDialogErrorReason | null);
    permissionDuration: (UserGrantedPermissionDuration | null);
    selectedCredentialId: (number | null);
}
export type SelectCredentialDialogResponse = SelectCredentialDialogResponseMojoType;
export interface AutofillSuggestionMojoType {
    id: string;
    title: string;
    details: string;
    icon: (skia_mojom_BitmapN32 | null);
}
export type AutofillSuggestion = AutofillSuggestionMojoType;
export interface FormFillingRequestMojoType {
    requestedData: bigint;
    suggestions: AutofillSuggestion[];
}
export type FormFillingRequest = FormFillingRequestMojoType;
export interface SelectAutofillSuggestionsDialogRequestMojoType {
    taskId: number;
    formFillingRequests: FormFillingRequest[];
}
export type SelectAutofillSuggestionsDialogRequest = SelectAutofillSuggestionsDialogRequestMojoType;
export interface FormFillingResponseMojoType {
    selectedSuggestionId: string;
}
export type FormFillingResponse = FormFillingResponseMojoType;
export interface SelectAutofillSuggestionsDialogResponseMojoType {
    taskId: number;
    result: SelectAutofillSuggestionsDialogResult;
}
export type SelectAutofillSuggestionsDialogResponse = SelectAutofillSuggestionsDialogResponseMojoType;
export interface UserConfirmationDialogPayloadMojoType {
    navigationOrigin: url_mojom_Origin;
    forBlocklistedOrigin: boolean;
}
export type UserConfirmationDialogPayload = UserConfirmationDialogPayloadMojoType;
export interface UserConfirmationDialogRequestMojoType {
    payload: UserConfirmationDialogPayload;
}
export type UserConfirmationDialogRequest = UserConfirmationDialogRequestMojoType;
export interface UserConfirmationDialogResponseMojoType {
    result: ConfirmationRequestResult;
}
export type UserConfirmationDialogResponse = UserConfirmationDialogResponseMojoType;
export interface NavigationConfirmationRequestMojoType {
    taskId: number;
    navigationOrigin: url_mojom_Origin;
}
export type NavigationConfirmationRequest = NavigationConfirmationRequestMojoType;
export interface NavigationConfirmationResponseMojoType {
    result: ConfirmationRequestResult;
}
export type NavigationConfirmationResponse = NavigationConfirmationResponseMojoType;
export interface SelectAutofillSuggestionsDialogResult {
    errorReason?: SelectAutofillSuggestionsDialogErrorReason;
    selectedSuggestions?: FormFillingResponse[];
}
export declare enum SelectAutofillSuggestionsDialogResultFieldTags {
    ERROR_REASON = 0,
    SELECTED_SUGGESTIONS = 1
}
export declare function whichSelectAutofillSuggestionsDialogResult(u: SelectAutofillSuggestionsDialogResult): SelectAutofillSuggestionsDialogResultFieldTags;
export interface UserConfirmationDialogResult {
    permissionGranted?: boolean;
    errorReason?: ConfirmationRequestErrorReason;
}
export declare enum UserConfirmationDialogResultFieldTags {
    PERMISSION_GRANTED = 0,
    ERROR_REASON = 1
}
export declare function whichUserConfirmationDialogResult(u: UserConfirmationDialogResult): UserConfirmationDialogResultFieldTags;
export interface ConfirmationRequestResult {
    permissionGranted?: boolean;
    errorReason?: ConfirmationRequestErrorReason;
}
export declare enum ConfirmationRequestResultFieldTags {
    PERMISSION_GRANTED = 0,
    ERROR_REASON = 1
}
export declare function whichConfirmationRequestResult(u: ConfirmationRequestResult): ConfirmationRequestResultFieldTags;
