// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class ObservableSubscription{observer;onUnsubscribe;constructor(observer,onUnsubscribe){this.observer=observer;this.onUnsubscribe=onUnsubscribe}unsubscribe(){this.onUnsubscribe(this)}}class ObservableBase{subscribers=new Set;state_="active";errorValue;next(value){switch(this.state_){case"active":break;case"complete":case"error":throw new Error("Observable is not active")}this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){try{sub.observer.next?.(value)}catch(e){console.warn(e)}}}))}error(e){switch(this.state_){case"active":this.state_="error";this.errorValue=e;break;case"complete":case"error":throw new Error("Observable is not active")}let loggedWarning=false;const hadSubscribers=this.hasActiveSubscription();this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){if(sub.observer.error){try{sub.observer.error(e)}catch(e){console.warn(e)}}else{if(!loggedWarning){console.warn("unhandled error: ",e);loggedWarning=true}}}}));this.subscribers.clear();if(hadSubscribers){this.activeSubscriptionChanged(false)}}complete(){switch(this.state_){case"active":this.state_="complete";break;case"complete":case"error":throw new Error("Observable is not active")}const hadSubscribers=this.hasActiveSubscription();this.subscribers.forEach((sub=>{if(this.subscribers.has(sub)){try{sub.observer.complete?.()}catch(e){console.warn(e)}}}));this.subscribers.clear();if(hadSubscribers){this.activeSubscriptionChanged(false)}}isStopped(){return this.state_!=="active"}subscribe(changeOrObserver){if(typeof changeOrObserver==="function"){return this.subscribeObserver({next:value=>{changeOrObserver(value)}})}else{return this.subscribeObserver(changeOrObserver)}}subscribeObserver(observer){switch(this.state_){case"active":break;case"complete":observer.complete?.();return{unsubscribe:()=>{}};case"error":observer.error?.(this.errorValue);return{unsubscribe:()=>{}}}const newSub=new ObservableSubscription(observer,this.onUnsubscribe.bind(this));if(this.subscribers.size===0){this.activeSubscriptionChanged(true)}this.subscribers.add(newSub);this.subscriberAdded(newSub);return newSub}onUnsubscribe(sub){if(!this.subscribers){return}if(this.subscribers.size===0){return}this.subscribers.delete(sub);if(this.subscribers.size===0){this.activeSubscriptionChanged(false)}}subscriberAdded(_sub){}activeSubscriptionChanged(_hasActiveSubscription){}hasActiveSubscription(){return this.subscribers.size>0}}export class Subject extends ObservableBase{next(value){super.next(value)}}export class ObservableValue extends Subject{isSet;value;hasActiveSubscriptionCallback;constructor(isSet,value,hasActiveSubscriptionCallback){super();this.isSet=isSet;this.value=value;this.hasActiveSubscriptionCallback=hasActiveSubscriptionCallback}static withValue(value,hasActiveSubscriptionCallback){return new ObservableValue(true,value,hasActiveSubscriptionCallback)}static withNoValue(hasActiveSubscriptionCallback){return new ObservableValue(false,undefined,hasActiveSubscriptionCallback)}assignAndSignal(v,force=false){if(this.isStopped()){throw new Error("ObservableValue is not active")}const send=!this.isSet||this.value!==v||force;this.isSet=true;this.value=v;if(!send){return}super.next(v)}getCurrentValue(){return this.value}async waitUntil(criteria){const{promise:promise,resolve:resolve,reject:reject}=Promise.withResolvers();const sub=this.subscribe({next(newValue){if(criteria(newValue)){resolve(newValue)}},error:reject,complete(){reject(new Error("Observable completed"))}});let resultValue;try{resultValue=await promise}finally{sub.unsubscribe()}return resultValue}subscriberAdded(sub){if(this.isSet){sub.observer.next?.(this.value)}}activeSubscriptionChanged(hasActiveSubscription){super.activeSubscriptionChanged(hasActiveSubscription);this.hasActiveSubscriptionCallback?.(hasActiveSubscription)}}