// chrome/browser/ui/webui/discards/site_data.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export class SiteDataProviderPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'discards.mojom.SiteDataProvider', scope);
    }
}
export class SiteDataProviderRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SiteDataProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getSiteDataArray(explicitlyRequestedOrigins) {
        return this.proxy.sendMessage(0, SiteDataProvider_GetSiteDataArray_ParamsSpec.$, SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$, [
            explicitlyRequestedOrigins
        ], false);
    }
    getSiteDataDatabaseSize() {
        return this.proxy.sendMessage(1, SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$, SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the SiteDataProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SiteDataProviderReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SiteDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SiteDataProvider_GetSiteDataArray_ParamsSpec.$, SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$, impl.getSiteDataArray.bind(impl), false);
        this.helper_internal_.registerHandler(1, SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$, SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$, impl.getSiteDataDatabaseSize.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SiteDataProvider {
    static get $interfaceName() {
        return "discards.mojom.SiteDataProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SiteDataProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SiteDataProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SiteDataProviderCallbackRouter {
    helper_internal_;
    $;
    router_;
    getSiteDataArray;
    getSiteDataDatabaseSize;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SiteDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getSiteDataArray =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SiteDataProvider_GetSiteDataArray_ParamsSpec.$, SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$, this.getSiteDataArray.createReceiverHandler(true /* expectsResponse */), false);
        this.getSiteDataDatabaseSize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$, SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$, this.getSiteDataDatabaseSize.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SiteDataFeatureSpec = { $: {} };
export const SiteDataPerformanceMeasurementSpec = { $: {} };
export const SiteDataDatabaseSizeSpec = { $: {} };
export const SiteDataValueSpec = { $: {} };
export const SiteDataEntrySpec = { $: {} };
export const SiteDataArraySpec = { $: {} };
export const SiteDataProvider_GetSiteDataArray_ParamsSpec = { $: {} };
export const SiteDataProvider_GetSiteDataArray_ResponseParamsSpec = { $: {} };
export const SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec = { $: {} };
export const SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(SiteDataFeatureSpec.$, 'SiteDataFeature', [
    mojo.internal.StructField('observationDuration', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('useTimestamp', 8, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SiteDataPerformanceMeasurementSpec.$, 'SiteDataPerformanceMeasurement', [
    mojo.internal.StructField('avgCpuUsageUs', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('avgFootprintKb', 4, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('avgLoadDurationUs', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SiteDataDatabaseSizeSpec.$, 'SiteDataDatabaseSize', [
    mojo.internal.StructField('numRows', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('onDiskSizeKb', 8, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SiteDataValueSpec.$, 'SiteDataValue', [
    mojo.internal.StructField('lastLoaded', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updatesFaviconInBackground', 8, 0, SiteDataFeatureSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updatesTitleInBackground', 16, 0, SiteDataFeatureSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('usesAudioInBackground', 24, 0, SiteDataFeatureSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('loadTimeEstimates', 32, 0, SiteDataPerformanceMeasurementSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(SiteDataEntrySpec.$, 'SiteDataEntry', [
    mojo.internal.StructField('origin', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDirty', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 16, 0, SiteDataValueSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(SiteDataArraySpec.$, 'SiteDataArray', [
    mojo.internal.StructField('dbRows', 0, 0, mojo.internal.Array(SiteDataEntrySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SiteDataProvider_GetSiteDataArray_ParamsSpec.$, 'SiteDataProvider_GetSiteDataArray_Params', [
    mojo.internal.StructField('explicitlyRequestedOrigins', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SiteDataProvider_GetSiteDataArray_ResponseParamsSpec.$, 'SiteDataProvider_GetSiteDataArray_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, SiteDataArraySpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SiteDataProvider_GetSiteDataDatabaseSize_ParamsSpec.$, 'SiteDataProvider_GetSiteDataDatabaseSize_Params', [], [[0, 8],]);
mojo.internal.Struct(SiteDataProvider_GetSiteDataDatabaseSize_ResponseParamsSpec.$, 'SiteDataProvider_GetSiteDataDatabaseSize_ResponseParams', [
    mojo.internal.StructField('dbSize', 0, 0, SiteDataDatabaseSizeSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
