// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";export class WordStreamer{callback;msPerTick_=100;charsPerTick_=10;msWaitBeforeComplete_=300;words_=[];displayState_=new DisplayState;nextTick_;finalTick_;finalTextReceived_=false;constructor(callback){this.callback=callback}reset(){if(this.nextTick_){window.clearTimeout(this.nextTick_)}if(this.finalTick_){window.clearTimeout(this.finalTick_)}this.words_=[];this.displayState_=new DisplayState;this.nextTick_=undefined;this.finalTextReceived_=false}setText(text,isFinal){assert(!isFinal||!this.finalTextReceived_);this.words_=splitIntoWords(text,isFinal);if(this.displayState_.update(0,this.words_)){this.callback([...this.displayState_.words],false)}this.finalTextReceived_=isFinal;if(!this.nextTick_){this.scheduleUpdate()}}scheduleUpdate(){if(this.nextTick_){window.clearTimeout(this.nextTick_)}this.nextTick_=window.setTimeout((()=>this.tick()),this.msPerTick_)}tick(){this.nextTick_=undefined;const displayChanged=this.displayState_.update(this.charsPerTick_,this.words_);const pendingWordsToDisplay=this.displayState_.words.length!==this.words_.length;const finalStateDisplayed=this.finalTextReceived_&&!pendingWordsToDisplay;if(displayChanged){this.callback([...this.displayState_.words],false)}if(pendingWordsToDisplay){this.scheduleUpdate()}else{this.displayState_.clearPendingChars()}if(finalStateDisplayed){this.finalTick_=window.setTimeout((()=>{this.callback([...this.displayState_.words],true);this.finalTick_=undefined}),this.msWaitBeforeComplete_)}}setMsPerTickForTesting(msPerTick){this.msPerTick_=msPerTick}setCharsPerTickForTesting(charsPerTick){this.charsPerTick_=charsPerTick}setMsWaitBeforeCompleteForTesting(msWaitBeforeComplete){this.msWaitBeforeComplete_=msWaitBeforeComplete}}function splitIntoWords(text,includeLast){let words=text.split(" ");if(words.length>0&&!includeLast){words.pop()}if(words.length===1&&words[0]===""){words=[]}return words.map(((s,i)=>(i>0?" ":"")+s))}class DisplayState{words_=[];pendingChars_=0;clearPendingChars(){this.pendingChars_=0}update(additionalChars,allWords){this.pendingChars_+=additionalChars;let modified=false;let prefixLen=0;while(prefixLen<Math.min(allWords.length,this.words_.length)&&allWords[prefixLen]===this.words_[prefixLen]){++prefixLen}if(prefixLen!==this.words_.length){modified=true;this.words_.splice(prefixLen)}while(allWords.length>this.words_.length){const nextWord=allWords[this.words_.length];if(nextWord.length>this.pendingChars_){break}this.words_.push(nextWord);this.pendingChars_-=nextWord.length;modified=true}return modified}get words(){return this.words_}}