export interface UrlListEntry {
    title: string;
    url: string;
    imageUrl: string;
}
export declare function getAbbreviatedUrl(urlString: string): string;
/**
 * Queries |selector| on |element|'s shadow root and returns the resulting
 * element if there is any.
 */
export declare function $$<K extends keyof HTMLElementTagNameMap>(element: Element, selector: K): HTMLElementTagNameMap[K] | null;
export declare function $$<K extends keyof SVGElementTagNameMap>(element: Element, selector: K): SVGElementTagNameMap[K] | null;
export declare function $$<E extends Element = Element>(element: Element, selector: string): E | null;
/**
 * @param uuid The UUID to validate.
 * @returns Whether the UUID is a valid lowercase UUID.
 */
export declare function isValidLowercaseUuid(uuid: string): boolean;
