// chrome/browser/resources/certificate_manager/certificate_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-params-data.h"
#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared-message-ids.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-import-headers.h"
#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-test-utils.h"


namespace certificate_manager::mojom {
SummaryCertInfo::SummaryCertInfo()
    : sha256hash_hex(),
      display_name(),
      is_deletable() {}

SummaryCertInfo::SummaryCertInfo(
    const std::string& sha256hash_hex_in,
    const std::string& display_name_in,
    bool is_deletable_in)
    : sha256hash_hex(std::move(sha256hash_hex_in)),
      display_name(std::move(display_name_in)),
      is_deletable(std::move(is_deletable_in)) {}

SummaryCertInfo::~SummaryCertInfo() = default;
size_t SummaryCertInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->sha256hash_hex);
  seed = mojo::internal::Hash(seed, this->display_name);
  seed = mojo::internal::Hash(seed, this->is_deletable);
  return seed;
}

void SummaryCertInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sha256hash_hex"), this->sha256hash_hex,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_deletable"), this->is_deletable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SummaryCertInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertManagementMetadata::CertManagementMetadata()
    : include_system_trust_store(),
      num_user_added_system_certs(),
      is_include_system_trust_store_managed(),
      num_policy_certs(),
      num_user_certs(),
      show_user_certs_ui() {}

CertManagementMetadata::CertManagementMetadata(
    bool include_system_trust_store_in,
    uint8_t num_user_added_system_certs_in,
    bool is_include_system_trust_store_managed_in,
    uint8_t num_policy_certs_in,
    uint32_t num_user_certs_in,
    bool show_user_certs_ui_in)
    : include_system_trust_store(std::move(include_system_trust_store_in)),
      num_user_added_system_certs(std::move(num_user_added_system_certs_in)),
      is_include_system_trust_store_managed(std::move(is_include_system_trust_store_managed_in)),
      num_policy_certs(std::move(num_policy_certs_in)),
      num_user_certs(std::move(num_user_certs_in)),
      show_user_certs_ui(std::move(show_user_certs_ui_in)) {}

CertManagementMetadata::~CertManagementMetadata() = default;
size_t CertManagementMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->include_system_trust_store);
  seed = mojo::internal::Hash(seed, this->num_user_added_system_certs);
  seed = mojo::internal::Hash(seed, this->is_include_system_trust_store_managed);
  seed = mojo::internal::Hash(seed, this->num_policy_certs);
  seed = mojo::internal::Hash(seed, this->num_user_certs);
  seed = mojo::internal::Hash(seed, this->show_user_certs_ui);
  return seed;
}

void CertManagementMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_system_trust_store"), this->include_system_trust_store,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_user_added_system_certs"), this->num_user_added_system_certs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_include_system_trust_store_managed"), this->is_include_system_trust_store_managed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_policy_certs"), this->num_policy_certs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_user_certs"), this->num_user_certs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_user_certs_ui"), this->show_user_certs_ui,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertManagementMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ActionResultPtr
ActionResult::NewError(
    const std::string& value) {
  return ActionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

ActionResultPtr
ActionResult::NewSuccess(
    SuccessResult value) {
  return ActionResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

ActionResult::ActionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}

ActionResult::ActionResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    SuccessResult value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}
ActionResult::~ActionResult() {
  DestroyActive();
}

void ActionResult::set_error(const std::string& error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) std::string(
        std::move(error));
  }
}

void ActionResult::set_success(SuccessResult success) {
  if (tag_ != Tag::kSuccess) {
    DestroyActive();
    tag_ = Tag::kSuccess;
  }
  data_.success = success;
}


ActionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : error(std::move(value)) {}

ActionResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    SuccessResult value)
    : success(std::move(value)) {}

void ActionResult::DestroyActive() {
  switch (tag_) {

    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
  }
}
size_t ActionResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kError:
      return mojo::internal::Hash(seed, data_.error);
    case Tag::kSuccess:
      return mojo::internal::Hash(seed, data_.success);
    default:
      NOTREACHED();
  }
}

bool ActionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

CertificateManagerPageHandlerFactory::IPCStableHashFunction CertificateManagerPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertificateManagerPageHandlerFactory>(message.name())) {
    case messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler: {
      return &CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertificateManagerPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertificateManagerPageHandlerFactory>(message.name())) {
      case messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler";
    }
  } else {
    switch (static_cast<messages::CertificateManagerPageHandlerFactory>(message.name())) {
      case messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab78112e;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CertificateManagerPageHandlerFactoryProxy::CertificateManagerPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertificateManagerPageHandlerFactoryProxy::CreateCertificateManagerPageHandler(
    ::mojo::PendingRemote<CertificateManagerPage> in_page, ::mojo::PendingReceiver<CertificateManagerPageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandlerFactory::CreateCertificateManagerPageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<CertificateManagerPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CertificateManagerPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::certificate_manager::mojom::CertificateManagerPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in CertificateManagerPageHandlerFactory.CreateCertificateManagerPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::certificate_manager::mojom::CertificateManagerPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CertificateManagerPageHandlerFactory.CreateCertificateManagerPageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandlerFactory::Name_);
  message.set_method_name("CreateCertificateManagerPageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CertificateManagerPageHandlerFactoryStubDispatch::Accept(
    CertificateManagerPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertificateManagerPageHandlerFactory>(message->header()->name)) {
    case messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<CertificateManagerPage> p_page{};
      ::mojo::PendingReceiver<CertificateManagerPageHandler> p_handler{};
      CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCertificateManagerPageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CertificateManagerPageHandlerFactoryStubDispatch::AcceptWithResponder(
    CertificateManagerPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertificateManagerPageHandlerFactory>(message->header()->name)) {
    case messages::CertificateManagerPageHandlerFactory::kCreateCertificateManagerPageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertificateManagerPageHandlerFactoryValidationInfo[] = {
    { &internal::CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertificateManagerPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::certificate_manager::mojom::CertificateManagerPageHandlerFactory::Name_,
    kCertificateManagerPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CertificateManagerPageHandler::IPCStableHashFunction CertificateManagerPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertificateManagerPageHandler>(message.name())) {
    case messages::CertificateManagerPageHandler::kGetCertificates: {
      return &CertificateManagerPageHandler::GetCertificates_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kGetCertManagementMetadata: {
      return &CertificateManagerPageHandler::GetCertManagementMetadata_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kViewCertificate: {
      return &CertificateManagerPageHandler::ViewCertificate_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kExportCertificates: {
      return &CertificateManagerPageHandler::ExportCertificates_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kImportCertificate: {
      return &CertificateManagerPageHandler::ImportCertificate_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kImportAndBindCertificate: {
      return &CertificateManagerPageHandler::ImportAndBindCertificate_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kDeleteCertificate: {
      return &CertificateManagerPageHandler::DeleteCertificate_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kShowNativeManageCertificates: {
      return &CertificateManagerPageHandler::ShowNativeManageCertificates_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore: {
      return &CertificateManagerPageHandler::SetIncludeSystemTrustStore_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertificateManagerPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertificateManagerPageHandler>(message.name())) {
      case messages::CertificateManagerPageHandler::kGetCertificates:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::GetCertificates";
      case messages::CertificateManagerPageHandler::kGetCertManagementMetadata:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::GetCertManagementMetadata";
      case messages::CertificateManagerPageHandler::kViewCertificate:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::ViewCertificate";
      case messages::CertificateManagerPageHandler::kExportCertificates:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::ExportCertificates";
      case messages::CertificateManagerPageHandler::kImportCertificate:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::ImportCertificate";
      case messages::CertificateManagerPageHandler::kImportAndBindCertificate:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::ImportAndBindCertificate";
      case messages::CertificateManagerPageHandler::kDeleteCertificate:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::DeleteCertificate";
      case messages::CertificateManagerPageHandler::kShowNativeManageCertificates:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::ShowNativeManageCertificates";
      case messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore:
            return "Receive certificate_manager::mojom::CertificateManagerPageHandler::SetIncludeSystemTrustStore";
    }
  } else {
    switch (static_cast<messages::CertificateManagerPageHandler>(message.name())) {
      case messages::CertificateManagerPageHandler::kGetCertificates:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::GetCertificates";
      case messages::CertificateManagerPageHandler::kGetCertManagementMetadata:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::GetCertManagementMetadata";
      case messages::CertificateManagerPageHandler::kViewCertificate:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::ViewCertificate";
      case messages::CertificateManagerPageHandler::kExportCertificates:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::ExportCertificates";
      case messages::CertificateManagerPageHandler::kImportCertificate:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::ImportCertificate";
      case messages::CertificateManagerPageHandler::kImportAndBindCertificate:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::ImportAndBindCertificate";
      case messages::CertificateManagerPageHandler::kDeleteCertificate:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::DeleteCertificate";
      case messages::CertificateManagerPageHandler::kShowNativeManageCertificates:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::ShowNativeManageCertificates";
      case messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore:
            return "Receive reply certificate_manager::mojom::CertificateManagerPageHandler::SetIncludeSystemTrustStore";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertificateManagerPageHandler::GetCertificates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8184c882;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::GetCertificates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::GetCertManagementMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaffe0d8e;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::GetCertManagementMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::ViewCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9e69b58;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::ViewCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::ExportCertificates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x916446da;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::ExportCertificates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::ImportCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f62a1c3;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::ImportCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::ImportAndBindCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07e8b9f1;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::ImportAndBindCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::DeleteCertificate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecae8d39;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::DeleteCertificate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::ShowNativeManageCertificates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecbb11db;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::ShowNativeManageCertificates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPageHandler::SetIncludeSystemTrustStore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x355cc95e;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPageHandler::SetIncludeSystemTrustStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CertificateManagerPageHandler_GetCertificates_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPageHandler_GetCertificates_ForwardToCallback(
      CertificateManagerPageHandler::GetCertificatesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPageHandler_GetCertificates_ForwardToCallback(const CertificateManagerPageHandler_GetCertificates_ForwardToCallback&) = delete;
  CertificateManagerPageHandler_GetCertificates_ForwardToCallback& operator=(const CertificateManagerPageHandler_GetCertificates_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPageHandler::GetCertificatesCallback callback_;
};

class CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback(
      CertificateManagerPageHandler::GetCertManagementMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback(const CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback&) = delete;
  CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback& operator=(const CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPageHandler::GetCertManagementMetadataCallback callback_;
};

class CertificateManagerPageHandler_ImportCertificate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPageHandler_ImportCertificate_ForwardToCallback(
      CertificateManagerPageHandler::ImportCertificateCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPageHandler_ImportCertificate_ForwardToCallback(const CertificateManagerPageHandler_ImportCertificate_ForwardToCallback&) = delete;
  CertificateManagerPageHandler_ImportCertificate_ForwardToCallback& operator=(const CertificateManagerPageHandler_ImportCertificate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPageHandler::ImportCertificateCallback callback_;
};

class CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback(
      CertificateManagerPageHandler::ImportAndBindCertificateCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback(const CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback&) = delete;
  CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback& operator=(const CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPageHandler::ImportAndBindCertificateCallback callback_;
};

class CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback(
      CertificateManagerPageHandler::DeleteCertificateCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback(const CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback&) = delete;
  CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback& operator=(const CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPageHandler::DeleteCertificateCallback callback_;
};

CertificateManagerPageHandlerProxy::CertificateManagerPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertificateManagerPageHandlerProxy::GetCertificates(
    CertificateSource in_source, GetCertificatesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::GetCertificates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kGetCertificates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_GetCertificates_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("GetCertificates");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPageHandler_GetCertificates_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageHandlerProxy::GetCertManagementMetadata(
    GetCertManagementMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::GetCertManagementMetadata");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kGetCertManagementMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("GetCertManagementMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageHandlerProxy::ViewCertificate(
    CertificateSource in_source, const std::string& in_sha256_hash_hex) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::ViewCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sha256_hash_hex"), in_sha256_hash_hex,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kViewCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ViewCertificate_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->sha256_hash_hex)::BaseType> sha256_hash_hex_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sha256_hash_hex,
    sha256_hash_hex_fragment);

  params->sha256_hash_hex.Set(
      sha256_hash_hex_fragment.is_null() ? nullptr : sha256_hash_hex_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sha256_hash_hex.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sha256_hash_hex in CertificateManagerPageHandler.ViewCertificate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ViewCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertificateManagerPageHandlerProxy::ExportCertificates(
    CertificateSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::ExportCertificates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kExportCertificates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ExportCertificates_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ExportCertificates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertificateManagerPageHandlerProxy::ImportCertificate(
    CertificateSource in_source, ImportCertificateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::ImportCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kImportCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ImportCertificate_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ImportCertificate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPageHandler_ImportCertificate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageHandlerProxy::ImportAndBindCertificate(
    CertificateSource in_source, ImportAndBindCertificateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::ImportAndBindCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kImportAndBindCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ImportAndBindCertificate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageHandlerProxy::DeleteCertificate(
    CertificateSource in_source, const std::string& in_display_name, const std::string& in_sha256_hash_hex, DeleteCertificateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::DeleteCertificate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type CertificateSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_name"), in_display_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sha256_hash_hex"), in_sha256_hash_hex,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kDeleteCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_DeleteCertificate_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::certificate_manager::mojom::CertificateSource>(
    in_source,
    &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->display_name)::BaseType> display_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_display_name,
    display_name_fragment);

  params->display_name.Set(
      display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->display_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null display_name in CertificateManagerPageHandler.DeleteCertificate request");
  mojo::internal::MessageFragment<
      typename decltype(params->sha256_hash_hex)::BaseType> sha256_hash_hex_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sha256_hash_hex,
    sha256_hash_hex_fragment);

  params->sha256_hash_hex.Set(
      sha256_hash_hex_fragment.is_null() ? nullptr : sha256_hash_hex_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sha256_hash_hex.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sha256_hash_hex in CertificateManagerPageHandler.DeleteCertificate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("DeleteCertificate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageHandlerProxy::ShowNativeManageCertificates(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::ShowNativeManageCertificates");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kShowNativeManageCertificates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ShowNativeManageCertificates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertificateManagerPageHandlerProxy::SetIncludeSystemTrustStore(
    bool in_include) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPageHandler::SetIncludeSystemTrustStore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("include"), in_include,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data> params(
          message);
  params.Allocate();

  params->include = in_include;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("SetIncludeSystemTrustStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CertificateManagerPageHandler_GetCertificates_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPageHandler::GetCertificatesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPageHandler_GetCertificates_ProxyToResponder> proxy(
        new CertificateManagerPageHandler_GetCertificates_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPageHandler_GetCertificates_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPageHandler_GetCertificates_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPageHandler_GetCertificates_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPageHandler::GetCertificatesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<SummaryCertInfoPtr> in_certs);
};

bool CertificateManagerPageHandler_GetCertificates_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPageHandler_GetCertificates_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPageHandler_GetCertificates_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPageHandler.0
  bool success = true;
  std::vector<SummaryCertInfoPtr> p_certs{};
  CertificateManagerPageHandler_GetCertificates_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCerts(&p_certs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_certs));
  }
  return true;
}

void CertificateManagerPageHandler_GetCertificates_ProxyToResponder::Run(
    std::vector<SummaryCertInfoPtr> in_certs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPageHandler::GetCertificates", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certs"), in_certs,
                        "<value of type std::vector<SummaryCertInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kGetCertificates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_GetCertificates_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certs)::BaseType>
      certs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& certs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::certificate_manager::mojom::SummaryCertInfoDataView>>(
    in_certs,
    certs_fragment,
    &certs_validate_params);

  params->certs.Set(
      certs_fragment.is_null() ? nullptr : certs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("GetCertificates");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPageHandler::GetCertManagementMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder> proxy(
        new CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPageHandler::GetCertManagementMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CertManagementMetadataPtr in_metadata);
};

bool CertificateManagerPageHandler_GetCertManagementMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPageHandler.1
  bool success = true;
  CertManagementMetadataPtr p_metadata{};
  CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_metadata));
  }
  return true;
}

void CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder::Run(
    CertManagementMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPageHandler::GetCertManagementMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type CertManagementMetadataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kGetCertManagementMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::certificate_manager::mojom::CertManagementMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("GetCertManagementMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertificateManagerPageHandler_ImportCertificate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPageHandler::ImportCertificateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPageHandler_ImportCertificate_ProxyToResponder> proxy(
        new CertificateManagerPageHandler_ImportCertificate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPageHandler_ImportCertificate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPageHandler_ImportCertificate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPageHandler_ImportCertificate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPageHandler::ImportCertificateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ActionResultPtr in_result);
};

bool CertificateManagerPageHandler_ImportCertificate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPageHandler.4
  bool success = true;
  ActionResultPtr p_result{};
  CertificateManagerPageHandler_ImportCertificate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CertificateManagerPageHandler_ImportCertificate_ProxyToResponder::Run(
    ActionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPageHandler::ImportCertificate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ActionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kImportCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::certificate_manager::mojom::ActionResultDataView>(
    in_result,
    result_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ImportCertificate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPageHandler::ImportAndBindCertificateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder> proxy(
        new CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPageHandler::ImportAndBindCertificateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ActionResultPtr in_result);
};

bool CertificateManagerPageHandler_ImportAndBindCertificate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPageHandler.5
  bool success = true;
  ActionResultPtr p_result{};
  CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder::Run(
    ActionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPageHandler::ImportAndBindCertificate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ActionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kImportAndBindCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::certificate_manager::mojom::ActionResultDataView>(
    in_result,
    result_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("ImportAndBindCertificate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPageHandler::DeleteCertificateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder> proxy(
        new CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPageHandler::DeleteCertificateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ActionResultPtr in_result);
};

bool CertificateManagerPageHandler_DeleteCertificate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPageHandler.6
  bool success = true;
  ActionResultPtr p_result{};
  CertificateManagerPageHandler_DeleteCertificate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder::Run(
    ActionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPageHandler::DeleteCertificate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ActionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPageHandler::kDeleteCertificate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::certificate_manager::mojom::ActionResultDataView>(
    in_result,
    result_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPageHandler::Name_);
  message.set_method_name("DeleteCertificate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CertificateManagerPageHandlerStubDispatch::Accept(
    CertificateManagerPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertificateManagerPageHandler>(message->header()->name)) {
    case messages::CertificateManagerPageHandler::kGetCertificates: {
      break;
    }
    case messages::CertificateManagerPageHandler::kGetCertManagementMetadata: {
      break;
    }
    case messages::CertificateManagerPageHandler::kViewCertificate: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPageHandler_ViewCertificate_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPageHandler_ViewCertificate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.2
      bool success = true;
      CertificateSource p_source{};
      std::string p_sha256_hash_hex{};
      CertificateManagerPageHandler_ViewCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadSha256HashHex(&p_sha256_hash_hex))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ViewCertificate(        
        std::move(p_source), 
        std::move(p_sha256_hash_hex));
      return true;
    }
    case messages::CertificateManagerPageHandler::kExportCertificates: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPageHandler_ExportCertificates_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPageHandler_ExportCertificates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.3
      bool success = true;
      CertificateSource p_source{};
      CertificateManagerPageHandler_ExportCertificates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExportCertificates(        
        std::move(p_source));
      return true;
    }
    case messages::CertificateManagerPageHandler::kImportCertificate: {
      break;
    }
    case messages::CertificateManagerPageHandler::kImportAndBindCertificate: {
      break;
    }
    case messages::CertificateManagerPageHandler::kDeleteCertificate: {
      break;
    }
    case messages::CertificateManagerPageHandler::kShowNativeManageCertificates: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.7
      bool success = true;
      CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowNativeManageCertificates(        );
      return true;
    }
    case messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.8
      bool success = true;
      bool p_include{};
      CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_include = input_data_view.include();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIncludeSystemTrustStore(        
        std::move(p_include));
      return true;
    }
  }
  return false;
}

// static
bool CertificateManagerPageHandlerStubDispatch::AcceptWithResponder(
    CertificateManagerPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertificateManagerPageHandler>(message->header()->name)) {
    case messages::CertificateManagerPageHandler::kGetCertificates: {
      internal::CertificateManagerPageHandler_GetCertificates_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPageHandler_GetCertificates_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.0
      bool success = true;
      CertificateSource p_source{};
      CertificateManagerPageHandler_GetCertificates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          CertificateManagerPageHandler_GetCertificates_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCertificates(        
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::CertificateManagerPageHandler::kGetCertManagementMetadata: {
      internal::CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.1
      bool success = true;
      CertificateManagerPageHandler_GetCertManagementMetadata_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          CertificateManagerPageHandler_GetCertManagementMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCertManagementMetadata(std::move(callback));
      return true;
    }
    case messages::CertificateManagerPageHandler::kViewCertificate: {
      break;
    }
    case messages::CertificateManagerPageHandler::kExportCertificates: {
      break;
    }
    case messages::CertificateManagerPageHandler::kImportCertificate: {
      internal::CertificateManagerPageHandler_ImportCertificate_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPageHandler_ImportCertificate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.4
      bool success = true;
      CertificateSource p_source{};
      CertificateManagerPageHandler_ImportCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          CertificateManagerPageHandler_ImportCertificate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportCertificate(        
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::CertificateManagerPageHandler::kImportAndBindCertificate: {
      internal::CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.5
      bool success = true;
      CertificateSource p_source{};
      CertificateManagerPageHandler_ImportAndBindCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          CertificateManagerPageHandler_ImportAndBindCertificate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImportAndBindCertificate(        
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::CertificateManagerPageHandler::kDeleteCertificate: {
      internal::CertificateManagerPageHandler_DeleteCertificate_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPageHandler_DeleteCertificate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPageHandler.6
      bool success = true;
      CertificateSource p_source{};
      std::string p_display_name{};
      std::string p_sha256_hash_hex{};
      CertificateManagerPageHandler_DeleteCertificate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadDisplayName(&p_display_name))
        success = false;
      if (success && !input_data_view.ReadSha256HashHex(&p_sha256_hash_hex))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPageHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          CertificateManagerPageHandler_DeleteCertificate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCertificate(        
        std::move(p_source), 
        std::move(p_display_name), 
        std::move(p_sha256_hash_hex), std::move(callback));
      return true;
    }
    case messages::CertificateManagerPageHandler::kShowNativeManageCertificates: {
      break;
    }
    case messages::CertificateManagerPageHandler::kSetIncludeSystemTrustStore: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertificateManagerPageHandlerValidationInfo[] = {
    { &internal::CertificateManagerPageHandler_GetCertificates_Params_Data::Validate,
     &internal::CertificateManagerPageHandler_GetCertificates_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPageHandler_GetCertManagementMetadata_Params_Data::Validate,
     &internal::CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPageHandler_ViewCertificate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertificateManagerPageHandler_ExportCertificates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertificateManagerPageHandler_ImportCertificate_Params_Data::Validate,
     &internal::CertificateManagerPageHandler_ImportCertificate_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPageHandler_ImportAndBindCertificate_Params_Data::Validate,
     &internal::CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPageHandler_DeleteCertificate_Params_Data::Validate,
     &internal::CertificateManagerPageHandler_DeleteCertificate_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPageHandler_ShowNativeManageCertificates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertificateManagerPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::certificate_manager::mojom::CertificateManagerPageHandler::Name_,
    kCertificateManagerPageHandlerValidationInfo);
}

bool CertificateManagerPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::certificate_manager::mojom::CertificateManagerPageHandler::Name_,
    kCertificateManagerPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

CertificateManagerPage::IPCStableHashFunction CertificateManagerPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertificateManagerPage>(message.name())) {
    case messages::CertificateManagerPage::kAskForImportPassword: {
      return &CertificateManagerPage::AskForImportPassword_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPage::kAskForConfirmation: {
      return &CertificateManagerPage::AskForConfirmation_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPage::kTriggerReload: {
      return &CertificateManagerPage::TriggerReload_Sym::IPCStableHash;
    }
    case messages::CertificateManagerPage::kTriggerMetadataUpdate: {
      return &CertificateManagerPage::TriggerMetadataUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertificateManagerPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertificateManagerPage>(message.name())) {
      case messages::CertificateManagerPage::kAskForImportPassword:
            return "Receive certificate_manager::mojom::CertificateManagerPage::AskForImportPassword";
      case messages::CertificateManagerPage::kAskForConfirmation:
            return "Receive certificate_manager::mojom::CertificateManagerPage::AskForConfirmation";
      case messages::CertificateManagerPage::kTriggerReload:
            return "Receive certificate_manager::mojom::CertificateManagerPage::TriggerReload";
      case messages::CertificateManagerPage::kTriggerMetadataUpdate:
            return "Receive certificate_manager::mojom::CertificateManagerPage::TriggerMetadataUpdate";
    }
  } else {
    switch (static_cast<messages::CertificateManagerPage>(message.name())) {
      case messages::CertificateManagerPage::kAskForImportPassword:
            return "Receive reply certificate_manager::mojom::CertificateManagerPage::AskForImportPassword";
      case messages::CertificateManagerPage::kAskForConfirmation:
            return "Receive reply certificate_manager::mojom::CertificateManagerPage::AskForConfirmation";
      case messages::CertificateManagerPage::kTriggerReload:
            return "Receive reply certificate_manager::mojom::CertificateManagerPage::TriggerReload";
      case messages::CertificateManagerPage::kTriggerMetadataUpdate:
            return "Receive reply certificate_manager::mojom::CertificateManagerPage::TriggerMetadataUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertificateManagerPage::AskForImportPassword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x164f8ed8;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPage::AskForImportPassword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPage::AskForConfirmation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c821ad6;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPage::AskForConfirmation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPage::TriggerReload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67a43f8b;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPage::TriggerReload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertificateManagerPage::TriggerMetadataUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x680c31ab;  // IPCStableHash for certificate_manager::mojom::CertificateManagerPage::TriggerMetadataUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CertificateManagerPage_AskForImportPassword_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPage_AskForImportPassword_ForwardToCallback(
      CertificateManagerPage::AskForImportPasswordCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPage_AskForImportPassword_ForwardToCallback(const CertificateManagerPage_AskForImportPassword_ForwardToCallback&) = delete;
  CertificateManagerPage_AskForImportPassword_ForwardToCallback& operator=(const CertificateManagerPage_AskForImportPassword_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPage::AskForImportPasswordCallback callback_;
};

class CertificateManagerPage_AskForConfirmation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertificateManagerPage_AskForConfirmation_ForwardToCallback(
      CertificateManagerPage::AskForConfirmationCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertificateManagerPage_AskForConfirmation_ForwardToCallback(const CertificateManagerPage_AskForConfirmation_ForwardToCallback&) = delete;
  CertificateManagerPage_AskForConfirmation_ForwardToCallback& operator=(const CertificateManagerPage_AskForConfirmation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertificateManagerPage::AskForConfirmationCallback callback_;
};

CertificateManagerPageProxy::CertificateManagerPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertificateManagerPageProxy::AskForImportPassword(
    AskForImportPasswordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send certificate_manager::mojom::CertificateManagerPage::AskForImportPassword");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kAskForImportPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_AskForImportPassword_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("AskForImportPassword");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPage_AskForImportPassword_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageProxy::AskForConfirmation(
    const std::string& in_title, const std::string& in_message, AskForConfirmationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPage::AskForConfirmation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kAskForConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_AskForConfirmation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in CertificateManagerPage.AskForConfirmation request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in CertificateManagerPage.AskForConfirmation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("AskForConfirmation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertificateManagerPage_AskForConfirmation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertificateManagerPageProxy::TriggerReload(
    const std::vector<CertificateSource>& in_sources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send certificate_manager::mojom::CertificateManagerPage::TriggerReload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sources"), in_sources,
                        "<value of type const std::vector<CertificateSource>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kTriggerReload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_TriggerReload_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sources)::BaseType>
      sources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::certificate_manager::mojom::internal::CertificateSource_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::certificate_manager::mojom::CertificateSource>>(
    in_sources,
    sources_fragment,
    &sources_validate_params);

  params->sources.Set(
      sources_fragment.is_null() ? nullptr : sources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sources in CertificateManagerPage.TriggerReload request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("TriggerReload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertificateManagerPageProxy::TriggerMetadataUpdate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send certificate_manager::mojom::CertificateManagerPage::TriggerMetadataUpdate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kTriggerMetadataUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_TriggerMetadataUpdate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("TriggerMetadataUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CertificateManagerPage_AskForImportPassword_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPage::AskForImportPasswordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPage_AskForImportPassword_ProxyToResponder> proxy(
        new CertificateManagerPage_AskForImportPassword_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPage_AskForImportPassword_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPage_AskForImportPassword_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPage_AskForImportPassword_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPage::AskForImportPasswordCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_password);
};

bool CertificateManagerPage_AskForImportPassword_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPage_AskForImportPassword_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPage_AskForImportPassword_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPage.0
  bool success = true;
  std::optional<std::string> p_password{};
  CertificateManagerPage_AskForImportPassword_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPassword(&p_password))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPage::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_password));
  }
  return true;
}

void CertificateManagerPage_AskForImportPassword_ProxyToResponder::Run(
    const std::optional<std::string>& in_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPage::AskForImportPassword", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kAskForImportPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_AskForImportPassword_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("AskForImportPassword");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CertificateManagerPage_AskForConfirmation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertificateManagerPage::AskForConfirmationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertificateManagerPage_AskForConfirmation_ProxyToResponder> proxy(
        new CertificateManagerPage_AskForConfirmation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertificateManagerPage_AskForConfirmation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertificateManagerPage_AskForConfirmation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertificateManagerPage_AskForConfirmation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertificateManagerPage::AskForConfirmationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_confirmed);
};

bool CertificateManagerPage_AskForConfirmation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertificateManagerPage_AskForConfirmation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertificateManagerPage_AskForConfirmation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertificateManagerPage.1
  bool success = true;
  bool p_confirmed{};
  CertificateManagerPage_AskForConfirmation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_confirmed = input_data_view.confirmed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertificateManagerPage::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_confirmed));
  }
  return true;
}

void CertificateManagerPage_AskForConfirmation_ProxyToResponder::Run(
    bool in_confirmed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply certificate_manager::mojom::CertificateManagerPage::AskForConfirmation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("confirmed"), in_confirmed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertificateManagerPage::kAskForConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::certificate_manager::mojom::internal::CertificateManagerPage_AskForConfirmation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->confirmed = in_confirmed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertificateManagerPage::Name_);
  message.set_method_name("AskForConfirmation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CertificateManagerPageStubDispatch::Accept(
    CertificateManagerPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertificateManagerPage>(message->header()->name)) {
    case messages::CertificateManagerPage::kAskForImportPassword: {
      break;
    }
    case messages::CertificateManagerPage::kAskForConfirmation: {
      break;
    }
    case messages::CertificateManagerPage::kTriggerReload: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPage_TriggerReload_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPage_TriggerReload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPage.2
      bool success = true;
      std::vector<CertificateSource> p_sources{};
      CertificateManagerPage_TriggerReload_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSources(&p_sources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerReload(        
        std::move(p_sources));
      return true;
    }
    case messages::CertificateManagerPage::kTriggerMetadataUpdate: {
      DCHECK(message->is_serialized());
      internal::CertificateManagerPage_TriggerMetadataUpdate_Params_Data* params =
          reinterpret_cast<internal::CertificateManagerPage_TriggerMetadataUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertificateManagerPage.3
      bool success = true;
      CertificateManagerPage_TriggerMetadataUpdate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerMetadataUpdate(        );
      return true;
    }
  }
  return false;
}

// static
bool CertificateManagerPageStubDispatch::AcceptWithResponder(
    CertificateManagerPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertificateManagerPage>(message->header()->name)) {
    case messages::CertificateManagerPage::kAskForImportPassword: {
      internal::CertificateManagerPage_AskForImportPassword_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPage_AskForImportPassword_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPage.0
      bool success = true;
      CertificateManagerPage_AskForImportPassword_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPage::Name_, 0, false);
        return false;
      }
      auto callback =
          CertificateManagerPage_AskForImportPassword_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AskForImportPassword(std::move(callback));
      return true;
    }
    case messages::CertificateManagerPage::kAskForConfirmation: {
      internal::CertificateManagerPage_AskForConfirmation_Params_Data* params =
          reinterpret_cast<
              internal::CertificateManagerPage_AskForConfirmation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertificateManagerPage.1
      bool success = true;
      std::string p_title{};
      std::string p_message{};
      CertificateManagerPage_AskForConfirmation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertificateManagerPage::Name_, 1, false);
        return false;
      }
      auto callback =
          CertificateManagerPage_AskForConfirmation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AskForConfirmation(        
        std::move(p_title), 
        std::move(p_message), std::move(callback));
      return true;
    }
    case messages::CertificateManagerPage::kTriggerReload: {
      break;
    }
    case messages::CertificateManagerPage::kTriggerMetadataUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertificateManagerPageValidationInfo[] = {
    { &internal::CertificateManagerPage_AskForImportPassword_Params_Data::Validate,
     &internal::CertificateManagerPage_AskForImportPassword_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPage_AskForConfirmation_Params_Data::Validate,
     &internal::CertificateManagerPage_AskForConfirmation_ResponseParams_Data::Validate},
    { &internal::CertificateManagerPage_TriggerReload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertificateManagerPage_TriggerMetadataUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertificateManagerPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::certificate_manager::mojom::CertificateManagerPage::Name_,
    kCertificateManagerPageValidationInfo);
}

bool CertificateManagerPageResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::certificate_manager::mojom::CertificateManagerPage::Name_,
    kCertificateManagerPageValidationInfo);
}


}  // certificate_manager::mojom


namespace mojo {


// static
bool StructTraits<::certificate_manager::mojom::SummaryCertInfo::DataView, ::certificate_manager::mojom::SummaryCertInfoPtr>::Read(
    ::certificate_manager::mojom::SummaryCertInfo::DataView input,
    ::certificate_manager::mojom::SummaryCertInfoPtr* output) {
  bool success = true;
  ::certificate_manager::mojom::SummaryCertInfoPtr result(::certificate_manager::mojom::SummaryCertInfo::New());
  
      if (success && !input.ReadSha256hashHex(&result->sha256hash_hex))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success)
        result->is_deletable = input.is_deletable();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::certificate_manager::mojom::CertManagementMetadata::DataView, ::certificate_manager::mojom::CertManagementMetadataPtr>::Read(
    ::certificate_manager::mojom::CertManagementMetadata::DataView input,
    ::certificate_manager::mojom::CertManagementMetadataPtr* output) {
  bool success = true;
  ::certificate_manager::mojom::CertManagementMetadataPtr result(::certificate_manager::mojom::CertManagementMetadata::New());
  
      if (success)
        result->include_system_trust_store = input.include_system_trust_store();
      if (success)
        result->num_user_added_system_certs = input.num_user_added_system_certs();
      if (success)
        result->is_include_system_trust_store_managed = input.is_include_system_trust_store_managed();
      if (success)
        result->num_policy_certs = input.num_policy_certs();
      if (success)
        result->num_user_certs = input.num_user_certs();
      if (success)
        result->show_user_certs_ui = input.show_user_certs_ui();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::certificate_manager::mojom::ActionResult::DataView, ::certificate_manager::mojom::ActionResultPtr>::Read(
    ::certificate_manager::mojom::ActionResult::DataView input,
    ::certificate_manager::mojom::ActionResultPtr* output) {
  using UnionType = ::certificate_manager::mojom::ActionResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kError: {
      std::string result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    case Tag::kSuccess: {
      ::certificate_manager::mojom::SuccessResult result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(result_success);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace certificate_manager::mojom {


void CertificateManagerPageHandlerFactoryInterceptorForTesting::CreateCertificateManagerPageHandler(::mojo::PendingRemote<CertificateManagerPage> page, ::mojo::PendingReceiver<CertificateManagerPageHandler> handler) {
  GetForwardingInterface()->CreateCertificateManagerPageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
CertificateManagerPageHandlerFactoryAsyncWaiter::CertificateManagerPageHandlerFactoryAsyncWaiter(
    CertificateManagerPageHandlerFactory* proxy) : proxy_(proxy) {}

CertificateManagerPageHandlerFactoryAsyncWaiter::~CertificateManagerPageHandlerFactoryAsyncWaiter() = default;





void CertificateManagerPageHandlerInterceptorForTesting::GetCertificates(CertificateSource source, GetCertificatesCallback callback) {
  GetForwardingInterface()->GetCertificates(
    std::move(source)
    , std::move(callback));
}
void CertificateManagerPageHandlerInterceptorForTesting::GetCertManagementMetadata(GetCertManagementMetadataCallback callback) {
  GetForwardingInterface()->GetCertManagementMetadata(std::move(callback));
}
void CertificateManagerPageHandlerInterceptorForTesting::ViewCertificate(CertificateSource source, const std::string& sha256_hash_hex) {
  GetForwardingInterface()->ViewCertificate(
    std::move(source)
    , 
    std::move(sha256_hash_hex)
    );
}
void CertificateManagerPageHandlerInterceptorForTesting::ExportCertificates(CertificateSource source) {
  GetForwardingInterface()->ExportCertificates(
    std::move(source)
    );
}
void CertificateManagerPageHandlerInterceptorForTesting::ImportCertificate(CertificateSource source, ImportCertificateCallback callback) {
  GetForwardingInterface()->ImportCertificate(
    std::move(source)
    , std::move(callback));
}
void CertificateManagerPageHandlerInterceptorForTesting::ImportAndBindCertificate(CertificateSource source, ImportAndBindCertificateCallback callback) {
  GetForwardingInterface()->ImportAndBindCertificate(
    std::move(source)
    , std::move(callback));
}
void CertificateManagerPageHandlerInterceptorForTesting::DeleteCertificate(CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, DeleteCertificateCallback callback) {
  GetForwardingInterface()->DeleteCertificate(
    std::move(source)
    , 
    std::move(display_name)
    , 
    std::move(sha256_hash_hex)
    , std::move(callback));
}
void CertificateManagerPageHandlerInterceptorForTesting::ShowNativeManageCertificates() {
  GetForwardingInterface()->ShowNativeManageCertificates();
}
void CertificateManagerPageHandlerInterceptorForTesting::SetIncludeSystemTrustStore(bool include) {
  GetForwardingInterface()->SetIncludeSystemTrustStore(
    std::move(include)
    );
}
CertificateManagerPageHandlerAsyncWaiter::CertificateManagerPageHandlerAsyncWaiter(
    CertificateManagerPageHandler* proxy) : proxy_(proxy) {}

CertificateManagerPageHandlerAsyncWaiter::~CertificateManagerPageHandlerAsyncWaiter() = default;


void CertificateManagerPageHandlerAsyncWaiter::GetCertificates(
    CertificateSource source, std::vector<SummaryCertInfoPtr>* out_certs) {
  base::RunLoop loop;
  proxy_->GetCertificates(
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<SummaryCertInfoPtr>* out_certs
,
             std::vector<SummaryCertInfoPtr> certs) {*out_certs = std::move(certs);
            loop->Quit();
          },
          &loop,
          out_certs));
  loop.Run();
}

std::vector<SummaryCertInfoPtr> CertificateManagerPageHandlerAsyncWaiter::GetCertificates(
    CertificateSource source) {
  std::vector<SummaryCertInfoPtr> async_wait_result;
  GetCertificates(std::move(source),&async_wait_result);
  return async_wait_result;
}

void CertificateManagerPageHandlerAsyncWaiter::GetCertManagementMetadata(
    CertManagementMetadataPtr* out_metadata) {
  base::RunLoop loop;
  proxy_->GetCertManagementMetadata(
      base::BindOnce(
          [](base::RunLoop* loop,
             CertManagementMetadataPtr* out_metadata
,
             CertManagementMetadataPtr metadata) {*out_metadata = std::move(metadata);
            loop->Quit();
          },
          &loop,
          out_metadata));
  loop.Run();
}

CertManagementMetadataPtr CertificateManagerPageHandlerAsyncWaiter::GetCertManagementMetadata(
    ) {
  CertManagementMetadataPtr async_wait_result;
  GetCertManagementMetadata(&async_wait_result);
  return async_wait_result;
}

void CertificateManagerPageHandlerAsyncWaiter::ImportCertificate(
    CertificateSource source, ActionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ImportCertificate(
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop,
             ActionResultPtr* out_result
,
             ActionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ActionResultPtr CertificateManagerPageHandlerAsyncWaiter::ImportCertificate(
    CertificateSource source) {
  ActionResultPtr async_wait_result;
  ImportCertificate(std::move(source),&async_wait_result);
  return async_wait_result;
}

void CertificateManagerPageHandlerAsyncWaiter::ImportAndBindCertificate(
    CertificateSource source, ActionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ImportAndBindCertificate(
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop,
             ActionResultPtr* out_result
,
             ActionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ActionResultPtr CertificateManagerPageHandlerAsyncWaiter::ImportAndBindCertificate(
    CertificateSource source) {
  ActionResultPtr async_wait_result;
  ImportAndBindCertificate(std::move(source),&async_wait_result);
  return async_wait_result;
}

void CertificateManagerPageHandlerAsyncWaiter::DeleteCertificate(
    CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, ActionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->DeleteCertificate(
      std::move(source),
      std::move(display_name),
      std::move(sha256_hash_hex),
      base::BindOnce(
          [](base::RunLoop* loop,
             ActionResultPtr* out_result
,
             ActionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ActionResultPtr CertificateManagerPageHandlerAsyncWaiter::DeleteCertificate(
    CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex) {
  ActionResultPtr async_wait_result;
  DeleteCertificate(std::move(source),std::move(display_name),std::move(sha256_hash_hex),&async_wait_result);
  return async_wait_result;
}




void CertificateManagerPageInterceptorForTesting::AskForImportPassword(AskForImportPasswordCallback callback) {
  GetForwardingInterface()->AskForImportPassword(std::move(callback));
}
void CertificateManagerPageInterceptorForTesting::AskForConfirmation(const std::string& title, const std::string& message, AskForConfirmationCallback callback) {
  GetForwardingInterface()->AskForConfirmation(
    std::move(title)
    , 
    std::move(message)
    , std::move(callback));
}
void CertificateManagerPageInterceptorForTesting::TriggerReload(const std::vector<CertificateSource>& sources) {
  GetForwardingInterface()->TriggerReload(
    std::move(sources)
    );
}
void CertificateManagerPageInterceptorForTesting::TriggerMetadataUpdate() {
  GetForwardingInterface()->TriggerMetadataUpdate();
}
CertificateManagerPageAsyncWaiter::CertificateManagerPageAsyncWaiter(
    CertificateManagerPage* proxy) : proxy_(proxy) {}

CertificateManagerPageAsyncWaiter::~CertificateManagerPageAsyncWaiter() = default;


void CertificateManagerPageAsyncWaiter::AskForImportPassword(
    std::optional<std::string>* out_password) {
  base::RunLoop loop;
  proxy_->AskForImportPassword(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_password
,
             const std::optional<std::string>& password) {*out_password = std::move(password);
            loop->Quit();
          },
          &loop,
          out_password));
  loop.Run();
}

std::optional<std::string> CertificateManagerPageAsyncWaiter::AskForImportPassword(
    ) {
  std::optional<std::string> async_wait_result;
  AskForImportPassword(&async_wait_result);
  return async_wait_result;
}

void CertificateManagerPageAsyncWaiter::AskForConfirmation(
    const std::string& title, const std::string& message, bool* out_confirmed) {
  base::RunLoop loop;
  proxy_->AskForConfirmation(
      std::move(title),
      std::move(message),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_confirmed
,
             bool confirmed) {*out_confirmed = std::move(confirmed);
            loop->Quit();
          },
          &loop,
          out_confirmed));
  loop.Run();
}

bool CertificateManagerPageAsyncWaiter::AskForConfirmation(
    const std::string& title, const std::string& message) {
  bool async_wait_result;
  AskForConfirmation(std::move(title),std::move(message),&async_wait_result);
  return async_wait_result;
}






}  // certificate_manager::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif