import type { BookmarkNode, BookmarksPageState, NodeMap, ObjectMap } from './types.js';
/**
 * @fileoverview Utility functions for the Bookmarks page.
 */
export declare function getDisplayedList(state: BookmarksPageState): string[];
export declare function normalizeNode(treeNode: chrome.bookmarks.BookmarkTreeNode): BookmarkNode;
export declare function normalizeNodes(rootNode: chrome.bookmarks.BookmarkTreeNode): NodeMap;
export declare function createEmptyState(): BookmarksPageState;
export declare function isShowingSearch(state: BookmarksPageState): boolean;
/**
 * Returns true if the node with ID |itemId| is modifiable, allowing
 * the node to be renamed, moved or deleted. Note that if a node is
 * uneditable, it may still have editable children (for example, the top-level
 * folders).
 */
export declare function canEditNode(state: BookmarksPageState, itemId: string): boolean;
/**
 * Returns true if it is possible to modify the children list of the node with
 * ID |itemId|. This includes rearranging the children or adding new ones.
 */
export declare function canReorderChildren(state: BookmarksPageState, itemId: string): boolean;
export declare function hasChildFolders(id: string, nodes: NodeMap): boolean;
export declare function getDescendants(nodes: NodeMap, baseId: string): Set<string>;
export declare function removeIdsFromObject<Type>(map: ObjectMap<Type>, ids: Set<string>): ObjectMap<Type>;
export declare function removeIdsFromMap<Type>(map: Map<string, Type>, ids: Set<string>): Map<string, Type>;
export declare function removeIdsFromSet(set: Set<string>, ids: Set<string>): Set<string>;
export declare function isRootNode(itemId: string): boolean;
/**
 * Whether the node with ID `itemId` satisfies `isRootNode()`, or its parent
 * satisfies `isRootNode()`.
 */
export declare function isRootOrChildOfRoot(state: BookmarksPageState, itemId: string): boolean;
