import type { StoreObserver } from 'chrome://resources/js/store.js';
import type { BookmarksPageState } from './types.js';
/**
 * This element is a one way bound interface that routes the page URL to
 * the searchTerm and selectedId. Clients must initialize themselves by
 * reading the router's fields after attach.
 */
export declare class BookmarksRouter implements StoreObserver<BookmarksPageState> {
    private searchTerm_;
    private selectedId_;
    private defaultId_;
    private updateStateTimeout_;
    private tracker_;
    initialize(): void;
    teardown(): void;
    private onQueryParamsChanged_;
    onStateChanged(state: BookmarksPageState): void;
    private updateQueryParams_;
}
