/**
 * A list that displays DescriptorListItems.
 */
export class DescriptorListElement extends ExpandableListElement {
    /** @private {?string} */
    private deviceAddress_;
    /** @private {?string} */
    private serviceId_;
    /** @private {?string} */
    private characteristicId_;
    /** @private {boolean} */
    private descriptorsRequested_;
    createItem(data: any): HTMLElement;
    /**
     * Loads the descriptor list with an array of DescriptorInfo from
     * the device with |deviceAddress|, service with |serviceId|, and
     * characteristic with |characteristicId|. If no active connection to the
     * device exists, one is created.
     * @param {string} deviceAddress
     * @param {string} serviceId
     * @param {string} characteristicId
     */
    load(deviceAddress: string, serviceId: string, characteristicId: string): void;
}
import { ExpandableListElement } from './expandable_list.js';
