/**
 * Page that allows user to enable/disable debug logs.
 */
export class DebugLogPage extends Page {
    /**
     * @param {!BluetoothInternalsHandlerRemote} bluetoothInternalsHandler
     */
    constructor(bluetoothInternalsHandler: BluetoothInternalsHandlerRemote);
    /**
     * @private {?DebugLogsChangeHandlerRemote}
     */
    private debugLogsChangeHandler_;
    /** @private {?HTMLInputElement} */
    private inputElement_;
    /** @private {!HTMLDivElement} */
    private debugContainer_;
    bluetoothInternalsHandler_: BluetoothInternalsHandlerRemote;
    btsnoopInterface_: import("./bluetooth_internals.mojom-webui.js").BluetoothBtsnoopRemote | null;
    /**
     * @param {!DebugLogsChangeHandlerRemote} handler
     * @param {boolean} initialInputValue
     */
    setUpInput(handler: DebugLogsChangeHandlerRemote, initialInputValue: boolean): void;
    setUpBtmonButton(): void;
    setBtmonButtonText(text: any): void;
    setBtmonStatusText(text: any): void;
    onToggleChange(): void;
    onStartBtsnoopClick(): void;
    onStartBtsnoop(): Promise<void>;
    onStopBtsnoop(): Promise<void>;
    prepareBtsnoopTemplate(): Promise<void>;
}
import { Page } from './page.js';
import { BluetoothInternalsHandlerRemote } from './bluetooth_internals.mojom-webui.js';
import { DebugLogsChangeHandlerRemote } from './bluetooth_internals.mojom-webui.js';
