export class CharacteristicListElement extends ExpandableListElement {
    /** @private {?string} */
    private deviceAddress_;
    /** @private {?string} */
    private serviceId_;
    /** @private {boolean} */
    private characteristicsRequested_;
    createItem(data: any): HTMLElement;
    /**
     * Loads the characteristic list with an array of CharacteristicInfo from
     * the device with |deviceAddress| and service with |serviceId|. If no
     * active connection to the device exists, one is created.
     * @param {string} deviceAddress
     * @param {string} serviceId
     */
    load(deviceAddress: string, serviceId: string): void;
}
import { ExpandableListElement } from './expandable_list.js';
