// chrome/browser/new_tab_page/modules/v2/calendar/calendar_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_CALENDAR_CALENDAR_DATA_MOJOM_H_
#define CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_CALENDAR_CALENDAR_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/new_tab_page/modules/v2/calendar/calendar_data.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/v2/calendar/calendar_data.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/new_tab_page/modules/v2/calendar/calendar_data.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace ntp::calendar::mojom {









class  Attachment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Attachment, T>::value>;
  using DataView = AttachmentDataView;
  using Data_ = internal::Attachment_Data;

  template <typename... Args>
  static AttachmentPtr New(Args&&... args) {
    return AttachmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttachmentPtr From(const U& u) {
    return mojo::TypeConverter<AttachmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Attachment>::Convert(*this);
  }


  Attachment();

  Attachment(
      const std::string& title,
      const std::optional<::GURL>& resource_url,
      const ::GURL& icon_url);


  ~Attachment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttachmentPtr>
  AttachmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Attachment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Attachment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Attachment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Attachment::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Attachment::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Attachment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Attachment_UnserializedMessageContext<
            UserType, Attachment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Attachment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Attachment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Attachment_UnserializedMessageContext<
            UserType, Attachment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Attachment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  std::optional<::GURL> resource_url;
  
  ::GURL icon_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Attachment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Attachment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Attachment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Attachment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CalendarEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CalendarEvent, T>::value>;
  using DataView = CalendarEventDataView;
  using Data_ = internal::CalendarEvent_Data;

  template <typename... Args>
  static CalendarEventPtr New(Args&&... args) {
    return CalendarEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CalendarEventPtr From(const U& u) {
    return mojo::TypeConverter<CalendarEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CalendarEvent>::Convert(*this);
  }


  CalendarEvent();

  CalendarEvent(
      const std::string& title,
      ::base::Time start_time,
      ::base::Time end_time,
      const ::GURL& url,
      const std::optional<std::string>& location,
      std::vector<AttachmentPtr> attachments,
      const std::optional<::GURL>& conference_url,
      bool is_accepted,
      bool has_other_attendee);

CalendarEvent(const CalendarEvent&) = delete;
CalendarEvent& operator=(const CalendarEvent&) = delete;

  ~CalendarEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CalendarEventPtr>
  CalendarEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CalendarEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CalendarEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CalendarEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CalendarEvent_UnserializedMessageContext<
            UserType, CalendarEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CalendarEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CalendarEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CalendarEvent_UnserializedMessageContext<
            UserType, CalendarEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CalendarEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::base::Time start_time;
  
  ::base::Time end_time;
  
  ::GURL url;
  
  std::optional<std::string> location;
  
  std::vector<AttachmentPtr> attachments;
  
  std::optional<::GURL> conference_url;
  
  bool is_accepted;
  
  bool has_other_attendee;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CalendarEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AttachmentPtr Attachment::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(resource_url),
      mojo::Clone(icon_url)
  );
}

template <typename T, Attachment::EnableIfSame<T>*>
bool Attachment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->resource_url, other_struct.resource_url))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  return true;
}

template <typename T, Attachment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.resource_url < rhs.resource_url)
    return true;
  if (rhs.resource_url < lhs.resource_url)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  return false;
}
template <typename StructPtrType>
CalendarEventPtr CalendarEvent::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(start_time),
      mojo::Clone(end_time),
      mojo::Clone(url),
      mojo::Clone(location),
      mojo::Clone(attachments),
      mojo::Clone(conference_url),
      mojo::Clone(is_accepted),
      mojo::Clone(has_other_attendee)
  );
}

template <typename T, CalendarEvent::EnableIfSame<T>*>
bool CalendarEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->end_time, other_struct.end_time))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->attachments, other_struct.attachments))
    return false;
  if (!mojo::Equals(this->conference_url, other_struct.conference_url))
    return false;
  if (!mojo::Equals(this->is_accepted, other_struct.is_accepted))
    return false;
  if (!mojo::Equals(this->has_other_attendee, other_struct.has_other_attendee))
    return false;
  return true;
}

template <typename T, CalendarEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.end_time < rhs.end_time)
    return true;
  if (rhs.end_time < lhs.end_time)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.attachments < rhs.attachments)
    return true;
  if (rhs.attachments < lhs.attachments)
    return false;
  if (lhs.conference_url < rhs.conference_url)
    return true;
  if (rhs.conference_url < lhs.conference_url)
    return false;
  if (lhs.is_accepted < rhs.is_accepted)
    return true;
  if (rhs.is_accepted < lhs.is_accepted)
    return false;
  if (lhs.has_other_attendee < rhs.has_other_attendee)
    return true;
  if (rhs.has_other_attendee < lhs.has_other_attendee)
    return false;
  return false;
}


}  // ntp::calendar::mojom

namespace mojo {


template <>
struct  StructTraits<::ntp::calendar::mojom::Attachment::DataView,
                                         ::ntp::calendar::mojom::AttachmentPtr> {
  static bool IsNull(const ::ntp::calendar::mojom::AttachmentPtr& input) { return !input; }
  static void SetToNull(::ntp::calendar::mojom::AttachmentPtr* output) { output->reset(); }

  static const decltype(::ntp::calendar::mojom::Attachment::title)& title(
      const ::ntp::calendar::mojom::AttachmentPtr& input) {
    return input->title;
  }

  static const decltype(::ntp::calendar::mojom::Attachment::resource_url)& resource_url(
      const ::ntp::calendar::mojom::AttachmentPtr& input) {
    return input->resource_url;
  }

  static const decltype(::ntp::calendar::mojom::Attachment::icon_url)& icon_url(
      const ::ntp::calendar::mojom::AttachmentPtr& input) {
    return input->icon_url;
  }

  static bool Read(::ntp::calendar::mojom::Attachment::DataView input, ::ntp::calendar::mojom::AttachmentPtr* output);
};


template <>
struct  StructTraits<::ntp::calendar::mojom::CalendarEvent::DataView,
                                         ::ntp::calendar::mojom::CalendarEventPtr> {
  static bool IsNull(const ::ntp::calendar::mojom::CalendarEventPtr& input) { return !input; }
  static void SetToNull(::ntp::calendar::mojom::CalendarEventPtr* output) { output->reset(); }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::title)& title(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->title;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::start_time)& start_time(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->start_time;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::end_time)& end_time(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->end_time;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::url)& url(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->url;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::location)& location(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->location;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::attachments)& attachments(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->attachments;
  }

  static const decltype(::ntp::calendar::mojom::CalendarEvent::conference_url)& conference_url(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->conference_url;
  }

  static decltype(::ntp::calendar::mojom::CalendarEvent::is_accepted) is_accepted(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->is_accepted;
  }

  static decltype(::ntp::calendar::mojom::CalendarEvent::has_other_attendee) has_other_attendee(
      const ::ntp::calendar::mojom::CalendarEventPtr& input) {
    return input->has_other_attendee;
  }

  static bool Read(::ntp::calendar::mojom::CalendarEvent::DataView input, ::ntp::calendar::mojom::CalendarEventPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_NEW_TAB_PAGE_MODULES_V2_CALENDAR_CALENDAR_DATA_MOJOM_H_