// chrome/browser/media/media_engagement_score_details.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/media/media_engagement_score_details.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/media/media_engagement_score_details.mojom-params-data.h"
#include "chrome/browser/media/media_engagement_score_details.mojom-shared-message-ids.h"

#include "chrome/browser/media/media_engagement_score_details.mojom-import-headers.h"
#include "chrome/browser/media/media_engagement_score_details.mojom-test-utils.h"


namespace media::mojom {
MediaEngagementScoreDetails::MediaEngagementScoreDetails()
    : origin(),
      total_score(),
      visits(),
      media_playbacks(),
      last_media_playback_time(),
      is_high() {}

MediaEngagementScoreDetails::MediaEngagementScoreDetails(
    const ::url::Origin& origin_in,
    double total_score_in,
    int32_t visits_in,
    int32_t media_playbacks_in,
    double last_media_playback_time_in,
    bool is_high_in)
    : origin(std::move(origin_in)),
      total_score(std::move(total_score_in)),
      visits(std::move(visits_in)),
      media_playbacks(std::move(media_playbacks_in)),
      last_media_playback_time(std::move(last_media_playback_time_in)),
      is_high(std::move(is_high_in)) {}

MediaEngagementScoreDetails::~MediaEngagementScoreDetails() = default;

void MediaEngagementScoreDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_score"), this->total_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visits"), this->visits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_playbacks"), this->media_playbacks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_media_playback_time"), this->last_media_playback_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_high"), this->is_high,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaEngagementScoreDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaEngagementConfig::MediaEngagementConfig()
    : score_min_visits(),
      high_score_lower_threshold(),
      high_score_upper_threshold(),
      feature_record_data(),
      feature_bypass_autoplay(),
      feature_preload_data(),
      feature_https_only(),
      feature_autoplay_disable_settings(),
      pref_disable_unified_autoplay(),
      has_custom_autoplay_policy(),
      autoplay_policy(),
      preload_version() {}

MediaEngagementConfig::MediaEngagementConfig(
    int32_t score_min_visits_in,
    double high_score_lower_threshold_in,
    double high_score_upper_threshold_in,
    bool feature_record_data_in,
    bool feature_bypass_autoplay_in,
    bool feature_preload_data_in,
    bool feature_https_only_in,
    bool feature_autoplay_disable_settings_in,
    bool pref_disable_unified_autoplay_in,
    bool has_custom_autoplay_policy_in,
    const std::string& autoplay_policy_in,
    const std::string& preload_version_in)
    : score_min_visits(std::move(score_min_visits_in)),
      high_score_lower_threshold(std::move(high_score_lower_threshold_in)),
      high_score_upper_threshold(std::move(high_score_upper_threshold_in)),
      feature_record_data(std::move(feature_record_data_in)),
      feature_bypass_autoplay(std::move(feature_bypass_autoplay_in)),
      feature_preload_data(std::move(feature_preload_data_in)),
      feature_https_only(std::move(feature_https_only_in)),
      feature_autoplay_disable_settings(std::move(feature_autoplay_disable_settings_in)),
      pref_disable_unified_autoplay(std::move(pref_disable_unified_autoplay_in)),
      has_custom_autoplay_policy(std::move(has_custom_autoplay_policy_in)),
      autoplay_policy(std::move(autoplay_policy_in)),
      preload_version(std::move(preload_version_in)) {}

MediaEngagementConfig::~MediaEngagementConfig() = default;
size_t MediaEngagementConfig::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->score_min_visits);
  seed = mojo::internal::Hash(seed, this->high_score_lower_threshold);
  seed = mojo::internal::Hash(seed, this->high_score_upper_threshold);
  seed = mojo::internal::Hash(seed, this->feature_record_data);
  seed = mojo::internal::Hash(seed, this->feature_bypass_autoplay);
  seed = mojo::internal::Hash(seed, this->feature_preload_data);
  seed = mojo::internal::Hash(seed, this->feature_https_only);
  seed = mojo::internal::Hash(seed, this->feature_autoplay_disable_settings);
  seed = mojo::internal::Hash(seed, this->pref_disable_unified_autoplay);
  seed = mojo::internal::Hash(seed, this->has_custom_autoplay_policy);
  seed = mojo::internal::Hash(seed, this->autoplay_policy);
  seed = mojo::internal::Hash(seed, this->preload_version);
  return seed;
}

void MediaEngagementConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "score_min_visits"), this->score_min_visits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "high_score_lower_threshold"), this->high_score_lower_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "high_score_upper_threshold"), this->high_score_upper_threshold,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_record_data"), this->feature_record_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_bypass_autoplay"), this->feature_bypass_autoplay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_preload_data"), this->feature_preload_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_https_only"), this->feature_https_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_autoplay_disable_settings"), this->feature_autoplay_disable_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pref_disable_unified_autoplay"), this->pref_disable_unified_autoplay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_custom_autoplay_policy"), this->has_custom_autoplay_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "autoplay_policy"), this->autoplay_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preload_version"), this->preload_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaEngagementConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MediaEngagementScoreDetailsProvider::IPCStableHashFunction MediaEngagementScoreDetailsProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaEngagementScoreDetailsProvider>(message.name())) {
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails: {
      return &MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails_Sym::IPCStableHash;
    }
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig: {
      return &MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaEngagementScoreDetailsProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaEngagementScoreDetailsProvider>(message.name())) {
      case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails:
            return "Receive media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails";
      case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig:
            return "Receive media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig";
    }
  } else {
    switch (static_cast<messages::MediaEngagementScoreDetailsProvider>(message.name())) {
      case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails:
            return "Receive reply media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails";
      case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig:
            return "Receive reply media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4df91946;  // IPCStableHash for media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc8e348d;  // IPCStableHash for media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback(
      MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback(const MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback&) = delete;
  MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback& operator=(const MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetailsCallback callback_;
};

class MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback(
      MediaEngagementScoreDetailsProvider::GetMediaEngagementConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback(const MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback&) = delete;
  MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback& operator=(const MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaEngagementScoreDetailsProvider::GetMediaEngagementConfigCallback callback_;
};

MediaEngagementScoreDetailsProviderProxy::MediaEngagementScoreDetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaEngagementScoreDetailsProviderProxy::GetMediaEngagementScoreDetails(
    GetMediaEngagementScoreDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaEngagementScoreDetailsProvider::Name_);
  message.set_method_name("GetMediaEngagementScoreDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaEngagementScoreDetailsProviderProxy::GetMediaEngagementConfig(
    GetMediaEngagementConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaEngagementScoreDetailsProvider::Name_);
  message.set_method_name("GetMediaEngagementConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder> proxy(
        new MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<MediaEngagementScoreDetailsPtr> in_info);
};

bool MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaEngagementScoreDetailsProvider.0
  bool success = true;
  std::vector<MediaEngagementScoreDetailsPtr> p_info{};
  MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaEngagementScoreDetailsProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder::Run(
    std::vector<MediaEngagementScoreDetailsPtr> in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementScoreDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type std::vector<MediaEngagementScoreDetailsPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType>
      info_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MediaEngagementScoreDetailsDataView>>(
    in_info,
    info_fragment,
    &info_validate_params);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaEngagementScoreDetailsProvider::Name_);
  message.set_method_name("GetMediaEngagementScoreDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaEngagementScoreDetailsProvider::GetMediaEngagementConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder> proxy(
        new MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaEngagementScoreDetailsProvider::GetMediaEngagementConfigCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaEngagementConfigPtr in_config);
};

bool MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaEngagementScoreDetailsProvider.1
  bool success = true;
  MediaEngagementConfigPtr p_config{};
  MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfig(&p_config))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaEngagementScoreDetailsProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_config));
  }
  return true;
}

void MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder::Run(
    MediaEngagementConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::MediaEngagementScoreDetailsProvider::GetMediaEngagementConfig", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type MediaEngagementConfigPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::MediaEngagementConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaEngagementScoreDetailsProvider::Name_);
  message.set_method_name("GetMediaEngagementConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaEngagementScoreDetailsProviderStubDispatch::Accept(
    MediaEngagementScoreDetailsProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaEngagementScoreDetailsProvider>(message->header()->name)) {
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails: {
      break;
    }
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig: {
      break;
    }
  }
  return false;
}

// static
bool MediaEngagementScoreDetailsProviderStubDispatch::AcceptWithResponder(
    MediaEngagementScoreDetailsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaEngagementScoreDetailsProvider>(message->header()->name)) {
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementScoreDetails: {
      internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params_Data* params =
          reinterpret_cast<
              internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaEngagementScoreDetailsProvider.0
      bool success = true;
      MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaEngagementScoreDetailsProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaEngagementScoreDetails(std::move(callback));
      return true;
    }
    case messages::MediaEngagementScoreDetailsProvider::kGetMediaEngagementConfig: {
      internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params_Data* params =
          reinterpret_cast<
              internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaEngagementScoreDetailsProvider.1
      bool success = true;
      MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaEngagementScoreDetailsProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaEngagementConfig(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaEngagementScoreDetailsProviderValidationInfo[] = {
    { &internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_Params_Data::Validate,
     &internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementScoreDetails_ResponseParams_Data::Validate},
    { &internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_Params_Data::Validate,
     &internal::MediaEngagementScoreDetailsProvider_GetMediaEngagementConfig_ResponseParams_Data::Validate},
};

bool MediaEngagementScoreDetailsProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaEngagementScoreDetailsProvider::Name_,
    kMediaEngagementScoreDetailsProviderValidationInfo);
}

bool MediaEngagementScoreDetailsProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::MediaEngagementScoreDetailsProvider::Name_,
    kMediaEngagementScoreDetailsProviderValidationInfo);
}


}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::MediaEngagementScoreDetails::DataView, ::media::mojom::MediaEngagementScoreDetailsPtr>::Read(
    ::media::mojom::MediaEngagementScoreDetails::DataView input,
    ::media::mojom::MediaEngagementScoreDetailsPtr* output) {
  bool success = true;
  ::media::mojom::MediaEngagementScoreDetailsPtr result(::media::mojom::MediaEngagementScoreDetails::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->total_score = input.total_score();
      if (success)
        result->visits = input.visits();
      if (success)
        result->media_playbacks = input.media_playbacks();
      if (success)
        result->last_media_playback_time = input.last_media_playback_time();
      if (success)
        result->is_high = input.is_high();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::MediaEngagementConfig::DataView, ::media::mojom::MediaEngagementConfigPtr>::Read(
    ::media::mojom::MediaEngagementConfig::DataView input,
    ::media::mojom::MediaEngagementConfigPtr* output) {
  bool success = true;
  ::media::mojom::MediaEngagementConfigPtr result(::media::mojom::MediaEngagementConfig::New());
  
      if (success)
        result->score_min_visits = input.score_min_visits();
      if (success)
        result->high_score_lower_threshold = input.high_score_lower_threshold();
      if (success)
        result->high_score_upper_threshold = input.high_score_upper_threshold();
      if (success)
        result->feature_record_data = input.feature_record_data();
      if (success)
        result->feature_bypass_autoplay = input.feature_bypass_autoplay();
      if (success)
        result->feature_preload_data = input.feature_preload_data();
      if (success)
        result->feature_https_only = input.feature_https_only();
      if (success)
        result->feature_autoplay_disable_settings = input.feature_autoplay_disable_settings();
      if (success)
        result->pref_disable_unified_autoplay = input.pref_disable_unified_autoplay();
      if (success)
        result->has_custom_autoplay_policy = input.has_custom_autoplay_policy();
      if (success && !input.ReadAutoplayPolicy(&result->autoplay_policy))
        success = false;
      if (success && !input.ReadPreloadVersion(&result->preload_version))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void MediaEngagementScoreDetailsProviderInterceptorForTesting::GetMediaEngagementScoreDetails(GetMediaEngagementScoreDetailsCallback callback) {
  GetForwardingInterface()->GetMediaEngagementScoreDetails(std::move(callback));
}
void MediaEngagementScoreDetailsProviderInterceptorForTesting::GetMediaEngagementConfig(GetMediaEngagementConfigCallback callback) {
  GetForwardingInterface()->GetMediaEngagementConfig(std::move(callback));
}
MediaEngagementScoreDetailsProviderAsyncWaiter::MediaEngagementScoreDetailsProviderAsyncWaiter(
    MediaEngagementScoreDetailsProvider* proxy) : proxy_(proxy) {}

MediaEngagementScoreDetailsProviderAsyncWaiter::~MediaEngagementScoreDetailsProviderAsyncWaiter() = default;


void MediaEngagementScoreDetailsProviderAsyncWaiter::GetMediaEngagementScoreDetails(
    std::vector<MediaEngagementScoreDetailsPtr>* out_info) {
  base::RunLoop loop;
  proxy_->GetMediaEngagementScoreDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<MediaEngagementScoreDetailsPtr>* out_info
,
             std::vector<MediaEngagementScoreDetailsPtr> info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

std::vector<MediaEngagementScoreDetailsPtr> MediaEngagementScoreDetailsProviderAsyncWaiter::GetMediaEngagementScoreDetails(
    ) {
  std::vector<MediaEngagementScoreDetailsPtr> async_wait_result;
  GetMediaEngagementScoreDetails(&async_wait_result);
  return async_wait_result;
}

void MediaEngagementScoreDetailsProviderAsyncWaiter::GetMediaEngagementConfig(
    MediaEngagementConfigPtr* out_config) {
  base::RunLoop loop;
  proxy_->GetMediaEngagementConfig(
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaEngagementConfigPtr* out_config
,
             MediaEngagementConfigPtr config) {*out_config = std::move(config);
            loop->Quit();
          },
          &loop,
          out_config));
  loop.Run();
}

MediaEngagementConfigPtr MediaEngagementScoreDetailsProviderAsyncWaiter::GetMediaEngagementConfig(
    ) {
  MediaEngagementConfigPtr async_wait_result;
  GetMediaEngagementConfig(&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif