// chrome/browser/media/media_engagement_score_details.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/media/media_engagement_score_details.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"

#include "chrome/browser/media/media_engagement_score_details.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::MediaEngagementScoreDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::MediaEngagementScoreDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::MediaEngagementScoreDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in MediaEngagementScoreDetails struct");

      fragment->total_score = Traits::total_score(input);

      fragment->visits = Traits::visits(input);

      fragment->media_playbacks = Traits::media_playbacks(input);

      fragment->last_media_playback_time = Traits::last_media_playback_time(input);

      fragment->is_high = Traits::is_high(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::MediaEngagementConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::MediaEngagementConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::MediaEngagementConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->score_min_visits = Traits::score_min_visits(input);

      fragment->high_score_lower_threshold = Traits::high_score_lower_threshold(input);

      fragment->high_score_upper_threshold = Traits::high_score_upper_threshold(input);

      fragment->feature_record_data = Traits::feature_record_data(input);

      fragment->feature_bypass_autoplay = Traits::feature_bypass_autoplay(input);

      fragment->feature_preload_data = Traits::feature_preload_data(input);

      fragment->feature_https_only = Traits::feature_https_only(input);

      fragment->feature_autoplay_disable_settings = Traits::feature_autoplay_disable_settings(input);

      fragment->pref_disable_unified_autoplay = Traits::pref_disable_unified_autoplay(input);

      fragment->has_custom_autoplay_policy = Traits::has_custom_autoplay_policy(input);

      decltype(Traits::autoplay_policy(input)) in_autoplay_policy = Traits::autoplay_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->autoplay_policy)::BaseType> autoplay_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_autoplay_policy,
        autoplay_policy_fragment);

      fragment->autoplay_policy.Set(
          autoplay_policy_fragment.is_null() ? nullptr : autoplay_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->autoplay_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null autoplay_policy in MediaEngagementConfig struct");

      decltype(Traits::preload_version(input)) in_preload_version = Traits::preload_version(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->preload_version)::BaseType> preload_version_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_preload_version,
        preload_version_fragment);

      fragment->preload_version.Set(
          preload_version_fragment.is_null() ? nullptr : preload_version_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->preload_version.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null preload_version in MediaEngagementConfig struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_MEDIA_MEDIA_ENGAGEMENT_SCORE_DETAILS_MOJOM_SEND_VALIDATION_H_