// chrome/browser/lens/core/mojom/text.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/lens/core/mojom/text.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"


namespace lens::mojom {
class TextDataView;

class TextLayoutDataView;

class WordDataView;

class LineDataView;

class BackgroundImageDataDataView;

class TranslatedLineDataView;

class TranslatedParagraphDataView;

class ParagraphDataView;

class FormulaMetadataDataView;



}  // lens::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::lens::mojom::TextDataView> {
  using Data = ::lens::mojom::internal::Text_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::TextLayoutDataView> {
  using Data = ::lens::mojom::internal::TextLayout_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::WordDataView> {
  using Data = ::lens::mojom::internal::Word_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::LineDataView> {
  using Data = ::lens::mojom::internal::Line_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::BackgroundImageDataDataView> {
  using Data = ::lens::mojom::internal::BackgroundImageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::TranslatedLineDataView> {
  using Data = ::lens::mojom::internal::TranslatedLine_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::TranslatedParagraphDataView> {
  using Data = ::lens::mojom::internal::TranslatedParagraph_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::ParagraphDataView> {
  using Data = ::lens::mojom::internal::Paragraph_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::FormulaMetadataDataView> {
  using Data = ::lens::mojom::internal::FormulaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace lens::mojom {


enum class WritingDirection : int32_t {
  
  kLeftToRight = 0,
  
  kRightToLeft = 1,
  
  kTopToBottom = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, WritingDirection value);
inline bool IsKnownEnumValue(WritingDirection value) {
  return internal::WritingDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Alignment : int32_t {
  
  kDefaultLeftAlgined = 0,
  
  kRightAligned = 1,
  
  kCenterAligned = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Alignment value);
inline bool IsKnownEnumValue(Alignment value) {
  return internal::Alignment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TextDataView {
 public:
  TextDataView() = default;

  TextDataView(
      internal::Text_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextLayoutDataView(
      TextLayoutDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextLayout(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::TextLayoutDataView, UserType>(),
    "Attempting to read the optional `text_layout` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTextLayout` instead "
    "of `ReadTextLayout if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text_layout.Get();
    return mojo::internal::Deserialize<::lens::mojom::TextLayoutDataView>(
        pointer, output, message_);
  }
  inline void GetContentLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentLanguage` instead "
    "of `ReadContentLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Text_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextLayoutDataView {
 public:
  TextLayoutDataView() = default;

  TextLayoutDataView(
      internal::TextLayout_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParagraphsDataView(
      mojo::ArrayDataView<ParagraphDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParagraphs(UserType* output) {
    
    auto* pointer = data_->paragraphs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::ParagraphDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TextLayout_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WordDataView {
 public:
  WordDataView() = default;

  WordDataView(
      internal::Word_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlainTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlainText(UserType* output) {
    
    auto* pointer = data_->plain_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextSeparatorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextSeparator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `text_separator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTextSeparator` instead "
    "of `ReadTextSeparator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text_separator.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGeometryDataView(
      ::lens::mojom::GeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::GeometryDataView, UserType>(),
    "Attempting to read the optional `geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeometry` instead "
    "of `ReadGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::lens::mojom::GeometryDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWritingDirection(UserType* output) const {
    if (!data_->writing_direction_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::lens::mojom::WritingDirection>(
        data_->writing_direction_$value, &output->emplace());
  }
  std::optional<WritingDirection> writing_direction() const {
    if (!data_->writing_direction_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::WritingDirection>(data_->writing_direction_$value));
  }
  inline void GetFormulaMetadataDataView(
      FormulaMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormulaMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::FormulaMetadataDataView, UserType>(),
    "Attempting to read the optional `formula_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormulaMetadata` instead "
    "of `ReadFormulaMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->formula_metadata.Get();
    return mojo::internal::Deserialize<::lens::mojom::FormulaMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::Word_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LineDataView {
 public:
  LineDataView() = default;

  LineDataView(
      internal::Line_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordsDataView(
      mojo::ArrayDataView<WordDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWords(UserType* output) {
    
    auto* pointer = data_->words.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::WordDataView>>(
        pointer, output, message_);
  }
  inline void GetGeometryDataView(
      ::lens::mojom::GeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::GeometryDataView, UserType>(),
    "Attempting to read the optional `geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeometry` instead "
    "of `ReadGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::lens::mojom::GeometryDataView>(
        pointer, output, message_);
  }
 private:
  internal::Line_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BackgroundImageDataDataView {
 public:
  BackgroundImageDataDataView() = default;

  BackgroundImageDataDataView(
      internal::BackgroundImageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBackgroundImageDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImage(UserType* output) {
    
    auto* pointer = !data_->background_image.is_null() ? &data_->background_image : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  inline void GetImageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageSize(UserType* output) {
    
    auto* pointer = data_->image_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float vertical_padding() const {
    return data_->vertical_padding;
  }
  float horizontal_padding() const {
    return data_->horizontal_padding;
  }
  inline void GetTextMaskDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextMask(UserType* output) {
    
    auto* pointer = !data_->text_mask.is_null() ? &data_->text_mask : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BackgroundImageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TranslatedLineDataView {
 public:
  TranslatedLineDataView() = default;

  TranslatedLineDataView(
      internal::TranslatedLine_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordsDataView(
      mojo::ArrayDataView<WordDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWords(UserType* output) {
    
    auto* pointer = data_->words.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::WordDataView>>(
        pointer, output, message_);
  }
  inline void GetTranslationDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslation(UserType* output) {
    
    auto* pointer = data_->translation.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextColor(UserType* output) {
    
    auto* pointer = data_->text_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundPrimaryColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundPrimaryColor(UserType* output) {
    
    auto* pointer = data_->background_primary_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundImageDataDataView(
      BackgroundImageDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundImageData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::BackgroundImageDataDataView, UserType>(),
    "Attempting to read the optional `background_image_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackgroundImageData` instead "
    "of `ReadBackgroundImageData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->background_image_data.Get();
    return mojo::internal::Deserialize<::lens::mojom::BackgroundImageDataDataView>(
        pointer, output, message_);
  }
  inline void GetGeometryDataView(
      ::lens::mojom::GeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::GeometryDataView, UserType>(),
    "Attempting to read the optional `geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeometry` instead "
    "of `ReadGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::lens::mojom::GeometryDataView>(
        pointer, output, message_);
  }
 private:
  internal::TranslatedLine_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TranslatedParagraphDataView {
 public:
  TranslatedParagraphDataView() = default;

  TranslatedParagraphDataView(
      internal::TranslatedParagraph_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLinesDataView(
      mojo::ArrayDataView<TranslatedLineDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLines(UserType* output) {
    
    auto* pointer = data_->lines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::TranslatedLineDataView>>(
        pointer, output, message_);
  }
  inline void GetResizedBitmapSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResizedBitmapSize(UserType* output) {
    
    auto* pointer = data_->resized_bitmap_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlignment(UserType* output) const {
    if (!data_->alignment_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::lens::mojom::Alignment>(
        data_->alignment_$value, &output->emplace());
  }
  std::optional<Alignment> alignment() const {
    if (!data_->alignment_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::Alignment>(data_->alignment_$value));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWritingDirection(UserType* output) const {
    if (!data_->writing_direction_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::lens::mojom::WritingDirection>(
        data_->writing_direction_$value, &output->emplace());
  }
  std::optional<WritingDirection> writing_direction() const {
    if (!data_->writing_direction_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::WritingDirection>(data_->writing_direction_$value));
  }
  inline void GetContentLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentLanguage` instead "
    "of `ReadContentLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TranslatedParagraph_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParagraphDataView {
 public:
  ParagraphDataView() = default;

  ParagraphDataView(
      internal::Paragraph_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLinesDataView(
      mojo::ArrayDataView<LineDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLines(UserType* output) {
    
    auto* pointer = data_->lines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::LineDataView>>(
        pointer, output, message_);
  }
  inline void GetTranslationDataView(
      TranslatedParagraphDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTranslation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::TranslatedParagraphDataView, UserType>(),
    "Attempting to read the optional `translation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTranslation` instead "
    "of `ReadTranslation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->translation.Get();
    return mojo::internal::Deserialize<::lens::mojom::TranslatedParagraphDataView>(
        pointer, output, message_);
  }
  inline void GetGeometryDataView(
      ::lens::mojom::GeometryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeometry(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::lens::mojom::GeometryDataView, UserType>(),
    "Attempting to read the optional `geometry` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGeometry` instead "
    "of `ReadGeometry if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->geometry.Get();
    return mojo::internal::Deserialize<::lens::mojom::GeometryDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWritingDirection(UserType* output) const {
    if (!data_->writing_direction_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::lens::mojom::WritingDirection>(
        data_->writing_direction_$value, &output->emplace());
  }
  std::optional<WritingDirection> writing_direction() const {
    if (!data_->writing_direction_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::WritingDirection>(data_->writing_direction_$value));
  }
  inline void GetContentLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentLanguage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_language` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentLanguage` instead "
    "of `ReadContentLanguage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Paragraph_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FormulaMetadataDataView {
 public:
  FormulaMetadataDataView() = default;

  FormulaMetadataDataView(
      internal::FormulaMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLatexDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatex(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `latex` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLatex` instead "
    "of `ReadLatex if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->latex.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FormulaMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // lens::mojom

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_TEXT_MOJOM_DATA_VIEW_H_