// chrome/browser/lens/core/mojom/lens_side_panel.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_LENS_SIDE_PANEL_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_LENS_SIDE_PANEL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/page_content_type.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace lens::mojom {

class LensSidePanelPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class LensSidePanelPageHandlerFactoryStub;

class LensSidePanelPageHandlerFactoryRequestValidator;


class LensSidePanelPageHandlerFactory
    : public LensSidePanelPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensSidePanelPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensSidePanelPageHandlerFactoryInterfaceBase;
  using Proxy_ = LensSidePanelPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensSidePanelPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = LensSidePanelPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateSidePanelPageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateSidePanelPageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensSidePanelPageHandlerFactory() = default;

  virtual void CreateSidePanelPageHandler(::mojo::PendingReceiver<LensSidePanelPageHandler> handler, ::mojo::PendingRemote<LensSidePanelPage> page) = 0;
};

class LensSidePanelPageHandlerProxy;

template <typename ImplRefTraits>
class LensSidePanelPageHandlerStub;

class LensSidePanelPageHandlerRequestValidator;
class LensSidePanelPageHandlerResponseValidator;


class LensSidePanelPageHandler
    : public LensSidePanelPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensSidePanelPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensSidePanelPageHandlerInterfaceBase;
  using Proxy_ = LensSidePanelPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensSidePanelPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = LensSidePanelPageHandlerRequestValidator;
  using ResponseValidator_ = LensSidePanelPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPopAndLoadQueryFromHistoryMinVersion = 0,
    kGetIsContextualSearchboxMinVersion = 0,
    kOnScrollToMessageMinVersion = 0,
    kRequestSendFeedbackMinVersion = 0,
    kOnAimMessageMinVersion = 0,
    kOnImageQueryWithEmptyTextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PopAndLoadQueryFromHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsContextualSearchbox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScrollToMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSendFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAimMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnImageQueryWithEmptyText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensSidePanelPageHandler() = default;

  virtual void PopAndLoadQueryFromHistory() = 0;

  using GetIsContextualSearchboxCallback = base::OnceCallback<void(bool)>;
  using GetIsContextualSearchboxMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetIsContextualSearchbox(GetIsContextualSearchboxCallback callback) = 0;

  virtual void OnScrollToMessage(const std::vector<std::string>& text_fragments, uint32_t pdf_page_number) = 0;

  virtual void RequestSendFeedback() = 0;

  virtual void OnAimMessage(const std::vector<uint8_t>& message) = 0;

  virtual void OnImageQueryWithEmptyText() = 0;
};

class LensSidePanelPageProxy;

template <typename ImplRefTraits>
class LensSidePanelPageStub;

class LensSidePanelPageRequestValidator;


class LensSidePanelPage
    : public LensSidePanelPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "lens.mojom.LensSidePanelPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LensSidePanelPageInterfaceBase;
  using Proxy_ = LensSidePanelPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = LensSidePanelPageStub<ImplRefTraits>;

  using RequestValidator_ = LensSidePanelPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLoadResultsInFrameMinVersion = 0,
    kSetIsLoadingResultsMinVersion = 0,
    kSetPageContentUploadProgressMinVersion = 0,
    kSetBackArrowVisibleMinVersion = 0,
    kSetShowErrorPageMinVersion = 0,
    kSuppressGhostLoaderMinVersion = 0,
    kPageContentTypeChangedMinVersion = 0,
    kShowToastMinVersion = 0,
    kSendClientMessageToAimMinVersion = 0,
    kAimHandshakeReceivedMinVersion = 0,
    kAimResultsChangedMinVersion = 0,
    kFocusResultsFrameMinVersion = 0,
    kSetIsOverlayShowingMinVersion = 0,
    kFocusSearchboxMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LoadResultsInFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsLoadingResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPageContentUploadProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackArrowVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetShowErrorPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuppressGhostLoader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PageContentTypeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowToast_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendClientMessageToAim_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AimHandshakeReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AimResultsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusResultsFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsOverlayShowing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusSearchbox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LensSidePanelPage() = default;

  virtual void LoadResultsInFrame(const ::GURL& results_url) = 0;

  virtual void SetIsLoadingResults(bool is_loading) = 0;

  virtual void SetPageContentUploadProgress(float progress) = 0;

  virtual void SetBackArrowVisible(bool visible) = 0;

  virtual void SetShowErrorPage(bool should_show_error_page, SidePanelResultStatus status) = 0;

  virtual void SuppressGhostLoader() = 0;

  virtual void PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) = 0;

  virtual void ShowToast(const std::string& message) = 0;

  virtual void SendClientMessageToAim(const std::vector<uint8_t>& serialized_message) = 0;

  virtual void AimHandshakeReceived() = 0;

  virtual void AimResultsChanged(bool on_aim) = 0;

  virtual void FocusResultsFrame() = 0;

  virtual void SetIsOverlayShowing(bool is_showing) = 0;

  virtual void FocusSearchbox() = 0;
};



class  LensSidePanelPageHandlerFactoryProxy
    : public LensSidePanelPageHandlerFactory {
 public:
  using InterfaceType = LensSidePanelPageHandlerFactory;

  explicit LensSidePanelPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateSidePanelPageHandler(::mojo::PendingReceiver<LensSidePanelPageHandler> handler, ::mojo::PendingRemote<LensSidePanelPage> page) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LensSidePanelPageHandlerProxy
    : public LensSidePanelPageHandler {
 public:
  using InterfaceType = LensSidePanelPageHandler;

  explicit LensSidePanelPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PopAndLoadQueryFromHistory() final;
  
  void GetIsContextualSearchbox(GetIsContextualSearchboxCallback callback) final;
  
  void OnScrollToMessage(const std::vector<std::string>& text_fragments, uint32_t pdf_page_number) final;
  
  void RequestSendFeedback() final;
  
  void OnAimMessage(const std::vector<uint8_t>& message) final;
  
  void OnImageQueryWithEmptyText() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LensSidePanelPageProxy
    : public LensSidePanelPage {
 public:
  using InterfaceType = LensSidePanelPage;

  explicit LensSidePanelPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LoadResultsInFrame(const ::GURL& results_url) final;
  
  void SetIsLoadingResults(bool is_loading) final;
  
  void SetPageContentUploadProgress(float progress) final;
  
  void SetBackArrowVisible(bool visible) final;
  
  void SetShowErrorPage(bool should_show_error_page, SidePanelResultStatus status) final;
  
  void SuppressGhostLoader() final;
  
  void PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) final;
  
  void ShowToast(const std::string& message) final;
  
  void SendClientMessageToAim(const std::vector<uint8_t>& serialized_message) final;
  
  void AimHandshakeReceived() final;
  
  void AimResultsChanged(bool on_aim) final;
  
  void FocusResultsFrame() final;
  
  void SetIsOverlayShowing(bool is_showing) final;
  
  void FocusSearchbox() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LensSidePanelPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(LensSidePanelPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensSidePanelPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensSidePanelPageHandlerFactory>>
class LensSidePanelPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensSidePanelPageHandlerFactoryStub() = default;
  ~LensSidePanelPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensSidePanelPageHandlerStubDispatch {
 public:
  static bool Accept(LensSidePanelPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensSidePanelPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensSidePanelPageHandler>>
class LensSidePanelPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensSidePanelPageHandlerStub() = default;
  ~LensSidePanelPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensSidePanelPageStubDispatch {
 public:
  static bool Accept(LensSidePanelPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LensSidePanelPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LensSidePanelPage>>
class LensSidePanelPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LensSidePanelPageStub() = default;
  ~LensSidePanelPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LensSidePanelPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LensSidePanelPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensSidePanelPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensSidePanelPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LensSidePanelPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // lens::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_LENS_SIDE_PANEL_MOJOM_H_