// chrome/browser/lens/core/mojom/geometry.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/polygon.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace lens::mojom {
class CenterRotatedBoxDataView;

class GeometryDataView;



}  // lens::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::lens::mojom::CenterRotatedBoxDataView> {
  using Data = ::lens::mojom::internal::CenterRotatedBox_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::GeometryDataView> {
  using Data = ::lens::mojom::internal::Geometry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace lens::mojom {


enum class CenterRotatedBox_CoordinateType : int32_t {
  
  kUnspecified = 0,
  
  kNormalized = 1,
  
  kImage = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CenterRotatedBox_CoordinateType value);
inline bool IsKnownEnumValue(CenterRotatedBox_CoordinateType value) {
  return internal::CenterRotatedBox_CoordinateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CenterRotatedBoxDataView {
 public:
  CenterRotatedBoxDataView() = default;

  CenterRotatedBoxDataView(
      internal::CenterRotatedBox_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoxDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBox(UserType* output) {
    
    auto* pointer = data_->box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  float rotation() const {
    return data_->rotation;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCoordinateType(UserType* output) const {
    auto data_value = data_->coordinate_type;
    return mojo::internal::Deserialize<::lens::mojom::CenterRotatedBox_CoordinateType>(
        data_value, output);
  }
  CenterRotatedBox_CoordinateType coordinate_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::CenterRotatedBox_CoordinateType>(data_->coordinate_type));
  }
 private:
  internal::CenterRotatedBox_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeometryDataView {
 public:
  GeometryDataView() = default;

  GeometryDataView(
      internal::Geometry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoundingBoxDataView(
      CenterRotatedBoxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundingBox(UserType* output) {
    
    auto* pointer = data_->bounding_box.Get();
    return mojo::internal::Deserialize<::lens::mojom::CenterRotatedBoxDataView>(
        pointer, output, message_);
  }
  inline void GetSegmentationPolygonDataView(
      mojo::ArrayDataView<::lens::mojom::PolygonDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentationPolygon(UserType* output) {
    
    auto* pointer = data_->segmentation_polygon.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::PolygonDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Geometry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // lens::mojom

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_DATA_VIEW_H_