// chrome/browser/glic/host/glic.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  NavigationConfirmationRequestSpec as actor_webui_mojom_NavigationConfirmationRequestSpec,
  NavigationConfirmationRequest as actor_webui_mojom_NavigationConfirmationRequest,
  NavigationConfirmationResponseSpec as actor_webui_mojom_NavigationConfirmationResponseSpec,
  NavigationConfirmationResponse as actor_webui_mojom_NavigationConfirmationResponse,
  SelectAutofillSuggestionsDialogRequestSpec as actor_webui_mojom_SelectAutofillSuggestionsDialogRequestSpec,
  SelectAutofillSuggestionsDialogRequest as actor_webui_mojom_SelectAutofillSuggestionsDialogRequest,
  SelectAutofillSuggestionsDialogResponseSpec as actor_webui_mojom_SelectAutofillSuggestionsDialogResponseSpec,
  SelectAutofillSuggestionsDialogResponse as actor_webui_mojom_SelectAutofillSuggestionsDialogResponse,
  SelectCredentialDialogRequestSpec as actor_webui_mojom_SelectCredentialDialogRequestSpec,
  SelectCredentialDialogRequest as actor_webui_mojom_SelectCredentialDialogRequest,
  SelectCredentialDialogResponseSpec as actor_webui_mojom_SelectCredentialDialogResponseSpec,
  SelectCredentialDialogResponse as actor_webui_mojom_SelectCredentialDialogResponse,
  TaskOptionsSpec as actor_webui_mojom_TaskOptionsSpec,
  TaskOptions as actor_webui_mojom_TaskOptions,
  UserConfirmationDialogRequestSpec as actor_webui_mojom_UserConfirmationDialogRequestSpec,
  UserConfirmationDialogRequest as actor_webui_mojom_UserConfirmationDialogRequest,
  UserConfirmationDialogResponseSpec as actor_webui_mojom_UserConfirmationDialogResponseSpec,
  UserConfirmationDialogResponse as actor_webui_mojom_UserConfirmationDialogResponse
} from './actor_webui.mojom-webui.js';
import {
  PageMetadataSpec as blink_mojom_PageMetadataSpec,
  PageMetadata as blink_mojom_PageMetadata
} from './ai_page_content_metadata.mojom-webui.js';
import {
  ContentSettingsTypeSpec as contentSettings_mojom_ContentSettingsTypeSpec,
  ContentSettingsType as contentSettings_mojom_ContentSettingsType
} from './content_settings_types.mojom-webui.js';
import {
  BigBufferSpec as mojoBase_mojom_BigBufferSpec,
  BigBuffer as mojoBase_mojom_BigBuffer
} from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import {
  ProtoWrapperSpec as mojoBase_mojom_ProtoWrapperSpec,
  ProtoWrapper as mojoBase_mojom_ProtoWrapper
} from '//resources/mojo/mojo/public/mojom/base/proto_wrapper.mojom-webui.js';
import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec,
  UnguessableToken as mojoBase_mojom_UnguessableToken
} from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import {
  VersionSpec as mojoBase_mojom_VersionSpec,
  Version as mojoBase_mojom_Version
} from '//resources/mojo/mojo/public/mojom/base/version.mojom-webui.js';
import {
  BitmapN32Spec as skia_mojom_BitmapN32Spec,
  BitmapN32 as skia_mojom_BitmapN32
} from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import {
  RectSpec as gfx_mojom_RectSpec,
  Rect as gfx_mojom_Rect,
  SizeSpec as gfx_mojom_SizeSpec,
  Size as gfx_mojom_Size
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import {
  OriginSpec as url_mojom_OriginSpec,
  Origin as url_mojom_Origin
} from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ProfileReadyStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ProfileReadyState {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kUnknownError = 0,
  kSignInRequired = 1,
  kReady = 2,
  kIneligible = 3,
  kDisabledByAdmin = 4,
}

export const WebUiStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WebUiState {

  MIN_VALUE = 0,
  MAX_VALUE = 12,
  kUninitialized = 0,
  kBeginLoad = 1,
  kShowLoading = 2,
  kHoldLoading = 3,
  kFinishLoading = 4,
  kError = 5,
  kOffline = 6,
  kUnavailable = 7,
  kReady = 8,
  kUnresponsive = 9,
  kSignIn = 10,
  kGuestError = 11,
  kDisabledByAdmin = 12,
}

export const MetricUserInputReactionTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MetricUserInputReactionType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kCanned = 1,
  kModel = 2,
}

export const PrepareForClientResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PrepareForClientResult {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kSuccess = 0,
  kErrorResyncingCookies = 1,
  kRequiresSignIn = 2,
}

export const PerformActionsErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PerformActionsErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kInvalidProto = 1,
  kMissingTaskId = 2,
}

export const CreateTaskErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CreateTaskErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kUnknown = 0,
  kTaskSystemUnavailable = 1,
}

export const ActorTaskStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ActorTaskState {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kUnknown = 0,
  kIdle = 1,
  kActing = 2,
  kPaused = 3,
  kStopped = 4,
}

export const ActorTaskPauseReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ActorTaskPauseReason {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kPausedByModel = 0,
  kPausedByUser = 1,
}

export const ActorTaskStopReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ActorTaskStopReason {

  MIN_VALUE = 0,
  MAX_VALUE = 4,
  kTaskComplete = 0,
  kStoppedByUser = 1,
  kModelError = 2,
  kUserStartedNewChat = 3,
  kUserLoadedPreviousChat = 4,
}

export const CaptureScreenshotErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CaptureScreenshotErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kScreenCaptureRequestThrottled = 1,
  kUserCancelledScreenPickerDialog = 2,
}

export const ScrollToErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ScrollToErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 8,
  kNotSupported = 0,
  kNewerScrollToCall = 1,
  kNoFocusedTab = 2,
  kNoMatchFound = 3,
  kFocusedTabChangedOrNavigated = 4,
  kNoMatchingDocument = 5,
  kSearchRangeInvalid = 6,
  kTabContextPermissionDisabled = 7,
  kDroppedByWebClient = 8,
}

export const SwitchConversationErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SwitchConversationErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kUnknown = 0,
}

export const RegisterConversationErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RegisterConversationErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kUnknown = 0,
  kInstanceAlreadyHasConversationId = 1,
}

export const PanelStateKindSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PanelStateKind {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kHidden = 0,
  kDetached = 1,
  kAttached = 2,
}

export const InvocationSourceSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum InvocationSource {

  MIN_VALUE = 0,
  MAX_VALUE = 14,
  kOsButton = 0,
  kOsButtonMenu = 1,
  kOsHotkey = 2,
  kTopChromeButton = 3,
  kFre = 4,
  kProfilePicker = 5,
  kNudge = 6,
  kThreeDotsMenu = 7,
  kUnsupported = 8,
  kWhatsNew = 9,
  kAfterSignIn = 10,
  kSharedTab = 11,
  kActorTaskIcon = 12,
  kSharedImage = 13,
  kHandoffButton = 14,
}

export const WebClientModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WebClientMode {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 2,
  kText = 0,
  kAudio = 1,
}

export const WebClientModelSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WebClientModel {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kDefault = 0,
  kActor = 1,
}

export const WebUseCounterSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum WebUseCounter {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kDefault = 0,
  kSubmitPromptWithAutoMode = 1,
}

export const ResponseStopCauseSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ResponseStopCause {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kUser = 1,
  kOther = 2,
}

export const CaptureRegionErrorReasonSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CaptureRegionErrorReason {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kUnknown = 0,
  kNoFocusableTab = 1,
}

export const SettingsPageFieldSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SettingsPageField {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNone = 0,
  kOsHotkey = 1,
  kOsEntrypointToggle = 2,
}

export const HostCapabilitySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum HostCapability {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kScrollToPdf = 0,
  kResetSizeAndLocationOnOpen = 1,
  kGetModelQualityClientId = 2,
  kMultiInstance = 3,
}

export const CurrentViewSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CurrentView {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kConversation = 0,
  kActuation = 1,
}



export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  intentToShow(): void;
  setProfileReadyState(readyState: ProfileReadyState): void;
  updatePageState(panelStateKind: PanelStateKind): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  intentToShow(): void {
    this.proxy.sendMessage(
        0,
        Page_IntentToShow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setProfileReadyState(
      readyState: ProfileReadyState): void {
    this.proxy.sendMessage(
        1,
        Page_SetProfileReadyState_ParamsSpec.$,
        null,
        [
          readyState
        ],
        false);
  }

  updatePageState(
      panelStateKind: PanelStateKind): void {
    this.proxy.sendMessage(
        2,
        Page_UpdatePageState_ParamsSpec.$,
        null,
        [
          panelStateKind
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_IntentToShow_ParamsSpec.$,
        null,
        impl.intentToShow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_SetProfileReadyState_ParamsSpec.$,
        null,
        impl.setProfileReadyState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_UpdatePageState_ParamsSpec.$,
        null,
        impl.updatePageState.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "glic.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  intentToShow: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setProfileReadyState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updatePageState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.intentToShow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_IntentToShow_ParamsSpec.$,
        null,
        this.intentToShow.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setProfileReadyState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_SetProfileReadyState_ParamsSpec.$,
        null,
        this.setProfileReadyState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updatePageState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_UpdatePageState_ParamsSpec.$,
        null,
        this.updatePageState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(receiver: PageHandlerPendingReceiver, page: PageRemote): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      receiver: PageHandlerPendingReceiver,
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          receiver,
          page
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "glic.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  createWebClient(webClientReceiver: WebClientHandlerPendingReceiver): void;
  prepareForClient(): Promise<{
        result: PrepareForClientResult, }>;
  webviewCommitted(url: url_mojom_Url): void;
  closePanel(): Promise<void>;
  openProfilePickerAndClosePanel(): void;
  openDisabledByAdminLinkAndClosePanel(): void;
  signInAndClosePanel(): void;
  resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
  enableDragResize(enabled: boolean): void;
  webUiStateChanged(newState: WebUiState): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createWebClient(
      webClientReceiver: WebClientHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandler_CreateWebClient_ParamsSpec.$,
        null,
        [
          webClientReceiver
        ],
        false);
  }

  prepareForClient(): Promise<{
        result: PrepareForClientResult, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_PrepareForClient_ParamsSpec.$,
        PageHandler_PrepareForClient_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  webviewCommitted(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        2,
        PageHandler_WebviewCommitted_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  closePanel(): Promise<void> {
    return this.proxy.sendMessage(
        3,
        PageHandler_ClosePanel_ParamsSpec.$,
        PageHandler_ClosePanel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openProfilePickerAndClosePanel(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openDisabledByAdminLinkAndClosePanel(): void {
    this.proxy.sendMessage(
        5,
        PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  signInAndClosePanel(): void {
    this.proxy.sendMessage(
        6,
        PageHandler_SignInAndClosePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  resizeWidget(
      size: gfx_mojom_Size,
      duration: mojoBase_mojom_TimeDelta): Promise<void> {
    return this.proxy.sendMessage(
        7,
        PageHandler_ResizeWidget_ParamsSpec.$,
        PageHandler_ResizeWidget_ResponseParamsSpec.$,
        [
          size,
          duration
        ],
        false);
  }

  enableDragResize(
      enabled: boolean): void {
    this.proxy.sendMessage(
        8,
        PageHandler_EnableDragResize_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  webUiStateChanged(
      newState: WebUiState): void {
    this.proxy.sendMessage(
        9,
        PageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        [
          newState
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_CreateWebClient_ParamsSpec.$,
        null,
        impl.createWebClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_PrepareForClient_ParamsSpec.$,
        PageHandler_PrepareForClient_ResponseParamsSpec.$,
        impl.prepareForClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_WebviewCommitted_ParamsSpec.$,
        null,
        impl.webviewCommitted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_ClosePanel_ParamsSpec.$,
        PageHandler_ClosePanel_ResponseParamsSpec.$,
        impl.closePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$,
        null,
        impl.openProfilePickerAndClosePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$,
        null,
        impl.openDisabledByAdminLinkAndClosePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_SignInAndClosePanel_ParamsSpec.$,
        null,
        impl.signInAndClosePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_ResizeWidget_ParamsSpec.$,
        PageHandler_ResizeWidget_ResponseParamsSpec.$,
        impl.resizeWidget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_EnableDragResize_ParamsSpec.$,
        null,
        impl.enableDragResize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        impl.webUiStateChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "glic.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createWebClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  prepareForClient: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  webviewCommitted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openProfilePickerAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openDisabledByAdminLinkAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  signInAndClosePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resizeWidget: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  enableDragResize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  webUiStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createWebClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_CreateWebClient_ParamsSpec.$,
        null,
        this.createWebClient.createReceiverHandler(false /* expectsResponse */),
        false);
    this.prepareForClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_PrepareForClient_ParamsSpec.$,
        PageHandler_PrepareForClient_ResponseParamsSpec.$,
        this.prepareForClient.createReceiverHandler(true /* expectsResponse */),
        false);
    this.webviewCommitted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_WebviewCommitted_ParamsSpec.$,
        null,
        this.webviewCommitted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_ClosePanel_ParamsSpec.$,
        PageHandler_ClosePanel_ResponseParamsSpec.$,
        this.closePanel.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openProfilePickerAndClosePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$,
        null,
        this.openProfilePickerAndClosePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openDisabledByAdminLinkAndClosePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$,
        null,
        this.openDisabledByAdminLinkAndClosePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.signInAndClosePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_SignInAndClosePanel_ParamsSpec.$,
        null,
        this.signInAndClosePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resizeWidget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_ResizeWidget_ParamsSpec.$,
        PageHandler_ResizeWidget_ResponseParamsSpec.$,
        this.resizeWidget.createReceiverHandler(true /* expectsResponse */),
        false);
    this.enableDragResize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_EnableDragResize_ParamsSpec.$,
        null,
        this.enableDragResize.createReceiverHandler(false /* expectsResponse */),
        false);
    this.webUiStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_WebUiStateChanged_ParamsSpec.$,
        null,
        this.webUiStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PinCandidatesObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PinCandidatesObserverPendingReceiver>;

export class PinCandidatesObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PinCandidatesObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<PinCandidatesObserverPendingReceiver>;
  constructor(handle: MojoHandle|PinCandidatesObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.PinCandidatesObserver',
        scope);
  }
}

export interface PinCandidatesObserverInterface {
  onPinCandidatesChanged(candidates: PinCandidate[]): void;
}

export class PinCandidatesObserverRemote implements PinCandidatesObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PinCandidatesObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PinCandidatesObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PinCandidatesObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PinCandidatesObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onPinCandidatesChanged(
      candidates: PinCandidate[]): void {
    this.proxy.sendMessage(
        0,
        PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$,
        null,
        [
          candidates
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PinCandidatesObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PinCandidatesObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PinCandidatesObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$,
        null,
        impl.onPinCandidatesChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PinCandidatesObserver {
  static get $interfaceName(): string {
    return "glic.mojom.PinCandidatesObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PinCandidatesObserverRemote {
    let remote = new PinCandidatesObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PinCandidatesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PinCandidatesObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PinCandidatesObserverRemote, PinCandidatesObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onPinCandidatesChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PinCandidatesObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onPinCandidatesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$,
        null,
        this.onPinCandidatesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type WebClientHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WebClientHandlerPendingReceiver>;

export class WebClientHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WebClientHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<WebClientHandlerPendingReceiver>;
  constructor(handle: MojoHandle|WebClientHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.WebClientHandler',
        scope);
  }
}

export interface WebClientHandlerInterface {
  webClientCreated(webClient: WebClientRemote): Promise<{
        initialState: WebClientInitialState, }>;
  webClientInitialized(): void;
  webClientInitializeFailed(): void;
  createTab(url: url_mojom_Url, openInBackground: boolean, windowId: (number | null)): Promise<{
        tabData: (TabData | null), }>;
  openLinkInPopup(url: url_mojom_Url, popupWidth: number, popupHeight: number): void;
  openGlicSettingsPage(options: OpenSettingsOptions): void;
  openPasswordManagerSettingsPage(): void;
  closePanel(): void;
  closePanelAndShutdown(): void;
  attachPanel(): void;
  detachPanel(): void;
  onModeChange(newMode: WebClientMode): void;
  showProfilePicker(): void;
  getModelQualityClientId(): Promise<{
        modelQualityClientId: string, }>;
  getContextFromFocusedTab(options: GetTabContextOptions): Promise<{
        result: GetContextResult, }>;
  getContextFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult, }>;
  getContextForActorFromTab(tabId: number, options: GetTabContextOptions): Promise<{
        result: GetContextResult, }>;
  setMaximumNumberOfPinnedTabs(requestedMax: number): Promise<{
        effectiveMax: number, }>;
  pinTabs(tabIds: number[]): Promise<{
        pinnedAll: boolean, }>;
  unpinTabs(tabIds: number[]): Promise<{
        unpinnedAll: boolean, }>;
  unpinAllTabs(): void;
  subscribeToPinCandidates(options: GetPinCandidatesOptions, observer: PinCandidatesObserverRemote): void;
  createTask(taskOptions: (actor_webui_mojom_TaskOptions | null)): Promise<number>;
  performActions(actionsProto: number[]): Promise<mojoBase_mojom_ProtoWrapper>;
  stopActorTask(taskId: number, stopReason: ActorTaskStopReason): void;
  pauseActorTask(taskId: number, pauseReason: ActorTaskPauseReason, tabId: (number | null)): void;
  resumeActorTask(taskId: number, contextOptions: GetTabContextOptions): Promise<{
        result: GetContextResultWithActionResultCode, }>;
  interruptActorTask(taskId: number): void;
  uninterruptActorTask(taskId: number): void;
  createActorTab(taskId: number, openInBackground: boolean, initiatorTabId: (number | null), initiatorWindowId: (number | null)): Promise<{
        tabData: (TabData | null), }>;
  activateTab(taskId: number): void;
  resizeWidget(size: gfx_mojom_Size, duration: mojoBase_mojom_TimeDelta): Promise<void>;
  captureScreenshot(): Promise<{
        result: CaptureScreenshotResult, }>;
  captureRegion(observer: CaptureRegionObserverRemote): void;
  setAudioDucking(enable: boolean): Promise<{
        result: boolean, }>;
  setPanelDraggableAreas(draggableAreas: gfx_mojom_Rect[]): Promise<void>;
  setMinimumPanelSize(size: gfx_mojom_Size): void;
  setMicrophonePermissionState(enabled: boolean): Promise<void>;
  setLocationPermissionState(enabled: boolean): Promise<void>;
  setTabContextPermissionState(enabled: boolean): Promise<void>;
  setClosedCaptioningSetting(enabled: boolean): Promise<void>;
  setActuationOnWebSetting(enabled: boolean): Promise<void>;
  shouldAllowMediaPermissionRequest(): Promise<{
        isAllowed: boolean, }>;
  shouldAllowGeolocationPermissionRequest(): Promise<{
        isAllowed: boolean, }>;
  setContextAccessIndicator(enabled: boolean): void;
  getUserProfileInfo(): Promise<{
        profileInfo: (UserProfileInfo | null), }>;
  syncCookies(): Promise<{
        success: boolean, }>;
  logBeginAsyncEvent(eventAsyncId: bigint, taskId: number, event: string, details: string): void;
  logEndAsyncEvent(eventAsyncId: bigint, details: string): void;
  logInstantEvent(taskId: number, event: string, details: string): void;
  journalClear(): void;
  journalSnapshot(clearJournal: boolean): Promise<{
        journal: Journal, }>;
  journalStart(maxBytes: bigint, captureScreenshots: boolean): void;
  journalStop(): void;
  journalRecordFeedback(positive: boolean, reason: string): void;
  onUserInputSubmitted(mode: WebClientMode): void;
  onContextUploadStarted(): void;
  onContextUploadCompleted(): void;
  onReaction(reactionType: MetricUserInputReactionType): void;
  onResponseStarted(): void;
  onResponseStopped(details: OnResponseStoppedDetails): void;
  onSessionTerminated(): void;
  onTurnCompleted(model: WebClientModel, duration: mojoBase_mojom_TimeDelta): void;
  onModelChanged(model: WebClientModel): void;
  onRecordUseCounter(counter: number): void;
  onResponseRated(positive: boolean): void;
  onClosedCaptionsShown(): void;
  scrollTo(params: ScrollToParams): Promise<{
        errorReason: (ScrollToErrorReason | null), }>;
  dropScrollToHighlight(): void;
  setSyntheticExperimentState(trialName: string, groupName: string): void;
  openOsPermissionSettingsMenu(type: contentSettings_mojom_ContentSettingsType): void;
  getOsMicrophonePermissionStatus(): Promise<{
        enabled: boolean, }>;
  getZeroStateSuggestionsAndSubscribe(isLive: boolean, options: ZeroStateSuggestionsOptions): Promise<{
        zeroStateSuggestions: (ZeroStateSuggestionsV2 | null), }>;
  getZeroStateSuggestionsForFocusedTab(isFirstRun: (boolean | null)): Promise<{
        suggestions: (ZeroStateSuggestions | null), }>;
  maybeRefreshUserStatus(): void;
  isDebuggerAttached(): Promise<{
        isAttachedToWebview: boolean, }>;
  onViewChanged(notification: ViewChangedNotification): void;
  subscribeToPageMetadata(tabId: number, names: string[]): Promise<{
        success: boolean, }>;
  switchConversation(info: (ConversationInfo | null)): Promise<{
        errorReason: (SwitchConversationErrorReason | null), }>;
  registerConversation(info: ConversationInfo): Promise<{
        errorReason: (RegisterConversationErrorReason | null), }>;
}

export class WebClientHandlerRemote implements WebClientHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WebClientHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WebClientHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WebClientHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebClientHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  webClientCreated(
      webClient: WebClientRemote): Promise<{
        initialState: WebClientInitialState, }> {
    return this.proxy.sendMessage(
        0,
        WebClientHandler_WebClientCreated_ParamsSpec.$,
        WebClientHandler_WebClientCreated_ResponseParamsSpec.$,
        [
          webClient
        ],
        false);
  }

  webClientInitialized(): void {
    this.proxy.sendMessage(
        1,
        WebClientHandler_WebClientInitialized_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  webClientInitializeFailed(): void {
    this.proxy.sendMessage(
        2,
        WebClientHandler_WebClientInitializeFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  createTab(
      url: url_mojom_Url,
      openInBackground: boolean,
      windowId: (number | null)): Promise<{
        tabData: (TabData | null), }> {
    return this.proxy.sendMessage(
        3,
        WebClientHandler_CreateTab_ParamsSpec.$,
        WebClientHandler_CreateTab_ResponseParamsSpec.$,
        [
          url,
          openInBackground,
          windowId
        ],
        false);
  }

  openLinkInPopup(
      url: url_mojom_Url,
      popupWidth: number,
      popupHeight: number): void {
    this.proxy.sendMessage(
        4,
        WebClientHandler_OpenLinkInPopup_ParamsSpec.$,
        null,
        [
          url,
          popupWidth,
          popupHeight
        ],
        false);
  }

  openGlicSettingsPage(
      options: OpenSettingsOptions): void {
    this.proxy.sendMessage(
        5,
        WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$,
        null,
        [
          options
        ],
        false);
  }

  openPasswordManagerSettingsPage(): void {
    this.proxy.sendMessage(
        6,
        WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closePanel(): void {
    this.proxy.sendMessage(
        7,
        WebClientHandler_ClosePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closePanelAndShutdown(): void {
    this.proxy.sendMessage(
        8,
        WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  attachPanel(): void {
    this.proxy.sendMessage(
        9,
        WebClientHandler_AttachPanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  detachPanel(): void {
    this.proxy.sendMessage(
        10,
        WebClientHandler_DetachPanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onModeChange(
      newMode: WebClientMode): void {
    this.proxy.sendMessage(
        11,
        WebClientHandler_OnModeChange_ParamsSpec.$,
        null,
        [
          newMode
        ],
        false);
  }

  showProfilePicker(): void {
    this.proxy.sendMessage(
        12,
        WebClientHandler_ShowProfilePicker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getModelQualityClientId(): Promise<{
        modelQualityClientId: string, }> {
    return this.proxy.sendMessage(
        13,
        WebClientHandler_GetModelQualityClientId_ParamsSpec.$,
        WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getContextFromFocusedTab(
      options: GetTabContextOptions): Promise<{
        result: GetContextResult, }> {
    return this.proxy.sendMessage(
        14,
        WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$,
        WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  getContextFromTab(
      tabId: number,
      options: GetTabContextOptions): Promise<{
        result: GetContextResult, }> {
    return this.proxy.sendMessage(
        15,
        WebClientHandler_GetContextFromTab_ParamsSpec.$,
        WebClientHandler_GetContextFromTab_ResponseParamsSpec.$,
        [
          tabId,
          options
        ],
        false);
  }

  getContextForActorFromTab(
      tabId: number,
      options: GetTabContextOptions): Promise<{
        result: GetContextResult, }> {
    return this.proxy.sendMessage(
        16,
        WebClientHandler_GetContextForActorFromTab_ParamsSpec.$,
        WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$,
        [
          tabId,
          options
        ],
        false);
  }

  setMaximumNumberOfPinnedTabs(
      requestedMax: number): Promise<{
        effectiveMax: number, }> {
    return this.proxy.sendMessage(
        17,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$,
        [
          requestedMax
        ],
        false);
  }

  pinTabs(
      tabIds: number[]): Promise<{
        pinnedAll: boolean, }> {
    return this.proxy.sendMessage(
        18,
        WebClientHandler_PinTabs_ParamsSpec.$,
        WebClientHandler_PinTabs_ResponseParamsSpec.$,
        [
          tabIds
        ],
        false);
  }

  unpinTabs(
      tabIds: number[]): Promise<{
        unpinnedAll: boolean, }> {
    return this.proxy.sendMessage(
        19,
        WebClientHandler_UnpinTabs_ParamsSpec.$,
        WebClientHandler_UnpinTabs_ResponseParamsSpec.$,
        [
          tabIds
        ],
        false);
  }

  unpinAllTabs(): void {
    this.proxy.sendMessage(
        20,
        WebClientHandler_UnpinAllTabs_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  subscribeToPinCandidates(
      options: GetPinCandidatesOptions,
      observer: PinCandidatesObserverRemote): void {
    this.proxy.sendMessage(
        21,
        WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$,
        null,
        [
          options,
          observer
        ],
        false);
  }

  createTask(
      taskOptions: (actor_webui_mojom_TaskOptions | null)): Promise<number> {
    return this.proxy.sendMessage(
        22,
        WebClientHandler_CreateTask_ParamsSpec.$,
        WebClientHandler_CreateTask_ResponseParamsSpec.$,
        [
          taskOptions
        ],
        true);
  }

  performActions(
      actionsProto: number[]): Promise<mojoBase_mojom_ProtoWrapper> {
    return this.proxy.sendMessage(
        23,
        WebClientHandler_PerformActions_ParamsSpec.$,
        WebClientHandler_PerformActions_ResponseParamsSpec.$,
        [
          actionsProto
        ],
        true);
  }

  stopActorTask(
      taskId: number,
      stopReason: ActorTaskStopReason): void {
    this.proxy.sendMessage(
        24,
        WebClientHandler_StopActorTask_ParamsSpec.$,
        null,
        [
          taskId,
          stopReason
        ],
        false);
  }

  pauseActorTask(
      taskId: number,
      pauseReason: ActorTaskPauseReason,
      tabId: (number | null)): void {
    this.proxy.sendMessage(
        25,
        WebClientHandler_PauseActorTask_ParamsSpec.$,
        null,
        [
          taskId,
          pauseReason,
          tabId
        ],
        false);
  }

  resumeActorTask(
      taskId: number,
      contextOptions: GetTabContextOptions): Promise<{
        result: GetContextResultWithActionResultCode, }> {
    return this.proxy.sendMessage(
        26,
        WebClientHandler_ResumeActorTask_ParamsSpec.$,
        WebClientHandler_ResumeActorTask_ResponseParamsSpec.$,
        [
          taskId,
          contextOptions
        ],
        false);
  }

  interruptActorTask(
      taskId: number): void {
    this.proxy.sendMessage(
        27,
        WebClientHandler_InterruptActorTask_ParamsSpec.$,
        null,
        [
          taskId
        ],
        false);
  }

  uninterruptActorTask(
      taskId: number): void {
    this.proxy.sendMessage(
        28,
        WebClientHandler_UninterruptActorTask_ParamsSpec.$,
        null,
        [
          taskId
        ],
        false);
  }

  createActorTab(
      taskId: number,
      openInBackground: boolean,
      initiatorTabId: (number | null),
      initiatorWindowId: (number | null)): Promise<{
        tabData: (TabData | null), }> {
    return this.proxy.sendMessage(
        29,
        WebClientHandler_CreateActorTab_ParamsSpec.$,
        WebClientHandler_CreateActorTab_ResponseParamsSpec.$,
        [
          taskId,
          openInBackground,
          initiatorTabId,
          initiatorWindowId
        ],
        false);
  }

  activateTab(
      taskId: number): void {
    this.proxy.sendMessage(
        30,
        WebClientHandler_ActivateTab_ParamsSpec.$,
        null,
        [
          taskId
        ],
        false);
  }

  resizeWidget(
      size: gfx_mojom_Size,
      duration: mojoBase_mojom_TimeDelta): Promise<void> {
    return this.proxy.sendMessage(
        31,
        WebClientHandler_ResizeWidget_ParamsSpec.$,
        WebClientHandler_ResizeWidget_ResponseParamsSpec.$,
        [
          size,
          duration
        ],
        false);
  }

  captureScreenshot(): Promise<{
        result: CaptureScreenshotResult, }> {
    return this.proxy.sendMessage(
        32,
        WebClientHandler_CaptureScreenshot_ParamsSpec.$,
        WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  captureRegion(
      observer: CaptureRegionObserverRemote): void {
    this.proxy.sendMessage(
        33,
        WebClientHandler_CaptureRegion_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  setAudioDucking(
      enable: boolean): Promise<{
        result: boolean, }> {
    return this.proxy.sendMessage(
        34,
        WebClientHandler_SetAudioDucking_ParamsSpec.$,
        WebClientHandler_SetAudioDucking_ResponseParamsSpec.$,
        [
          enable
        ],
        false);
  }

  setPanelDraggableAreas(
      draggableAreas: gfx_mojom_Rect[]): Promise<void> {
    return this.proxy.sendMessage(
        35,
        WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$,
        WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$,
        [
          draggableAreas
        ],
        false);
  }

  setMinimumPanelSize(
      size: gfx_mojom_Size): void {
    this.proxy.sendMessage(
        36,
        WebClientHandler_SetMinimumPanelSize_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  setMicrophonePermissionState(
      enabled: boolean): Promise<void> {
    return this.proxy.sendMessage(
        37,
        WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$,
        WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  setLocationPermissionState(
      enabled: boolean): Promise<void> {
    return this.proxy.sendMessage(
        38,
        WebClientHandler_SetLocationPermissionState_ParamsSpec.$,
        WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  setTabContextPermissionState(
      enabled: boolean): Promise<void> {
    return this.proxy.sendMessage(
        39,
        WebClientHandler_SetTabContextPermissionState_ParamsSpec.$,
        WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  setClosedCaptioningSetting(
      enabled: boolean): Promise<void> {
    return this.proxy.sendMessage(
        40,
        WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$,
        WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  setActuationOnWebSetting(
      enabled: boolean): Promise<void> {
    return this.proxy.sendMessage(
        41,
        WebClientHandler_SetActuationOnWebSetting_ParamsSpec.$,
        WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  shouldAllowMediaPermissionRequest(): Promise<{
        isAllowed: boolean, }> {
    return this.proxy.sendMessage(
        42,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  shouldAllowGeolocationPermissionRequest(): Promise<{
        isAllowed: boolean, }> {
    return this.proxy.sendMessage(
        43,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setContextAccessIndicator(
      enabled: boolean): void {
    this.proxy.sendMessage(
        44,
        WebClientHandler_SetContextAccessIndicator_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  getUserProfileInfo(): Promise<{
        profileInfo: (UserProfileInfo | null), }> {
    return this.proxy.sendMessage(
        45,
        WebClientHandler_GetUserProfileInfo_ParamsSpec.$,
        WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  syncCookies(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        46,
        WebClientHandler_SyncCookies_ParamsSpec.$,
        WebClientHandler_SyncCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  logBeginAsyncEvent(
      eventAsyncId: bigint,
      taskId: number,
      event: string,
      details: string): void {
    this.proxy.sendMessage(
        47,
        WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$,
        null,
        [
          eventAsyncId,
          taskId,
          event,
          details
        ],
        false);
  }

  logEndAsyncEvent(
      eventAsyncId: bigint,
      details: string): void {
    this.proxy.sendMessage(
        48,
        WebClientHandler_LogEndAsyncEvent_ParamsSpec.$,
        null,
        [
          eventAsyncId,
          details
        ],
        false);
  }

  logInstantEvent(
      taskId: number,
      event: string,
      details: string): void {
    this.proxy.sendMessage(
        49,
        WebClientHandler_LogInstantEvent_ParamsSpec.$,
        null,
        [
          taskId,
          event,
          details
        ],
        false);
  }

  journalClear(): void {
    this.proxy.sendMessage(
        50,
        WebClientHandler_JournalClear_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  journalSnapshot(
      clearJournal: boolean): Promise<{
        journal: Journal, }> {
    return this.proxy.sendMessage(
        51,
        WebClientHandler_JournalSnapshot_ParamsSpec.$,
        WebClientHandler_JournalSnapshot_ResponseParamsSpec.$,
        [
          clearJournal
        ],
        false);
  }

  journalStart(
      maxBytes: bigint,
      captureScreenshots: boolean): void {
    this.proxy.sendMessage(
        52,
        WebClientHandler_JournalStart_ParamsSpec.$,
        null,
        [
          maxBytes,
          captureScreenshots
        ],
        false);
  }

  journalStop(): void {
    this.proxy.sendMessage(
        53,
        WebClientHandler_JournalStop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  journalRecordFeedback(
      positive: boolean,
      reason: string): void {
    this.proxy.sendMessage(
        54,
        WebClientHandler_JournalRecordFeedback_ParamsSpec.$,
        null,
        [
          positive,
          reason
        ],
        false);
  }

  onUserInputSubmitted(
      mode: WebClientMode): void {
    this.proxy.sendMessage(
        55,
        WebClientHandler_OnUserInputSubmitted_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  onContextUploadStarted(): void {
    this.proxy.sendMessage(
        56,
        WebClientHandler_OnContextUploadStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onContextUploadCompleted(): void {
    this.proxy.sendMessage(
        57,
        WebClientHandler_OnContextUploadCompleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onReaction(
      reactionType: MetricUserInputReactionType): void {
    this.proxy.sendMessage(
        58,
        WebClientHandler_OnReaction_ParamsSpec.$,
        null,
        [
          reactionType
        ],
        false);
  }

  onResponseStarted(): void {
    this.proxy.sendMessage(
        59,
        WebClientHandler_OnResponseStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onResponseStopped(
      details: OnResponseStoppedDetails): void {
    this.proxy.sendMessage(
        60,
        WebClientHandler_OnResponseStopped_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  onSessionTerminated(): void {
    this.proxy.sendMessage(
        61,
        WebClientHandler_OnSessionTerminated_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onTurnCompleted(
      model: WebClientModel,
      duration: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        62,
        WebClientHandler_OnTurnCompleted_ParamsSpec.$,
        null,
        [
          model,
          duration
        ],
        false);
  }

  onModelChanged(
      model: WebClientModel): void {
    this.proxy.sendMessage(
        63,
        WebClientHandler_OnModelChanged_ParamsSpec.$,
        null,
        [
          model
        ],
        false);
  }

  onRecordUseCounter(
      counter: number): void {
    this.proxy.sendMessage(
        64,
        WebClientHandler_OnRecordUseCounter_ParamsSpec.$,
        null,
        [
          counter
        ],
        false);
  }

  onResponseRated(
      positive: boolean): void {
    this.proxy.sendMessage(
        65,
        WebClientHandler_OnResponseRated_ParamsSpec.$,
        null,
        [
          positive
        ],
        false);
  }

  onClosedCaptionsShown(): void {
    this.proxy.sendMessage(
        66,
        WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  scrollTo(
      params: ScrollToParams): Promise<{
        errorReason: (ScrollToErrorReason | null), }> {
    return this.proxy.sendMessage(
        67,
        WebClientHandler_ScrollTo_ParamsSpec.$,
        WebClientHandler_ScrollTo_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  dropScrollToHighlight(): void {
    this.proxy.sendMessage(
        68,
        WebClientHandler_DropScrollToHighlight_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setSyntheticExperimentState(
      trialName: string,
      groupName: string): void {
    this.proxy.sendMessage(
        69,
        WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$,
        null,
        [
          trialName,
          groupName
        ],
        false);
  }

  openOsPermissionSettingsMenu(
      type: contentSettings_mojom_ContentSettingsType): void {
    this.proxy.sendMessage(
        70,
        WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }

  getOsMicrophonePermissionStatus(): Promise<{
        enabled: boolean, }> {
    return this.proxy.sendMessage(
        71,
        WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$,
        WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getZeroStateSuggestionsAndSubscribe(
      isLive: boolean,
      options: ZeroStateSuggestionsOptions): Promise<{
        zeroStateSuggestions: (ZeroStateSuggestionsV2 | null), }> {
    return this.proxy.sendMessage(
        72,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$,
        [
          isLive,
          options
        ],
        false);
  }

  getZeroStateSuggestionsForFocusedTab(
      isFirstRun: (boolean | null)): Promise<{
        suggestions: (ZeroStateSuggestions | null), }> {
    return this.proxy.sendMessage(
        73,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$,
        [
          isFirstRun
        ],
        false);
  }

  maybeRefreshUserStatus(): void {
    this.proxy.sendMessage(
        74,
        WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  isDebuggerAttached(): Promise<{
        isAttachedToWebview: boolean, }> {
    return this.proxy.sendMessage(
        75,
        WebClientHandler_IsDebuggerAttached_ParamsSpec.$,
        WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  onViewChanged(
      notification: ViewChangedNotification): void {
    this.proxy.sendMessage(
        76,
        WebClientHandler_OnViewChanged_ParamsSpec.$,
        null,
        [
          notification
        ],
        false);
  }

  subscribeToPageMetadata(
      tabId: number,
      names: string[]): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        77,
        WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$,
        WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$,
        [
          tabId,
          names
        ],
        false);
  }

  switchConversation(
      info: (ConversationInfo | null)): Promise<{
        errorReason: (SwitchConversationErrorReason | null), }> {
    return this.proxy.sendMessage(
        78,
        WebClientHandler_SwitchConversation_ParamsSpec.$,
        WebClientHandler_SwitchConversation_ResponseParamsSpec.$,
        [
          info
        ],
        false);
  }

  registerConversation(
      info: ConversationInfo): Promise<{
        errorReason: (RegisterConversationErrorReason | null), }> {
    return this.proxy.sendMessage(
        79,
        WebClientHandler_RegisterConversation_ParamsSpec.$,
        WebClientHandler_RegisterConversation_ResponseParamsSpec.$,
        [
          info
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebClientHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebClientHandlerRemote, WebClientHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebClientHandlerRemote, WebClientHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WebClientHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebClientHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebClientHandler_WebClientCreated_ParamsSpec.$,
        WebClientHandler_WebClientCreated_ResponseParamsSpec.$,
        impl.webClientCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebClientHandler_WebClientInitialized_ParamsSpec.$,
        null,
        impl.webClientInitialized.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebClientHandler_WebClientInitializeFailed_ParamsSpec.$,
        null,
        impl.webClientInitializeFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebClientHandler_CreateTab_ParamsSpec.$,
        WebClientHandler_CreateTab_ResponseParamsSpec.$,
        impl.createTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebClientHandler_OpenLinkInPopup_ParamsSpec.$,
        null,
        impl.openLinkInPopup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$,
        null,
        impl.openGlicSettingsPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec.$,
        null,
        impl.openPasswordManagerSettingsPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebClientHandler_ClosePanel_ParamsSpec.$,
        null,
        impl.closePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$,
        null,
        impl.closePanelAndShutdown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebClientHandler_AttachPanel_ParamsSpec.$,
        null,
        impl.attachPanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WebClientHandler_DetachPanel_ParamsSpec.$,
        null,
        impl.detachPanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WebClientHandler_OnModeChange_ParamsSpec.$,
        null,
        impl.onModeChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WebClientHandler_ShowProfilePicker_ParamsSpec.$,
        null,
        impl.showProfilePicker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        WebClientHandler_GetModelQualityClientId_ParamsSpec.$,
        WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$,
        impl.getModelQualityClientId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$,
        WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$,
        impl.getContextFromFocusedTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        WebClientHandler_GetContextFromTab_ParamsSpec.$,
        WebClientHandler_GetContextFromTab_ResponseParamsSpec.$,
        impl.getContextFromTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        WebClientHandler_GetContextForActorFromTab_ParamsSpec.$,
        WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$,
        impl.getContextForActorFromTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$,
        impl.setMaximumNumberOfPinnedTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        WebClientHandler_PinTabs_ParamsSpec.$,
        WebClientHandler_PinTabs_ResponseParamsSpec.$,
        impl.pinTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        WebClientHandler_UnpinTabs_ParamsSpec.$,
        WebClientHandler_UnpinTabs_ResponseParamsSpec.$,
        impl.unpinTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        WebClientHandler_UnpinAllTabs_ParamsSpec.$,
        null,
        impl.unpinAllTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$,
        null,
        impl.subscribeToPinCandidates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        WebClientHandler_CreateTask_ParamsSpec.$,
        WebClientHandler_CreateTask_ResponseParamsSpec.$,
        impl.createTask.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        23,
        WebClientHandler_PerformActions_ParamsSpec.$,
        WebClientHandler_PerformActions_ResponseParamsSpec.$,
        impl.performActions.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        24,
        WebClientHandler_StopActorTask_ParamsSpec.$,
        null,
        impl.stopActorTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        WebClientHandler_PauseActorTask_ParamsSpec.$,
        null,
        impl.pauseActorTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        WebClientHandler_ResumeActorTask_ParamsSpec.$,
        WebClientHandler_ResumeActorTask_ResponseParamsSpec.$,
        impl.resumeActorTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        WebClientHandler_InterruptActorTask_ParamsSpec.$,
        null,
        impl.interruptActorTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        WebClientHandler_UninterruptActorTask_ParamsSpec.$,
        null,
        impl.uninterruptActorTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        WebClientHandler_CreateActorTab_ParamsSpec.$,
        WebClientHandler_CreateActorTab_ResponseParamsSpec.$,
        impl.createActorTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        WebClientHandler_ActivateTab_ParamsSpec.$,
        null,
        impl.activateTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        WebClientHandler_ResizeWidget_ParamsSpec.$,
        WebClientHandler_ResizeWidget_ResponseParamsSpec.$,
        impl.resizeWidget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        WebClientHandler_CaptureScreenshot_ParamsSpec.$,
        WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$,
        impl.captureScreenshot.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        WebClientHandler_CaptureRegion_ParamsSpec.$,
        null,
        impl.captureRegion.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        WebClientHandler_SetAudioDucking_ParamsSpec.$,
        WebClientHandler_SetAudioDucking_ResponseParamsSpec.$,
        impl.setAudioDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$,
        WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$,
        impl.setPanelDraggableAreas.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        WebClientHandler_SetMinimumPanelSize_ParamsSpec.$,
        null,
        impl.setMinimumPanelSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$,
        WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$,
        impl.setMicrophonePermissionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        WebClientHandler_SetLocationPermissionState_ParamsSpec.$,
        WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$,
        impl.setLocationPermissionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        WebClientHandler_SetTabContextPermissionState_ParamsSpec.$,
        WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$,
        impl.setTabContextPermissionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        40,
        WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$,
        WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$,
        impl.setClosedCaptioningSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        41,
        WebClientHandler_SetActuationOnWebSetting_ParamsSpec.$,
        WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec.$,
        impl.setActuationOnWebSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        42,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$,
        impl.shouldAllowMediaPermissionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        43,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$,
        impl.shouldAllowGeolocationPermissionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        44,
        WebClientHandler_SetContextAccessIndicator_ParamsSpec.$,
        null,
        impl.setContextAccessIndicator.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        45,
        WebClientHandler_GetUserProfileInfo_ParamsSpec.$,
        WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$,
        impl.getUserProfileInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        46,
        WebClientHandler_SyncCookies_ParamsSpec.$,
        WebClientHandler_SyncCookies_ResponseParamsSpec.$,
        impl.syncCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        47,
        WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$,
        null,
        impl.logBeginAsyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        48,
        WebClientHandler_LogEndAsyncEvent_ParamsSpec.$,
        null,
        impl.logEndAsyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        49,
        WebClientHandler_LogInstantEvent_ParamsSpec.$,
        null,
        impl.logInstantEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        50,
        WebClientHandler_JournalClear_ParamsSpec.$,
        null,
        impl.journalClear.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        51,
        WebClientHandler_JournalSnapshot_ParamsSpec.$,
        WebClientHandler_JournalSnapshot_ResponseParamsSpec.$,
        impl.journalSnapshot.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        52,
        WebClientHandler_JournalStart_ParamsSpec.$,
        null,
        impl.journalStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        53,
        WebClientHandler_JournalStop_ParamsSpec.$,
        null,
        impl.journalStop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        54,
        WebClientHandler_JournalRecordFeedback_ParamsSpec.$,
        null,
        impl.journalRecordFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        55,
        WebClientHandler_OnUserInputSubmitted_ParamsSpec.$,
        null,
        impl.onUserInputSubmitted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        56,
        WebClientHandler_OnContextUploadStarted_ParamsSpec.$,
        null,
        impl.onContextUploadStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        57,
        WebClientHandler_OnContextUploadCompleted_ParamsSpec.$,
        null,
        impl.onContextUploadCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        58,
        WebClientHandler_OnReaction_ParamsSpec.$,
        null,
        impl.onReaction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        59,
        WebClientHandler_OnResponseStarted_ParamsSpec.$,
        null,
        impl.onResponseStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        60,
        WebClientHandler_OnResponseStopped_ParamsSpec.$,
        null,
        impl.onResponseStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        61,
        WebClientHandler_OnSessionTerminated_ParamsSpec.$,
        null,
        impl.onSessionTerminated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        62,
        WebClientHandler_OnTurnCompleted_ParamsSpec.$,
        null,
        impl.onTurnCompleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        63,
        WebClientHandler_OnModelChanged_ParamsSpec.$,
        null,
        impl.onModelChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        64,
        WebClientHandler_OnRecordUseCounter_ParamsSpec.$,
        null,
        impl.onRecordUseCounter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        65,
        WebClientHandler_OnResponseRated_ParamsSpec.$,
        null,
        impl.onResponseRated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        66,
        WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$,
        null,
        impl.onClosedCaptionsShown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        67,
        WebClientHandler_ScrollTo_ParamsSpec.$,
        WebClientHandler_ScrollTo_ResponseParamsSpec.$,
        impl.scrollTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        68,
        WebClientHandler_DropScrollToHighlight_ParamsSpec.$,
        null,
        impl.dropScrollToHighlight.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        69,
        WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$,
        null,
        impl.setSyntheticExperimentState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        70,
        WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$,
        null,
        impl.openOsPermissionSettingsMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        71,
        WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$,
        WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$,
        impl.getOsMicrophonePermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        72,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$,
        impl.getZeroStateSuggestionsAndSubscribe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        73,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$,
        impl.getZeroStateSuggestionsForFocusedTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        74,
        WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$,
        null,
        impl.maybeRefreshUserStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        75,
        WebClientHandler_IsDebuggerAttached_ParamsSpec.$,
        WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$,
        impl.isDebuggerAttached.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        76,
        WebClientHandler_OnViewChanged_ParamsSpec.$,
        null,
        impl.onViewChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        77,
        WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$,
        WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$,
        impl.subscribeToPageMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        78,
        WebClientHandler_SwitchConversation_ParamsSpec.$,
        WebClientHandler_SwitchConversation_ResponseParamsSpec.$,
        impl.switchConversation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        79,
        WebClientHandler_RegisterConversation_ParamsSpec.$,
        WebClientHandler_RegisterConversation_ResponseParamsSpec.$,
        impl.registerConversation.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebClientHandler {
  static get $interfaceName(): string {
    return "glic.mojom.WebClientHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WebClientHandlerRemote {
    let remote = new WebClientHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WebClientHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebClientHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebClientHandlerRemote, WebClientHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebClientHandlerRemote, WebClientHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  webClientCreated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  webClientInitialized: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  webClientInitializeFailed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openLinkInPopup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openGlicSettingsPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openPasswordManagerSettingsPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closePanelAndShutdown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  attachPanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  detachPanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onModeChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showProfilePicker: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getModelQualityClientId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getContextFromFocusedTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getContextFromTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getContextForActorFromTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMaximumNumberOfPinnedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pinTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  unpinTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  unpinAllTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  subscribeToPinCandidates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  performActions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pauseActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resumeActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  interruptActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  uninterruptActorTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createActorTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  activateTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resizeWidget: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  captureScreenshot: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  captureRegion: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAudioDucking: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPanelDraggableAreas: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMinimumPanelSize: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMicrophonePermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setLocationPermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTabContextPermissionState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setClosedCaptioningSetting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setActuationOnWebSetting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  shouldAllowMediaPermissionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  shouldAllowGeolocationPermissionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setContextAccessIndicator: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUserProfileInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  syncCookies: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logBeginAsyncEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logEndAsyncEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logInstantEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  journalClear: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  journalSnapshot: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  journalStart: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  journalStop: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  journalRecordFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onUserInputSubmitted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onContextUploadStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onContextUploadCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onReaction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onResponseStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onResponseStopped: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onSessionTerminated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onTurnCompleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onModelChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onRecordUseCounter: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onResponseRated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onClosedCaptionsShown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  scrollTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dropScrollToHighlight: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSyntheticExperimentState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openOsPermissionSettingsMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getOsMicrophonePermissionStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getZeroStateSuggestionsAndSubscribe: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getZeroStateSuggestionsForFocusedTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeRefreshUserStatus: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isDebuggerAttached: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onViewChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  subscribeToPageMetadata: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  switchConversation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  registerConversation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebClientHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.webClientCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebClientHandler_WebClientCreated_ParamsSpec.$,
        WebClientHandler_WebClientCreated_ResponseParamsSpec.$,
        this.webClientCreated.createReceiverHandler(true /* expectsResponse */),
        false);
    this.webClientInitialized =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebClientHandler_WebClientInitialized_ParamsSpec.$,
        null,
        this.webClientInitialized.createReceiverHandler(false /* expectsResponse */),
        false);
    this.webClientInitializeFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebClientHandler_WebClientInitializeFailed_ParamsSpec.$,
        null,
        this.webClientInitializeFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebClientHandler_CreateTab_ParamsSpec.$,
        WebClientHandler_CreateTab_ResponseParamsSpec.$,
        this.createTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openLinkInPopup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebClientHandler_OpenLinkInPopup_ParamsSpec.$,
        null,
        this.openLinkInPopup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openGlicSettingsPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$,
        null,
        this.openGlicSettingsPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openPasswordManagerSettingsPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec.$,
        null,
        this.openPasswordManagerSettingsPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebClientHandler_ClosePanel_ParamsSpec.$,
        null,
        this.closePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closePanelAndShutdown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$,
        null,
        this.closePanelAndShutdown.createReceiverHandler(false /* expectsResponse */),
        false);
    this.attachPanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebClientHandler_AttachPanel_ParamsSpec.$,
        null,
        this.attachPanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.detachPanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WebClientHandler_DetachPanel_ParamsSpec.$,
        null,
        this.detachPanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onModeChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WebClientHandler_OnModeChange_ParamsSpec.$,
        null,
        this.onModeChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showProfilePicker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WebClientHandler_ShowProfilePicker_ParamsSpec.$,
        null,
        this.showProfilePicker.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getModelQualityClientId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        WebClientHandler_GetModelQualityClientId_ParamsSpec.$,
        WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$,
        this.getModelQualityClientId.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getContextFromFocusedTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$,
        WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$,
        this.getContextFromFocusedTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getContextFromTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        WebClientHandler_GetContextFromTab_ParamsSpec.$,
        WebClientHandler_GetContextFromTab_ResponseParamsSpec.$,
        this.getContextFromTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getContextForActorFromTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        WebClientHandler_GetContextForActorFromTab_ParamsSpec.$,
        WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$,
        this.getContextForActorFromTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setMaximumNumberOfPinnedTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$,
        WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$,
        this.setMaximumNumberOfPinnedTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.pinTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        WebClientHandler_PinTabs_ParamsSpec.$,
        WebClientHandler_PinTabs_ResponseParamsSpec.$,
        this.pinTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.unpinTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        WebClientHandler_UnpinTabs_ParamsSpec.$,
        WebClientHandler_UnpinTabs_ResponseParamsSpec.$,
        this.unpinTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.unpinAllTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        WebClientHandler_UnpinAllTabs_ParamsSpec.$,
        null,
        this.unpinAllTabs.createReceiverHandler(false /* expectsResponse */),
        false);
    this.subscribeToPinCandidates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$,
        null,
        this.subscribeToPinCandidates.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        WebClientHandler_CreateTask_ParamsSpec.$,
        WebClientHandler_CreateTask_ResponseParamsSpec.$,
        this.createTask.createReceiverHandler(true /* expectsResponse */),
        true);
    this.performActions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        WebClientHandler_PerformActions_ParamsSpec.$,
        WebClientHandler_PerformActions_ResponseParamsSpec.$,
        this.performActions.createReceiverHandler(true /* expectsResponse */),
        true);
    this.stopActorTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        WebClientHandler_StopActorTask_ParamsSpec.$,
        null,
        this.stopActorTask.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pauseActorTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        WebClientHandler_PauseActorTask_ParamsSpec.$,
        null,
        this.pauseActorTask.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resumeActorTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        WebClientHandler_ResumeActorTask_ParamsSpec.$,
        WebClientHandler_ResumeActorTask_ResponseParamsSpec.$,
        this.resumeActorTask.createReceiverHandler(true /* expectsResponse */),
        false);
    this.interruptActorTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        WebClientHandler_InterruptActorTask_ParamsSpec.$,
        null,
        this.interruptActorTask.createReceiverHandler(false /* expectsResponse */),
        false);
    this.uninterruptActorTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        WebClientHandler_UninterruptActorTask_ParamsSpec.$,
        null,
        this.uninterruptActorTask.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createActorTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        WebClientHandler_CreateActorTab_ParamsSpec.$,
        WebClientHandler_CreateActorTab_ResponseParamsSpec.$,
        this.createActorTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.activateTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        WebClientHandler_ActivateTab_ParamsSpec.$,
        null,
        this.activateTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resizeWidget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        WebClientHandler_ResizeWidget_ParamsSpec.$,
        WebClientHandler_ResizeWidget_ResponseParamsSpec.$,
        this.resizeWidget.createReceiverHandler(true /* expectsResponse */),
        false);
    this.captureScreenshot =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        WebClientHandler_CaptureScreenshot_ParamsSpec.$,
        WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$,
        this.captureScreenshot.createReceiverHandler(true /* expectsResponse */),
        false);
    this.captureRegion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        WebClientHandler_CaptureRegion_ParamsSpec.$,
        null,
        this.captureRegion.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setAudioDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        WebClientHandler_SetAudioDucking_ParamsSpec.$,
        WebClientHandler_SetAudioDucking_ResponseParamsSpec.$,
        this.setAudioDucking.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setPanelDraggableAreas =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$,
        WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$,
        this.setPanelDraggableAreas.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setMinimumPanelSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        WebClientHandler_SetMinimumPanelSize_ParamsSpec.$,
        null,
        this.setMinimumPanelSize.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setMicrophonePermissionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$,
        WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$,
        this.setMicrophonePermissionState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setLocationPermissionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        WebClientHandler_SetLocationPermissionState_ParamsSpec.$,
        WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$,
        this.setLocationPermissionState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setTabContextPermissionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        WebClientHandler_SetTabContextPermissionState_ParamsSpec.$,
        WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$,
        this.setTabContextPermissionState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setClosedCaptioningSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        40,
        WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$,
        WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$,
        this.setClosedCaptioningSetting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setActuationOnWebSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        41,
        WebClientHandler_SetActuationOnWebSetting_ParamsSpec.$,
        WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec.$,
        this.setActuationOnWebSetting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.shouldAllowMediaPermissionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        42,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$,
        this.shouldAllowMediaPermissionRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    this.shouldAllowGeolocationPermissionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        43,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$,
        WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$,
        this.shouldAllowGeolocationPermissionRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setContextAccessIndicator =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        44,
        WebClientHandler_SetContextAccessIndicator_ParamsSpec.$,
        null,
        this.setContextAccessIndicator.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getUserProfileInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        45,
        WebClientHandler_GetUserProfileInfo_ParamsSpec.$,
        WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$,
        this.getUserProfileInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.syncCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        46,
        WebClientHandler_SyncCookies_ParamsSpec.$,
        WebClientHandler_SyncCookies_ResponseParamsSpec.$,
        this.syncCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    this.logBeginAsyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        47,
        WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$,
        null,
        this.logBeginAsyncEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.logEndAsyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        48,
        WebClientHandler_LogEndAsyncEvent_ParamsSpec.$,
        null,
        this.logEndAsyncEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.logInstantEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        49,
        WebClientHandler_LogInstantEvent_ParamsSpec.$,
        null,
        this.logInstantEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.journalClear =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        50,
        WebClientHandler_JournalClear_ParamsSpec.$,
        null,
        this.journalClear.createReceiverHandler(false /* expectsResponse */),
        false);
    this.journalSnapshot =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        51,
        WebClientHandler_JournalSnapshot_ParamsSpec.$,
        WebClientHandler_JournalSnapshot_ResponseParamsSpec.$,
        this.journalSnapshot.createReceiverHandler(true /* expectsResponse */),
        false);
    this.journalStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        52,
        WebClientHandler_JournalStart_ParamsSpec.$,
        null,
        this.journalStart.createReceiverHandler(false /* expectsResponse */),
        false);
    this.journalStop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        53,
        WebClientHandler_JournalStop_ParamsSpec.$,
        null,
        this.journalStop.createReceiverHandler(false /* expectsResponse */),
        false);
    this.journalRecordFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        54,
        WebClientHandler_JournalRecordFeedback_ParamsSpec.$,
        null,
        this.journalRecordFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onUserInputSubmitted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        55,
        WebClientHandler_OnUserInputSubmitted_ParamsSpec.$,
        null,
        this.onUserInputSubmitted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onContextUploadStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        56,
        WebClientHandler_OnContextUploadStarted_ParamsSpec.$,
        null,
        this.onContextUploadStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onContextUploadCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        57,
        WebClientHandler_OnContextUploadCompleted_ParamsSpec.$,
        null,
        this.onContextUploadCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onReaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        58,
        WebClientHandler_OnReaction_ParamsSpec.$,
        null,
        this.onReaction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onResponseStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        59,
        WebClientHandler_OnResponseStarted_ParamsSpec.$,
        null,
        this.onResponseStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onResponseStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        60,
        WebClientHandler_OnResponseStopped_ParamsSpec.$,
        null,
        this.onResponseStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onSessionTerminated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        61,
        WebClientHandler_OnSessionTerminated_ParamsSpec.$,
        null,
        this.onSessionTerminated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onTurnCompleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        62,
        WebClientHandler_OnTurnCompleted_ParamsSpec.$,
        null,
        this.onTurnCompleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onModelChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        63,
        WebClientHandler_OnModelChanged_ParamsSpec.$,
        null,
        this.onModelChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onRecordUseCounter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        64,
        WebClientHandler_OnRecordUseCounter_ParamsSpec.$,
        null,
        this.onRecordUseCounter.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onResponseRated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        65,
        WebClientHandler_OnResponseRated_ParamsSpec.$,
        null,
        this.onResponseRated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onClosedCaptionsShown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        66,
        WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$,
        null,
        this.onClosedCaptionsShown.createReceiverHandler(false /* expectsResponse */),
        false);
    this.scrollTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        67,
        WebClientHandler_ScrollTo_ParamsSpec.$,
        WebClientHandler_ScrollTo_ResponseParamsSpec.$,
        this.scrollTo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.dropScrollToHighlight =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        68,
        WebClientHandler_DropScrollToHighlight_ParamsSpec.$,
        null,
        this.dropScrollToHighlight.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setSyntheticExperimentState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        69,
        WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$,
        null,
        this.setSyntheticExperimentState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openOsPermissionSettingsMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        70,
        WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$,
        null,
        this.openOsPermissionSettingsMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getOsMicrophonePermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        71,
        WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$,
        WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$,
        this.getOsMicrophonePermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getZeroStateSuggestionsAndSubscribe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        72,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$,
        this.getZeroStateSuggestionsAndSubscribe.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getZeroStateSuggestionsForFocusedTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        73,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$,
        WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$,
        this.getZeroStateSuggestionsForFocusedTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.maybeRefreshUserStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        74,
        WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$,
        null,
        this.maybeRefreshUserStatus.createReceiverHandler(false /* expectsResponse */),
        false);
    this.isDebuggerAttached =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        75,
        WebClientHandler_IsDebuggerAttached_ParamsSpec.$,
        WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$,
        this.isDebuggerAttached.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onViewChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        76,
        WebClientHandler_OnViewChanged_ParamsSpec.$,
        null,
        this.onViewChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.subscribeToPageMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        77,
        WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$,
        WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$,
        this.subscribeToPageMetadata.createReceiverHandler(true /* expectsResponse */),
        false);
    this.switchConversation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        78,
        WebClientHandler_SwitchConversation_ParamsSpec.$,
        WebClientHandler_SwitchConversation_ResponseParamsSpec.$,
        this.switchConversation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.registerConversation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        79,
        WebClientHandler_RegisterConversation_ParamsSpec.$,
        WebClientHandler_RegisterConversation_ResponseParamsSpec.$,
        this.registerConversation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type WebClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<WebClientPendingReceiver>;

export class WebClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<WebClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<WebClientPendingReceiver>;
  constructor(handle: MojoHandle|WebClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.WebClient',
        scope);
  }
}

export interface WebClientInterface {
  notifyPanelWillOpen(panelOpeningData: PanelOpeningData): Promise<{
        openPanelInfo: OpenPanelInfo, }>;
  notifyPanelWasClosed(): Promise<void>;
  notifyPanelStateChange(panelState: PanelState): void;
  notifyPanelActiveChange(panelActive: boolean): void;
  notifyPanelCanAttachChange(canAttach: boolean): void;
  notifyMicrophonePermissionStateChanged(enabled: boolean): void;
  notifyLocationPermissionStateChanged(enabled: boolean): void;
  notifyTabContextPermissionStateChanged(enabled: boolean): void;
  notifyOsLocationPermissionStateChanged(enabled: boolean): void;
  notifyFocusedTabChanged(focusedTabData: FocusedTabData): void;
  notifyManualResizeChanged(resizing: boolean): void;
  notifyOsHotkeyStateChanged(hotkey: string): void;
  notifyBrowserIsOpenChanged(browserIsOpen: boolean): void;
  notifyInstanceActivationChanged(instanceActive: boolean): void;
  notifyClosedCaptioningSettingChanged(enabled: boolean): void;
  notifyPinnedTabsChanged(tabData: TabData[]): void;
  notifyPinnedTabDataChanged(tabData: TabData): void;
  notifyZeroStateSuggestionsChanged(suggestions: (ZeroStateSuggestionsV2 | null), options: ZeroStateSuggestionsOptions): void;
  notifyActorTaskStateChanged(taskId: number, state: ActorTaskState): void;
  notifyTabDataChanged(tabData: TabData): void;
  requestViewChange(request: ViewChangeRequest): void;
  notifyPageMetadataChanged(tabId: number, metadata: (blink_mojom_PageMetadata | null)): void;
  notifyDefaultTabContextPermissionStateChanged(enabled: boolean): void;
  requestToShowCredentialSelectionDialog(request: actor_webui_mojom_SelectCredentialDialogRequest): Promise<{
        response: actor_webui_mojom_SelectCredentialDialogResponse, }>;
  requestToShowAutofillSuggestionsDialog(request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest): Promise<{
        response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse, }>;
  requestToShowUserConfirmationDialog(request: actor_webui_mojom_UserConfirmationDialogRequest): Promise<{
        response: actor_webui_mojom_UserConfirmationDialogResponse, }>;
  requestToConfirmNavigation(request: actor_webui_mojom_NavigationConfirmationRequest): Promise<{
        response: actor_webui_mojom_NavigationConfirmationResponse, }>;
  notifyAdditionalContext(context: AdditionalContext): void;
  notifyActuationOnWebSettingChanged(enabled: boolean): void;
  notifyActOnWebCapabilityChanged(canActOnWeb: boolean): void;
}

export class WebClientRemote implements WebClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<WebClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<WebClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|WebClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  notifyPanelWillOpen(
      panelOpeningData: PanelOpeningData): Promise<{
        openPanelInfo: OpenPanelInfo, }> {
    return this.proxy.sendMessage(
        0,
        WebClient_NotifyPanelWillOpen_ParamsSpec.$,
        WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$,
        [
          panelOpeningData
        ],
        false);
  }

  notifyPanelWasClosed(): Promise<void> {
    return this.proxy.sendMessage(
        1,
        WebClient_NotifyPanelWasClosed_ParamsSpec.$,
        WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  notifyPanelStateChange(
      panelState: PanelState): void {
    this.proxy.sendMessage(
        2,
        WebClient_NotifyPanelStateChange_ParamsSpec.$,
        null,
        [
          panelState
        ],
        false);
  }

  notifyPanelActiveChange(
      panelActive: boolean): void {
    this.proxy.sendMessage(
        3,
        WebClient_NotifyPanelActiveChange_ParamsSpec.$,
        null,
        [
          panelActive
        ],
        false);
  }

  notifyPanelCanAttachChange(
      canAttach: boolean): void {
    this.proxy.sendMessage(
        4,
        WebClient_NotifyPanelCanAttachChange_ParamsSpec.$,
        null,
        [
          canAttach
        ],
        false);
  }

  notifyMicrophonePermissionStateChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        5,
        WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyLocationPermissionStateChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        6,
        WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyTabContextPermissionStateChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        7,
        WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyOsLocationPermissionStateChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        8,
        WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyFocusedTabChanged(
      focusedTabData: FocusedTabData): void {
    this.proxy.sendMessage(
        9,
        WebClient_NotifyFocusedTabChanged_ParamsSpec.$,
        null,
        [
          focusedTabData
        ],
        false);
  }

  notifyManualResizeChanged(
      resizing: boolean): void {
    this.proxy.sendMessage(
        10,
        WebClient_NotifyManualResizeChanged_ParamsSpec.$,
        null,
        [
          resizing
        ],
        false);
  }

  notifyOsHotkeyStateChanged(
      hotkey: string): void {
    this.proxy.sendMessage(
        11,
        WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$,
        null,
        [
          hotkey
        ],
        false);
  }

  notifyBrowserIsOpenChanged(
      browserIsOpen: boolean): void {
    this.proxy.sendMessage(
        12,
        WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$,
        null,
        [
          browserIsOpen
        ],
        false);
  }

  notifyInstanceActivationChanged(
      instanceActive: boolean): void {
    this.proxy.sendMessage(
        13,
        WebClient_NotifyInstanceActivationChanged_ParamsSpec.$,
        null,
        [
          instanceActive
        ],
        false);
  }

  notifyClosedCaptioningSettingChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        14,
        WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyPinnedTabsChanged(
      tabData: TabData[]): void {
    this.proxy.sendMessage(
        15,
        WebClient_NotifyPinnedTabsChanged_ParamsSpec.$,
        null,
        [
          tabData
        ],
        false);
  }

  notifyPinnedTabDataChanged(
      tabData: TabData): void {
    this.proxy.sendMessage(
        16,
        WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$,
        null,
        [
          tabData
        ],
        false);
  }

  notifyZeroStateSuggestionsChanged(
      suggestions: (ZeroStateSuggestionsV2 | null),
      options: ZeroStateSuggestionsOptions): void {
    this.proxy.sendMessage(
        17,
        WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$,
        null,
        [
          suggestions,
          options
        ],
        false);
  }

  notifyActorTaskStateChanged(
      taskId: number,
      state: ActorTaskState): void {
    this.proxy.sendMessage(
        18,
        WebClient_NotifyActorTaskStateChanged_ParamsSpec.$,
        null,
        [
          taskId,
          state
        ],
        false);
  }

  notifyTabDataChanged(
      tabData: TabData): void {
    this.proxy.sendMessage(
        19,
        WebClient_NotifyTabDataChanged_ParamsSpec.$,
        null,
        [
          tabData
        ],
        false);
  }

  requestViewChange(
      request: ViewChangeRequest): void {
    this.proxy.sendMessage(
        20,
        WebClient_RequestViewChange_ParamsSpec.$,
        null,
        [
          request
        ],
        false);
  }

  notifyPageMetadataChanged(
      tabId: number,
      metadata: (blink_mojom_PageMetadata | null)): void {
    this.proxy.sendMessage(
        21,
        WebClient_NotifyPageMetadataChanged_ParamsSpec.$,
        null,
        [
          tabId,
          metadata
        ],
        false);
  }

  notifyDefaultTabContextPermissionStateChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        22,
        WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  requestToShowCredentialSelectionDialog(
      request: actor_webui_mojom_SelectCredentialDialogRequest): Promise<{
        response: actor_webui_mojom_SelectCredentialDialogResponse, }> {
    return this.proxy.sendMessage(
        23,
        WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$,
        WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  requestToShowAutofillSuggestionsDialog(
      request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest): Promise<{
        response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse, }> {
    return this.proxy.sendMessage(
        24,
        WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec.$,
        WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  requestToShowUserConfirmationDialog(
      request: actor_webui_mojom_UserConfirmationDialogRequest): Promise<{
        response: actor_webui_mojom_UserConfirmationDialogResponse, }> {
    return this.proxy.sendMessage(
        25,
        WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$,
        WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  requestToConfirmNavigation(
      request: actor_webui_mojom_NavigationConfirmationRequest): Promise<{
        response: actor_webui_mojom_NavigationConfirmationResponse, }> {
    return this.proxy.sendMessage(
        26,
        WebClient_RequestToConfirmNavigation_ParamsSpec.$,
        WebClient_RequestToConfirmNavigation_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  notifyAdditionalContext(
      context: AdditionalContext): void {
    this.proxy.sendMessage(
        27,
        WebClient_NotifyAdditionalContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  notifyActuationOnWebSettingChanged(
      enabled: boolean): void {
    this.proxy.sendMessage(
        28,
        WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  notifyActOnWebCapabilityChanged(
      canActOnWeb: boolean): void {
    this.proxy.sendMessage(
        29,
        WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec.$,
        null,
        [
          canActOnWeb
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WebClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebClientRemote, WebClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebClientRemote, WebClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: WebClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebClient_NotifyPanelWillOpen_ParamsSpec.$,
        WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$,
        impl.notifyPanelWillOpen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WebClient_NotifyPanelWasClosed_ParamsSpec.$,
        WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$,
        impl.notifyPanelWasClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WebClient_NotifyPanelStateChange_ParamsSpec.$,
        null,
        impl.notifyPanelStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WebClient_NotifyPanelActiveChange_ParamsSpec.$,
        null,
        impl.notifyPanelActiveChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WebClient_NotifyPanelCanAttachChange_ParamsSpec.$,
        null,
        impl.notifyPanelCanAttachChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$,
        null,
        impl.notifyMicrophonePermissionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$,
        null,
        impl.notifyLocationPermissionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        impl.notifyTabContextPermissionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$,
        null,
        impl.notifyOsLocationPermissionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        WebClient_NotifyFocusedTabChanged_ParamsSpec.$,
        null,
        impl.notifyFocusedTabChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        WebClient_NotifyManualResizeChanged_ParamsSpec.$,
        null,
        impl.notifyManualResizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$,
        null,
        impl.notifyOsHotkeyStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$,
        null,
        impl.notifyBrowserIsOpenChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        WebClient_NotifyInstanceActivationChanged_ParamsSpec.$,
        null,
        impl.notifyInstanceActivationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$,
        null,
        impl.notifyClosedCaptioningSettingChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        WebClient_NotifyPinnedTabsChanged_ParamsSpec.$,
        null,
        impl.notifyPinnedTabsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$,
        null,
        impl.notifyPinnedTabDataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$,
        null,
        impl.notifyZeroStateSuggestionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        WebClient_NotifyActorTaskStateChanged_ParamsSpec.$,
        null,
        impl.notifyActorTaskStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        WebClient_NotifyTabDataChanged_ParamsSpec.$,
        null,
        impl.notifyTabDataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        WebClient_RequestViewChange_ParamsSpec.$,
        null,
        impl.requestViewChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        WebClient_NotifyPageMetadataChanged_ParamsSpec.$,
        null,
        impl.notifyPageMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        impl.notifyDefaultTabContextPermissionStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$,
        WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$,
        impl.requestToShowCredentialSelectionDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec.$,
        WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec.$,
        impl.requestToShowAutofillSuggestionsDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$,
        WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$,
        impl.requestToShowUserConfirmationDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        WebClient_RequestToConfirmNavigation_ParamsSpec.$,
        WebClient_RequestToConfirmNavigation_ResponseParamsSpec.$,
        impl.requestToConfirmNavigation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        WebClient_NotifyAdditionalContext_ParamsSpec.$,
        null,
        impl.notifyAdditionalContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec.$,
        null,
        impl.notifyActuationOnWebSettingChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec.$,
        null,
        impl.notifyActOnWebCapabilityChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebClient {
  static get $interfaceName(): string {
    return "glic.mojom.WebClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): WebClientRemote {
    let remote = new WebClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the WebClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    WebClientRemote, WebClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    WebClientRemote, WebClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  notifyPanelWillOpen: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPanelWasClosed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPanelStateChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPanelActiveChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPanelCanAttachChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyMicrophonePermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyLocationPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyTabContextPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyOsLocationPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyFocusedTabChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyManualResizeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyOsHotkeyStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyBrowserIsOpenChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyInstanceActivationChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyClosedCaptioningSettingChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPinnedTabsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPinnedTabDataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyZeroStateSuggestionsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyActorTaskStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyTabDataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestViewChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyPageMetadataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyDefaultTabContextPermissionStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestToShowCredentialSelectionDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestToShowAutofillSuggestionsDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestToShowUserConfirmationDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestToConfirmNavigation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyAdditionalContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyActuationOnWebSettingChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyActOnWebCapabilityChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.notifyPanelWillOpen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebClient_NotifyPanelWillOpen_ParamsSpec.$,
        WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$,
        this.notifyPanelWillOpen.createReceiverHandler(true /* expectsResponse */),
        false);
    this.notifyPanelWasClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WebClient_NotifyPanelWasClosed_ParamsSpec.$,
        WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$,
        this.notifyPanelWasClosed.createReceiverHandler(true /* expectsResponse */),
        false);
    this.notifyPanelStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WebClient_NotifyPanelStateChange_ParamsSpec.$,
        null,
        this.notifyPanelStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyPanelActiveChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WebClient_NotifyPanelActiveChange_ParamsSpec.$,
        null,
        this.notifyPanelActiveChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyPanelCanAttachChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WebClient_NotifyPanelCanAttachChange_ParamsSpec.$,
        null,
        this.notifyPanelCanAttachChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyMicrophonePermissionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$,
        null,
        this.notifyMicrophonePermissionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyLocationPermissionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$,
        null,
        this.notifyLocationPermissionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyTabContextPermissionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        this.notifyTabContextPermissionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyOsLocationPermissionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$,
        null,
        this.notifyOsLocationPermissionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyFocusedTabChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        WebClient_NotifyFocusedTabChanged_ParamsSpec.$,
        null,
        this.notifyFocusedTabChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyManualResizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        WebClient_NotifyManualResizeChanged_ParamsSpec.$,
        null,
        this.notifyManualResizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyOsHotkeyStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$,
        null,
        this.notifyOsHotkeyStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyBrowserIsOpenChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$,
        null,
        this.notifyBrowserIsOpenChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyInstanceActivationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        WebClient_NotifyInstanceActivationChanged_ParamsSpec.$,
        null,
        this.notifyInstanceActivationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyClosedCaptioningSettingChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$,
        null,
        this.notifyClosedCaptioningSettingChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyPinnedTabsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        WebClient_NotifyPinnedTabsChanged_ParamsSpec.$,
        null,
        this.notifyPinnedTabsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyPinnedTabDataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$,
        null,
        this.notifyPinnedTabDataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyZeroStateSuggestionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$,
        null,
        this.notifyZeroStateSuggestionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyActorTaskStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        WebClient_NotifyActorTaskStateChanged_ParamsSpec.$,
        null,
        this.notifyActorTaskStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyTabDataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        WebClient_NotifyTabDataChanged_ParamsSpec.$,
        null,
        this.notifyTabDataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestViewChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        WebClient_RequestViewChange_ParamsSpec.$,
        null,
        this.requestViewChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyPageMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        WebClient_NotifyPageMetadataChanged_ParamsSpec.$,
        null,
        this.notifyPageMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyDefaultTabContextPermissionStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$,
        null,
        this.notifyDefaultTabContextPermissionStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestToShowCredentialSelectionDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$,
        WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$,
        this.requestToShowCredentialSelectionDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestToShowAutofillSuggestionsDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec.$,
        WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec.$,
        this.requestToShowAutofillSuggestionsDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestToShowUserConfirmationDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$,
        WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$,
        this.requestToShowUserConfirmationDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    this.requestToConfirmNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        WebClient_RequestToConfirmNavigation_ParamsSpec.$,
        WebClient_RequestToConfirmNavigation_ResponseParamsSpec.$,
        this.requestToConfirmNavigation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.notifyAdditionalContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        WebClient_NotifyAdditionalContext_ParamsSpec.$,
        null,
        this.notifyAdditionalContext.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyActuationOnWebSettingChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec.$,
        null,
        this.notifyActuationOnWebSettingChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyActOnWebCapabilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec.$,
        null,
        this.notifyActOnWebCapabilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CaptureRegionObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CaptureRegionObserverPendingReceiver>;

export class CaptureRegionObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CaptureRegionObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<CaptureRegionObserverPendingReceiver>;
  constructor(handle: MojoHandle|CaptureRegionObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'glic.mojom.CaptureRegionObserver',
        scope);
  }
}

export interface CaptureRegionObserverInterface {
  onUpdate(result: (CaptureRegionResult | null), reason: (CaptureRegionErrorReason | null)): void;
}

export class CaptureRegionObserverRemote implements CaptureRegionObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CaptureRegionObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CaptureRegionObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CaptureRegionObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CaptureRegionObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onUpdate(
      result: (CaptureRegionResult | null),
      reason: (CaptureRegionErrorReason | null)): void {
    this.proxy.sendMessage(
        0,
        CaptureRegionObserver_OnUpdate_ParamsSpec.$,
        null,
        [
          result,
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CaptureRegionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CaptureRegionObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CaptureRegionObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CaptureRegionObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CaptureRegionObserver_OnUpdate_ParamsSpec.$,
        null,
        impl.onUpdate.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CaptureRegionObserver {
  static get $interfaceName(): string {
    return "glic.mojom.CaptureRegionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CaptureRegionObserverRemote {
    let remote = new CaptureRegionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CaptureRegionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CaptureRegionObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CaptureRegionObserverRemote, CaptureRegionObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onUpdate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CaptureRegionObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CaptureRegionObserver_OnUpdate_ParamsSpec.$,
        null,
        this.onUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const GetContextResultWithActionResultCodeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UserProfileInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientInitialStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GetTabContextOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GetPinCandidatesOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScrollToParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScrollToTextSelectorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScrollToTextFragmentSelectorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScrollToNodeSelectorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SuggestionContentSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ZeroStateSuggestionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ZeroStateSuggestionsV2Spec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ZeroStateSuggestionsOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PinCandidateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ConversationInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PanelOpeningDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PanelStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OnResponseStoppedDetailsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OpenPanelInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ContextDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdditionalContextSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabContextSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebPageDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DocumentDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PdfDocumentDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NoFocusedTabDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AnnotatedPageDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ImageOriginAnnotationsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const JournalSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CaptureRegionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScreenshotSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const OpenSettingsOptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ViewChangeRequestActuationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ViewChangeRequestConversationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ViewChangeRequestSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ViewChangedNotificationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_IntentToShow_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetProfileReadyState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_UpdatePageState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CreateWebClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_PrepareForClient_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_PrepareForClient_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_WebviewCommitted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClosePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClosePanel_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SignInAndClosePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ResizeWidget_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ResizeWidget_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_EnableDragResize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_WebUiStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_WebClientCreated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_WebClientCreated_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_WebClientInitialized_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_WebClientInitializeFailed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OpenLinkInPopup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OpenGlicSettingsPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ClosePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ClosePanelAndShutdown_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_AttachPanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_DetachPanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnModeChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ShowProfilePicker_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetModelQualityClientId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetModelQualityClientId_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextFromFocusedTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextFromTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextFromTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextForActorFromTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PinTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PinTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_UnpinTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_UnpinTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_UnpinAllTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SubscribeToPinCandidates_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateTask_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PerformActions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PerformActions_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_StopActorTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PauseActorTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ResumeActorTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ResumeActorTask_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_InterruptActorTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_UninterruptActorTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateActorTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateActorTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ActivateTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ResizeWidget_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ResizeWidget_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CaptureScreenshot_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CaptureScreenshot_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CaptureRegion_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetAudioDucking_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetAudioDucking_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetPanelDraggableAreas_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetMinimumPanelSize_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetMicrophonePermissionState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetLocationPermissionState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetLocationPermissionState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetTabContextPermissionState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetClosedCaptioningSetting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetActuationOnWebSetting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetContextAccessIndicator_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetUserProfileInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetUserProfileInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SyncCookies_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SyncCookies_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_LogBeginAsyncEvent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_LogEndAsyncEvent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_LogInstantEvent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalClear_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalSnapshot_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalSnapshot_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalStart_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalStop_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_JournalRecordFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnUserInputSubmitted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnContextUploadStarted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnContextUploadCompleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnReaction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnResponseStarted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnResponseStopped_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnSessionTerminated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnTurnCompleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnModelChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnRecordUseCounter_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnResponseRated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnClosedCaptionsShown_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ScrollTo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_ScrollTo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_DropScrollToHighlight_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SetSyntheticExperimentState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_MaybeRefreshUserStatus_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_IsDebuggerAttached_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_IsDebuggerAttached_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_OnViewChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SubscribeToPageMetadata_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SwitchConversation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_SwitchConversation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_RegisterConversation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_RegisterConversation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelWillOpen_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelWillOpen_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelWasClosed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelWasClosed_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelStateChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelActiveChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPanelCanAttachChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyLocationPermissionStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyFocusedTabChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyManualResizeChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyOsHotkeyStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyBrowserIsOpenChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyInstanceActivationChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPinnedTabsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPinnedTabDataChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyActorTaskStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyTabDataChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestViewChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyPageMetadataChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowUserConfirmationDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToConfirmNavigation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_RequestToConfirmNavigation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyAdditionalContext_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CaptureRegionObserver_OnUpdate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GetContextResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CaptureScreenshotResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ScrollToSelectorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AdditionalContextPartSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const FocusedTabDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CapturedRegionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ViewChangeRequestDetailsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_CreateTask_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebClientHandler_PerformActions_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface GetContextResultWithActionResultCodeMojoType {
  getContextResult: GetContextResult;
  actionResult: (number | null);
}


export type GetContextResultWithActionResultCode = GetContextResultWithActionResultCodeMojoType;
mojo.internal.Struct<GetContextResultWithActionResultCodeMojoType>(
    GetContextResultWithActionResultCodeSpec.$,
    'GetContextResultWithActionResultCode',
    [
      mojo.internal.StructField<GetContextResultWithActionResultCodeMojoType, GetContextResult>(
        'getContextResult', 0,
        0,
        GetContextResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetContextResultWithActionResultCodeMojoType, boolean>(
        'action_result_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "action_result_$value",
          originalFieldName: "actionResult",
        },
        undefined,
    ),
      mojo.internal.StructField<GetContextResultWithActionResultCodeMojoType, number>(
        'action_result_$value', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "actionResult",
        },
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UserProfileInfoMojoType {
  avatarIcon: (skia_mojom_BitmapN32 | null);
  displayName: string;
  localProfileName: string;
  email: string;
  givenName: string;
  isManaged: boolean;
}


export type UserProfileInfo = UserProfileInfoMojoType;
mojo.internal.Struct<UserProfileInfoMojoType>(
    UserProfileInfoSpec.$,
    'UserProfileInfo',
    [
      mojo.internal.StructField<UserProfileInfoMojoType, skia_mojom_BitmapN32>(
        'avatarIcon', 0,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UserProfileInfoMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UserProfileInfoMojoType, string>(
        'localProfileName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UserProfileInfoMojoType, string>(
        'email', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UserProfileInfoMojoType, string>(
        'givenName', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UserProfileInfoMojoType, boolean>(
        'isManaged', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface WebClientInitialStateMojoType {
  panelState: PanelState;
  focusedTabData: FocusedTabData;
  microphonePermissionEnabled: boolean;
  locationPermissionEnabled: boolean;
  tabContextPermissionEnabled: boolean;
  osLocationPermissionEnabled: boolean;
  canAttach: boolean;
  panelIsActive: boolean;
  browserIsOpen: boolean;
  instanceIsActive: boolean;
  alwaysDetachedMode: boolean;
  enableZeroStateSuggestions: boolean;
  enableActInFocusedTab: boolean;
  enableScrollTo: boolean;
  enableDefaultTabContextSettingFeature: boolean;
  defaultTabContextSettingEnabled: boolean;
  enableClosedCaptioningFeature: boolean;
  closedCaptioningSettingEnabled: boolean;
  enableMaybeRefreshUserStatus: boolean;
  enableMultiTab: boolean;
  enableGetContextActor: boolean;
  enableGetPageMetadata: boolean;
  enableApiActivationGating: boolean;
  enableCaptureRegion: boolean;
  enableWebActuationSettingFeature: boolean;
  actuationOnWebSettingEnabled: boolean;
  canActOnWeb: boolean;
  enableActivateTab: boolean;
  enableGetTabById: boolean;
  enableOpenPasswordManagerSettingsPage: boolean;
  hotkey: string;
  chromeVersion: mojoBase_mojom_Version;
  hostCapabilities: HostCapability[];
}


export type WebClientInitialState = WebClientInitialStateMojoType;
mojo.internal.Struct<WebClientInitialStateMojoType>(
    WebClientInitialStateSpec.$,
    'WebClientInitialState',
    [
      mojo.internal.StructField<WebClientInitialStateMojoType, PanelState>(
        'panelState', 0,
        0,
        PanelStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, FocusedTabData>(
        'focusedTabData', 8,
        0,
        FocusedTabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'microphonePermissionEnabled', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'locationPermissionEnabled', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'tabContextPermissionEnabled', 24,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'osLocationPermissionEnabled', 24,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, string>(
        'hotkey', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, mojoBase_mojom_Version>(
        'chromeVersion', 40,
        0,
        mojoBase_mojom_VersionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'canAttach', 24,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'panelIsActive', 24,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'browserIsOpen', 24,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'instanceIsActive', 24,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'alwaysDetachedMode', 25,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableZeroStateSuggestions', 25,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableActInFocusedTab', 25,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableScrollTo', 25,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableDefaultTabContextSettingFeature', 25,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'defaultTabContextSettingEnabled', 25,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableClosedCaptioningFeature', 25,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'closedCaptioningSettingEnabled', 25,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableMaybeRefreshUserStatus', 26,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableMultiTab', 26,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableGetContextActor', 26,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, HostCapability[]>(
        'hostCapabilities', 48,
        0,
        mojo.internal.Array(HostCapabilitySpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableGetPageMetadata', 26,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableApiActivationGating', 26,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableCaptureRegion', 26,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableWebActuationSettingFeature', 26,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'actuationOnWebSettingEnabled', 26,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'canActOnWeb', 27,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableActivateTab', 27,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableGetTabById', 27,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientInitialStateMojoType, boolean>(
        'enableOpenPasswordManagerSettingsPage', 27,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface GetTabContextOptionsMojoType {
  includeInnerText: boolean;
  includeViewportScreenshot: boolean;
  includeAnnotatedPageContent: boolean;
  includePdf: boolean;
  innerTextBytesLimit: number;
  maxMetaTags: number;
  pdfSizeLimit: number;
  annotatedPageContentMode: number;
}


export type GetTabContextOptions = GetTabContextOptionsMojoType;
mojo.internal.Struct<GetTabContextOptionsMojoType>(
    GetTabContextOptionsSpec.$,
    'GetTabContextOptions',
    [
      mojo.internal.StructField<GetTabContextOptionsMojoType, boolean>(
        'includeInnerText', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, number>(
        'innerTextBytesLimit', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, boolean>(
        'includeViewportScreenshot', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, boolean>(
        'includeAnnotatedPageContent', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, number>(
        'maxMetaTags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, boolean>(
        'includePdf', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, number>(
        'pdfSizeLimit', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetTabContextOptionsMojoType, number>(
        'annotatedPageContentMode', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface GetPinCandidatesOptionsMojoType {
  maxCandidates: number;
  query: (string | null);
}


export type GetPinCandidatesOptions = GetPinCandidatesOptionsMojoType;
mojo.internal.Struct<GetPinCandidatesOptionsMojoType>(
    GetPinCandidatesOptionsSpec.$,
    'GetPinCandidatesOptions',
    [
      mojo.internal.StructField<GetPinCandidatesOptionsMojoType, number>(
        'maxCandidates', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GetPinCandidatesOptionsMojoType, string>(
        'query', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ScrollToParamsMojoType {
  selector: ScrollToSelector;
  highlight: boolean;
  documentId: (mojoBase_mojom_UnguessableToken | null);
  url: (url_mojom_Url | null);
}


export type ScrollToParams = ScrollToParamsMojoType;
mojo.internal.Struct<ScrollToParamsMojoType>(
    ScrollToParamsSpec.$,
    'ScrollToParams',
    [
      mojo.internal.StructField<ScrollToParamsMojoType, ScrollToSelector>(
        'selector', 0,
        0,
        ScrollToSelectorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToParamsMojoType, boolean>(
        'highlight', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'documentId', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToParamsMojoType, url_mojom_Url>(
        'url', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface ScrollToTextSelectorMojoType {
  text: string;
  searchRangeStartNodeId: (number | null);
}


export type ScrollToTextSelector = ScrollToTextSelectorMojoType;
mojo.internal.Struct<ScrollToTextSelectorMojoType>(
    ScrollToTextSelectorSpec.$,
    'ScrollToTextSelector',
    [
      mojo.internal.StructField<ScrollToTextSelectorMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToTextSelectorMojoType, boolean>(
        'search_range_start_node_id_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "search_range_start_node_id_$value",
          originalFieldName: "searchRangeStartNodeId",
        },
        undefined,
    ),
      mojo.internal.StructField<ScrollToTextSelectorMojoType, number>(
        'search_range_start_node_id_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "searchRangeStartNodeId",
        },
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ScrollToTextFragmentSelectorMojoType {
  textStart: string;
  textEnd: string;
  searchRangeStartNodeId: (number | null);
}


export type ScrollToTextFragmentSelector = ScrollToTextFragmentSelectorMojoType;
mojo.internal.Struct<ScrollToTextFragmentSelectorMojoType>(
    ScrollToTextFragmentSelectorSpec.$,
    'ScrollToTextFragmentSelector',
    [
      mojo.internal.StructField<ScrollToTextFragmentSelectorMojoType, string>(
        'textStart', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToTextFragmentSelectorMojoType, string>(
        'textEnd', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScrollToTextFragmentSelectorMojoType, boolean>(
        'search_range_start_node_id_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "search_range_start_node_id_$value",
          originalFieldName: "searchRangeStartNodeId",
        },
        undefined,
    ),
      mojo.internal.StructField<ScrollToTextFragmentSelectorMojoType, number>(
        'search_range_start_node_id_$value', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "searchRangeStartNodeId",
        },
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ScrollToNodeSelectorMojoType {
  nodeId: number;
}


export type ScrollToNodeSelector = ScrollToNodeSelectorMojoType;
mojo.internal.Struct<ScrollToNodeSelectorMojoType>(
    ScrollToNodeSelectorSpec.$,
    'ScrollToNodeSelector',
    [
      mojo.internal.StructField<ScrollToNodeSelectorMojoType, number>(
        'nodeId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SuggestionContentMojoType {
  suggestion: string;
}


export type SuggestionContent = SuggestionContentMojoType;
mojo.internal.Struct<SuggestionContentMojoType>(
    SuggestionContentSpec.$,
    'SuggestionContent',
    [
      mojo.internal.StructField<SuggestionContentMojoType, string>(
        'suggestion', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ZeroStateSuggestionsMojoType {
  suggestions: SuggestionContent[];
  tabId: number;
  tabUrl: url_mojom_Url;
}


export type ZeroStateSuggestions = ZeroStateSuggestionsMojoType;
mojo.internal.Struct<ZeroStateSuggestionsMojoType>(
    ZeroStateSuggestionsSpec.$,
    'ZeroStateSuggestions',
    [
      mojo.internal.StructField<ZeroStateSuggestionsMojoType, SuggestionContent[]>(
        'suggestions', 0,
        0,
        mojo.internal.Array(SuggestionContentSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ZeroStateSuggestionsMojoType, number>(
        'tabId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ZeroStateSuggestionsMojoType, url_mojom_Url>(
        'tabUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ZeroStateSuggestionsV2MojoType {
  suggestions: SuggestionContent[];
  isPending: boolean;
}


export type ZeroStateSuggestionsV2 = ZeroStateSuggestionsV2MojoType;
mojo.internal.Struct<ZeroStateSuggestionsV2MojoType>(
    ZeroStateSuggestionsV2Spec.$,
    'ZeroStateSuggestionsV2',
    [
      mojo.internal.StructField<ZeroStateSuggestionsV2MojoType, SuggestionContent[]>(
        'suggestions', 0,
        0,
        mojo.internal.Array(SuggestionContentSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ZeroStateSuggestionsV2MojoType, boolean>(
        'isPending', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ZeroStateSuggestionsOptionsMojoType {
  isFirstRun: boolean;
  supportedTools: string[];
}


export type ZeroStateSuggestionsOptions = ZeroStateSuggestionsOptionsMojoType;
mojo.internal.Struct<ZeroStateSuggestionsOptionsMojoType>(
    ZeroStateSuggestionsOptionsSpec.$,
    'ZeroStateSuggestionsOptions',
    [
      mojo.internal.StructField<ZeroStateSuggestionsOptionsMojoType, boolean>(
        'isFirstRun', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ZeroStateSuggestionsOptionsMojoType, string[]>(
        'supportedTools', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PinCandidateMojoType {
  tabData: TabData;
}


export type PinCandidate = PinCandidateMojoType;
mojo.internal.Struct<PinCandidateMojoType>(
    PinCandidateSpec.$,
    'PinCandidate',
    [
      mojo.internal.StructField<PinCandidateMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ConversationInfoMojoType {
  conversationId: string;
  conversationTitle: string;
}


export type ConversationInfo = ConversationInfoMojoType;
mojo.internal.Struct<ConversationInfoMojoType>(
    ConversationInfoSpec.$,
    'ConversationInfo',
    [
      mojo.internal.StructField<ConversationInfoMojoType, string>(
        'conversationId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ConversationInfoMojoType, string>(
        'conversationTitle', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PanelOpeningDataMojoType {
  panelState: PanelState;
  invocationSource: InvocationSource;
  conversationId: (string | null);
  promptSuggestion: (string | null);
  recentlyActiveConversations: (ConversationInfo[] | null);
}


export type PanelOpeningData = PanelOpeningDataMojoType;
mojo.internal.Struct<PanelOpeningDataMojoType>(
    PanelOpeningDataSpec.$,
    'PanelOpeningData',
    [
      mojo.internal.StructField<PanelOpeningDataMojoType, PanelState>(
        'panelState', 0,
        0,
        PanelStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PanelOpeningDataMojoType, InvocationSource>(
        'invocationSource', 8,
        0,
        InvocationSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PanelOpeningDataMojoType, string>(
        'conversationId', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PanelOpeningDataMojoType, string>(
        'promptSuggestion', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PanelOpeningDataMojoType, ConversationInfo[]>(
        'recentlyActiveConversations', 32,
        0,
        mojo.internal.Array(ConversationInfoSpec.$, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface PanelStateMojoType {
  kind: PanelStateKind;
  windowId: (number | null);
}


export type PanelState = PanelStateMojoType;
mojo.internal.Struct<PanelStateMojoType>(
    PanelStateSpec.$,
    'PanelState',
    [
      mojo.internal.StructField<PanelStateMojoType, PanelStateKind>(
        'kind', 0,
        0,
        PanelStateKindSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PanelStateMojoType, boolean>(
        'window_id_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "window_id_$value",
          originalFieldName: "windowId",
        },
        undefined,
    ),
      mojo.internal.StructField<PanelStateMojoType, number>(
        'window_id_$value', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "windowId",
        },
        undefined,
    ),
    ],
    [[0, 24],]);





export interface OnResponseStoppedDetailsMojoType {
  cause: ResponseStopCause;
}


export type OnResponseStoppedDetails = OnResponseStoppedDetailsMojoType;
mojo.internal.Struct<OnResponseStoppedDetailsMojoType>(
    OnResponseStoppedDetailsSpec.$,
    'OnResponseStoppedDetails',
    [
      mojo.internal.StructField<OnResponseStoppedDetailsMojoType, ResponseStopCause>(
        'cause', 0,
        0,
        ResponseStopCauseSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface OpenPanelInfoMojoType {
  webClientMode: WebClientMode;
  canUserResize: boolean;
  panelSize: (gfx_mojom_Size | null);
  resizeDuration: mojoBase_mojom_TimeDelta;
}


export type OpenPanelInfo = OpenPanelInfoMojoType;
mojo.internal.Struct<OpenPanelInfoMojoType>(
    OpenPanelInfoSpec.$,
    'OpenPanelInfo',
    [
      mojo.internal.StructField<OpenPanelInfoMojoType, WebClientMode>(
        'webClientMode', 0,
        0,
        WebClientModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenPanelInfoMojoType, gfx_mojom_Size>(
        'panelSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenPanelInfoMojoType, mojoBase_mojom_TimeDelta>(
        'resizeDuration', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OpenPanelInfoMojoType, boolean>(
        'canUserResize', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ContextDataMojoType {
  mimeType: string;
  data: mojoBase_mojom_BigBuffer;
}


export type ContextData = ContextDataMojoType;
mojo.internal.Struct<ContextDataMojoType>(
    ContextDataSpec.$,
    'ContextData',
    [
      mojo.internal.StructField<ContextDataMojoType, string>(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ContextDataMojoType, mojoBase_mojom_BigBuffer>(
        'data', 8,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface AdditionalContextMojoType {
  name: (string | null);
  tabId: (number | null);
  origin: (url_mojom_Origin | null);
  frameUrl: (url_mojom_Url | null);
  parts: AdditionalContextPart[];
}


export type AdditionalContext = AdditionalContextMojoType;
mojo.internal.Struct<AdditionalContextMojoType>(
    AdditionalContextSpec.$,
    'AdditionalContext',
    [
      mojo.internal.StructField<AdditionalContextMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdditionalContextMojoType, boolean>(
        'tab_id_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "tab_id_$value",
          originalFieldName: "tabId",
        },
        undefined,
    ),
      mojo.internal.StructField<AdditionalContextMojoType, number>(
        'tab_id_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "tabId",
        },
        undefined,
    ),
      mojo.internal.StructField<AdditionalContextMojoType, url_mojom_Origin>(
        'origin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdditionalContextMojoType, url_mojom_Url>(
        'frameUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AdditionalContextMojoType, AdditionalContextPart[]>(
        'parts', 32,
        0,
        mojo.internal.Array(AdditionalContextPartSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface TabContextMojoType {
  tabData: TabData;
  webPageData: (WebPageData | null);
  viewportScreenshot: (Screenshot | null);
  pdfDocumentData: (PdfDocumentData | null);
  annotatedPageData: (AnnotatedPageData | null);
}


export type TabContext = TabContextMojoType;
mojo.internal.Struct<TabContextMojoType>(
    TabContextSpec.$,
    'TabContext',
    [
      mojo.internal.StructField<TabContextMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabContextMojoType, WebPageData>(
        'webPageData', 8,
        0,
        WebPageDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabContextMojoType, Screenshot>(
        'viewportScreenshot', 16,
        0,
        ScreenshotSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabContextMojoType, PdfDocumentData>(
        'pdfDocumentData', 24,
        0,
        PdfDocumentDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabContextMojoType, AnnotatedPageData>(
        'annotatedPageData', 32,
        0,
        AnnotatedPageDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface WebPageDataMojoType {
  mainDocument: DocumentData;
}


export type WebPageData = WebPageDataMojoType;
mojo.internal.Struct<WebPageDataMojoType>(
    WebPageDataSpec.$,
    'WebPageData',
    [
      mojo.internal.StructField<WebPageDataMojoType, DocumentData>(
        'mainDocument', 0,
        0,
        DocumentDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface DocumentDataMojoType {
  origin: url_mojom_Origin;
  innerText: string;
  innerTextTruncated: boolean;
}


export type DocumentData = DocumentDataMojoType;
mojo.internal.Struct<DocumentDataMojoType>(
    DocumentDataSpec.$,
    'DocumentData',
    [
      mojo.internal.StructField<DocumentDataMojoType, url_mojom_Origin>(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DocumentDataMojoType, string>(
        'innerText', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DocumentDataMojoType, boolean>(
        'innerTextTruncated', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PdfDocumentDataMojoType {
  origin: url_mojom_Origin;
  pdfData: (number[] | null);
  sizeLimitExceeded: boolean;
}


export type PdfDocumentData = PdfDocumentDataMojoType;
mojo.internal.Struct<PdfDocumentDataMojoType>(
    PdfDocumentDataSpec.$,
    'PdfDocumentData',
    [
      mojo.internal.StructField<PdfDocumentDataMojoType, url_mojom_Origin>(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PdfDocumentDataMojoType, number[]>(
        'pdfData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PdfDocumentDataMojoType, boolean>(
        'sizeLimitExceeded', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface TabDataMojoType {
  tabId: number;
  windowId: number;
  url: url_mojom_Url;
  title: (string | null);
  favicon: (skia_mojom_BitmapN32 | null);
  faviconUrl: (url_mojom_Url | null);
  documentMimeType: string;
  isObservable: (boolean | null);
  isMediaActive: (boolean | null);
  isTabContentCaptured: (boolean | null);
  isActiveInWindow: (boolean | null);
  isWindowActive: (boolean | null);
}


export type TabData = TabDataMojoType;
mojo.internal.Struct<TabDataMojoType>(
    TabDataSpec.$,
    'TabData',
    [
      mojo.internal.StructField<TabDataMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, number>(
        'windowId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, string>(
        'title', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, skia_mojom_BitmapN32>(
        'favicon', 24,
        0,
        skia_mojom_BitmapN32Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, url_mojom_Url>(
        'faviconUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, string>(
        'documentMimeType', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_observable_$flag', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_observable_$value",
          originalFieldName: "isObservable",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_observable_$value', 48,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isObservable",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_media_active_$flag', 48,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_media_active_$value",
          originalFieldName: "isMediaActive",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_media_active_$value', 48,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isMediaActive",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_tab_content_captured_$flag', 48,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_tab_content_captured_$value",
          originalFieldName: "isTabContentCaptured",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_tab_content_captured_$value', 48,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isTabContentCaptured",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_active_in_window_$flag', 48,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_active_in_window_$value",
          originalFieldName: "isActiveInWindow",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_active_in_window_$value', 48,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isActiveInWindow",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_window_active_$flag', 49,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_window_active_$value",
          originalFieldName: "isWindowActive",
        },
        undefined,
    ),
      mojo.internal.StructField<TabDataMojoType, boolean>(
        'is_window_active_$value', 49,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isWindowActive",
        },
        undefined,
    ),
    ],
    [[0, 64],]);





export interface NoFocusedTabDataMojoType {
  activeTabData: (TabData | null);
  noFocusReason: string;
}


export type NoFocusedTabData = NoFocusedTabDataMojoType;
mojo.internal.Struct<NoFocusedTabDataMojoType>(
    NoFocusedTabDataSpec.$,
    'NoFocusedTabData',
    [
      mojo.internal.StructField<NoFocusedTabDataMojoType, TabData>(
        'activeTabData', 0,
        0,
        TabDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NoFocusedTabDataMojoType, string>(
        'noFocusReason', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface AnnotatedPageDataMojoType {
  annotatedPageContent: (mojoBase_mojom_ProtoWrapper | null);
  metadata: (blink_mojom_PageMetadata | null);
}


export type AnnotatedPageData = AnnotatedPageDataMojoType;
mojo.internal.Struct<AnnotatedPageDataMojoType>(
    AnnotatedPageDataSpec.$,
    'AnnotatedPageData',
    [
      mojo.internal.StructField<AnnotatedPageDataMojoType, mojoBase_mojom_ProtoWrapper>(
        'annotatedPageContent', 0,
        0,
        mojoBase_mojom_ProtoWrapperSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AnnotatedPageDataMojoType, blink_mojom_PageMetadata>(
        'metadata', 8,
        0,
        blink_mojom_PageMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ImageOriginAnnotationsMojoType {
}


export type ImageOriginAnnotations = ImageOriginAnnotationsMojoType;
mojo.internal.Struct<ImageOriginAnnotationsMojoType>(
    ImageOriginAnnotationsSpec.$,
    'ImageOriginAnnotations',
    [
    ],
    [[0, 8],]);





export interface JournalMojoType {
  data: number[];
}


export type Journal = JournalMojoType;
mojo.internal.Struct<JournalMojoType>(
    JournalSpec.$,
    'Journal',
    [
      mojo.internal.StructField<JournalMojoType, number[]>(
        'data', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CaptureRegionResultMojoType {
  tabId: number;
  region: CapturedRegion;
}


export type CaptureRegionResult = CaptureRegionResultMojoType;
mojo.internal.Struct<CaptureRegionResultMojoType>(
    CaptureRegionResultSpec.$,
    'CaptureRegionResult',
    [
      mojo.internal.StructField<CaptureRegionResultMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CaptureRegionResultMojoType, CapturedRegion>(
        'region', 8,
        0,
        CapturedRegionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ScreenshotMojoType {
  widthPixels: number;
  heightPixels: number;
  data: number[];
  mimeType: string;
  originAnnotations: ImageOriginAnnotations;
}


export type Screenshot = ScreenshotMojoType;
mojo.internal.Struct<ScreenshotMojoType>(
    ScreenshotSpec.$,
    'Screenshot',
    [
      mojo.internal.StructField<ScreenshotMojoType, number>(
        'widthPixels', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScreenshotMojoType, number>(
        'heightPixels', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScreenshotMojoType, number[]>(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScreenshotMojoType, string>(
        'mimeType', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ScreenshotMojoType, ImageOriginAnnotations>(
        'originAnnotations', 24,
        0,
        ImageOriginAnnotationsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface OpenSettingsOptionsMojoType {
  highlightField: SettingsPageField;
}


export type OpenSettingsOptions = OpenSettingsOptionsMojoType;
mojo.internal.Struct<OpenSettingsOptionsMojoType>(
    OpenSettingsOptionsSpec.$,
    'OpenSettingsOptions',
    [
      mojo.internal.StructField<OpenSettingsOptionsMojoType, SettingsPageField>(
        'highlightField', 0,
        0,
        SettingsPageFieldSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ViewChangeRequestActuationMojoType {
}


export type ViewChangeRequestActuation = ViewChangeRequestActuationMojoType;
mojo.internal.Struct<ViewChangeRequestActuationMojoType>(
    ViewChangeRequestActuationSpec.$,
    'ViewChangeRequestActuation',
    [
    ],
    [[0, 8],]);





export interface ViewChangeRequestConversationMojoType {
}


export type ViewChangeRequestConversation = ViewChangeRequestConversationMojoType;
mojo.internal.Struct<ViewChangeRequestConversationMojoType>(
    ViewChangeRequestConversationSpec.$,
    'ViewChangeRequestConversation',
    [
    ],
    [[0, 8],]);





export interface ViewChangeRequestMojoType {
  details: ViewChangeRequestDetails;
}


export type ViewChangeRequest = ViewChangeRequestMojoType;
mojo.internal.Struct<ViewChangeRequestMojoType>(
    ViewChangeRequestSpec.$,
    'ViewChangeRequest',
    [
      mojo.internal.StructField<ViewChangeRequestMojoType, ViewChangeRequestDetails>(
        'details', 0,
        0,
        ViewChangeRequestDetailsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ViewChangedNotificationMojoType {
  currentView: CurrentView;
}


export type ViewChangedNotification = ViewChangedNotificationMojoType;
mojo.internal.Struct<ViewChangedNotificationMojoType>(
    ViewChangedNotificationSpec.$,
    'ViewChangedNotification',
    [
      mojo.internal.StructField<ViewChangedNotificationMojoType, CurrentView>(
        'currentView', 0,
        0,
        CurrentViewSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_IntentToShow_ParamsMojoType {
}


export type Page_IntentToShow_Params = Page_IntentToShow_ParamsMojoType;
mojo.internal.Struct<Page_IntentToShow_ParamsMojoType>(
    Page_IntentToShow_ParamsSpec.$,
    'Page_IntentToShow_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SetProfileReadyState_ParamsMojoType {
  readyState: ProfileReadyState;
}


export type Page_SetProfileReadyState_Params = Page_SetProfileReadyState_ParamsMojoType;
mojo.internal.Struct<Page_SetProfileReadyState_ParamsMojoType>(
    Page_SetProfileReadyState_ParamsSpec.$,
    'Page_SetProfileReadyState_Params',
    [
      mojo.internal.StructField<Page_SetProfileReadyState_ParamsMojoType, ProfileReadyState>(
        'readyState', 0,
        0,
        ProfileReadyStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_UpdatePageState_ParamsMojoType {
  panelStateKind: PanelStateKind;
}


export type Page_UpdatePageState_Params = Page_UpdatePageState_ParamsMojoType;
mojo.internal.Struct<Page_UpdatePageState_ParamsMojoType>(
    Page_UpdatePageState_ParamsSpec.$,
    'Page_UpdatePageState_Params',
    [
      mojo.internal.StructField<Page_UpdatePageState_ParamsMojoType, PanelStateKind>(
        'panelStateKind', 0,
        0,
        PanelStateKindSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  receiver: PageHandlerPendingReceiver;
  page: PageRemote;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 4,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_CreateWebClient_ParamsMojoType {
  webClientReceiver: WebClientHandlerPendingReceiver;
}


export type PageHandler_CreateWebClient_Params = PageHandler_CreateWebClient_ParamsMojoType;
mojo.internal.Struct<PageHandler_CreateWebClient_ParamsMojoType>(
    PageHandler_CreateWebClient_ParamsSpec.$,
    'PageHandler_CreateWebClient_Params',
    [
      mojo.internal.StructField<PageHandler_CreateWebClient_ParamsMojoType, WebClientHandlerPendingReceiver>(
        'webClientReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(WebClientHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_PrepareForClient_ParamsMojoType {
}


export type PageHandler_PrepareForClient_Params = PageHandler_PrepareForClient_ParamsMojoType;
mojo.internal.Struct<PageHandler_PrepareForClient_ParamsMojoType>(
    PageHandler_PrepareForClient_ParamsSpec.$,
    'PageHandler_PrepareForClient_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_PrepareForClient_ResponseParamsMojoType {
  result: PrepareForClientResult;
}


export type PageHandler_PrepareForClient_ResponseParams = PageHandler_PrepareForClient_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_PrepareForClient_ResponseParamsMojoType>(
    PageHandler_PrepareForClient_ResponseParamsSpec.$,
    'PageHandler_PrepareForClient_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_PrepareForClient_ResponseParamsMojoType, PrepareForClientResult>(
        'result', 0,
        0,
        PrepareForClientResultSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_WebviewCommitted_ParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_WebviewCommitted_Params = PageHandler_WebviewCommitted_ParamsMojoType;
mojo.internal.Struct<PageHandler_WebviewCommitted_ParamsMojoType>(
    PageHandler_WebviewCommitted_ParamsSpec.$,
    'PageHandler_WebviewCommitted_Params',
    [
      mojo.internal.StructField<PageHandler_WebviewCommitted_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ClosePanel_ParamsMojoType {
}


export type PageHandler_ClosePanel_Params = PageHandler_ClosePanel_ParamsMojoType;
mojo.internal.Struct<PageHandler_ClosePanel_ParamsMojoType>(
    PageHandler_ClosePanel_ParamsSpec.$,
    'PageHandler_ClosePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ClosePanel_ResponseParamsMojoType {
}


export type PageHandler_ClosePanel_ResponseParams = PageHandler_ClosePanel_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ClosePanel_ResponseParamsMojoType>(
    PageHandler_ClosePanel_ResponseParamsSpec.$,
    'PageHandler_ClosePanel_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenProfilePickerAndClosePanel_ParamsMojoType {
}


export type PageHandler_OpenProfilePickerAndClosePanel_Params = PageHandler_OpenProfilePickerAndClosePanel_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenProfilePickerAndClosePanel_ParamsMojoType>(
    PageHandler_OpenProfilePickerAndClosePanel_ParamsSpec.$,
    'PageHandler_OpenProfilePickerAndClosePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsMojoType {
}


export type PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params = PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsMojoType>(
    PageHandler_OpenDisabledByAdminLinkAndClosePanel_ParamsSpec.$,
    'PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_SignInAndClosePanel_ParamsMojoType {
}


export type PageHandler_SignInAndClosePanel_Params = PageHandler_SignInAndClosePanel_ParamsMojoType;
mojo.internal.Struct<PageHandler_SignInAndClosePanel_ParamsMojoType>(
    PageHandler_SignInAndClosePanel_ParamsSpec.$,
    'PageHandler_SignInAndClosePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ResizeWidget_ParamsMojoType {
  size: gfx_mojom_Size;
  duration: mojoBase_mojom_TimeDelta;
}


export type PageHandler_ResizeWidget_Params = PageHandler_ResizeWidget_ParamsMojoType;
mojo.internal.Struct<PageHandler_ResizeWidget_ParamsMojoType>(
    PageHandler_ResizeWidget_ParamsSpec.$,
    'PageHandler_ResizeWidget_Params',
    [
      mojo.internal.StructField<PageHandler_ResizeWidget_ParamsMojoType, gfx_mojom_Size>(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ResizeWidget_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ResizeWidget_ResponseParamsMojoType {
}


export type PageHandler_ResizeWidget_ResponseParams = PageHandler_ResizeWidget_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ResizeWidget_ResponseParamsMojoType>(
    PageHandler_ResizeWidget_ResponseParamsSpec.$,
    'PageHandler_ResizeWidget_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface PageHandler_EnableDragResize_ParamsMojoType {
  enabled: boolean;
}


export type PageHandler_EnableDragResize_Params = PageHandler_EnableDragResize_ParamsMojoType;
mojo.internal.Struct<PageHandler_EnableDragResize_ParamsMojoType>(
    PageHandler_EnableDragResize_ParamsSpec.$,
    'PageHandler_EnableDragResize_Params',
    [
      mojo.internal.StructField<PageHandler_EnableDragResize_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_WebUiStateChanged_ParamsMojoType {
  newState: WebUiState;
}


export type PageHandler_WebUiStateChanged_Params = PageHandler_WebUiStateChanged_ParamsMojoType;
mojo.internal.Struct<PageHandler_WebUiStateChanged_ParamsMojoType>(
    PageHandler_WebUiStateChanged_ParamsSpec.$,
    'PageHandler_WebUiStateChanged_Params',
    [
      mojo.internal.StructField<PageHandler_WebUiStateChanged_ParamsMojoType, WebUiState>(
        'newState', 0,
        0,
        WebUiStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType {
  candidates: PinCandidate[];
}


export type PinCandidatesObserver_OnPinCandidatesChanged_Params = PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType;
mojo.internal.Struct<PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType>(
    PinCandidatesObserver_OnPinCandidatesChanged_ParamsSpec.$,
    'PinCandidatesObserver_OnPinCandidatesChanged_Params',
    [
      mojo.internal.StructField<PinCandidatesObserver_OnPinCandidatesChanged_ParamsMojoType, PinCandidate[]>(
        'candidates', 0,
        0,
        mojo.internal.Array(PinCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_WebClientCreated_ParamsMojoType {
  webClient: WebClientRemote;
}


export type WebClientHandler_WebClientCreated_Params = WebClientHandler_WebClientCreated_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_WebClientCreated_ParamsMojoType>(
    WebClientHandler_WebClientCreated_ParamsSpec.$,
    'WebClientHandler_WebClientCreated_Params',
    [
      mojo.internal.StructField<WebClientHandler_WebClientCreated_ParamsMojoType, WebClientRemote>(
        'webClient', 0,
        0,
        mojo.internal.InterfaceProxy(WebClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_WebClientCreated_ResponseParamsMojoType {
  initialState: WebClientInitialState;
}


export type WebClientHandler_WebClientCreated_ResponseParams = WebClientHandler_WebClientCreated_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_WebClientCreated_ResponseParamsMojoType>(
    WebClientHandler_WebClientCreated_ResponseParamsSpec.$,
    'WebClientHandler_WebClientCreated_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_WebClientCreated_ResponseParamsMojoType, WebClientInitialState>(
        'initialState', 0,
        0,
        WebClientInitialStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_WebClientInitialized_ParamsMojoType {
}


export type WebClientHandler_WebClientInitialized_Params = WebClientHandler_WebClientInitialized_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_WebClientInitialized_ParamsMojoType>(
    WebClientHandler_WebClientInitialized_ParamsSpec.$,
    'WebClientHandler_WebClientInitialized_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_WebClientInitializeFailed_ParamsMojoType {
}


export type WebClientHandler_WebClientInitializeFailed_Params = WebClientHandler_WebClientInitializeFailed_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_WebClientInitializeFailed_ParamsMojoType>(
    WebClientHandler_WebClientInitializeFailed_ParamsSpec.$,
    'WebClientHandler_WebClientInitializeFailed_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_CreateTab_ParamsMojoType {
  url: url_mojom_Url;
  openInBackground: boolean;
  windowId: (number | null);
}


export type WebClientHandler_CreateTab_Params = WebClientHandler_CreateTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateTab_ParamsMojoType>(
    WebClientHandler_CreateTab_ParamsSpec.$,
    'WebClientHandler_CreateTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_CreateTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateTab_ParamsMojoType, boolean>(
        'openInBackground', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateTab_ParamsMojoType, boolean>(
        'window_id_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "window_id_$value",
          originalFieldName: "windowId",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateTab_ParamsMojoType, number>(
        'window_id_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "windowId",
        },
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_CreateTab_ResponseParamsMojoType {
  tabData: (TabData | null);
}


export type WebClientHandler_CreateTab_ResponseParams = WebClientHandler_CreateTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateTab_ResponseParamsMojoType>(
    WebClientHandler_CreateTab_ResponseParamsSpec.$,
    'WebClientHandler_CreateTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_CreateTab_ResponseParamsMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OpenLinkInPopup_ParamsMojoType {
  url: url_mojom_Url;
  popupWidth: number;
  popupHeight: number;
}


export type WebClientHandler_OpenLinkInPopup_Params = WebClientHandler_OpenLinkInPopup_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OpenLinkInPopup_ParamsMojoType>(
    WebClientHandler_OpenLinkInPopup_ParamsSpec.$,
    'WebClientHandler_OpenLinkInPopup_Params',
    [
      mojo.internal.StructField<WebClientHandler_OpenLinkInPopup_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_OpenLinkInPopup_ParamsMojoType, number>(
        'popupWidth', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_OpenLinkInPopup_ParamsMojoType, number>(
        'popupHeight', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_OpenGlicSettingsPage_ParamsMojoType {
  options: OpenSettingsOptions;
}


export type WebClientHandler_OpenGlicSettingsPage_Params = WebClientHandler_OpenGlicSettingsPage_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OpenGlicSettingsPage_ParamsMojoType>(
    WebClientHandler_OpenGlicSettingsPage_ParamsSpec.$,
    'WebClientHandler_OpenGlicSettingsPage_Params',
    [
      mojo.internal.StructField<WebClientHandler_OpenGlicSettingsPage_ParamsMojoType, OpenSettingsOptions>(
        'options', 0,
        0,
        OpenSettingsOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OpenPasswordManagerSettingsPage_ParamsMojoType {
}


export type WebClientHandler_OpenPasswordManagerSettingsPage_Params = WebClientHandler_OpenPasswordManagerSettingsPage_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OpenPasswordManagerSettingsPage_ParamsMojoType>(
    WebClientHandler_OpenPasswordManagerSettingsPage_ParamsSpec.$,
    'WebClientHandler_OpenPasswordManagerSettingsPage_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ClosePanel_ParamsMojoType {
}


export type WebClientHandler_ClosePanel_Params = WebClientHandler_ClosePanel_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ClosePanel_ParamsMojoType>(
    WebClientHandler_ClosePanel_ParamsSpec.$,
    'WebClientHandler_ClosePanel_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ClosePanelAndShutdown_ParamsMojoType {
}


export type WebClientHandler_ClosePanelAndShutdown_Params = WebClientHandler_ClosePanelAndShutdown_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ClosePanelAndShutdown_ParamsMojoType>(
    WebClientHandler_ClosePanelAndShutdown_ParamsSpec.$,
    'WebClientHandler_ClosePanelAndShutdown_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_AttachPanel_ParamsMojoType {
}


export type WebClientHandler_AttachPanel_Params = WebClientHandler_AttachPanel_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_AttachPanel_ParamsMojoType>(
    WebClientHandler_AttachPanel_ParamsSpec.$,
    'WebClientHandler_AttachPanel_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_DetachPanel_ParamsMojoType {
}


export type WebClientHandler_DetachPanel_Params = WebClientHandler_DetachPanel_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_DetachPanel_ParamsMojoType>(
    WebClientHandler_DetachPanel_ParamsSpec.$,
    'WebClientHandler_DetachPanel_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_OnModeChange_ParamsMojoType {
  newMode: WebClientMode;
}


export type WebClientHandler_OnModeChange_Params = WebClientHandler_OnModeChange_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnModeChange_ParamsMojoType>(
    WebClientHandler_OnModeChange_ParamsSpec.$,
    'WebClientHandler_OnModeChange_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnModeChange_ParamsMojoType, WebClientMode>(
        'newMode', 0,
        0,
        WebClientModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_ShowProfilePicker_ParamsMojoType {
}


export type WebClientHandler_ShowProfilePicker_Params = WebClientHandler_ShowProfilePicker_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ShowProfilePicker_ParamsMojoType>(
    WebClientHandler_ShowProfilePicker_ParamsSpec.$,
    'WebClientHandler_ShowProfilePicker_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_GetModelQualityClientId_ParamsMojoType {
}


export type WebClientHandler_GetModelQualityClientId_Params = WebClientHandler_GetModelQualityClientId_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetModelQualityClientId_ParamsMojoType>(
    WebClientHandler_GetModelQualityClientId_ParamsSpec.$,
    'WebClientHandler_GetModelQualityClientId_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType {
  modelQualityClientId: string;
}


export type WebClientHandler_GetModelQualityClientId_ResponseParams = WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType>(
    WebClientHandler_GetModelQualityClientId_ResponseParamsSpec.$,
    'WebClientHandler_GetModelQualityClientId_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetModelQualityClientId_ResponseParamsMojoType, string>(
        'modelQualityClientId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetContextFromFocusedTab_ParamsMojoType {
  options: GetTabContextOptions;
}


export type WebClientHandler_GetContextFromFocusedTab_Params = WebClientHandler_GetContextFromFocusedTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextFromFocusedTab_ParamsMojoType>(
    WebClientHandler_GetContextFromFocusedTab_ParamsSpec.$,
    'WebClientHandler_GetContextFromFocusedTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_GetContextFromFocusedTab_ParamsMojoType, GetTabContextOptions>(
        'options', 0,
        0,
        GetTabContextOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType {
  result: GetContextResult;
}


export type WebClientHandler_GetContextFromFocusedTab_ResponseParams = WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType>(
    WebClientHandler_GetContextFromFocusedTab_ResponseParamsSpec.$,
    'WebClientHandler_GetContextFromFocusedTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetContextFromFocusedTab_ResponseParamsMojoType, GetContextResult>(
        'result', 0,
        0,
        GetContextResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_GetContextFromTab_ParamsMojoType {
  tabId: number;
  options: GetTabContextOptions;
}


export type WebClientHandler_GetContextFromTab_Params = WebClientHandler_GetContextFromTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextFromTab_ParamsMojoType>(
    WebClientHandler_GetContextFromTab_ParamsSpec.$,
    'WebClientHandler_GetContextFromTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_GetContextFromTab_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_GetContextFromTab_ParamsMojoType, GetTabContextOptions>(
        'options', 8,
        0,
        GetTabContextOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_GetContextFromTab_ResponseParamsMojoType {
  result: GetContextResult;
}


export type WebClientHandler_GetContextFromTab_ResponseParams = WebClientHandler_GetContextFromTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextFromTab_ResponseParamsMojoType>(
    WebClientHandler_GetContextFromTab_ResponseParamsSpec.$,
    'WebClientHandler_GetContextFromTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetContextFromTab_ResponseParamsMojoType, GetContextResult>(
        'result', 0,
        0,
        GetContextResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_GetContextForActorFromTab_ParamsMojoType {
  tabId: number;
  options: GetTabContextOptions;
}


export type WebClientHandler_GetContextForActorFromTab_Params = WebClientHandler_GetContextForActorFromTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextForActorFromTab_ParamsMojoType>(
    WebClientHandler_GetContextForActorFromTab_ParamsSpec.$,
    'WebClientHandler_GetContextForActorFromTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_GetContextForActorFromTab_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_GetContextForActorFromTab_ParamsMojoType, GetTabContextOptions>(
        'options', 8,
        0,
        GetTabContextOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType {
  result: GetContextResult;
}


export type WebClientHandler_GetContextForActorFromTab_ResponseParams = WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType>(
    WebClientHandler_GetContextForActorFromTab_ResponseParamsSpec.$,
    'WebClientHandler_GetContextForActorFromTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetContextForActorFromTab_ResponseParamsMojoType, GetContextResult>(
        'result', 0,
        0,
        GetContextResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType {
  requestedMax: number;
}


export type WebClientHandler_SetMaximumNumberOfPinnedTabs_Params = WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType>(
    WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsSpec.$,
    'WebClientHandler_SetMaximumNumberOfPinnedTabs_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetMaximumNumberOfPinnedTabs_ParamsMojoType, number>(
        'requestedMax', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType {
  effectiveMax: number;
}


export type WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams = WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType>(
    WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsSpec.$,
    'WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParamsMojoType, number>(
        'effectiveMax', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_PinTabs_ParamsMojoType {
  tabIds: number[];
}


export type WebClientHandler_PinTabs_Params = WebClientHandler_PinTabs_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_PinTabs_ParamsMojoType>(
    WebClientHandler_PinTabs_ParamsSpec.$,
    'WebClientHandler_PinTabs_Params',
    [
      mojo.internal.StructField<WebClientHandler_PinTabs_ParamsMojoType, number[]>(
        'tabIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_PinTabs_ResponseParamsMojoType {
  pinnedAll: boolean;
}


export type WebClientHandler_PinTabs_ResponseParams = WebClientHandler_PinTabs_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_PinTabs_ResponseParamsMojoType>(
    WebClientHandler_PinTabs_ResponseParamsSpec.$,
    'WebClientHandler_PinTabs_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_PinTabs_ResponseParamsMojoType, boolean>(
        'pinnedAll', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_UnpinTabs_ParamsMojoType {
  tabIds: number[];
}


export type WebClientHandler_UnpinTabs_Params = WebClientHandler_UnpinTabs_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_UnpinTabs_ParamsMojoType>(
    WebClientHandler_UnpinTabs_ParamsSpec.$,
    'WebClientHandler_UnpinTabs_Params',
    [
      mojo.internal.StructField<WebClientHandler_UnpinTabs_ParamsMojoType, number[]>(
        'tabIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_UnpinTabs_ResponseParamsMojoType {
  unpinnedAll: boolean;
}


export type WebClientHandler_UnpinTabs_ResponseParams = WebClientHandler_UnpinTabs_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_UnpinTabs_ResponseParamsMojoType>(
    WebClientHandler_UnpinTabs_ResponseParamsSpec.$,
    'WebClientHandler_UnpinTabs_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_UnpinTabs_ResponseParamsMojoType, boolean>(
        'unpinnedAll', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_UnpinAllTabs_ParamsMojoType {
}


export type WebClientHandler_UnpinAllTabs_Params = WebClientHandler_UnpinAllTabs_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_UnpinAllTabs_ParamsMojoType>(
    WebClientHandler_UnpinAllTabs_ParamsSpec.$,
    'WebClientHandler_UnpinAllTabs_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SubscribeToPinCandidates_ParamsMojoType {
  options: GetPinCandidatesOptions;
  observer: PinCandidatesObserverRemote;
}


export type WebClientHandler_SubscribeToPinCandidates_Params = WebClientHandler_SubscribeToPinCandidates_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SubscribeToPinCandidates_ParamsMojoType>(
    WebClientHandler_SubscribeToPinCandidates_ParamsSpec.$,
    'WebClientHandler_SubscribeToPinCandidates_Params',
    [
      mojo.internal.StructField<WebClientHandler_SubscribeToPinCandidates_ParamsMojoType, GetPinCandidatesOptions>(
        'options', 0,
        0,
        GetPinCandidatesOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_SubscribeToPinCandidates_ParamsMojoType, PinCandidatesObserverRemote>(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(PinCandidatesObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_CreateTask_ParamsMojoType {
  taskOptions: (actor_webui_mojom_TaskOptions | null);
}


export type WebClientHandler_CreateTask_Params = WebClientHandler_CreateTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateTask_ParamsMojoType>(
    WebClientHandler_CreateTask_ParamsSpec.$,
    'WebClientHandler_CreateTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_CreateTask_ParamsMojoType, actor_webui_mojom_TaskOptions>(
        'taskOptions', 0,
        0,
        actor_webui_mojom_TaskOptionsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_CreateTask_ResponseParamsMojoType {
  result: WebClientHandler_CreateTask_ResponseParam_Result;
}


export type WebClientHandler_CreateTask_ResponseParams = WebClientHandler_CreateTask_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateTask_ResponseParamsMojoType>(
    WebClientHandler_CreateTask_ResponseParamsSpec.$,
    'WebClientHandler_CreateTask_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_CreateTask_ResponseParamsMojoType, WebClientHandler_CreateTask_ResponseParam_Result>(
        'result', 0,
        0,
        WebClientHandler_CreateTask_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_PerformActions_ParamsMojoType {
  actionsProto: number[];
}


export type WebClientHandler_PerformActions_Params = WebClientHandler_PerformActions_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_PerformActions_ParamsMojoType>(
    WebClientHandler_PerformActions_ParamsSpec.$,
    'WebClientHandler_PerformActions_Params',
    [
      mojo.internal.StructField<WebClientHandler_PerformActions_ParamsMojoType, number[]>(
        'actionsProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_PerformActions_ResponseParamsMojoType {
  result: WebClientHandler_PerformActions_ResponseParam_Result;
}


export type WebClientHandler_PerformActions_ResponseParams = WebClientHandler_PerformActions_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_PerformActions_ResponseParamsMojoType>(
    WebClientHandler_PerformActions_ResponseParamsSpec.$,
    'WebClientHandler_PerformActions_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_PerformActions_ResponseParamsMojoType, WebClientHandler_PerformActions_ResponseParam_Result>(
        'result', 0,
        0,
        WebClientHandler_PerformActions_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_StopActorTask_ParamsMojoType {
  taskId: number;
  stopReason: ActorTaskStopReason;
}


export type WebClientHandler_StopActorTask_Params = WebClientHandler_StopActorTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_StopActorTask_ParamsMojoType>(
    WebClientHandler_StopActorTask_ParamsSpec.$,
    'WebClientHandler_StopActorTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_StopActorTask_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_StopActorTask_ParamsMojoType, ActorTaskStopReason>(
        'stopReason', 4,
        0,
        ActorTaskStopReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_PauseActorTask_ParamsMojoType {
  taskId: number;
  pauseReason: ActorTaskPauseReason;
  tabId: (number | null);
}


export type WebClientHandler_PauseActorTask_Params = WebClientHandler_PauseActorTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_PauseActorTask_ParamsMojoType>(
    WebClientHandler_PauseActorTask_ParamsSpec.$,
    'WebClientHandler_PauseActorTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_PauseActorTask_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_PauseActorTask_ParamsMojoType, ActorTaskPauseReason>(
        'pauseReason', 4,
        0,
        ActorTaskPauseReasonSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_PauseActorTask_ParamsMojoType, boolean>(
        'tab_id_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "tab_id_$value",
          originalFieldName: "tabId",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_PauseActorTask_ParamsMojoType, number>(
        'tab_id_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "tabId",
        },
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_ResumeActorTask_ParamsMojoType {
  taskId: number;
  contextOptions: GetTabContextOptions;
}


export type WebClientHandler_ResumeActorTask_Params = WebClientHandler_ResumeActorTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ResumeActorTask_ParamsMojoType>(
    WebClientHandler_ResumeActorTask_ParamsSpec.$,
    'WebClientHandler_ResumeActorTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_ResumeActorTask_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_ResumeActorTask_ParamsMojoType, GetTabContextOptions>(
        'contextOptions', 8,
        0,
        GetTabContextOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_ResumeActorTask_ResponseParamsMojoType {
  result: GetContextResultWithActionResultCode;
}


export type WebClientHandler_ResumeActorTask_ResponseParams = WebClientHandler_ResumeActorTask_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_ResumeActorTask_ResponseParamsMojoType>(
    WebClientHandler_ResumeActorTask_ResponseParamsSpec.$,
    'WebClientHandler_ResumeActorTask_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_ResumeActorTask_ResponseParamsMojoType, GetContextResultWithActionResultCode>(
        'result', 0,
        0,
        GetContextResultWithActionResultCodeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_InterruptActorTask_ParamsMojoType {
  taskId: number;
}


export type WebClientHandler_InterruptActorTask_Params = WebClientHandler_InterruptActorTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_InterruptActorTask_ParamsMojoType>(
    WebClientHandler_InterruptActorTask_ParamsSpec.$,
    'WebClientHandler_InterruptActorTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_InterruptActorTask_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_UninterruptActorTask_ParamsMojoType {
  taskId: number;
}


export type WebClientHandler_UninterruptActorTask_Params = WebClientHandler_UninterruptActorTask_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_UninterruptActorTask_ParamsMojoType>(
    WebClientHandler_UninterruptActorTask_ParamsSpec.$,
    'WebClientHandler_UninterruptActorTask_Params',
    [
      mojo.internal.StructField<WebClientHandler_UninterruptActorTask_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_CreateActorTab_ParamsMojoType {
  taskId: number;
  openInBackground: boolean;
  initiatorTabId: (number | null);
  initiatorWindowId: (number | null);
}


export type WebClientHandler_CreateActorTab_Params = WebClientHandler_CreateActorTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateActorTab_ParamsMojoType>(
    WebClientHandler_CreateActorTab_ParamsSpec.$,
    'WebClientHandler_CreateActorTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, boolean>(
        'openInBackground', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, boolean>(
        'initiator_tab_id_$flag', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "initiator_tab_id_$value",
          originalFieldName: "initiatorTabId",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, number>(
        'initiator_tab_id_$value', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "initiatorTabId",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, boolean>(
        'initiator_window_id_$flag', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "initiator_window_id_$value",
          originalFieldName: "initiatorWindowId",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ParamsMojoType, number>(
        'initiator_window_id_$value', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "initiatorWindowId",
        },
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_CreateActorTab_ResponseParamsMojoType {
  tabData: (TabData | null);
}


export type WebClientHandler_CreateActorTab_ResponseParams = WebClientHandler_CreateActorTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_CreateActorTab_ResponseParamsMojoType>(
    WebClientHandler_CreateActorTab_ResponseParamsSpec.$,
    'WebClientHandler_CreateActorTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_CreateActorTab_ResponseParamsMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_ActivateTab_ParamsMojoType {
  taskId: number;
}


export type WebClientHandler_ActivateTab_Params = WebClientHandler_ActivateTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ActivateTab_ParamsMojoType>(
    WebClientHandler_ActivateTab_ParamsSpec.$,
    'WebClientHandler_ActivateTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_ActivateTab_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_ResizeWidget_ParamsMojoType {
  size: gfx_mojom_Size;
  duration: mojoBase_mojom_TimeDelta;
}


export type WebClientHandler_ResizeWidget_Params = WebClientHandler_ResizeWidget_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ResizeWidget_ParamsMojoType>(
    WebClientHandler_ResizeWidget_ParamsSpec.$,
    'WebClientHandler_ResizeWidget_Params',
    [
      mojo.internal.StructField<WebClientHandler_ResizeWidget_ParamsMojoType, gfx_mojom_Size>(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_ResizeWidget_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_ResizeWidget_ResponseParamsMojoType {
}


export type WebClientHandler_ResizeWidget_ResponseParams = WebClientHandler_ResizeWidget_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_ResizeWidget_ResponseParamsMojoType>(
    WebClientHandler_ResizeWidget_ResponseParamsSpec.$,
    'WebClientHandler_ResizeWidget_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_CaptureScreenshot_ParamsMojoType {
}


export type WebClientHandler_CaptureScreenshot_Params = WebClientHandler_CaptureScreenshot_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_CaptureScreenshot_ParamsMojoType>(
    WebClientHandler_CaptureScreenshot_ParamsSpec.$,
    'WebClientHandler_CaptureScreenshot_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_CaptureScreenshot_ResponseParamsMojoType {
  result: CaptureScreenshotResult;
}


export type WebClientHandler_CaptureScreenshot_ResponseParams = WebClientHandler_CaptureScreenshot_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_CaptureScreenshot_ResponseParamsMojoType>(
    WebClientHandler_CaptureScreenshot_ResponseParamsSpec.$,
    'WebClientHandler_CaptureScreenshot_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_CaptureScreenshot_ResponseParamsMojoType, CaptureScreenshotResult>(
        'result', 0,
        0,
        CaptureScreenshotResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_CaptureRegion_ParamsMojoType {
  observer: CaptureRegionObserverRemote;
}


export type WebClientHandler_CaptureRegion_Params = WebClientHandler_CaptureRegion_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_CaptureRegion_ParamsMojoType>(
    WebClientHandler_CaptureRegion_ParamsSpec.$,
    'WebClientHandler_CaptureRegion_Params',
    [
      mojo.internal.StructField<WebClientHandler_CaptureRegion_ParamsMojoType, CaptureRegionObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(CaptureRegionObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetAudioDucking_ParamsMojoType {
  enable: boolean;
}


export type WebClientHandler_SetAudioDucking_Params = WebClientHandler_SetAudioDucking_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetAudioDucking_ParamsMojoType>(
    WebClientHandler_SetAudioDucking_ParamsSpec.$,
    'WebClientHandler_SetAudioDucking_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetAudioDucking_ParamsMojoType, boolean>(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetAudioDucking_ResponseParamsMojoType {
  result: boolean;
}


export type WebClientHandler_SetAudioDucking_ResponseParams = WebClientHandler_SetAudioDucking_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetAudioDucking_ResponseParamsMojoType>(
    WebClientHandler_SetAudioDucking_ResponseParamsSpec.$,
    'WebClientHandler_SetAudioDucking_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_SetAudioDucking_ResponseParamsMojoType, boolean>(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetPanelDraggableAreas_ParamsMojoType {
  draggableAreas: gfx_mojom_Rect[];
}


export type WebClientHandler_SetPanelDraggableAreas_Params = WebClientHandler_SetPanelDraggableAreas_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetPanelDraggableAreas_ParamsMojoType>(
    WebClientHandler_SetPanelDraggableAreas_ParamsSpec.$,
    'WebClientHandler_SetPanelDraggableAreas_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetPanelDraggableAreas_ParamsMojoType, gfx_mojom_Rect[]>(
        'draggableAreas', 0,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetPanelDraggableAreas_ResponseParamsMojoType {
}


export type WebClientHandler_SetPanelDraggableAreas_ResponseParams = WebClientHandler_SetPanelDraggableAreas_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetPanelDraggableAreas_ResponseParamsMojoType>(
    WebClientHandler_SetPanelDraggableAreas_ResponseParamsSpec.$,
    'WebClientHandler_SetPanelDraggableAreas_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetMinimumPanelSize_ParamsMojoType {
  size: gfx_mojom_Size;
}


export type WebClientHandler_SetMinimumPanelSize_Params = WebClientHandler_SetMinimumPanelSize_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetMinimumPanelSize_ParamsMojoType>(
    WebClientHandler_SetMinimumPanelSize_ParamsSpec.$,
    'WebClientHandler_SetMinimumPanelSize_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetMinimumPanelSize_ParamsMojoType, gfx_mojom_Size>(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetMicrophonePermissionState_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetMicrophonePermissionState_Params = WebClientHandler_SetMicrophonePermissionState_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetMicrophonePermissionState_ParamsMojoType>(
    WebClientHandler_SetMicrophonePermissionState_ParamsSpec.$,
    'WebClientHandler_SetMicrophonePermissionState_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetMicrophonePermissionState_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetMicrophonePermissionState_ResponseParamsMojoType {
}


export type WebClientHandler_SetMicrophonePermissionState_ResponseParams = WebClientHandler_SetMicrophonePermissionState_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetMicrophonePermissionState_ResponseParamsMojoType>(
    WebClientHandler_SetMicrophonePermissionState_ResponseParamsSpec.$,
    'WebClientHandler_SetMicrophonePermissionState_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetLocationPermissionState_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetLocationPermissionState_Params = WebClientHandler_SetLocationPermissionState_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetLocationPermissionState_ParamsMojoType>(
    WebClientHandler_SetLocationPermissionState_ParamsSpec.$,
    'WebClientHandler_SetLocationPermissionState_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetLocationPermissionState_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetLocationPermissionState_ResponseParamsMojoType {
}


export type WebClientHandler_SetLocationPermissionState_ResponseParams = WebClientHandler_SetLocationPermissionState_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetLocationPermissionState_ResponseParamsMojoType>(
    WebClientHandler_SetLocationPermissionState_ResponseParamsSpec.$,
    'WebClientHandler_SetLocationPermissionState_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetTabContextPermissionState_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetTabContextPermissionState_Params = WebClientHandler_SetTabContextPermissionState_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetTabContextPermissionState_ParamsMojoType>(
    WebClientHandler_SetTabContextPermissionState_ParamsSpec.$,
    'WebClientHandler_SetTabContextPermissionState_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetTabContextPermissionState_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetTabContextPermissionState_ResponseParamsMojoType {
}


export type WebClientHandler_SetTabContextPermissionState_ResponseParams = WebClientHandler_SetTabContextPermissionState_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetTabContextPermissionState_ResponseParamsMojoType>(
    WebClientHandler_SetTabContextPermissionState_ResponseParamsSpec.$,
    'WebClientHandler_SetTabContextPermissionState_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetClosedCaptioningSetting_Params = WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType>(
    WebClientHandler_SetClosedCaptioningSetting_ParamsSpec.$,
    'WebClientHandler_SetClosedCaptioningSetting_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetClosedCaptioningSetting_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetClosedCaptioningSetting_ResponseParamsMojoType {
}


export type WebClientHandler_SetClosedCaptioningSetting_ResponseParams = WebClientHandler_SetClosedCaptioningSetting_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetClosedCaptioningSetting_ResponseParamsMojoType>(
    WebClientHandler_SetClosedCaptioningSetting_ResponseParamsSpec.$,
    'WebClientHandler_SetClosedCaptioningSetting_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetActuationOnWebSetting_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetActuationOnWebSetting_Params = WebClientHandler_SetActuationOnWebSetting_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetActuationOnWebSetting_ParamsMojoType>(
    WebClientHandler_SetActuationOnWebSetting_ParamsSpec.$,
    'WebClientHandler_SetActuationOnWebSetting_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetActuationOnWebSetting_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetActuationOnWebSetting_ResponseParamsMojoType {
}


export type WebClientHandler_SetActuationOnWebSetting_ResponseParams = WebClientHandler_SetActuationOnWebSetting_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetActuationOnWebSetting_ResponseParamsMojoType>(
    WebClientHandler_SetActuationOnWebSetting_ResponseParamsSpec.$,
    'WebClientHandler_SetActuationOnWebSetting_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsMojoType {
}


export type WebClientHandler_ShouldAllowMediaPermissionRequest_Params = WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsMojoType>(
    WebClientHandler_ShouldAllowMediaPermissionRequest_ParamsSpec.$,
    'WebClientHandler_ShouldAllowMediaPermissionRequest_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType {
  isAllowed: boolean;
}


export type WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams = WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType>(
    WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsSpec.$,
    'WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParamsMojoType, boolean>(
        'isAllowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsMojoType {
}


export type WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params = WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsMojoType>(
    WebClientHandler_ShouldAllowGeolocationPermissionRequest_ParamsSpec.$,
    'WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType {
  isAllowed: boolean;
}


export type WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams = WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType>(
    WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsSpec.$,
    'WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParamsMojoType, boolean>(
        'isAllowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SetContextAccessIndicator_ParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_SetContextAccessIndicator_Params = WebClientHandler_SetContextAccessIndicator_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetContextAccessIndicator_ParamsMojoType>(
    WebClientHandler_SetContextAccessIndicator_ParamsSpec.$,
    'WebClientHandler_SetContextAccessIndicator_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetContextAccessIndicator_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetUserProfileInfo_ParamsMojoType {
}


export type WebClientHandler_GetUserProfileInfo_Params = WebClientHandler_GetUserProfileInfo_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetUserProfileInfo_ParamsMojoType>(
    WebClientHandler_GetUserProfileInfo_ParamsSpec.$,
    'WebClientHandler_GetUserProfileInfo_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType {
  profileInfo: (UserProfileInfo | null);
}


export type WebClientHandler_GetUserProfileInfo_ResponseParams = WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType>(
    WebClientHandler_GetUserProfileInfo_ResponseParamsSpec.$,
    'WebClientHandler_GetUserProfileInfo_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetUserProfileInfo_ResponseParamsMojoType, UserProfileInfo>(
        'profileInfo', 0,
        0,
        UserProfileInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SyncCookies_ParamsMojoType {
}


export type WebClientHandler_SyncCookies_Params = WebClientHandler_SyncCookies_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SyncCookies_ParamsMojoType>(
    WebClientHandler_SyncCookies_ParamsSpec.$,
    'WebClientHandler_SyncCookies_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SyncCookies_ResponseParamsMojoType {
  success: boolean;
}


export type WebClientHandler_SyncCookies_ResponseParams = WebClientHandler_SyncCookies_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SyncCookies_ResponseParamsMojoType>(
    WebClientHandler_SyncCookies_ResponseParamsSpec.$,
    'WebClientHandler_SyncCookies_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_SyncCookies_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_LogBeginAsyncEvent_ParamsMojoType {
  eventAsyncId: bigint;
  taskId: number;
  event: string;
  details: string;
}


export type WebClientHandler_LogBeginAsyncEvent_Params = WebClientHandler_LogBeginAsyncEvent_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_LogBeginAsyncEvent_ParamsMojoType>(
    WebClientHandler_LogBeginAsyncEvent_ParamsSpec.$,
    'WebClientHandler_LogBeginAsyncEvent_Params',
    [
      mojo.internal.StructField<WebClientHandler_LogBeginAsyncEvent_ParamsMojoType, bigint>(
        'eventAsyncId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogBeginAsyncEvent_ParamsMojoType, number>(
        'taskId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogBeginAsyncEvent_ParamsMojoType, string>(
        'event', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogBeginAsyncEvent_ParamsMojoType, string>(
        'details', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface WebClientHandler_LogEndAsyncEvent_ParamsMojoType {
  eventAsyncId: bigint;
  details: string;
}


export type WebClientHandler_LogEndAsyncEvent_Params = WebClientHandler_LogEndAsyncEvent_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_LogEndAsyncEvent_ParamsMojoType>(
    WebClientHandler_LogEndAsyncEvent_ParamsSpec.$,
    'WebClientHandler_LogEndAsyncEvent_Params',
    [
      mojo.internal.StructField<WebClientHandler_LogEndAsyncEvent_ParamsMojoType, bigint>(
        'eventAsyncId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogEndAsyncEvent_ParamsMojoType, string>(
        'details', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_LogInstantEvent_ParamsMojoType {
  taskId: number;
  event: string;
  details: string;
}


export type WebClientHandler_LogInstantEvent_Params = WebClientHandler_LogInstantEvent_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_LogInstantEvent_ParamsMojoType>(
    WebClientHandler_LogInstantEvent_ParamsSpec.$,
    'WebClientHandler_LogInstantEvent_Params',
    [
      mojo.internal.StructField<WebClientHandler_LogInstantEvent_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogInstantEvent_ParamsMojoType, string>(
        'event', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_LogInstantEvent_ParamsMojoType, string>(
        'details', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface WebClientHandler_JournalClear_ParamsMojoType {
}


export type WebClientHandler_JournalClear_Params = WebClientHandler_JournalClear_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalClear_ParamsMojoType>(
    WebClientHandler_JournalClear_ParamsSpec.$,
    'WebClientHandler_JournalClear_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_JournalSnapshot_ParamsMojoType {
  clearJournal: boolean;
}


export type WebClientHandler_JournalSnapshot_Params = WebClientHandler_JournalSnapshot_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalSnapshot_ParamsMojoType>(
    WebClientHandler_JournalSnapshot_ParamsSpec.$,
    'WebClientHandler_JournalSnapshot_Params',
    [
      mojo.internal.StructField<WebClientHandler_JournalSnapshot_ParamsMojoType, boolean>(
        'clearJournal', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_JournalSnapshot_ResponseParamsMojoType {
  journal: Journal;
}


export type WebClientHandler_JournalSnapshot_ResponseParams = WebClientHandler_JournalSnapshot_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalSnapshot_ResponseParamsMojoType>(
    WebClientHandler_JournalSnapshot_ResponseParamsSpec.$,
    'WebClientHandler_JournalSnapshot_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_JournalSnapshot_ResponseParamsMojoType, Journal>(
        'journal', 0,
        0,
        JournalSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_JournalStart_ParamsMojoType {
  maxBytes: bigint;
  captureScreenshots: boolean;
}


export type WebClientHandler_JournalStart_Params = WebClientHandler_JournalStart_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalStart_ParamsMojoType>(
    WebClientHandler_JournalStart_ParamsSpec.$,
    'WebClientHandler_JournalStart_Params',
    [
      mojo.internal.StructField<WebClientHandler_JournalStart_ParamsMojoType, bigint>(
        'maxBytes', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_JournalStart_ParamsMojoType, boolean>(
        'captureScreenshots', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_JournalStop_ParamsMojoType {
}


export type WebClientHandler_JournalStop_Params = WebClientHandler_JournalStop_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalStop_ParamsMojoType>(
    WebClientHandler_JournalStop_ParamsSpec.$,
    'WebClientHandler_JournalStop_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_JournalRecordFeedback_ParamsMojoType {
  positive: boolean;
  reason: string;
}


export type WebClientHandler_JournalRecordFeedback_Params = WebClientHandler_JournalRecordFeedback_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_JournalRecordFeedback_ParamsMojoType>(
    WebClientHandler_JournalRecordFeedback_ParamsSpec.$,
    'WebClientHandler_JournalRecordFeedback_Params',
    [
      mojo.internal.StructField<WebClientHandler_JournalRecordFeedback_ParamsMojoType, boolean>(
        'positive', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_JournalRecordFeedback_ParamsMojoType, string>(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_OnUserInputSubmitted_ParamsMojoType {
  mode: WebClientMode;
}


export type WebClientHandler_OnUserInputSubmitted_Params = WebClientHandler_OnUserInputSubmitted_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnUserInputSubmitted_ParamsMojoType>(
    WebClientHandler_OnUserInputSubmitted_ParamsSpec.$,
    'WebClientHandler_OnUserInputSubmitted_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnUserInputSubmitted_ParamsMojoType, WebClientMode>(
        'mode', 0,
        0,
        WebClientModeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnContextUploadStarted_ParamsMojoType {
}


export type WebClientHandler_OnContextUploadStarted_Params = WebClientHandler_OnContextUploadStarted_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnContextUploadStarted_ParamsMojoType>(
    WebClientHandler_OnContextUploadStarted_ParamsSpec.$,
    'WebClientHandler_OnContextUploadStarted_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_OnContextUploadCompleted_ParamsMojoType {
}


export type WebClientHandler_OnContextUploadCompleted_Params = WebClientHandler_OnContextUploadCompleted_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnContextUploadCompleted_ParamsMojoType>(
    WebClientHandler_OnContextUploadCompleted_ParamsSpec.$,
    'WebClientHandler_OnContextUploadCompleted_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_OnReaction_ParamsMojoType {
  reactionType: MetricUserInputReactionType;
}


export type WebClientHandler_OnReaction_Params = WebClientHandler_OnReaction_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnReaction_ParamsMojoType>(
    WebClientHandler_OnReaction_ParamsSpec.$,
    'WebClientHandler_OnReaction_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnReaction_ParamsMojoType, MetricUserInputReactionType>(
        'reactionType', 0,
        0,
        MetricUserInputReactionTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnResponseStarted_ParamsMojoType {
}


export type WebClientHandler_OnResponseStarted_Params = WebClientHandler_OnResponseStarted_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnResponseStarted_ParamsMojoType>(
    WebClientHandler_OnResponseStarted_ParamsSpec.$,
    'WebClientHandler_OnResponseStarted_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_OnResponseStopped_ParamsMojoType {
  details: OnResponseStoppedDetails;
}


export type WebClientHandler_OnResponseStopped_Params = WebClientHandler_OnResponseStopped_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnResponseStopped_ParamsMojoType>(
    WebClientHandler_OnResponseStopped_ParamsSpec.$,
    'WebClientHandler_OnResponseStopped_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnResponseStopped_ParamsMojoType, OnResponseStoppedDetails>(
        'details', 0,
        0,
        OnResponseStoppedDetailsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnSessionTerminated_ParamsMojoType {
}


export type WebClientHandler_OnSessionTerminated_Params = WebClientHandler_OnSessionTerminated_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnSessionTerminated_ParamsMojoType>(
    WebClientHandler_OnSessionTerminated_ParamsSpec.$,
    'WebClientHandler_OnSessionTerminated_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_OnTurnCompleted_ParamsMojoType {
  model: WebClientModel;
  duration: mojoBase_mojom_TimeDelta;
}


export type WebClientHandler_OnTurnCompleted_Params = WebClientHandler_OnTurnCompleted_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnTurnCompleted_ParamsMojoType>(
    WebClientHandler_OnTurnCompleted_ParamsSpec.$,
    'WebClientHandler_OnTurnCompleted_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnTurnCompleted_ParamsMojoType, WebClientModel>(
        'model', 0,
        0,
        WebClientModelSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_OnTurnCompleted_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_OnModelChanged_ParamsMojoType {
  model: WebClientModel;
}


export type WebClientHandler_OnModelChanged_Params = WebClientHandler_OnModelChanged_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnModelChanged_ParamsMojoType>(
    WebClientHandler_OnModelChanged_ParamsSpec.$,
    'WebClientHandler_OnModelChanged_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnModelChanged_ParamsMojoType, WebClientModel>(
        'model', 0,
        0,
        WebClientModelSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnRecordUseCounter_ParamsMojoType {
  counter: number;
}


export type WebClientHandler_OnRecordUseCounter_Params = WebClientHandler_OnRecordUseCounter_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnRecordUseCounter_ParamsMojoType>(
    WebClientHandler_OnRecordUseCounter_ParamsSpec.$,
    'WebClientHandler_OnRecordUseCounter_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnRecordUseCounter_ParamsMojoType, number>(
        'counter', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnResponseRated_ParamsMojoType {
  positive: boolean;
}


export type WebClientHandler_OnResponseRated_Params = WebClientHandler_OnResponseRated_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnResponseRated_ParamsMojoType>(
    WebClientHandler_OnResponseRated_ParamsSpec.$,
    'WebClientHandler_OnResponseRated_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnResponseRated_ParamsMojoType, boolean>(
        'positive', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnClosedCaptionsShown_ParamsMojoType {
}


export type WebClientHandler_OnClosedCaptionsShown_Params = WebClientHandler_OnClosedCaptionsShown_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnClosedCaptionsShown_ParamsMojoType>(
    WebClientHandler_OnClosedCaptionsShown_ParamsSpec.$,
    'WebClientHandler_OnClosedCaptionsShown_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_ScrollTo_ParamsMojoType {
  params: ScrollToParams;
}


export type WebClientHandler_ScrollTo_Params = WebClientHandler_ScrollTo_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_ScrollTo_ParamsMojoType>(
    WebClientHandler_ScrollTo_ParamsSpec.$,
    'WebClientHandler_ScrollTo_Params',
    [
      mojo.internal.StructField<WebClientHandler_ScrollTo_ParamsMojoType, ScrollToParams>(
        'params', 0,
        0,
        ScrollToParamsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_ScrollTo_ResponseParamsMojoType {
  errorReason: (ScrollToErrorReason | null);
}


export type WebClientHandler_ScrollTo_ResponseParams = WebClientHandler_ScrollTo_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_ScrollTo_ResponseParamsMojoType>(
    WebClientHandler_ScrollTo_ResponseParamsSpec.$,
    'WebClientHandler_ScrollTo_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_ScrollTo_ResponseParamsMojoType, boolean>(
        'error_reason_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_reason_$value",
          originalFieldName: "errorReason",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_ScrollTo_ResponseParamsMojoType, ScrollToErrorReason>(
        'error_reason_$value', 4,
        0,
        ScrollToErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorReason",
        },
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_DropScrollToHighlight_ParamsMojoType {
}


export type WebClientHandler_DropScrollToHighlight_Params = WebClientHandler_DropScrollToHighlight_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_DropScrollToHighlight_ParamsMojoType>(
    WebClientHandler_DropScrollToHighlight_ParamsSpec.$,
    'WebClientHandler_DropScrollToHighlight_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_SetSyntheticExperimentState_ParamsMojoType {
  trialName: string;
  groupName: string;
}


export type WebClientHandler_SetSyntheticExperimentState_Params = WebClientHandler_SetSyntheticExperimentState_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SetSyntheticExperimentState_ParamsMojoType>(
    WebClientHandler_SetSyntheticExperimentState_ParamsSpec.$,
    'WebClientHandler_SetSyntheticExperimentState_Params',
    [
      mojo.internal.StructField<WebClientHandler_SetSyntheticExperimentState_ParamsMojoType, string>(
        'trialName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_SetSyntheticExperimentState_ParamsMojoType, string>(
        'groupName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType {
  type: contentSettings_mojom_ContentSettingsType;
}


export type WebClientHandler_OpenOsPermissionSettingsMenu_Params = WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType>(
    WebClientHandler_OpenOsPermissionSettingsMenu_ParamsSpec.$,
    'WebClientHandler_OpenOsPermissionSettingsMenu_Params',
    [
      mojo.internal.StructField<WebClientHandler_OpenOsPermissionSettingsMenu_ParamsMojoType, contentSettings_mojom_ContentSettingsType>(
        'type', 0,
        0,
        contentSettings_mojom_ContentSettingsTypeSpec.$,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetOsMicrophonePermissionStatus_ParamsMojoType {
}


export type WebClientHandler_GetOsMicrophonePermissionStatus_Params = WebClientHandler_GetOsMicrophonePermissionStatus_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetOsMicrophonePermissionStatus_ParamsMojoType>(
    WebClientHandler_GetOsMicrophonePermissionStatus_ParamsSpec.$,
    'WebClientHandler_GetOsMicrophonePermissionStatus_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType {
  enabled: boolean;
}


export type WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams = WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType>(
    WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsSpec.$,
    'WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType {
  isLive: boolean;
  options: ZeroStateSuggestionsOptions;
}


export type WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params = WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType>(
    WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsSpec.$,
    'WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params',
    [
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType, boolean>(
        'isLive', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ParamsMojoType, ZeroStateSuggestionsOptions>(
        'options', 8,
        0,
        ZeroStateSuggestionsOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType {
  zeroStateSuggestions: (ZeroStateSuggestionsV2 | null);
}


export type WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams = WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType>(
    WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsSpec.$,
    'WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParamsMojoType, ZeroStateSuggestionsV2>(
        'zeroStateSuggestions', 0,
        0,
        ZeroStateSuggestionsV2Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType {
  isFirstRun: (boolean | null);
}


export type WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params = WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType>(
    WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsSpec.$,
    'WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params',
    [
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType, boolean>(
        'is_first_run_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "is_first_run_$value",
          originalFieldName: "isFirstRun",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ParamsMojoType, boolean>(
        'is_first_run_$value', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "isFirstRun",
        },
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType {
  suggestions: (ZeroStateSuggestions | null);
}


export type WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams = WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType>(
    WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsSpec.$,
    'WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParamsMojoType, ZeroStateSuggestions>(
        'suggestions', 0,
        0,
        ZeroStateSuggestionsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_MaybeRefreshUserStatus_ParamsMojoType {
}


export type WebClientHandler_MaybeRefreshUserStatus_Params = WebClientHandler_MaybeRefreshUserStatus_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_MaybeRefreshUserStatus_ParamsMojoType>(
    WebClientHandler_MaybeRefreshUserStatus_ParamsSpec.$,
    'WebClientHandler_MaybeRefreshUserStatus_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_IsDebuggerAttached_ParamsMojoType {
}


export type WebClientHandler_IsDebuggerAttached_Params = WebClientHandler_IsDebuggerAttached_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_IsDebuggerAttached_ParamsMojoType>(
    WebClientHandler_IsDebuggerAttached_ParamsSpec.$,
    'WebClientHandler_IsDebuggerAttached_Params',
    [
    ],
    [[0, 8],]);





export interface WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType {
  isAttachedToWebview: boolean;
}


export type WebClientHandler_IsDebuggerAttached_ResponseParams = WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType>(
    WebClientHandler_IsDebuggerAttached_ResponseParamsSpec.$,
    'WebClientHandler_IsDebuggerAttached_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_IsDebuggerAttached_ResponseParamsMojoType, boolean>(
        'isAttachedToWebview', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_OnViewChanged_ParamsMojoType {
  notification: ViewChangedNotification;
}


export type WebClientHandler_OnViewChanged_Params = WebClientHandler_OnViewChanged_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_OnViewChanged_ParamsMojoType>(
    WebClientHandler_OnViewChanged_ParamsSpec.$,
    'WebClientHandler_OnViewChanged_Params',
    [
      mojo.internal.StructField<WebClientHandler_OnViewChanged_ParamsMojoType, ViewChangedNotification>(
        'notification', 0,
        0,
        ViewChangedNotificationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SubscribeToPageMetadata_ParamsMojoType {
  tabId: number;
  names: string[];
}


export type WebClientHandler_SubscribeToPageMetadata_Params = WebClientHandler_SubscribeToPageMetadata_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SubscribeToPageMetadata_ParamsMojoType>(
    WebClientHandler_SubscribeToPageMetadata_ParamsSpec.$,
    'WebClientHandler_SubscribeToPageMetadata_Params',
    [
      mojo.internal.StructField<WebClientHandler_SubscribeToPageMetadata_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_SubscribeToPageMetadata_ParamsMojoType, string[]>(
        'names', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType {
  success: boolean;
}


export type WebClientHandler_SubscribeToPageMetadata_ResponseParams = WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType>(
    WebClientHandler_SubscribeToPageMetadata_ResponseParamsSpec.$,
    'WebClientHandler_SubscribeToPageMetadata_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_SubscribeToPageMetadata_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SwitchConversation_ParamsMojoType {
  info: (ConversationInfo | null);
}


export type WebClientHandler_SwitchConversation_Params = WebClientHandler_SwitchConversation_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_SwitchConversation_ParamsMojoType>(
    WebClientHandler_SwitchConversation_ParamsSpec.$,
    'WebClientHandler_SwitchConversation_Params',
    [
      mojo.internal.StructField<WebClientHandler_SwitchConversation_ParamsMojoType, ConversationInfo>(
        'info', 0,
        0,
        ConversationInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_SwitchConversation_ResponseParamsMojoType {
  errorReason: (SwitchConversationErrorReason | null);
}


export type WebClientHandler_SwitchConversation_ResponseParams = WebClientHandler_SwitchConversation_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_SwitchConversation_ResponseParamsMojoType>(
    WebClientHandler_SwitchConversation_ResponseParamsSpec.$,
    'WebClientHandler_SwitchConversation_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_SwitchConversation_ResponseParamsMojoType, boolean>(
        'error_reason_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_reason_$value",
          originalFieldName: "errorReason",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_SwitchConversation_ResponseParamsMojoType, SwitchConversationErrorReason>(
        'error_reason_$value', 4,
        0,
        SwitchConversationErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorReason",
        },
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_RegisterConversation_ParamsMojoType {
  info: ConversationInfo;
}


export type WebClientHandler_RegisterConversation_Params = WebClientHandler_RegisterConversation_ParamsMojoType;
mojo.internal.Struct<WebClientHandler_RegisterConversation_ParamsMojoType>(
    WebClientHandler_RegisterConversation_ParamsSpec.$,
    'WebClientHandler_RegisterConversation_Params',
    [
      mojo.internal.StructField<WebClientHandler_RegisterConversation_ParamsMojoType, ConversationInfo>(
        'info', 0,
        0,
        ConversationInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClientHandler_RegisterConversation_ResponseParamsMojoType {
  errorReason: (RegisterConversationErrorReason | null);
}


export type WebClientHandler_RegisterConversation_ResponseParams = WebClientHandler_RegisterConversation_ResponseParamsMojoType;
mojo.internal.Struct<WebClientHandler_RegisterConversation_ResponseParamsMojoType>(
    WebClientHandler_RegisterConversation_ResponseParamsSpec.$,
    'WebClientHandler_RegisterConversation_ResponseParams',
    [
      mojo.internal.StructField<WebClientHandler_RegisterConversation_ResponseParamsMojoType, boolean>(
        'error_reason_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "error_reason_$value",
          originalFieldName: "errorReason",
        },
        undefined,
    ),
      mojo.internal.StructField<WebClientHandler_RegisterConversation_ResponseParamsMojoType, RegisterConversationErrorReason>(
        'error_reason_$value', 4,
        0,
        RegisterConversationErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "errorReason",
        },
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPanelWillOpen_ParamsMojoType {
  panelOpeningData: PanelOpeningData;
}


export type WebClient_NotifyPanelWillOpen_Params = WebClient_NotifyPanelWillOpen_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelWillOpen_ParamsMojoType>(
    WebClient_NotifyPanelWillOpen_ParamsSpec.$,
    'WebClient_NotifyPanelWillOpen_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPanelWillOpen_ParamsMojoType, PanelOpeningData>(
        'panelOpeningData', 0,
        0,
        PanelOpeningDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPanelWillOpen_ResponseParamsMojoType {
  openPanelInfo: OpenPanelInfo;
}


export type WebClient_NotifyPanelWillOpen_ResponseParams = WebClient_NotifyPanelWillOpen_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelWillOpen_ResponseParamsMojoType>(
    WebClient_NotifyPanelWillOpen_ResponseParamsSpec.$,
    'WebClient_NotifyPanelWillOpen_ResponseParams',
    [
      mojo.internal.StructField<WebClient_NotifyPanelWillOpen_ResponseParamsMojoType, OpenPanelInfo>(
        'openPanelInfo', 0,
        0,
        OpenPanelInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPanelWasClosed_ParamsMojoType {
}


export type WebClient_NotifyPanelWasClosed_Params = WebClient_NotifyPanelWasClosed_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelWasClosed_ParamsMojoType>(
    WebClient_NotifyPanelWasClosed_ParamsSpec.$,
    'WebClient_NotifyPanelWasClosed_Params',
    [
    ],
    [[0, 8],]);





export interface WebClient_NotifyPanelWasClosed_ResponseParamsMojoType {
}


export type WebClient_NotifyPanelWasClosed_ResponseParams = WebClient_NotifyPanelWasClosed_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelWasClosed_ResponseParamsMojoType>(
    WebClient_NotifyPanelWasClosed_ResponseParamsSpec.$,
    'WebClient_NotifyPanelWasClosed_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface WebClient_NotifyPanelStateChange_ParamsMojoType {
  panelState: PanelState;
}


export type WebClient_NotifyPanelStateChange_Params = WebClient_NotifyPanelStateChange_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelStateChange_ParamsMojoType>(
    WebClient_NotifyPanelStateChange_ParamsSpec.$,
    'WebClient_NotifyPanelStateChange_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPanelStateChange_ParamsMojoType, PanelState>(
        'panelState', 0,
        0,
        PanelStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPanelActiveChange_ParamsMojoType {
  panelActive: boolean;
}


export type WebClient_NotifyPanelActiveChange_Params = WebClient_NotifyPanelActiveChange_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelActiveChange_ParamsMojoType>(
    WebClient_NotifyPanelActiveChange_ParamsSpec.$,
    'WebClient_NotifyPanelActiveChange_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPanelActiveChange_ParamsMojoType, boolean>(
        'panelActive', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPanelCanAttachChange_ParamsMojoType {
  canAttach: boolean;
}


export type WebClient_NotifyPanelCanAttachChange_Params = WebClient_NotifyPanelCanAttachChange_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPanelCanAttachChange_ParamsMojoType>(
    WebClient_NotifyPanelCanAttachChange_ParamsSpec.$,
    'WebClient_NotifyPanelCanAttachChange_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPanelCanAttachChange_ParamsMojoType, boolean>(
        'canAttach', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyMicrophonePermissionStateChanged_Params = WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType>(
    WebClient_NotifyMicrophonePermissionStateChanged_ParamsSpec.$,
    'WebClient_NotifyMicrophonePermissionStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyMicrophonePermissionStateChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyLocationPermissionStateChanged_Params = WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType>(
    WebClient_NotifyLocationPermissionStateChanged_ParamsSpec.$,
    'WebClient_NotifyLocationPermissionStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyLocationPermissionStateChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyTabContextPermissionStateChanged_Params = WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType>(
    WebClient_NotifyTabContextPermissionStateChanged_ParamsSpec.$,
    'WebClient_NotifyTabContextPermissionStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyTabContextPermissionStateChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyOsLocationPermissionStateChanged_Params = WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType>(
    WebClient_NotifyOsLocationPermissionStateChanged_ParamsSpec.$,
    'WebClient_NotifyOsLocationPermissionStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyOsLocationPermissionStateChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyFocusedTabChanged_ParamsMojoType {
  focusedTabData: FocusedTabData;
}


export type WebClient_NotifyFocusedTabChanged_Params = WebClient_NotifyFocusedTabChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyFocusedTabChanged_ParamsMojoType>(
    WebClient_NotifyFocusedTabChanged_ParamsSpec.$,
    'WebClient_NotifyFocusedTabChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyFocusedTabChanged_ParamsMojoType, FocusedTabData>(
        'focusedTabData', 0,
        0,
        FocusedTabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClient_NotifyManualResizeChanged_ParamsMojoType {
  resizing: boolean;
}


export type WebClient_NotifyManualResizeChanged_Params = WebClient_NotifyManualResizeChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyManualResizeChanged_ParamsMojoType>(
    WebClient_NotifyManualResizeChanged_ParamsSpec.$,
    'WebClient_NotifyManualResizeChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyManualResizeChanged_ParamsMojoType, boolean>(
        'resizing', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType {
  hotkey: string;
}


export type WebClient_NotifyOsHotkeyStateChanged_Params = WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType>(
    WebClient_NotifyOsHotkeyStateChanged_ParamsSpec.$,
    'WebClient_NotifyOsHotkeyStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyOsHotkeyStateChanged_ParamsMojoType, string>(
        'hotkey', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType {
  browserIsOpen: boolean;
}


export type WebClient_NotifyBrowserIsOpenChanged_Params = WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType>(
    WebClient_NotifyBrowserIsOpenChanged_ParamsSpec.$,
    'WebClient_NotifyBrowserIsOpenChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyBrowserIsOpenChanged_ParamsMojoType, boolean>(
        'browserIsOpen', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyInstanceActivationChanged_ParamsMojoType {
  instanceActive: boolean;
}


export type WebClient_NotifyInstanceActivationChanged_Params = WebClient_NotifyInstanceActivationChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyInstanceActivationChanged_ParamsMojoType>(
    WebClient_NotifyInstanceActivationChanged_ParamsSpec.$,
    'WebClient_NotifyInstanceActivationChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyInstanceActivationChanged_ParamsMojoType, boolean>(
        'instanceActive', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyClosedCaptioningSettingChanged_Params = WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType>(
    WebClient_NotifyClosedCaptioningSettingChanged_ParamsSpec.$,
    'WebClient_NotifyClosedCaptioningSettingChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyClosedCaptioningSettingChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPinnedTabsChanged_ParamsMojoType {
  tabData: TabData[];
}


export type WebClient_NotifyPinnedTabsChanged_Params = WebClient_NotifyPinnedTabsChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPinnedTabsChanged_ParamsMojoType>(
    WebClient_NotifyPinnedTabsChanged_ParamsSpec.$,
    'WebClient_NotifyPinnedTabsChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPinnedTabsChanged_ParamsMojoType, TabData[]>(
        'tabData', 0,
        0,
        mojo.internal.Array(TabDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPinnedTabDataChanged_ParamsMojoType {
  tabData: TabData;
}


export type WebClient_NotifyPinnedTabDataChanged_Params = WebClient_NotifyPinnedTabDataChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPinnedTabDataChanged_ParamsMojoType>(
    WebClient_NotifyPinnedTabDataChanged_ParamsSpec.$,
    'WebClient_NotifyPinnedTabDataChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPinnedTabDataChanged_ParamsMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType {
  suggestions: (ZeroStateSuggestionsV2 | null);
  options: ZeroStateSuggestionsOptions;
}


export type WebClient_NotifyZeroStateSuggestionsChanged_Params = WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType>(
    WebClient_NotifyZeroStateSuggestionsChanged_ParamsSpec.$,
    'WebClient_NotifyZeroStateSuggestionsChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType, ZeroStateSuggestionsV2>(
        'suggestions', 0,
        0,
        ZeroStateSuggestionsV2Spec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClient_NotifyZeroStateSuggestionsChanged_ParamsMojoType, ZeroStateSuggestionsOptions>(
        'options', 8,
        0,
        ZeroStateSuggestionsOptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClient_NotifyActorTaskStateChanged_ParamsMojoType {
  taskId: number;
  state: ActorTaskState;
}


export type WebClient_NotifyActorTaskStateChanged_Params = WebClient_NotifyActorTaskStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyActorTaskStateChanged_ParamsMojoType>(
    WebClient_NotifyActorTaskStateChanged_ParamsSpec.$,
    'WebClient_NotifyActorTaskStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyActorTaskStateChanged_ParamsMojoType, number>(
        'taskId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClient_NotifyActorTaskStateChanged_ParamsMojoType, ActorTaskState>(
        'state', 4,
        0,
        ActorTaskStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyTabDataChanged_ParamsMojoType {
  tabData: TabData;
}


export type WebClient_NotifyTabDataChanged_Params = WebClient_NotifyTabDataChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyTabDataChanged_ParamsMojoType>(
    WebClient_NotifyTabDataChanged_ParamsSpec.$,
    'WebClient_NotifyTabDataChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyTabDataChanged_ParamsMojoType, TabData>(
        'tabData', 0,
        0,
        TabDataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestViewChange_ParamsMojoType {
  request: ViewChangeRequest;
}


export type WebClient_RequestViewChange_Params = WebClient_RequestViewChange_ParamsMojoType;
mojo.internal.Struct<WebClient_RequestViewChange_ParamsMojoType>(
    WebClient_RequestViewChange_ParamsSpec.$,
    'WebClient_RequestViewChange_Params',
    [
      mojo.internal.StructField<WebClient_RequestViewChange_ParamsMojoType, ViewChangeRequest>(
        'request', 0,
        0,
        ViewChangeRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyPageMetadataChanged_ParamsMojoType {
  tabId: number;
  metadata: (blink_mojom_PageMetadata | null);
}


export type WebClient_NotifyPageMetadataChanged_Params = WebClient_NotifyPageMetadataChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyPageMetadataChanged_ParamsMojoType>(
    WebClient_NotifyPageMetadataChanged_ParamsSpec.$,
    'WebClient_NotifyPageMetadataChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyPageMetadataChanged_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebClient_NotifyPageMetadataChanged_ParamsMojoType, blink_mojom_PageMetadata>(
        'metadata', 8,
        0,
        blink_mojom_PageMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyDefaultTabContextPermissionStateChanged_Params = WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType>(
    WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsSpec.$,
    'WebClient_NotifyDefaultTabContextPermissionStateChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyDefaultTabContextPermissionStateChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType {
  request: actor_webui_mojom_SelectCredentialDialogRequest;
}


export type WebClient_RequestToShowCredentialSelectionDialog_Params = WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType>(
    WebClient_RequestToShowCredentialSelectionDialog_ParamsSpec.$,
    'WebClient_RequestToShowCredentialSelectionDialog_Params',
    [
      mojo.internal.StructField<WebClient_RequestToShowCredentialSelectionDialog_ParamsMojoType, actor_webui_mojom_SelectCredentialDialogRequest>(
        'request', 0,
        0,
        actor_webui_mojom_SelectCredentialDialogRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType {
  response: actor_webui_mojom_SelectCredentialDialogResponse;
}


export type WebClient_RequestToShowCredentialSelectionDialog_ResponseParams = WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType>(
    WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsSpec.$,
    'WebClient_RequestToShowCredentialSelectionDialog_ResponseParams',
    [
      mojo.internal.StructField<WebClient_RequestToShowCredentialSelectionDialog_ResponseParamsMojoType, actor_webui_mojom_SelectCredentialDialogResponse>(
        'response', 0,
        0,
        actor_webui_mojom_SelectCredentialDialogResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType {
  request: actor_webui_mojom_SelectAutofillSuggestionsDialogRequest;
}


export type WebClient_RequestToShowAutofillSuggestionsDialog_Params = WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType>(
    WebClient_RequestToShowAutofillSuggestionsDialog_ParamsSpec.$,
    'WebClient_RequestToShowAutofillSuggestionsDialog_Params',
    [
      mojo.internal.StructField<WebClient_RequestToShowAutofillSuggestionsDialog_ParamsMojoType, actor_webui_mojom_SelectAutofillSuggestionsDialogRequest>(
        'request', 0,
        0,
        actor_webui_mojom_SelectAutofillSuggestionsDialogRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType {
  response: actor_webui_mojom_SelectAutofillSuggestionsDialogResponse;
}


export type WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams = WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType>(
    WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsSpec.$,
    'WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams',
    [
      mojo.internal.StructField<WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParamsMojoType, actor_webui_mojom_SelectAutofillSuggestionsDialogResponse>(
        'response', 0,
        0,
        actor_webui_mojom_SelectAutofillSuggestionsDialogResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType {
  request: actor_webui_mojom_UserConfirmationDialogRequest;
}


export type WebClient_RequestToShowUserConfirmationDialog_Params = WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType>(
    WebClient_RequestToShowUserConfirmationDialog_ParamsSpec.$,
    'WebClient_RequestToShowUserConfirmationDialog_Params',
    [
      mojo.internal.StructField<WebClient_RequestToShowUserConfirmationDialog_ParamsMojoType, actor_webui_mojom_UserConfirmationDialogRequest>(
        'request', 0,
        0,
        actor_webui_mojom_UserConfirmationDialogRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType {
  response: actor_webui_mojom_UserConfirmationDialogResponse;
}


export type WebClient_RequestToShowUserConfirmationDialog_ResponseParams = WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType>(
    WebClient_RequestToShowUserConfirmationDialog_ResponseParamsSpec.$,
    'WebClient_RequestToShowUserConfirmationDialog_ResponseParams',
    [
      mojo.internal.StructField<WebClient_RequestToShowUserConfirmationDialog_ResponseParamsMojoType, actor_webui_mojom_UserConfirmationDialogResponse>(
        'response', 0,
        0,
        actor_webui_mojom_UserConfirmationDialogResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToConfirmNavigation_ParamsMojoType {
  request: actor_webui_mojom_NavigationConfirmationRequest;
}


export type WebClient_RequestToConfirmNavigation_Params = WebClient_RequestToConfirmNavigation_ParamsMojoType;
mojo.internal.Struct<WebClient_RequestToConfirmNavigation_ParamsMojoType>(
    WebClient_RequestToConfirmNavigation_ParamsSpec.$,
    'WebClient_RequestToConfirmNavigation_Params',
    [
      mojo.internal.StructField<WebClient_RequestToConfirmNavigation_ParamsMojoType, actor_webui_mojom_NavigationConfirmationRequest>(
        'request', 0,
        0,
        actor_webui_mojom_NavigationConfirmationRequestSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_RequestToConfirmNavigation_ResponseParamsMojoType {
  response: actor_webui_mojom_NavigationConfirmationResponse;
}


export type WebClient_RequestToConfirmNavigation_ResponseParams = WebClient_RequestToConfirmNavigation_ResponseParamsMojoType;
mojo.internal.Struct<WebClient_RequestToConfirmNavigation_ResponseParamsMojoType>(
    WebClient_RequestToConfirmNavigation_ResponseParamsSpec.$,
    'WebClient_RequestToConfirmNavigation_ResponseParams',
    [
      mojo.internal.StructField<WebClient_RequestToConfirmNavigation_ResponseParamsMojoType, actor_webui_mojom_NavigationConfirmationResponse>(
        'response', 0,
        0,
        actor_webui_mojom_NavigationConfirmationResponseSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyAdditionalContext_ParamsMojoType {
  context: AdditionalContext;
}


export type WebClient_NotifyAdditionalContext_Params = WebClient_NotifyAdditionalContext_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyAdditionalContext_ParamsMojoType>(
    WebClient_NotifyAdditionalContext_ParamsSpec.$,
    'WebClient_NotifyAdditionalContext_Params',
    [
      mojo.internal.StructField<WebClient_NotifyAdditionalContext_ParamsMojoType, AdditionalContext>(
        'context', 0,
        0,
        AdditionalContextSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType {
  enabled: boolean;
}


export type WebClient_NotifyActuationOnWebSettingChanged_Params = WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType>(
    WebClient_NotifyActuationOnWebSettingChanged_ParamsSpec.$,
    'WebClient_NotifyActuationOnWebSettingChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyActuationOnWebSettingChanged_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType {
  canActOnWeb: boolean;
}


export type WebClient_NotifyActOnWebCapabilityChanged_Params = WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType;
mojo.internal.Struct<WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType>(
    WebClient_NotifyActOnWebCapabilityChanged_ParamsSpec.$,
    'WebClient_NotifyActOnWebCapabilityChanged_Params',
    [
      mojo.internal.StructField<WebClient_NotifyActOnWebCapabilityChanged_ParamsMojoType, boolean>(
        'canActOnWeb', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CaptureRegionObserver_OnUpdate_ParamsMojoType {
  result: (CaptureRegionResult | null);
  reason: (CaptureRegionErrorReason | null);
}


export type CaptureRegionObserver_OnUpdate_Params = CaptureRegionObserver_OnUpdate_ParamsMojoType;
mojo.internal.Struct<CaptureRegionObserver_OnUpdate_ParamsMojoType>(
    CaptureRegionObserver_OnUpdate_ParamsSpec.$,
    'CaptureRegionObserver_OnUpdate_Params',
    [
      mojo.internal.StructField<CaptureRegionObserver_OnUpdate_ParamsMojoType, CaptureRegionResult>(
        'result', 0,
        0,
        CaptureRegionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CaptureRegionObserver_OnUpdate_ParamsMojoType, boolean>(
        'reason_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "reason_$value",
          originalFieldName: "reason",
        },
        undefined,
    ),
      mojo.internal.StructField<CaptureRegionObserver_OnUpdate_ParamsMojoType, CaptureRegionErrorReason>(
        'reason_$value', 12,
        0,
        CaptureRegionErrorReasonSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "reason",
        },
        undefined,
    ),
    ],
    [[0, 24],]);



mojo.internal.Union(
    GetContextResultSpec.$, 'GetContextResult',
    {
      'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'tabContext': {
        'ordinal': 1,
        'type': TabContextSpec.$,
      },
    });

export interface GetContextResult {
  errorReason?: string,
  tabContext?: TabContext,
}

export enum GetContextResultFieldTags {
  ERROR_REASON,
  TAB_CONTEXT,
}

export function whichGetContextResult(u: GetContextResult): GetContextResultFieldTags {
  if (u.errorReason !== null && u.errorReason !== undefined) {
    return GetContextResultFieldTags.ERROR_REASON;
  }
  if (u.tabContext !== null && u.tabContext !== undefined) {
    return GetContextResultFieldTags.TAB_CONTEXT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    CaptureScreenshotResultSpec.$, 'CaptureScreenshotResult',
    {
      'errorReason': {
        'ordinal': 0,
        'type': CaptureScreenshotErrorReasonSpec.$,
      },
      'screenshot': {
        'ordinal': 1,
        'type': ScreenshotSpec.$,
      },
    });

export interface CaptureScreenshotResult {
  errorReason?: CaptureScreenshotErrorReason,
  screenshot?: Screenshot,
}

export enum CaptureScreenshotResultFieldTags {
  ERROR_REASON,
  SCREENSHOT,
}

export function whichCaptureScreenshotResult(u: CaptureScreenshotResult): CaptureScreenshotResultFieldTags {
  if (u.errorReason !== null && u.errorReason !== undefined) {
    return CaptureScreenshotResultFieldTags.ERROR_REASON;
  }
  if (u.screenshot !== null && u.screenshot !== undefined) {
    return CaptureScreenshotResultFieldTags.SCREENSHOT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    ScrollToSelectorSpec.$, 'ScrollToSelector',
    {
      'exactTextSelector': {
        'ordinal': 0,
        'type': ScrollToTextSelectorSpec.$,
      },
      'textFragmentSelector': {
        'ordinal': 1,
        'type': ScrollToTextFragmentSelectorSpec.$,
      },
      'nodeSelector': {
        'ordinal': 2,
        'type': ScrollToNodeSelectorSpec.$,
      },
    });

export interface ScrollToSelector {
  exactTextSelector?: ScrollToTextSelector,
  textFragmentSelector?: ScrollToTextFragmentSelector,
  nodeSelector?: ScrollToNodeSelector,
}

export enum ScrollToSelectorFieldTags {
  EXACT_TEXT_SELECTOR,
  TEXT_FRAGMENT_SELECTOR,
  NODE_SELECTOR,
}

export function whichScrollToSelector(u: ScrollToSelector): ScrollToSelectorFieldTags {
  if (u.exactTextSelector !== null && u.exactTextSelector !== undefined) {
    return ScrollToSelectorFieldTags.EXACT_TEXT_SELECTOR;
  }
  if (u.textFragmentSelector !== null && u.textFragmentSelector !== undefined) {
    return ScrollToSelectorFieldTags.TEXT_FRAGMENT_SELECTOR;
  }
  if (u.nodeSelector !== null && u.nodeSelector !== undefined) {
    return ScrollToSelectorFieldTags.NODE_SELECTOR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    AdditionalContextPartSpec.$, 'AdditionalContextPart',
    {
      'data': {
        'ordinal': 0,
        'type': ContextDataSpec.$,
      },
      'screenshot': {
        'ordinal': 1,
        'type': ScreenshotSpec.$,
      },
      'webPageData': {
        'ordinal': 2,
        'type': WebPageDataSpec.$,
      },
      'annotatedPageData': {
        'ordinal': 3,
        'type': AnnotatedPageDataSpec.$,
      },
      'pdfDocumentData': {
        'ordinal': 4,
        'type': PdfDocumentDataSpec.$,
      },
      'tabContext': {
        'ordinal': 5,
        'type': TabContextSpec.$,
      },
    });

export interface AdditionalContextPart {
  data?: ContextData,
  screenshot?: Screenshot,
  webPageData?: WebPageData,
  annotatedPageData?: AnnotatedPageData,
  pdfDocumentData?: PdfDocumentData,
  tabContext?: TabContext,
}

export enum AdditionalContextPartFieldTags {
  DATA,
  SCREENSHOT,
  WEB_PAGE_DATA,
  ANNOTATED_PAGE_DATA,
  PDF_DOCUMENT_DATA,
  TAB_CONTEXT,
}

export function whichAdditionalContextPart(u: AdditionalContextPart): AdditionalContextPartFieldTags {
  if (u.data !== null && u.data !== undefined) {
    return AdditionalContextPartFieldTags.DATA;
  }
  if (u.screenshot !== null && u.screenshot !== undefined) {
    return AdditionalContextPartFieldTags.SCREENSHOT;
  }
  if (u.webPageData !== null && u.webPageData !== undefined) {
    return AdditionalContextPartFieldTags.WEB_PAGE_DATA;
  }
  if (u.annotatedPageData !== null && u.annotatedPageData !== undefined) {
    return AdditionalContextPartFieldTags.ANNOTATED_PAGE_DATA;
  }
  if (u.pdfDocumentData !== null && u.pdfDocumentData !== undefined) {
    return AdditionalContextPartFieldTags.PDF_DOCUMENT_DATA;
  }
  if (u.tabContext !== null && u.tabContext !== undefined) {
    return AdditionalContextPartFieldTags.TAB_CONTEXT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    FocusedTabDataSpec.$, 'FocusedTabData',
    {
      'focusedTab': {
        'ordinal': 0,
        'type': TabDataSpec.$,
      },
      'noFocusedTabData': {
        'ordinal': 1,
        'type': NoFocusedTabDataSpec.$,
      },
    });

export interface FocusedTabData {
  focusedTab?: TabData,
  noFocusedTabData?: NoFocusedTabData,
}

export enum FocusedTabDataFieldTags {
  FOCUSED_TAB,
  NO_FOCUSED_TAB_DATA,
}

export function whichFocusedTabData(u: FocusedTabData): FocusedTabDataFieldTags {
  if (u.focusedTab !== null && u.focusedTab !== undefined) {
    return FocusedTabDataFieldTags.FOCUSED_TAB;
  }
  if (u.noFocusedTabData !== null && u.noFocusedTabData !== undefined) {
    return FocusedTabDataFieldTags.NO_FOCUSED_TAB_DATA;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    CapturedRegionSpec.$, 'CapturedRegion',
    {
      'rect': {
        'ordinal': 0,
        'type': gfx_mojom_RectSpec.$,
      },
    });

export interface CapturedRegion {
  rect?: gfx_mojom_Rect,
}

export enum CapturedRegionFieldTags {
  RECT,
}

export function whichCapturedRegion(u: CapturedRegion): CapturedRegionFieldTags {
  if (u.rect !== null && u.rect !== undefined) {
    return CapturedRegionFieldTags.RECT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    ViewChangeRequestDetailsSpec.$, 'ViewChangeRequestDetails',
    {
      'actuation': {
        'ordinal': 0,
        'type': ViewChangeRequestActuationSpec.$,
      },
      'conversation': {
        'ordinal': 1,
        'type': ViewChangeRequestConversationSpec.$,
      },
    });

export interface ViewChangeRequestDetails {
  actuation?: ViewChangeRequestActuation,
  conversation?: ViewChangeRequestConversation,
}

export enum ViewChangeRequestDetailsFieldTags {
  ACTUATION,
  CONVERSATION,
}

export function whichViewChangeRequestDetails(u: ViewChangeRequestDetails): ViewChangeRequestDetailsFieldTags {
  if (u.actuation !== null && u.actuation !== undefined) {
    return ViewChangeRequestDetailsFieldTags.ACTUATION;
  }
  if (u.conversation !== null && u.conversation !== undefined) {
    return ViewChangeRequestDetailsFieldTags.CONVERSATION;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    WebClientHandler_CreateTask_ResponseParam_ResultSpec.$, 'WebClientHandler_CreateTask_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojo.internal.Int32,
      },
      'failure': {
        'ordinal': 1,
        'type': CreateTaskErrorReasonSpec.$,
      },
    });

export interface WebClientHandler_CreateTask_ResponseParam_Result {
  success?: number,
  failure?: CreateTaskErrorReason,
}

export enum WebClientHandler_CreateTask_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichWebClientHandler_CreateTask_ResponseParam_Result(u: WebClientHandler_CreateTask_ResponseParam_Result): WebClientHandler_CreateTask_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return WebClientHandler_CreateTask_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return WebClientHandler_CreateTask_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    WebClientHandler_PerformActions_ResponseParam_ResultSpec.$, 'WebClientHandler_PerformActions_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_ProtoWrapperSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': PerformActionsErrorReasonSpec.$,
      },
    });

export interface WebClientHandler_PerformActions_ResponseParam_Result {
  success?: mojoBase_mojom_ProtoWrapper,
  failure?: PerformActionsErrorReason,
}

export enum WebClientHandler_PerformActions_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichWebClientHandler_PerformActions_ResponseParam_Result(u: WebClientHandler_PerformActions_ResponseParam_Result): WebClientHandler_PerformActions_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return WebClientHandler_PerformActions_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return WebClientHandler_PerformActions_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
