// chrome/browser/glic/host/glic.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_TEST_UTILS_H_

#include "chrome/browser/glic/host/glic.mojom.h"


namespace glic::mojom {


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void IntentToShow() override;
  void SetProfileReadyState(ProfileReadyState ready_state) override;
  void UpdatePageState(PanelStateKind panelStateKind) override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingReceiver<PageHandler> receiver, ::mojo::PendingRemote<Page> page) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void CreateWebClient(::mojo::PendingReceiver<WebClientHandler> web_client_receiver) override;
  void PrepareForClient(PrepareForClientCallback callback) override;
  void WebviewCommitted(const ::GURL& url) override;
  void ClosePanel(ClosePanelCallback callback) override;
  void OpenProfilePickerAndClosePanel() override;
  void OpenDisabledByAdminLinkAndClosePanel() override;
  void SignInAndClosePanel() override;
  void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) override;
  void EnableDragResize(bool enabled) override;
  void WebUiStateChanged(WebUiState new_state) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void PrepareForClient(
      PrepareForClientResult* out_result);
  PrepareForClientResult PrepareForClient();
  void ClosePanel(
      );
  
  void ResizeWidget(
      const ::gfx::Size& size, ::base::TimeDelta duration);
  

 private:
  PageHandler* const proxy_;
};


class  PinCandidatesObserverInterceptorForTesting : public PinCandidatesObserver {
  virtual PinCandidatesObserver* GetForwardingInterface() = 0;
  void OnPinCandidatesChanged(std::vector<PinCandidatePtr> candidates) override;
};
class  PinCandidatesObserverAsyncWaiter {
 public:
  explicit PinCandidatesObserverAsyncWaiter(PinCandidatesObserver* proxy);

  PinCandidatesObserverAsyncWaiter(const PinCandidatesObserverAsyncWaiter&) = delete;
  PinCandidatesObserverAsyncWaiter& operator=(const PinCandidatesObserverAsyncWaiter&) = delete;

  ~PinCandidatesObserverAsyncWaiter();

 private:
  PinCandidatesObserver* const proxy_;
};


class  WebClientHandlerInterceptorForTesting : public WebClientHandler {
  virtual WebClientHandler* GetForwardingInterface() = 0;
  void WebClientCreated(::mojo::PendingRemote<WebClient> web_client, WebClientCreatedCallback callback) override;
  void WebClientInitialized() override;
  void WebClientInitializeFailed() override;
  void CreateTab(const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, CreateTabCallback callback) override;
  void OpenLinkInPopup(const ::GURL& url, int32_t popup_width, int32_t popup_height) override;
  void OpenGlicSettingsPage(OpenSettingsOptionsPtr options) override;
  void OpenPasswordManagerSettingsPage() override;
  void ClosePanel() override;
  void ClosePanelAndShutdown() override;
  void AttachPanel() override;
  void DetachPanel() override;
  void OnModeChange(WebClientMode new_mode) override;
  void ShowProfilePicker() override;
  void GetModelQualityClientId(GetModelQualityClientIdCallback callback) override;
  void GetContextFromFocusedTab(GetTabContextOptionsPtr options, GetContextFromFocusedTabCallback callback) override;
  void GetContextFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextFromTabCallback callback) override;
  void GetContextForActorFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextForActorFromTabCallback callback) override;
  void SetMaximumNumberOfPinnedTabs(uint32_t requested_max, SetMaximumNumberOfPinnedTabsCallback callback) override;
  void PinTabs(const std::vector<int32_t>& tab_ids, PinTabsCallback callback) override;
  void UnpinTabs(const std::vector<int32_t>& tab_ids, UnpinTabsCallback callback) override;
  void UnpinAllTabs() override;
  void SubscribeToPinCandidates(GetPinCandidatesOptionsPtr options, ::mojo::PendingRemote<PinCandidatesObserver> observer) override;
  void CreateTask(::actor::webui::mojom::TaskOptionsPtr task_options, CreateTaskCallback callback) override;
  void PerformActions(const std::vector<uint8_t>& actions_proto, PerformActionsCallback callback) override;
  void StopActorTask(int32_t task_id, ActorTaskStopReason stop_reason) override;
  void PauseActorTask(int32_t task_id, ActorTaskPauseReason pause_reason, std::optional<int32_t> tab_id) override;
  void ResumeActorTask(int32_t task_id, GetTabContextOptionsPtr context_options, ResumeActorTaskCallback callback) override;
  void InterruptActorTask(int32_t task_id) override;
  void UninterruptActorTask(int32_t task_id) override;
  void CreateActorTab(int32_t task_id, bool open_in_background, std::optional<int32_t> initiator_tab_id, std::optional<int32_t> initiator_window_id, CreateActorTabCallback callback) override;
  void ActivateTab(int32_t task_id) override;
  void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) override;
  void CaptureScreenshot(CaptureScreenshotCallback callback) override;
  void CaptureRegion(::mojo::PendingRemote<CaptureRegionObserver> observer) override;
  void SetAudioDucking(bool enable, SetAudioDuckingCallback callback) override;
  void SetPanelDraggableAreas(const std::vector<::gfx::Rect>& draggable_areas, SetPanelDraggableAreasCallback callback) override;
  void SetMinimumPanelSize(const ::gfx::Size& size) override;
  void SetMicrophonePermissionState(bool enabled, SetMicrophonePermissionStateCallback callback) override;
  void SetLocationPermissionState(bool enabled, SetLocationPermissionStateCallback callback) override;
  void SetTabContextPermissionState(bool enabled, SetTabContextPermissionStateCallback callback) override;
  void SetClosedCaptioningSetting(bool enabled, SetClosedCaptioningSettingCallback callback) override;
  void SetActuationOnWebSetting(bool enabled, SetActuationOnWebSettingCallback callback) override;
  void ShouldAllowMediaPermissionRequest(ShouldAllowMediaPermissionRequestCallback callback) override;
  void ShouldAllowGeolocationPermissionRequest(ShouldAllowGeolocationPermissionRequestCallback callback) override;
  void SetContextAccessIndicator(bool enabled) override;
  void GetUserProfileInfo(GetUserProfileInfoCallback callback) override;
  void SyncCookies(SyncCookiesCallback callback) override;
  void LogBeginAsyncEvent(uint64_t event_async_id, int32_t task_id, const std::string& event, const std::string& details) override;
  void LogEndAsyncEvent(uint64_t event_async_id, const std::string& details) override;
  void LogInstantEvent(int32_t task_id, const std::string& event, const std::string& details) override;
  void JournalClear() override;
  void JournalSnapshot(bool clear_journal, JournalSnapshotCallback callback) override;
  void JournalStart(uint64_t max_bytes, bool capture_screenshots) override;
  void JournalStop() override;
  void JournalRecordFeedback(bool positive, const std::string& reason) override;
  void OnUserInputSubmitted(WebClientMode mode) override;
  void OnContextUploadStarted() override;
  void OnContextUploadCompleted() override;
  void OnReaction(MetricUserInputReactionType reactionType) override;
  void OnResponseStarted() override;
  void OnResponseStopped(OnResponseStoppedDetailsPtr details) override;
  void OnSessionTerminated() override;
  void OnTurnCompleted(WebClientModel model, ::base::TimeDelta duration) override;
  void OnModelChanged(WebClientModel model) override;
  void OnRecordUseCounter(uint16_t counter) override;
  void OnResponseRated(bool positive) override;
  void OnClosedCaptionsShown() override;
  void ScrollTo(ScrollToParamsPtr params, ScrollToCallback callback) override;
  void DropScrollToHighlight() override;
  void SetSyntheticExperimentState(const std::string& trial_name, const std::string& group_name) override;
  void OpenOsPermissionSettingsMenu(::content_settings::mojom::ContentSettingsType type) override;
  void GetOsMicrophonePermissionStatus(GetOsMicrophonePermissionStatusCallback callback) override;
  void GetZeroStateSuggestionsAndSubscribe(bool is_live, ZeroStateSuggestionsOptionsPtr options, GetZeroStateSuggestionsAndSubscribeCallback callback) override;
  void GetZeroStateSuggestionsForFocusedTab(std::optional<bool> is_first_run, GetZeroStateSuggestionsForFocusedTabCallback callback) override;
  void MaybeRefreshUserStatus() override;
  void IsDebuggerAttached(IsDebuggerAttachedCallback callback) override;
  void OnViewChanged(ViewChangedNotificationPtr notification) override;
  void SubscribeToPageMetadata(int32_t tab_id, const std::vector<std::string>& names, SubscribeToPageMetadataCallback callback) override;
  void SwitchConversation(ConversationInfoPtr info, SwitchConversationCallback callback) override;
  void RegisterConversation(ConversationInfoPtr info, RegisterConversationCallback callback) override;
};
class  WebClientHandlerAsyncWaiter {
 public:
  explicit WebClientHandlerAsyncWaiter(WebClientHandler* proxy);

  WebClientHandlerAsyncWaiter(const WebClientHandlerAsyncWaiter&) = delete;
  WebClientHandlerAsyncWaiter& operator=(const WebClientHandlerAsyncWaiter&) = delete;

  ~WebClientHandlerAsyncWaiter();
  void WebClientCreated(
      ::mojo::PendingRemote<WebClient> web_client, WebClientInitialStatePtr* out_initial_state);
  WebClientInitialStatePtr WebClientCreated(::mojo::PendingRemote<WebClient> web_client);
  void CreateTab(
      const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, TabDataPtr* out_tab_data);
  TabDataPtr CreateTab(const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id);
  void GetModelQualityClientId(
      std::string* out_model_quality_client_id);
  std::string GetModelQualityClientId();
  void GetContextFromFocusedTab(
      GetTabContextOptionsPtr options, GetContextResultPtr* out_result);
  GetContextResultPtr GetContextFromFocusedTab(GetTabContextOptionsPtr options);
  void GetContextFromTab(
      int32_t tab_id, GetTabContextOptionsPtr options, GetContextResultPtr* out_result);
  GetContextResultPtr GetContextFromTab(int32_t tab_id, GetTabContextOptionsPtr options);
  void GetContextForActorFromTab(
      int32_t tab_id, GetTabContextOptionsPtr options, GetContextResultPtr* out_result);
  GetContextResultPtr GetContextForActorFromTab(int32_t tab_id, GetTabContextOptionsPtr options);
  void SetMaximumNumberOfPinnedTabs(
      uint32_t requested_max, uint32_t* out_effective_max);
  uint32_t SetMaximumNumberOfPinnedTabs(uint32_t requested_max);
  void PinTabs(
      const std::vector<int32_t>& tab_ids, bool* out_pinned_all);
  bool PinTabs(const std::vector<int32_t>& tab_ids);
  void UnpinTabs(
      const std::vector<int32_t>& tab_ids, bool* out_unpinned_all);
  bool UnpinTabs(const std::vector<int32_t>& tab_ids);
  void CreateTask(
      ::actor::webui::mojom::TaskOptionsPtr task_options,
base::expected<
  int32_t,
  CreateTaskErrorReason>* out_result);
  WebClientHandler_CreateTask_ResponseParam_ResultPtr CreateTask(::actor::webui::mojom::TaskOptionsPtr task_options);
  void PerformActions(
      const std::vector<uint8_t>& actions_proto,
base::expected<
  ::mojo_base::ProtoWrapper,
  PerformActionsErrorReason>* out_result);
  WebClientHandler_PerformActions_ResponseParam_ResultPtr PerformActions(const std::vector<uint8_t>& actions_proto);
  void ResumeActorTask(
      int32_t task_id, GetTabContextOptionsPtr context_options, GetContextResultWithActionResultCodePtr* out_result);
  GetContextResultWithActionResultCodePtr ResumeActorTask(int32_t task_id, GetTabContextOptionsPtr context_options);
  void CreateActorTab(
      int32_t task_id, bool open_in_background, std::optional<int32_t> initiator_tab_id, std::optional<int32_t> initiator_window_id, TabDataPtr* out_tab_data);
  TabDataPtr CreateActorTab(int32_t task_id, bool open_in_background, std::optional<int32_t> initiator_tab_id, std::optional<int32_t> initiator_window_id);
  void ResizeWidget(
      const ::gfx::Size& size, ::base::TimeDelta duration);
  
  void CaptureScreenshot(
      CaptureScreenshotResultPtr* out_result);
  CaptureScreenshotResultPtr CaptureScreenshot();
  void SetAudioDucking(
      bool enable, bool* out_result);
  bool SetAudioDucking(bool enable);
  void SetPanelDraggableAreas(
      const std::vector<::gfx::Rect>& draggable_areas);
  
  void SetMicrophonePermissionState(
      bool enabled);
  
  void SetLocationPermissionState(
      bool enabled);
  
  void SetTabContextPermissionState(
      bool enabled);
  
  void SetClosedCaptioningSetting(
      bool enabled);
  
  void SetActuationOnWebSetting(
      bool enabled);
  
  void ShouldAllowMediaPermissionRequest(
      bool* out_is_allowed);
  bool ShouldAllowMediaPermissionRequest();
  void ShouldAllowGeolocationPermissionRequest(
      bool* out_is_allowed);
  bool ShouldAllowGeolocationPermissionRequest();
  void GetUserProfileInfo(
      UserProfileInfoPtr* out_profile_info);
  UserProfileInfoPtr GetUserProfileInfo();
  void SyncCookies(
      bool* out_success);
  bool SyncCookies();
  void JournalSnapshot(
      bool clear_journal, JournalPtr* out_journal);
  JournalPtr JournalSnapshot(bool clear_journal);
  void ScrollTo(
      ScrollToParamsPtr params, std::optional<ScrollToErrorReason>* out_error_reason);
  std::optional<ScrollToErrorReason> ScrollTo(ScrollToParamsPtr params);
  void GetOsMicrophonePermissionStatus(
      bool* out_enabled);
  bool GetOsMicrophonePermissionStatus();
  void GetZeroStateSuggestionsAndSubscribe(
      bool is_live, ZeroStateSuggestionsOptionsPtr options, ZeroStateSuggestionsV2Ptr* out_zero_state_suggestions);
  ZeroStateSuggestionsV2Ptr GetZeroStateSuggestionsAndSubscribe(bool is_live, ZeroStateSuggestionsOptionsPtr options);
  void GetZeroStateSuggestionsForFocusedTab(
      std::optional<bool> is_first_run, ZeroStateSuggestionsPtr* out_suggestions);
  ZeroStateSuggestionsPtr GetZeroStateSuggestionsForFocusedTab(std::optional<bool> is_first_run);
  void IsDebuggerAttached(
      bool* out_is_attached_to_webview);
  bool IsDebuggerAttached();
  void SubscribeToPageMetadata(
      int32_t tab_id, const std::vector<std::string>& names, bool* out_success);
  bool SubscribeToPageMetadata(int32_t tab_id, const std::vector<std::string>& names);
  void SwitchConversation(
      ConversationInfoPtr info, std::optional<SwitchConversationErrorReason>* out_error_reason);
  std::optional<SwitchConversationErrorReason> SwitchConversation(ConversationInfoPtr info);
  void RegisterConversation(
      ConversationInfoPtr info, std::optional<RegisterConversationErrorReason>* out_error_reason);
  std::optional<RegisterConversationErrorReason> RegisterConversation(ConversationInfoPtr info);

 private:
  WebClientHandler* const proxy_;
};


class  WebClientInterceptorForTesting : public WebClient {
  virtual WebClient* GetForwardingInterface() = 0;
  void NotifyPanelWillOpen(PanelOpeningDataPtr panel_opening_data, NotifyPanelWillOpenCallback callback) override;
  void NotifyPanelWasClosed(NotifyPanelWasClosedCallback callback) override;
  void NotifyPanelStateChange(PanelStatePtr panel_state) override;
  void NotifyPanelActiveChange(bool panel_active) override;
  void NotifyPanelCanAttachChange(bool can_attach) override;
  void NotifyMicrophonePermissionStateChanged(bool enabled) override;
  void NotifyLocationPermissionStateChanged(bool enabled) override;
  void NotifyTabContextPermissionStateChanged(bool enabled) override;
  void NotifyOsLocationPermissionStateChanged(bool enabled) override;
  void NotifyFocusedTabChanged(FocusedTabDataPtr focused_tab_data) override;
  void NotifyManualResizeChanged(bool resizing) override;
  void NotifyOsHotkeyStateChanged(const std::string& hotkey) override;
  void NotifyBrowserIsOpenChanged(bool browser_is_open) override;
  void NotifyInstanceActivationChanged(bool instance_active) override;
  void NotifyClosedCaptioningSettingChanged(bool enabled) override;
  void NotifyPinnedTabsChanged(std::vector<TabDataPtr> tab_data) override;
  void NotifyPinnedTabDataChanged(TabDataPtr tab_data) override;
  void NotifyZeroStateSuggestionsChanged(ZeroStateSuggestionsV2Ptr suggestions, ZeroStateSuggestionsOptionsPtr options) override;
  void NotifyActorTaskStateChanged(int32_t task_id, ActorTaskState state) override;
  void NotifyTabDataChanged(TabDataPtr tab_data) override;
  void RequestViewChange(ViewChangeRequestPtr request) override;
  void NotifyPageMetadataChanged(int32_t tab_id, ::blink::mojom::PageMetadataPtr metadata) override;
  void NotifyDefaultTabContextPermissionStateChanged(bool enabled) override;
  void RequestToShowCredentialSelectionDialog(::actor::webui::mojom::SelectCredentialDialogRequestPtr request, RequestToShowCredentialSelectionDialogCallback callback) override;
  void RequestToShowAutofillSuggestionsDialog(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr request, RequestToShowAutofillSuggestionsDialogCallback callback) override;
  void RequestToShowUserConfirmationDialog(::actor::webui::mojom::UserConfirmationDialogRequestPtr request, RequestToShowUserConfirmationDialogCallback callback) override;
  void RequestToConfirmNavigation(::actor::webui::mojom::NavigationConfirmationRequestPtr request, RequestToConfirmNavigationCallback callback) override;
  void NotifyAdditionalContext(AdditionalContextPtr context) override;
  void NotifyActuationOnWebSettingChanged(bool enabled) override;
  void NotifyActOnWebCapabilityChanged(bool can_act_on_web) override;
};
class  WebClientAsyncWaiter {
 public:
  explicit WebClientAsyncWaiter(WebClient* proxy);

  WebClientAsyncWaiter(const WebClientAsyncWaiter&) = delete;
  WebClientAsyncWaiter& operator=(const WebClientAsyncWaiter&) = delete;

  ~WebClientAsyncWaiter();
  void NotifyPanelWillOpen(
      PanelOpeningDataPtr panel_opening_data, OpenPanelInfoPtr* out_openPanelInfo);
  OpenPanelInfoPtr NotifyPanelWillOpen(PanelOpeningDataPtr panel_opening_data);
  void NotifyPanelWasClosed(
      );
  
  void RequestToShowCredentialSelectionDialog(
      ::actor::webui::mojom::SelectCredentialDialogRequestPtr request, ::actor::webui::mojom::SelectCredentialDialogResponsePtr* out_response);
  ::actor::webui::mojom::SelectCredentialDialogResponsePtr RequestToShowCredentialSelectionDialog(::actor::webui::mojom::SelectCredentialDialogRequestPtr request);
  void RequestToShowAutofillSuggestionsDialog(
      ::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr request, ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr* out_response);
  ::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr RequestToShowAutofillSuggestionsDialog(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr request);
  void RequestToShowUserConfirmationDialog(
      ::actor::webui::mojom::UserConfirmationDialogRequestPtr request, ::actor::webui::mojom::UserConfirmationDialogResponsePtr* out_response);
  ::actor::webui::mojom::UserConfirmationDialogResponsePtr RequestToShowUserConfirmationDialog(::actor::webui::mojom::UserConfirmationDialogRequestPtr request);
  void RequestToConfirmNavigation(
      ::actor::webui::mojom::NavigationConfirmationRequestPtr request, ::actor::webui::mojom::NavigationConfirmationResponsePtr* out_response);
  ::actor::webui::mojom::NavigationConfirmationResponsePtr RequestToConfirmNavigation(::actor::webui::mojom::NavigationConfirmationRequestPtr request);

 private:
  WebClient* const proxy_;
};


class  CaptureRegionObserverInterceptorForTesting : public CaptureRegionObserver {
  virtual CaptureRegionObserver* GetForwardingInterface() = 0;
  void OnUpdate(CaptureRegionResultPtr result, std::optional<CaptureRegionErrorReason> reason) override;
};
class  CaptureRegionObserverAsyncWaiter {
 public:
  explicit CaptureRegionObserverAsyncWaiter(CaptureRegionObserver* proxy);

  CaptureRegionObserverAsyncWaiter(const CaptureRegionObserverAsyncWaiter&) = delete;
  CaptureRegionObserverAsyncWaiter& operator=(const CaptureRegionObserverAsyncWaiter&) = delete;

  ~CaptureRegionObserverAsyncWaiter();

 private:
  CaptureRegionObserver* const proxy_;
};




}  // glic::mojom

#endif  // CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_TEST_UTILS_H_