// chrome/browser/glic/fre/glic_fre.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/glic/fre/glic_fre.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/glic/fre/glic_fre.mojom-params-data.h"
#include "chrome/browser/glic/fre/glic_fre.mojom-shared-message-ids.h"

#include "chrome/browser/glic/fre/glic_fre.mojom-import-headers.h"
#include "chrome/browser/glic/fre/glic_fre.mojom-test-utils.h"


namespace glic::mojom {
// The declaration includes the definition on other builds.

FrePageHandlerFactory::IPCStableHashFunction FrePageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrePageHandlerFactory>(message.name())) {
    case messages::FrePageHandlerFactory::kCreatePageHandler: {
      return &FrePageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrePageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrePageHandlerFactory>(message.name())) {
      case messages::FrePageHandlerFactory::kCreatePageHandler:
            return "Receive glic::mojom::FrePageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::FrePageHandlerFactory>(message.name())) {
      case messages::FrePageHandlerFactory::kCreatePageHandler:
            return "Receive reply glic::mojom::FrePageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrePageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd57b317b;  // IPCStableHash for glic::mojom::FrePageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrePageHandlerFactoryProxy::FrePageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrePageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingReceiver<FrePageHandler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::FrePageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<FrePageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::glic::mojom::FrePageHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrePageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrePageHandlerFactoryStubDispatch::Accept(
    FrePageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrePageHandlerFactory>(message->header()->name)) {
    case messages::FrePageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::FrePageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::FrePageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<FrePageHandler> p_receiver{};
      FrePageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FrePageHandlerFactoryStubDispatch::AcceptWithResponder(
    FrePageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrePageHandlerFactory>(message->header()->name)) {
    case messages::FrePageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrePageHandlerFactoryValidationInfo[] = {
    { &internal::FrePageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrePageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::FrePageHandlerFactory::Name_,
    kFrePageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

FrePageHandler::IPCStableHashFunction FrePageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrePageHandler>(message.name())) {
    case messages::FrePageHandler::kAcceptFre: {
      return &FrePageHandler::AcceptFre_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kRejectFre: {
      return &FrePageHandler::RejectFre_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kDismissFre: {
      return &FrePageHandler::DismissFre_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kFreReloaded: {
      return &FrePageHandler::FreReloaded_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kPrepareForClient: {
      return &FrePageHandler::PrepareForClient_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kValidateAndOpenLinkInNewTab: {
      return &FrePageHandler::ValidateAndOpenLinkInNewTab_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kWebUiStateChanged: {
      return &FrePageHandler::WebUiStateChanged_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kExceededTimeoutError: {
      return &FrePageHandler::ExceededTimeoutError_Sym::IPCStableHash;
    }
    case messages::FrePageHandler::kLogWebUiLoadComplete: {
      return &FrePageHandler::LogWebUiLoadComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrePageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrePageHandler>(message.name())) {
      case messages::FrePageHandler::kAcceptFre:
            return "Receive glic::mojom::FrePageHandler::AcceptFre";
      case messages::FrePageHandler::kRejectFre:
            return "Receive glic::mojom::FrePageHandler::RejectFre";
      case messages::FrePageHandler::kDismissFre:
            return "Receive glic::mojom::FrePageHandler::DismissFre";
      case messages::FrePageHandler::kFreReloaded:
            return "Receive glic::mojom::FrePageHandler::FreReloaded";
      case messages::FrePageHandler::kPrepareForClient:
            return "Receive glic::mojom::FrePageHandler::PrepareForClient";
      case messages::FrePageHandler::kValidateAndOpenLinkInNewTab:
            return "Receive glic::mojom::FrePageHandler::ValidateAndOpenLinkInNewTab";
      case messages::FrePageHandler::kWebUiStateChanged:
            return "Receive glic::mojom::FrePageHandler::WebUiStateChanged";
      case messages::FrePageHandler::kExceededTimeoutError:
            return "Receive glic::mojom::FrePageHandler::ExceededTimeoutError";
      case messages::FrePageHandler::kLogWebUiLoadComplete:
            return "Receive glic::mojom::FrePageHandler::LogWebUiLoadComplete";
    }
  } else {
    switch (static_cast<messages::FrePageHandler>(message.name())) {
      case messages::FrePageHandler::kAcceptFre:
            return "Receive reply glic::mojom::FrePageHandler::AcceptFre";
      case messages::FrePageHandler::kRejectFre:
            return "Receive reply glic::mojom::FrePageHandler::RejectFre";
      case messages::FrePageHandler::kDismissFre:
            return "Receive reply glic::mojom::FrePageHandler::DismissFre";
      case messages::FrePageHandler::kFreReloaded:
            return "Receive reply glic::mojom::FrePageHandler::FreReloaded";
      case messages::FrePageHandler::kPrepareForClient:
            return "Receive reply glic::mojom::FrePageHandler::PrepareForClient";
      case messages::FrePageHandler::kValidateAndOpenLinkInNewTab:
            return "Receive reply glic::mojom::FrePageHandler::ValidateAndOpenLinkInNewTab";
      case messages::FrePageHandler::kWebUiStateChanged:
            return "Receive reply glic::mojom::FrePageHandler::WebUiStateChanged";
      case messages::FrePageHandler::kExceededTimeoutError:
            return "Receive reply glic::mojom::FrePageHandler::ExceededTimeoutError";
      case messages::FrePageHandler::kLogWebUiLoadComplete:
            return "Receive reply glic::mojom::FrePageHandler::LogWebUiLoadComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrePageHandler::AcceptFre_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3eb8c0c;  // IPCStableHash for glic::mojom::FrePageHandler::AcceptFre
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::RejectFre_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02ffb649;  // IPCStableHash for glic::mojom::FrePageHandler::RejectFre
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::DismissFre_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92f700e7;  // IPCStableHash for glic::mojom::FrePageHandler::DismissFre
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::FreReloaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6639d5d3;  // IPCStableHash for glic::mojom::FrePageHandler::FreReloaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::PrepareForClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8c402cc;  // IPCStableHash for glic::mojom::FrePageHandler::PrepareForClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::ValidateAndOpenLinkInNewTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x441da28e;  // IPCStableHash for glic::mojom::FrePageHandler::ValidateAndOpenLinkInNewTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::WebUiStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73ff8f20;  // IPCStableHash for glic::mojom::FrePageHandler::WebUiStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::ExceededTimeoutError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee0ff258;  // IPCStableHash for glic::mojom::FrePageHandler::ExceededTimeoutError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrePageHandler::LogWebUiLoadComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb5fc599;  // IPCStableHash for glic::mojom::FrePageHandler::LogWebUiLoadComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FrePageHandler_PrepareForClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrePageHandler_PrepareForClient_ForwardToCallback(
      FrePageHandler::PrepareForClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrePageHandler_PrepareForClient_ForwardToCallback(const FrePageHandler_PrepareForClient_ForwardToCallback&) = delete;
  FrePageHandler_PrepareForClient_ForwardToCallback& operator=(const FrePageHandler_PrepareForClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrePageHandler::PrepareForClientCallback callback_;
};

FrePageHandlerProxy::FrePageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrePageHandlerProxy::AcceptFre(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::AcceptFre");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kAcceptFre), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_AcceptFre_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("AcceptFre");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::RejectFre(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::RejectFre");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kRejectFre), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_RejectFre_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("RejectFre");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::DismissFre(
    FreWebUiState in_panel) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::FrePageHandler::DismissFre", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("panel"), in_panel,
                        "<value of type FreWebUiState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kDismissFre), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_DismissFre_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::FreWebUiState>(
    in_panel,
    &params->panel);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("DismissFre");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::FreReloaded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::FreReloaded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kFreReloaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_FreReloaded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("FreReloaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::PrepareForClient(
    PrepareForClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::PrepareForClient");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kPrepareForClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_PrepareForClient_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("PrepareForClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrePageHandler_PrepareForClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrePageHandlerProxy::ValidateAndOpenLinkInNewTab(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::FrePageHandler::ValidateAndOpenLinkInNewTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kValidateAndOpenLinkInNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FrePageHandler.ValidateAndOpenLinkInNewTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("ValidateAndOpenLinkInNewTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::WebUiStateChanged(
    FreWebUiState in_new_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send glic::mojom::FrePageHandler::WebUiStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_state"), in_new_state,
                        "<value of type FreWebUiState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kWebUiStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_WebUiStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::glic::mojom::FreWebUiState>(
    in_new_state,
    &params->new_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("WebUiStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::ExceededTimeoutError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::ExceededTimeoutError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kExceededTimeoutError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_ExceededTimeoutError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("ExceededTimeoutError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrePageHandlerProxy::LogWebUiLoadComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send glic::mojom::FrePageHandler::LogWebUiLoadComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kLogWebUiLoadComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_LogWebUiLoadComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("LogWebUiLoadComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrePageHandler_PrepareForClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrePageHandler::PrepareForClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrePageHandler_PrepareForClient_ProxyToResponder> proxy(
        new FrePageHandler_PrepareForClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrePageHandler_PrepareForClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrePageHandler_PrepareForClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrePageHandler_PrepareForClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrePageHandler::PrepareForClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FrePageHandler_PrepareForClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrePageHandler_PrepareForClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrePageHandler_PrepareForClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrePageHandler.4
  bool success = true;
  bool p_success{};
  FrePageHandler_PrepareForClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrePageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FrePageHandler_PrepareForClient_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply glic::mojom::FrePageHandler::PrepareForClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrePageHandler::kPrepareForClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::glic::mojom::internal::FrePageHandler_PrepareForClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrePageHandler::Name_);
  message.set_method_name("PrepareForClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrePageHandlerStubDispatch::Accept(
    FrePageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrePageHandler>(message->header()->name)) {
    case messages::FrePageHandler::kAcceptFre: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_AcceptFre_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_AcceptFre_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.0
      bool success = true;
      FrePageHandler_AcceptFre_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptFre(        );
      return true;
    }
    case messages::FrePageHandler::kRejectFre: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_RejectFre_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_RejectFre_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.1
      bool success = true;
      FrePageHandler_RejectFre_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RejectFre(        );
      return true;
    }
    case messages::FrePageHandler::kDismissFre: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_DismissFre_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_DismissFre_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.2
      bool success = true;
      FreWebUiState p_panel{};
      FrePageHandler_DismissFre_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPanel(&p_panel))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DismissFre(        
        std::move(p_panel));
      return true;
    }
    case messages::FrePageHandler::kFreReloaded: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_FreReloaded_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_FreReloaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.3
      bool success = true;
      FrePageHandler_FreReloaded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FreReloaded(        );
      return true;
    }
    case messages::FrePageHandler::kPrepareForClient: {
      break;
    }
    case messages::FrePageHandler::kValidateAndOpenLinkInNewTab: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.5
      bool success = true;
      ::GURL p_url{};
      FrePageHandler_ValidateAndOpenLinkInNewTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ValidateAndOpenLinkInNewTab(        
        std::move(p_url));
      return true;
    }
    case messages::FrePageHandler::kWebUiStateChanged: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_WebUiStateChanged_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_WebUiStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.6
      bool success = true;
      FreWebUiState p_new_state{};
      FrePageHandler_WebUiStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewState(&p_new_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebUiStateChanged(        
        std::move(p_new_state));
      return true;
    }
    case messages::FrePageHandler::kExceededTimeoutError: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_ExceededTimeoutError_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_ExceededTimeoutError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.7
      bool success = true;
      FrePageHandler_ExceededTimeoutError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExceededTimeoutError(        );
      return true;
    }
    case messages::FrePageHandler::kLogWebUiLoadComplete: {
      DCHECK(message->is_serialized());
      internal::FrePageHandler_LogWebUiLoadComplete_Params_Data* params =
          reinterpret_cast<internal::FrePageHandler_LogWebUiLoadComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrePageHandler.8
      bool success = true;
      FrePageHandler_LogWebUiLoadComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogWebUiLoadComplete(        );
      return true;
    }
  }
  return false;
}

// static
bool FrePageHandlerStubDispatch::AcceptWithResponder(
    FrePageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrePageHandler>(message->header()->name)) {
    case messages::FrePageHandler::kAcceptFre: {
      break;
    }
    case messages::FrePageHandler::kRejectFre: {
      break;
    }
    case messages::FrePageHandler::kDismissFre: {
      break;
    }
    case messages::FrePageHandler::kFreReloaded: {
      break;
    }
    case messages::FrePageHandler::kPrepareForClient: {
      internal::FrePageHandler_PrepareForClient_Params_Data* params =
          reinterpret_cast<
              internal::FrePageHandler_PrepareForClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrePageHandler.4
      bool success = true;
      FrePageHandler_PrepareForClient_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrePageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          FrePageHandler_PrepareForClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrepareForClient(std::move(callback));
      return true;
    }
    case messages::FrePageHandler::kValidateAndOpenLinkInNewTab: {
      break;
    }
    case messages::FrePageHandler::kWebUiStateChanged: {
      break;
    }
    case messages::FrePageHandler::kExceededTimeoutError: {
      break;
    }
    case messages::FrePageHandler::kLogWebUiLoadComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrePageHandlerValidationInfo[] = {
    { &internal::FrePageHandler_AcceptFre_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_RejectFre_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_DismissFre_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_FreReloaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_PrepareForClient_Params_Data::Validate,
     &internal::FrePageHandler_PrepareForClient_ResponseParams_Data::Validate},
    { &internal::FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_WebUiStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_ExceededTimeoutError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrePageHandler_LogWebUiLoadComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrePageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::glic::mojom::FrePageHandler::Name_,
    kFrePageHandlerValidationInfo);
}

bool FrePageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::glic::mojom::FrePageHandler::Name_,
    kFrePageHandlerValidationInfo);
}


}  // glic::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace glic::mojom {


void FrePageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingReceiver<FrePageHandler> receiver) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(receiver)
    );
}
FrePageHandlerFactoryAsyncWaiter::FrePageHandlerFactoryAsyncWaiter(
    FrePageHandlerFactory* proxy) : proxy_(proxy) {}

FrePageHandlerFactoryAsyncWaiter::~FrePageHandlerFactoryAsyncWaiter() = default;





void FrePageHandlerInterceptorForTesting::AcceptFre() {
  GetForwardingInterface()->AcceptFre();
}
void FrePageHandlerInterceptorForTesting::RejectFre() {
  GetForwardingInterface()->RejectFre();
}
void FrePageHandlerInterceptorForTesting::DismissFre(FreWebUiState panel) {
  GetForwardingInterface()->DismissFre(
    std::move(panel)
    );
}
void FrePageHandlerInterceptorForTesting::FreReloaded() {
  GetForwardingInterface()->FreReloaded();
}
void FrePageHandlerInterceptorForTesting::PrepareForClient(PrepareForClientCallback callback) {
  GetForwardingInterface()->PrepareForClient(std::move(callback));
}
void FrePageHandlerInterceptorForTesting::ValidateAndOpenLinkInNewTab(const ::GURL& url) {
  GetForwardingInterface()->ValidateAndOpenLinkInNewTab(
    std::move(url)
    );
}
void FrePageHandlerInterceptorForTesting::WebUiStateChanged(FreWebUiState new_state) {
  GetForwardingInterface()->WebUiStateChanged(
    std::move(new_state)
    );
}
void FrePageHandlerInterceptorForTesting::ExceededTimeoutError() {
  GetForwardingInterface()->ExceededTimeoutError();
}
void FrePageHandlerInterceptorForTesting::LogWebUiLoadComplete() {
  GetForwardingInterface()->LogWebUiLoadComplete();
}
FrePageHandlerAsyncWaiter::FrePageHandlerAsyncWaiter(
    FrePageHandler* proxy) : proxy_(proxy) {}

FrePageHandlerAsyncWaiter::~FrePageHandlerAsyncWaiter() = default;


void FrePageHandlerAsyncWaiter::PrepareForClient(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->PrepareForClient(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FrePageHandlerAsyncWaiter::PrepareForClient(
    ) {
  bool async_wait_result;
  PrepareForClient(&async_wait_result);
  return async_wait_result;
}






}  // glic::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif