// cc/mojom/synced_scroll_offset.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/synced_scroll_offset.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function SyncedScrollOffset(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SyncedScrollOffset.prototype.initDefaults_ = function() {
    this.scrollOffset = null;
  };
  SyncedScrollOffset.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SyncedScrollOffset.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SyncedScrollOffset.scrollOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SyncedScrollOffset.encodedSize = codec.kStructHeaderSize + 8;

  SyncedScrollOffset.decode = function(decoder) {
    var packed;
    var val = new SyncedScrollOffset();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollOffset =
        decoder.decodeStructPointer(geometry$.PointF);
    return val;
  };

  SyncedScrollOffset.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SyncedScrollOffset.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.scrollOffset);
  };
  exports.SyncedScrollOffset = SyncedScrollOffset;
})();