// cc/mojom/layer_selection_bound.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SHARED_H_
#define CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/layer_selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"




#include "cc/mojom/layer_selection_bound.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::LayerSelectionBoundDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::LayerSelectionBoundDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::LayerSelectionBound_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::edge_start(input)) in_edge_start = Traits::edge_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edge_start)::BaseType> edge_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_edge_start,
      edge_start_fragment);

    fragment->edge_start.Set(
        edge_start_fragment.is_null() ? nullptr : edge_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->edge_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null edge_start in LayerSelectionBound struct");

    decltype(Traits::edge_end(input)) in_edge_end = Traits::edge_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edge_end)::BaseType> edge_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_edge_end,
      edge_end_fragment);

    fragment->edge_end.Set(
        edge_end_fragment.is_null() ? nullptr : edge_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->edge_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null edge_end in LayerSelectionBound struct");

    fragment->layer_id = Traits::layer_id(input);

    fragment->hidden = Traits::hidden(input);
  }

  static bool Deserialize(::cc::mojom::internal::LayerSelectionBound_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::LayerSelectionBoundDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::LayerSelectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::LayerSelectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::LayerSelection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::LayerSelectionBoundDataView>(
      in_start,
      start_fragment);

    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start in LayerSelection struct");

    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::LayerSelectionBoundDataView>(
      in_end,
      end_fragment);

    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end in LayerSelection struct");
  }

  static bool Deserialize(::cc::mojom::internal::LayerSelection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::LayerSelectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {

inline void LayerSelectionBoundDataView::GetEdgeStartDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->edge_start.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void LayerSelectionBoundDataView::GetEdgeEndDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->edge_end.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}


inline void LayerSelectionDataView::GetStartDataView(
    LayerSelectionBoundDataView* output) {
  auto pointer = data_->start.Get();
  *output = LayerSelectionBoundDataView(pointer, message_);
}
inline void LayerSelectionDataView::GetEndDataView(
    LayerSelectionBoundDataView* output) {
  auto pointer = data_->end.Get();
  *output = LayerSelectionBoundDataView(pointer, message_);
}



}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SHARED_H_