// cc/mojom/layer_selection_bound.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SEND_VALIDATION_H_
#define CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SEND_VALIDATION_H_

#include "cc/mojom/layer_selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"

#include "cc/mojom/layer_selection_bound.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cc::mojom::LayerSelectionBoundDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::LayerSelectionBoundDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::LayerSelectionBound_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gfx::mojom::SelectionBoundType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::edge_start(input)) in_edge_start = Traits::edge_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edge_start)::BaseType> edge_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_edge_start,
        edge_start_fragment);

      fragment->edge_start.Set(
          edge_start_fragment.is_null() ? nullptr : edge_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->edge_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edge_start in LayerSelectionBound struct");

      decltype(Traits::edge_end(input)) in_edge_end = Traits::edge_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edge_end)::BaseType> edge_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_edge_end,
        edge_end_fragment);

      fragment->edge_end.Set(
          edge_end_fragment.is_null() ? nullptr : edge_end_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->edge_end.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edge_end in LayerSelectionBound struct");

      fragment->layer_id = Traits::layer_id(input);

      fragment->hidden = Traits::hidden(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cc::mojom::LayerSelectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::LayerSelectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::LayerSelection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::start(input)) in_start = Traits::start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start)::BaseType> start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::LayerSelectionBoundDataView, send_validation>(
        in_start,
        start_fragment);

      fragment->start.Set(
          start_fragment.is_null() ? nullptr : start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start in LayerSelection struct");

      decltype(Traits::end(input)) in_end = Traits::end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->end)::BaseType> end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::LayerSelectionBoundDataView, send_validation>(
        in_end,
        end_fragment);

      fragment->end.Set(
          end_fragment.is_null() ? nullptr : end_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->end.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null end in LayerSelection struct");
  }
};

}  // namespace mojo::internal

#endif  // CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_SEND_VALIDATION_H_